package com.xebialabs.xlrelease.script.security

import com.xebialabs.xlrelease.script.security.ScriptPermissions.{grantedClassAccess, revokedClassAccess}
import grizzled.slf4j.Logging
import org.apache.commons.lang3.reflect.FieldUtils.readField

import java.lang.System.getSecurityManager
import java.security.AccessController.getContext
import java.security.ProtectionDomain

trait SandboxSupport extends Logging {
  def hasClassAccess(target: String): Boolean = {
    !isRestrictedContext || (has(grantedClassAccess(target)) && !has(revokedClassAccess(target)))
  }

  def has(permission: RuntimePermission): Boolean = try {
    getSecurityManager.checkPermission(permission)
    true
  } catch {
    case _: SecurityException => false
  }

  def isRestrictedContext: Boolean = try { // TODO: some ugly stuff, find an alternative way
    val context = readField(getContext, "context", true).asInstanceOf[Array[ProtectionDomain]]
    getSecurityManager != null && context != null && context.exists(_.getCodeSource.isInstanceOf[ScriptCodeSource])
  } catch {
    case e: Exception =>
      logger.warn("Error checking script protection domain", e)
      false
  }
}
