package com.xebialabs.xlrelease.script.security

import com.xebialabs.xlrelease.script.security.RuntimePermission.{ALL_ACTION, NONE_ACTION}

object ScriptPermissions {
  val ACCESS_CLASS_PREFIX = "accessClass."

  def grantedClassAccess(name: String) = new RuntimePermission(ACCESS_CLASS_PREFIX + name, ALL_ACTION)

  def revokedClassAccess(name: String) = new RuntimePermission(ACCESS_CLASS_PREFIX + name, NONE_ACTION)
}
