package com.xebialabs.xlrelease.security.sql.db

import com.xebialabs.xlplatform.repository.sql.Database
import com.xebialabs.xlrelease.security.sql.db.Ids.GLOBAL_SCOPE_CI_ID
import com.xebialabs.xlrelease.security.sql.db.SecuritySchema._
import slick.jdbc.JdbcProfile

object SecuritySchema {

  abstract class Table(val TABLE: String)

  object ROLES extends Table("XL_ROLES") {
    val id: String = "ID"
    val name: String = "NAME"
    val ciId: String = "CI_ID"
  }

  object ROLE_ROLES extends Table("XL_ROLE_ROLES") {
    val roleId: String = "ROLE_ID"
    val memberRoleId: String = "MEMBER_ROLE_ID"
  }

  object ROLE_PRINCIPALS extends Table("XL_ROLE_PRINCIPALS") {
    val roleId: String = "ROLE_ID"
    val principalName: String = "PRINCIPAL_NAME"
  }

  object ROLE_PERMISSIONS extends Table("XL_ROLE_PERMISSIONS") {
    val roleId: String = "ROLE_ID"
    val permissionName: String = "PERMISSION_NAME"
    val ciId: String = "CI_ID"
  }

  object USERS extends Table("XL_USERS") {
    val username: String = "USERNAME"
    val password: String = "PASSWORD"
  }

}

object Tables {

  lazy val profile: JdbcProfile = Database.databaseType.profile

  import profile.api._

  trait HasCiRef {
    def ciId: Rep[Int]
  }

  case class Role(id: String, name: String, ciId: Int = GLOBAL_SCOPE_CI_ID)

  class Roles(tag: Tag) extends Table[Role](tag, ROLES.TABLE) with HasCiRef {
    def id = column[String](ROLES.id, O.PrimaryKey)

    def name = column[String](ROLES.name)

    def ciId = column[Int](ROLES.ciId)

    def * = (id, name, ciId).<>(Role.tupled, Role.unapply)
  }

  val roles = TableQuery[Roles]

  case class RoleRole(roleId: String, memberRoleId: String)

  class RoleRoles(tag: Tag) extends Table[RoleRole](tag, ROLE_ROLES.TABLE) {
    def roleId = column[String](ROLE_ROLES.roleId)

    def memberRoleId = column[String](ROLE_ROLES.memberRoleId)

    def role = foreignKey("FK_ROLE_ROLES_ROLES_ID", roleId, roles)(_.id)

    def pk = primaryKey("PK_ROLE_ROLES", (roleId, memberRoleId))

    def * = (roleId, memberRoleId).<>(RoleRole.tupled, RoleRole.unapply)
  }

  val roleRoles = TableQuery[RoleRoles]

  case class RolePrincipal(roleId: String, principalName: String)

  class RolePrincipals(tag: Tag) extends Table[RolePrincipal](tag, ROLE_PRINCIPALS.TABLE) {
    def roleId = column[String](ROLE_PRINCIPALS.roleId)

    def principalName = column[String](ROLE_PRINCIPALS.principalName)

    def role = foreignKey("FK_ROLE_PRIN_ROLES_ID", roleId, roles)(_.id)

    def pk = primaryKey("PK_ROLE_PRINCIPALS", (roleId, principalName))

    def * = (roleId, principalName).<>(RolePrincipal.tupled, RolePrincipal.unapply)
  }

  val rolePrincipals = TableQuery[RolePrincipals]

  case class RolePermission(roleId: String, permissionName: String, ciId: Int = GLOBAL_SCOPE_CI_ID)

  class RolePermissions(tag: Tag) extends Table[RolePermission](tag, ROLE_PERMISSIONS.TABLE) with HasCiRef {
    def roleId = column[String](ROLE_PERMISSIONS.roleId)

    def permissionName = column[String](ROLE_PERMISSIONS.permissionName)

    def ciId = column[Int](ROLE_PERMISSIONS.ciId)

    def role = foreignKey("FK_ROLE_PERM_ROLES_ID", roleId, roles)(_.id)

    def pk = primaryKey("PK_ROLE_PERMISSIONS", (roleId, permissionName, ciId))

    def * = (roleId, permissionName, ciId).<>(RolePermission.tupled, RolePermission.unapply)
  }

  val rolePermissions = TableQuery[RolePermissions]

  type User = (String, String)

  class Users(tag: Tag) extends Table[User](tag, USERS.TABLE) {
    def username = column[String](USERS.username, O.PrimaryKey)

    def password = column[String](USERS.password)

    override def * = (username, password)
  }

  lazy val users = TableQuery[Users]

}
