/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.spring.config;

import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.security.JcrPermissionChecker;
import com.xebialabs.deployit.security.JcrPermissionEditor;
import com.xebialabs.deployit.security.JcrPermissionLister;
import com.xebialabs.deployit.security.JcrRoleService;
import com.xebialabs.deployit.security.PermissionChecker;
import com.xebialabs.deployit.security.PermissionEditor;
import com.xebialabs.deployit.security.PermissionLister;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.xlrelease.repository.SecuredCis;
import com.xebialabs.xlrelease.repository.Teams;
import com.xebialabs.xlrelease.repository.jcr.JcrSecuredCis;
import com.xebialabs.xlrelease.repository.jcr.JcrTeams;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.CiIdService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@Configuration
@Profile(value={"!sql"})
public class JcrSecurityConfiguration {
    private JcrTemplate jcrTemplate;

    @Autowired
    public JcrSecurityConfiguration(JcrTemplate jcrTemplate) {
        this.jcrTemplate = jcrTemplate;
    }

    @Bean
    public JcrRoleService roleService() {
        return new JcrRoleService(this.jcrTemplate);
    }

    @Bean
    public PermissionEditor permissionEditor() {
        return new JcrPermissionEditor(this.jcrTemplate, this.roleService());
    }

    @Bean
    public PermissionLister permissionLister(RepositoryService repositoryService) {
        return new JcrPermissionLister(this.jcrTemplate, repositoryService);
    }

    @Bean
    public PermissionChecker xlrPermissionChecker() {
        return new JcrPermissionChecker(this.jcrTemplate, this.roleService());
    }

    @Bean
    public SecuredCis securedCis() {
        return new JcrSecuredCis();
    }

    @Bean
    public Teams teams(CiIdService ciIdService, PermissionEditor permissionEditor, RoleService roleService, ArchivingService archivingService) {
        return new JcrTeams(ciIdService, permissionEditor, roleService, archivingService);
    }
}

