/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.CiWithUid;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskContainer;
import com.xebialabs.xlrelease.domain.TaskGroup;
import com.xebialabs.xlrelease.domain.blackout.BlackoutMetadata$;
import com.xebialabs.xlrelease.domain.calendar.Blackout;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.domain.utils.syntax;
import com.xebialabs.xlrelease.domain.utils.syntax$;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.repository.CommentRepository;
import com.xebialabs.xlrelease.repository.FacetRepositoryDispatcher;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.repository.query.ResolveOptions;
import com.xebialabs.xlrelease.repository.query.ResolveOptionsBuilder;
import com.xebialabs.xlrelease.repository.query.TaskBasicData;
import com.xebialabs.xlrelease.repository.sql.BaseReleaseItemRepository;
import com.xebialabs.xlrelease.repository.sql.ConfigurationReferencesSupport;
import com.xebialabs.xlrelease.repository.sql.DeserializationSupport;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$RichCiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.DependencyPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasesSqlBuilder;
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.TasksSqlBuilder;
import com.xebialabs.xlrelease.repository.sql.persistence.configuration.ConfigurationReferencePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.ReleaseRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.TaskRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.TaskRow$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Date;
import java.util.Set;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0001\t=h\u0001\u0002\u0014(\u0001IB\u0001b\u0014\u0001\u0003\u0006\u0004%\t\u0001\u0015\u0005\t/\u0002\u0011\t\u0011)A\u0005#\"A\u0001\f\u0001BC\u0002\u0013\u0005\u0011\f\u0003\u0005^\u0001\t\u0005\t\u0015!\u0003[\u0011!q\u0006A!b\u0001\n\u0003y\u0006\u0002C2\u0001\u0005\u0003\u0005\u000b\u0011\u00021\t\u0011\u0011\u0004!Q1A\u0005\u0002\u0015D\u0001\"\u001b\u0001\u0003\u0002\u0003\u0006IA\u001a\u0005\tU\u0002\u0011)\u0019!C\u0001W\"Aq\u000e\u0001B\u0001B\u0003%A\u000e\u0003\u0005q\u0001\t\u0015\r\u0011\"\u0001r\u0011!A\bA!A!\u0002\u0013\u0011\b\u0002C=\u0001\u0005\u000b\u0007I\u0011\u0001>\t\u0011y\u0004!\u0011!Q\u0001\nmD\u0011b \u0001\u0003\u0006\u0004%\u0019!!\u0001\t\u0015\u0005E\u0002A!A!\u0002\u0013\t\u0019\u0001C\u0004\u00024\u0001!\t!!\u000e\t\u000f\u0005%\u0003\u0001\"\u0011\u0002L!9\u0011\u0011\n\u0001\u0005B\u0005U\u0005bBAY\u0001\u0011\u0005\u00131\u0017\u0005\b\u0003C\u0004A\u0011IAr\u0011\u001d\t\t\u0010\u0001C!\u0003gDq!a?\u0001\t\u0003\ni\u0010C\u0004\u0003\u001e\u0001!\tEa\b\t\u000f\t\u0015\u0002\u0001\"\u0011\u0003(!9!q\u0007\u0001\u0005B\te\u0002b\u0002B \u0001\u0011\u0005#\u0011\t\u0005\b\u0005\u000f\u0002A\u0011\u0002B%\u0011\u001d\u0011y\u0005\u0001C!\u0005#BqAa\u0016\u0001\t\u0003\u0012I\u0006C\u0004\u0003t\u0001!\tE!\u001e\t\u000f\t%\u0005\u0001\"\u0011\u0003\f\"9!q\u0012\u0001\u0005B\tE\u0005b\u0002BM\u0001\u0011\u0005#1\u0014\u0005\b\u0005c\u0003A\u0011\tBZ\u0011\u001d\u0011Y\r\u0001C!\u0005gCqA!5\u0001\t\u0003\u0012\u0019NA\tTc2$\u0016m]6SKB|7/\u001b;pefT!\u0001K\u0015\u0002\u0007M\fHN\u0003\u0002+W\u0005Q!/\u001a9pg&$xN]=\u000b\u00051j\u0013!\u0003=me\u0016dW-Y:f\u0015\tqs&A\u0005yK\nL\u0017\r\\1cg*\t\u0001'A\u0002d_6\u001c\u0001aE\u0004\u0001gej\u0014\tR$\u0011\u0005Q:T\"A\u001b\u000b\u0003Y\nQa]2bY\u0006L!\u0001O\u001b\u0003\r\u0005s\u0017PU3g!\tQ4(D\u0001*\u0013\ta\u0014F\u0001\bUCN\\'+\u001a9pg&$xN]=\u0011\u0005yzT\"A\u0014\n\u0005\u0001;#!\u0007\"bg\u0016\u0014V\r\\3bg\u0016LE/Z7SKB|7/\u001b;pef\u0004\"A\u0010\"\n\u0005\r;#A\u0006#fg\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8TkB\u0004xN\u001d;\u0011\u0005y*\u0015B\u0001$(\u0005y\u0019uN\u001c4jOV\u0014\u0018\r^5p]J+g-\u001a:f]\u000e,7oU;qa>\u0014H\u000f\u0005\u0002I\u001b6\t\u0011J\u0003\u0002K\u0017\u0006)1\u000f\u001c45U*\tA*\u0001\u0005he&T(\u0010\\3e\u0013\tq\u0015JA\u0004M_\u001e<\u0017N\\4\u0002%I,G.Z1tKB+'o]5ti\u0016t7-Z\u000b\u0002#B\u0011!+V\u0007\u0002'*\u0011AkJ\u0001\fa\u0016\u00148/[:uK:\u001cW-\u0003\u0002W'\n\u0011\"+\u001a7fCN,\u0007+\u001a:tSN$XM\\2f\u0003M\u0011X\r\\3bg\u0016\u0004VM]:jgR,gnY3!\u0003U!W\r]3oI\u0016t7-\u001f)feNL7\u000f^3oG\u0016,\u0012A\u0017\t\u0003%nK!\u0001X*\u0003+\u0011+\u0007/\u001a8eK:\u001c\u0017\u0010U3sg&\u001cH/\u001a8dK\u00061B-\u001a9f]\u0012,gnY=QKJ\u001c\u0018n\u001d;f]\u000e,\u0007%A\buCN\\\u0007+\u001a:tSN$XM\\2f+\u0005\u0001\u0007C\u0001*b\u0013\t\u00117KA\bUCN\\\u0007+\u001a:tSN$XM\\2f\u0003A!\u0018m]6QKJ\u001c\u0018n\u001d;f]\u000e,\u0007%A\td_6lWM\u001c;SKB|7/\u001b;pef,\u0012A\u001a\t\u0003u\u001dL!\u0001[\u0015\u0003#\r{W.\\3oiJ+\u0007o\\:ji>\u0014\u00180\u0001\nd_6lWM\u001c;SKB|7/\u001b;pef\u0004\u0013!\u0005:fa>\u001c\u0018\u000e^8ss\u0006#\u0017\r\u001d;feV\tA\u000e\u0005\u0002?[&\u0011an\n\u0002\u0015'Fd'+\u001a9pg&$xN]=BI\u0006\u0004H/\u001a:\u0002%I,\u0007o\\:ji>\u0014\u00180\u00113baR,'\u000fI\u0001\u0019G>tg-[4ve\u0006$\u0018n\u001c8QKJ\u001c\u0018n\u001d;f]\u000e,W#\u0001:\u0011\u0005M4X\"\u0001;\u000b\u0005U\u001c\u0016!D2p]\u001aLw-\u001e:bi&|g.\u0003\u0002xi\n\t3i\u001c8gS\u001e,(/\u0019;j_:\u0014VMZ3sK:\u001cW\rU3sg&\u001cH/\u001a8dK\u0006I2m\u001c8gS\u001e,(/\u0019;j_:\u0004VM]:jgR,gnY3!\u0003e1\u0017mY3u%\u0016\u0004xn]5u_JLH)[:qCR\u001c\u0007.\u001a:\u0016\u0003m\u0004\"A\u000f?\n\u0005uL#!\u0007$bG\u0016$(+\u001a9pg&$xN]=ESN\u0004\u0018\r^2iKJ\f!DZ1dKR\u0014V\r]8tSR|'/\u001f#jgB\fGo\u00195fe\u0002\nq\u0001Z5bY\u0016\u001cG/\u0006\u0002\u0002\u0004A!\u0011QAA\u0016\u001d\u0011\t9!!\n\u000f\t\u0005%\u0011\u0011\u0005\b\u0005\u0003\u0017\tiB\u0004\u0003\u0002\u000e\u0005ma\u0002BA\b\u00033qA!!\u0005\u0002\u00185\u0011\u00111\u0003\u0006\u0004\u0003+\t\u0014A\u0002\u001fs_>$h(C\u00011\u0013\tqs&\u0003\u0002-[%\u0019\u0011qD\u0016\u0002\u0005\u0011\u0014\u0017b\u0001\u0015\u0002$)\u0019\u0011qD\u0016\n\t\u0005\u001d\u0012\u0011F\u0001\u000b'Fd')^5mI\u0016\u0014(b\u0001\u0015\u0002$%!\u0011QFA\u0018\u0005\u001d!\u0015.\u00197fGRTA!a\n\u0002*\u0005AA-[1mK\u000e$\b%\u0001\u0004=S:LGO\u0010\u000b\u0013\u0003o\tI$a\u000f\u0002>\u0005}\u0012\u0011IA\"\u0003\u000b\n9\u0005\u0005\u0002?\u0001!)q*\u0005a\u0001#\")\u0001,\u0005a\u00015\")a,\u0005a\u0001A\")A-\u0005a\u0001M\")!.\u0005a\u0001Y\")\u0001/\u0005a\u0001e\")\u00110\u0005a\u0001w\"1q0\u0005a\u0002\u0003\u0007\t\u0001BZ5oI\nK\u0018\nZ\u000b\u0005\u0003\u001b\n\u0019\u0006\u0006\u0003\u0002P\u0005-\u0004\u0003BA)\u0003'b\u0001\u0001B\u0004\u0002VI\u0011\r!a\u0016\u0003\u0003Q\u000bB!!\u0017\u0002`A\u0019A'a\u0017\n\u0007\u0005uSGA\u0004O_RD\u0017N\\4\u0011\t\u0005\u0005\u0014qM\u0007\u0003\u0003GR1!!\u001a,\u0003\u0019!w.\\1j]&!\u0011\u0011NA2\u0005\u0011!\u0016m]6\t\u000f\u00055$\u00031\u0001\u0002p\u00051A/Y:l\u0013\u0012\u0004B!!\u001d\u0002z9!\u00111OA;!\r\t\t\"N\u0005\u0004\u0003o*\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002|\u0005u$AB*ue&twMC\u0002\u0002xUB3AEAA!\u0011\t\u0019)!%\u000e\u0005\u0005\u0015%\u0002BAD\u0003\u0013\u000b!\"\u00198o_R\fG/[8o\u0015\u0011\tY)!$\u0002\u000f5,GO]5dg*\u0019\u0011qR\u0018\u0002\u0011\r|G-\u00195bY\u0016LA!a%\u0002\u0006\n)A+[7fIV!\u0011qSAN)\u0019\tI*!(\u0002 B!\u0011\u0011KAN\t\u001d\t)f\u0005b\u0001\u0003/Bq!!\u001c\u0014\u0001\u0004\ty\u0007C\u0004\u0002\"N\u0001\r!a)\u0002\u001dI,7o\u001c7wK>\u0003H/[8ogB!\u0011QUAV\u001b\t\t9KC\u0002\u0002*&\nQ!];fefLA!!,\u0002(\nq!+Z:pYZ,w\n\u001d;j_:\u001c\bfA\n\u0002\u0002\u0006\u0011b-\u001b8e)\u0006\u001c8n\u001d\"bg&\u001cG)\u0019;b)\u0011\t),a3\u0011\r\u0005]\u0016\u0011YAc\u001b\t\tIL\u0003\u0003\u0002<\u0006u\u0016\u0001B;uS2T!!a0\u0002\t)\fg/Y\u0005\u0005\u0003\u0007\fIL\u0001\u0003MSN$\b\u0003BAS\u0003\u000fLA!!3\u0002(\niA+Y:l\u0005\u0006\u001c\u0018n\u0019#bi\u0006Dq!!4\u0015\u0001\u0004\ty-A\u0004uCN\\\u0017\nZ:\u0011\r\u0005]\u0016\u0011YA8Q\r!\u00121\u001b\t\u0005\u0003+\fY.\u0004\u0002\u0002X*!\u0011\u0011\\A\u0015\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\n\t\u0005u\u0017q\u001b\u0002\u000b\u0013N\u0014V-\u00193P]2L\bf\u0001\u000b\u0002\u0002\u00061Q\r_5tiN$B!!:\u0002lB\u0019A'a:\n\u0007\u0005%XGA\u0004C_>dW-\u00198\t\u000f\u00055T\u00031\u0001\u0002p!\u001aQ#a5)\u0007U\t\t)\u0001\u0004va\u0012\fG/\u001a\u000b\u0005\u0003?\n)\u0010C\u0004\u0002xZ\u0001\r!a\u0018\u0002\tQ\f7o\u001b\u0015\u0004-\u0005\u0005\u0015aC;qI\u0006$X\rV1tWN$B!a@\u0003\u0006A\u0019AG!\u0001\n\u0007\t\rQG\u0001\u0003V]&$\bb\u0002B\u0004/\u0001\u0007!\u0011B\u0001\u0006i\u0006\u001c8n\u001d\t\u0006i\t-\u0011qL\u0005\u0004\u0005\u001b)$A\u0003\u001fsKB,\u0017\r^3e}!\u001aqC!\u0005\u0011\t\tM!qC\u0007\u0003\u0005+Q1!a\"6\u0013\u0011\u0011IB!\u0006\u0003\u000fY\f'/\u0019:hg\"\u001aq#!!\u0002)U\u0004H-\u0019;f)\u0006\u001c8\u000e\u0015:pa\u0016\u0014H/[3t)\u0011\tyP!\t\t\u000f\u0005]\b\u00041\u0001\u0002`!\u001a\u0001$!!\u0002=U\u0004H-\u0019;f)\u0006\u001c8.\u00118e%\u0016dW-Y:f\r2\fwm\u0015;biV\u001cHCBA0\u0005S\u0011Y\u0003C\u0004\u0002xf\u0001\r!a\u0018\t\u000f\t5\u0012\u00041\u0001\u00030\u00059!/\u001a7fCN,\u0007\u0003BA1\u0005cIAAa\r\u0002d\t9!+\u001a7fCN,\u0007fA\r\u0002\u0002\u0006QQ\u000f\u001d3bi\u0016$\u0016\u0010]3\u0015\t\u0005}#1\b\u0005\b\u0003oT\u0002\u0019AA0Q\rQ\u0012\u0011Q\u0001\u0007I\u0016dW\r^3\u0015\t\u0005}(1\t\u0005\b\u0003o\\\u0002\u0019AA0Q\rY\u0012\u0011Q\u0001\u000bGJ,\u0017\r^3UCN\\G\u0003BA0\u0005\u0017BqA!\u0014\u001d\u0001\u0004\ty&A\u0004oK^$\u0016m]6\u0002\r\r\u0014X-\u0019;f)\u0011\tyFa\u0015\t\u000f\t5S\u00041\u0001\u0002`!\u001aQ$!!\u0002\u00115|g/\u001a+bg.$\"\"a\u0018\u0003\\\t}#1\rB7\u0011\u001d\u0011iF\ba\u0001\u0003?\n!\u0002^1tWR{Wj\u001c<f\u0011\u001d\u0011\tG\ba\u0001\u0003?\n\u0011\"\\8wK\u0012$\u0016m]6\t\u000f\t\u0015d\u00041\u0001\u0003h\u00051R\u000f\u001d3bi\u0016$wJ]5hS:\u001cuN\u001c;bS:,'\u000f\u0005\u0003\u0002b\t%\u0014\u0002\u0002B6\u0003G\u0012Q\u0002V1tW\u000e{g\u000e^1j]\u0016\u0014\bb\u0002B8=\u0001\u0007!qM\u0001\u0017kB$\u0017\r^3e)\u0006\u0014x-\u001a;D_:$\u0018-\u001b8fe\"\u001aa$!!\u0002-\u0019Lg\u000eZ!gM\u0016\u001cG/\u001a3Cs\nc\u0017mY6pkR$B!a4\u0003x!9!\u0011P\u0010A\u0002\tm\u0014\u0001\u00032mC\u000e\\w.\u001e;\u0011\t\tu$1Q\u0007\u0003\u0005\u007fRAA!!\u0002d\u0005A1-\u00197f]\u0012\f'/\u0003\u0003\u0003\u0006\n}$\u0001\u0003\"mC\u000e\\w.\u001e;)\u0007}\t\t)\u0001\u000egS:$\u0007+\u001a8eS:<G+Y:lg^KG\u000f\u001b$bG\u0016$8\u000f\u0006\u0002\u0002P\"\u001a\u0001%!!\u0002\u0011\u001d,G\u000fV5uY\u0016$B!a\u001c\u0003\u0014\"9\u0011QN\u0011A\u0002\u0005=\u0004fA\u0011\u0002T\"\u001a\u0011%!!\u0002\u0015\u001d,G/\u00117m)\u0006<7\u000f\u0006\u0003\u0003\u001e\n\r\u0006CBA\\\u0005?\u000by'\u0003\u0003\u0003\"\u0006e&aA*fi\"9!Q\u0015\u0012A\u0002\t\u001d\u0016a\u00037j[&$h*^7cKJ\u00042\u0001\u000eBU\u0013\r\u0011Y+\u000e\u0002\u0004\u0013:$\bf\u0001\u0012\u0002T\"\u001a!%!!\u0002%\u0019Lg\u000eZ(wKJ$W/\u001a+bg.LEm\u001d\u000b\u0003\u0005k\u0003bAa.\u0003B\u0006=d\u0002\u0002B]\u0005{sA!!\u0005\u0003<&\ta'C\u0002\u0003@V\nq\u0001]1dW\u0006<W-\u0003\u0003\u0003D\n\u0015'aA*fc*\u0019!qX\u001b)\u0007\r\n\u0019\u000eK\u0002$\u0003\u0003\u000b!CZ5oI\u0012+XmU8p]R\u000b7o[%eg\"\u001aA%a5)\u0007\u0011\n\t)A\u0005hKR\u001cF/\u0019;vgR!!Q\u001bBq!\u0011\u00119N!8\u000e\u0005\te'\u0002\u0002Bn\u0003G\naa\u001d;biV\u001c\u0018\u0002\u0002Bp\u00053\u0014!\u0002V1tWN#\u0018\r^;t\u0011\u001d\ti'\na\u0001\u0003_B3!JAjQ\r)\u0013\u0011\u0011\u0015\u0004\u0001\t%\b\u0003BAk\u0005WLAA!<\u0002X\ny\u0011j\u001d+sC:\u001c\u0018m\u0019;j_:\fG\u000e")
public class SqlTaskRepository
implements TaskRepository,
BaseReleaseItemRepository,
DeserializationSupport,
ConfigurationReferencesSupport,
Logging {
    private final ReleasePersistence releasePersistence;
    private final DependencyPersistence dependencyPersistence;
    private final TaskPersistence taskPersistence;
    private final CommentRepository commentRepository;
    private final SqlRepositoryAdapter repositoryAdapter;
    private final ConfigurationReferencePersistence configurationPersistence;
    private final FacetRepositoryDispatcher facetRepositoryDispatcher;
    private final SqlBuilder.Dialect dialect;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public void updateConfigurationRefs(CiWithUid entity) {
        ConfigurationReferencesSupport.updateConfigurationRefs$(this, entity);
    }

    @Override
    public void deleteConfigurationRefs(Integer uid) {
        ConfigurationReferencesSupport.deleteConfigurationRefs$(this, uid);
    }

    @Override
    public Release deserializeRelease(ReleaseRow releaseData, ResolveOptions resolveOptions) {
        return DeserializationSupport.deserializeRelease$(this, releaseData, resolveOptions);
    }

    @Override
    public Option<Release> tryDeserializeRelease(ReleaseRow releaseData, ResolveOptions resolveOptions) {
        return DeserializationSupport.tryDeserializeRelease$(this, releaseData, resolveOptions);
    }

    @Override
    public Release getRelease(String releaseId, String entityId) {
        return BaseReleaseItemRepository.getRelease$(this, releaseId, entityId);
    }

    @Override
    public Release getRelease(String releaseId, String entityId, ResolveOptions resolveOptions) {
        return BaseReleaseItemRepository.getRelease$(this, releaseId, entityId, resolveOptions);
    }

    @Override
    public <T> T notNull(T ci, String ciId) {
        return (T)BaseReleaseItemRepository.notNull$(this, ci, ciId);
    }

    @Override
    public void insertDependencyWithGateTaskUid(Integer gateTaskUid, Dependency dependency) {
        BaseReleaseItemRepository.insertDependencyWithGateTaskUid$(this, gateTaskUid, dependency);
    }

    @Override
    public void insertDependency(Dependency dependency) {
        BaseReleaseItemRepository.insertDependency$(this, dependency);
    }

    @Override
    public void checkIsNotReferencedByDependencies(String planItemIdOrItsChildren) {
        BaseReleaseItemRepository.checkIsNotReferencedByDependencies$(this, planItemIdOrItsChildren);
    }

    public TaskBasicData findTaskBasicData(String taskId) {
        return TaskRepository.findTaskBasicData$((TaskRepository)this, (String)taskId);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlTaskRepository sqlTaskRepository = this;
        synchronized (sqlTaskRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public void updateTasks(Task ... tasks) {
        this.updateTasks((Seq<Task>)Predef$.MODULE$.wrapRefArray((Object[])tasks));
    }

    public ReleasePersistence releasePersistence() {
        return this.releasePersistence;
    }

    @Override
    public DependencyPersistence dependencyPersistence() {
        return this.dependencyPersistence;
    }

    public TaskPersistence taskPersistence() {
        return this.taskPersistence;
    }

    public CommentRepository commentRepository() {
        return this.commentRepository;
    }

    @Override
    public SqlRepositoryAdapter repositoryAdapter() {
        return this.repositoryAdapter;
    }

    @Override
    public ConfigurationReferencePersistence configurationPersistence() {
        return this.configurationPersistence;
    }

    public FacetRepositoryDispatcher facetRepositoryDispatcher() {
        return this.facetRepositoryDispatcher;
    }

    public SqlBuilder.Dialect dialect() {
        return this.dialect;
    }

    @Timed
    public <T extends Task> T findById(String taskId) {
        return this.findById(taskId, new ResolveOptionsBuilder().withEverything().build());
    }

    @Timed
    public <T extends Task> T findById(String taskId, ResolveOptions resolveOptions) {
        if (!this.exists(taskId)) {
            throw new NotFoundException(new StringBuilder(30).append("Repository entity [").append(taskId).append("] not found").toString(), new Object[0]);
        }
        Release release = this.getRelease(Ids.releaseIdFrom((String)taskId), taskId, resolveOptions);
        return (T)((Task)Option$.MODULE$.apply((Object)release.getTask(CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(taskId)))).fold((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException(new StringBuilder(41).append("Repository entity [").append(taskId).append("] not found in release").toString(), new Object[0]);
        }, (Function1 & Serializable & scala.Serializable)task -> {
            task.getAllTasks().forEach(t -> this.commentRepository().decorate(t));
            return task;
        }));
    }

    @Timed
    @IsReadOnly
    public java.util.List<TaskBasicData> findTasksBasicData(java.util.List<String> taskIds) {
        java.util.List list;
        if (taskIds.isEmpty()) {
            list = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava();
        } else {
            Seq<TaskRow> tasksData = this.taskPersistence().findByIds((Iterable<String>)((Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(taskIds).asScala()));
            list = (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(taskIds).asScala()).map((Function1 & Serializable & scala.Serializable)taskId -> new Tuple2(taskId, (Object)tasksData.find((Function1 & Serializable & scala.Serializable)data -> BoxesRunTime.boxToBoolean((boolean)taskId.endsWith(data.taskId())))), Buffer$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                String id = (String)tuple2._1();
                Option option = (Option)tuple2._2();
                if (!(option instanceof Some)) return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                Some some = (Some)option;
                TaskRow data = (TaskRow)some.value();
                return Option$.MODULE$.option2Iterable((Option)new Some((Object)TaskRow$.MODULE$.TaskDataOps(data).asTaskData(id)));
            }, Buffer$.MODULE$.canBuildFrom())).asJava();
        }
        return list;
    }

    @Timed
    @IsReadOnly
    public boolean exists(String taskId) {
        this.logger().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Checking if exists task [").append(taskId).append("]").toString());
        return this.taskPersistence().exists(taskId);
    }

    @Timed
    public Task update(Task task) {
        Release release = task.getRelease();
        this.releasePersistence().update(release);
        this.updateTaskProperties(task);
        this.updateConfigurationRefs((CiWithUid)release);
        return task;
    }

    @Timed
    public void updateTasks(Seq<Task> tasks) {
        tasks.groupBy((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getRelease()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            SqlTaskRepository.$anonfun$updateTasks$2(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public void updateTaskProperties(Task task) {
        this.taskPersistence().updateProperties(task);
        syntax.TaskOps$.MODULE$.dependencies$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            SqlTaskRepository.$anonfun$updateTaskProperties$1(this, task, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public Task updateTaskAndReleaseFlagStatus(Task task, Release release) {
        return this.update(task);
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Task updateType(Task task) {
        void var2_2;
        Task updated = this.update(task);
        this.taskPersistence().updateType(task);
        return var2_2;
    }

    @Timed
    public void delete(Task task) {
        this.checkIsNotReferencedByDependencies(task.getId());
        this.releasePersistence().update(task.getRelease());
        syntax.TaskOps$.MODULE$.allDependencies$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable & scala.Serializable)dependency -> {
            SqlTaskRepository.$anonfun$delete$1(this, dependency);
            return BoxedUnit.UNIT;
        });
        task.getAllTasks().forEach(t -> {
            this.commentRepository().deleteByTask(t);
            this.taskPersistence().delete((Task)t);
        });
        this.updateConfigurationRefs((CiWithUid)task.getRelease());
    }

    private Task createTask(Task newTask2) {
        this.taskPersistence().insert(newTask2, Predef$.MODULE$.Integer2int(newTask2.getRelease().getCiUid()));
        Object object = newTask2 instanceof TaskGroup ? ((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(newTask2.getAllTasks()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)SqlTaskRepository.$anonfun$createTask$1(newTask2, x$2)))).map((Function1 & Serializable & scala.Serializable)newTask -> this.createTask((Task)newTask), Buffer$.MODULE$.canBuildFrom()) : BoxedUnit.UNIT;
        return newTask2;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Task create(Task newTask) {
        void var2_2;
        this.releasePersistence().update(newTask.getRelease());
        Task createdTask = this.createTask(newTask);
        syntax.TaskOps$.MODULE$.allDependencies$extension(syntax$.MODULE$.TaskOps(createdTask)).foreach((Function1 & Serializable & scala.Serializable)dependency -> {
            this.insertDependency(dependency);
            return BoxedUnit.UNIT;
        });
        this.updateConfigurationRefs((CiWithUid)createdTask.getRelease());
        this.facetRepositoryDispatcher().liveRepository().createFromTasks((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(newTask.getAllTasks()).asScala(), this.facetRepositoryDispatcher().liveRepository().createFromTasks$default$2());
        return var2_2;
    }

    @Timed
    public Task moveTask(Task taskToMove, Task movedTask, TaskContainer updatedOriginContainer, TaskContainer updatedTargetContainer) {
        TaskContainer taskContainer = updatedOriginContainer;
        TaskContainer taskContainer2 = updatedTargetContainer;
        if (taskContainer == null ? taskContainer2 != null : !taskContainer.equals(taskContainer2)) {
            this.checkIsNotReferencedByDependencies(taskToMove.getId());
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(taskToMove.getAllTasks()).asScala()).foreach((Function1 & Serializable & scala.Serializable)taskWithOldId -> {
                SqlTaskRepository.$anonfun$moveTask$1(this, taskToMove, movedTask, taskWithOldId);
                return BoxedUnit.UNIT;
            });
        }
        this.releasePersistence().update(movedTask.getRelease());
        return movedTask;
    }

    @Timed
    public java.util.List<String> findAffectedByBlackout(Blackout blackout) {
        Date endDate = BlackoutMetadata$.MODULE$.toStartOfNextMinute(blackout.getEndDate());
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.dialect()).selectReleaseData().withOneOfStatuses((Seq<ReleaseStatus>)Predef$.MODULE$.wrapRefArray((Object[])ReleaseStatus.ACTIVE_STATUSES)).build();
        return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)((TraversableLike)((TraversableLike)this.releasePersistence().findReleaseDatasByQuery((Tuple2<String, Seq<Object>>)sqlWithParams).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> Option$.MODULE$.option2Iterable(this.tryDeserializeRelease((ReleaseRow)x$3, new ResolveOptionsBuilder().build())), Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)rel -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(rel.getAllTasks()).asScala(), Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)task -> BoxesRunTime.boxToBoolean((boolean)SqlTaskRepository.$anonfun$findAffectedByBlackout$3(endDate, task)))).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getId(), Seq$.MODULE$.canBuildFrom())).asJava();
    }

    @Timed
    public java.util.List<String> findPendingTasksWithFacets() {
        Tuple2 sqlWithParams = new TasksSqlBuilder(this.dialect()).selectTaskId().withOneOfTaskStatuses((Seq<TaskStatus>)((Seq)new .colon.colon((Object)TaskStatus.PENDING, (List)Nil$.MODULE$))).withAnyFacets().build();
        return (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)this.taskPersistence().findTaskIdsByQuery((Tuple2<String, Seq<Object>>)sqlWithParams).toSet().toList()).asJava();
    }

    @Timed
    @IsReadOnly
    public String getTitle(String taskId) {
        return (String)this.taskPersistence().getTitle(taskId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new NotFoundException("Task [%s] not found", new Object[]{taskId});
        });
    }

    @Timed
    @IsReadOnly
    public Set<String> getAllTags(int limitNumber) {
        return (Set)JavaConverters$.MODULE$.setAsJavaSetConverter(this.taskPersistence().findAllTags(limitNumber)).asJava();
    }

    @Timed
    @IsReadOnly
    public Seq<String> findOverdueTaskIds() {
        return this.taskPersistence().findOverdueTaskIds();
    }

    @Timed
    @IsReadOnly
    public Seq<String> findDueSoonTaskIds() {
        return this.taskPersistence().findDueSoonTaskIds();
    }

    @Timed
    @IsReadOnly
    public TaskStatus getStatus(String taskId) {
        return (TaskStatus)this.taskPersistence().getStatus(taskId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new LogFriendlyNotFoundException(new StringBuilder(33).append("getStatus: could not find task '").append(taskId).append("'").toString(), new Object[0]);
        });
    }

    public static final /* synthetic */ void $anonfun$updateTasks$2(SqlTaskRepository $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Release release = (Release)tuple2._1();
        Seq tasks = (Seq)tuple2._2();
        $this.releasePersistence().update(release);
        tasks.foreach((Function1 & Serializable & scala.Serializable)task -> {
            $this.updateTaskProperties(task);
            return BoxedUnit.UNIT;
        });
        $this.updateConfigurationRefs((CiWithUid)release);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$updateTaskProperties$1(SqlTaskRepository $this, Task task$1, Dependency x0$1) {
        Dependency dependency = x0$1;
        if (dependency.isArchived()) {
            $this.dependencyPersistence().deleteDependency(dependency);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit;
            try {
                $this.dependencyPersistence().updateDependency(dependency);
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (NotFoundException e) {
                $this.logger().error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Dependency ").append(dependency).append(" not found when updating task ").append(task$1).toString(), (Function0 & Serializable & scala.Serializable)() -> e);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }
    }

    public static final /* synthetic */ void $anonfun$delete$1(SqlTaskRepository $this, Dependency dependency) {
        $this.dependencyPersistence().deleteDependency(dependency);
    }

    public static final /* synthetic */ boolean $anonfun$createTask$1(Task newTask$1, Task x$2) {
        String string = x$2.getContainer().getId();
        String string2 = newTask$1.getId();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$moveTask$1(SqlTaskRepository $this, Task taskToMove$1, Task movedTask$1, Task taskWithOldId) {
        String oldId = taskWithOldId.getId();
        String newId = oldId.replace(taskToMove$1.getId(), movedTask$1.getId());
        $this.taskPersistence().move(oldId, newId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$findAffectedByBlackout$3(Date endDate$1, Task task) {
        TaskStatus taskStatus = task.getStatus();
        TaskStatus taskStatus2 = TaskStatus.PENDING;
        if (taskStatus == null) {
            if (taskStatus2 != null) {
                return false;
            }
        } else if (!taskStatus.equals(taskStatus2)) return false;
        if (!task.isPostponedDueToBlackout()) return false;
        Date date = task.getScheduledStartDate();
        Date date2 = endDate$1;
        if (date == null) {
            if (date2 == null) return true;
            return false;
        } else {
            if (!((Object)date).equals(date2)) return false;
            return true;
        }
    }

    public SqlTaskRepository(ReleasePersistence releasePersistence, DependencyPersistence dependencyPersistence, TaskPersistence taskPersistence, CommentRepository commentRepository, SqlRepositoryAdapter repositoryAdapter, ConfigurationReferencePersistence configurationPersistence, FacetRepositoryDispatcher facetRepositoryDispatcher, SqlBuilder.Dialect dialect) {
        this.releasePersistence = releasePersistence;
        this.dependencyPersistence = dependencyPersistence;
        this.taskPersistence = taskPersistence;
        this.commentRepository = commentRepository;
        this.repositoryAdapter = repositoryAdapter;
        this.configurationPersistence = configurationPersistence;
        this.facetRepositoryDispatcher = facetRepositoryDispatcher;
        this.dialect = dialect;
        TaskRepository.$init$((TaskRepository)this);
        BaseReleaseItemRepository.$init$(this);
        DeserializationSupport.$init$(this);
        ConfigurationReferencesSupport.$init$(this);
        Logging.$init$((Logging)this);
    }
}

