/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Comment;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.repository.CommentRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.query.ResolveOptions;
import com.xebialabs.xlrelease.repository.sql.DeserializationSupport;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.CommentPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.CommentPersistence$CommentRow$;
import com.xebialabs.xlrelease.repository.sql.persistence.CommentPersistence$CommentRow$CommentRowOps$;
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.ReleaseRow;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.joda.time.DateTime;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\u0005}h\u0001B\n\u0015\u0001}A\u0001B\u000e\u0001\u0003\u0006\u0004%\ta\u000e\u0005\t}\u0001\u0011\t\u0011)A\u0005q!Aq\b\u0001BC\u0002\u0013\u0005\u0001\t\u0003\u0005E\u0001\t\u0005\t\u0015!\u0003B\u0011!)\u0005A!b\u0001\n\u00031\u0005\u0002\u0003&\u0001\u0005\u0003\u0005\u000b\u0011B$\t\u000b-\u0003A\u0011\u0001'\t\u000bE\u0003A\u0011\t*\t\u000be\u0004A\u0011\t>\t\u000f\u0005%\u0001\u0001\"\u0011\u0002\f!9\u0011q\u0006\u0001\u0005B\u0005E\u0002bBA5\u0001\u0011\u0005\u00131\u000e\u0005\b\u0003c\u0002A\u0011IA:\u0011\u001d\tI\b\u0001C!\u0003wBq!a$\u0001\t\u0003\n\t\nC\u0004\u0002\u001a\u0002!\t%a'\t\u000f\u0005\u0005\u0006\u0001\"\u0003\u0002$\"9\u0011q\u001b\u0001\u0005\n\u0005e'\u0001F*rY\u000e{W.\\3oiJ+\u0007o\\:ji>\u0014\u0018P\u0003\u0002\u0016-\u0005\u00191/\u001d7\u000b\u0005]A\u0012A\u0003:fa>\u001c\u0018\u000e^8ss*\u0011\u0011DG\u0001\nq2\u0014X\r\\3bg\u0016T!a\u0007\u000f\u0002\u0013a,'-[1mC\n\u001c(\"A\u000f\u0002\u0007\r|Wn\u0001\u0001\u0014\u000b\u0001\u0001cE\u000b\u001a\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0003\r\nQa]2bY\u0006L!!\n\u0012\u0003\r\u0005s\u0017PU3g!\t9\u0003&D\u0001\u0017\u0013\tIcCA\tD_6lWM\u001c;SKB|7/\u001b;pef\u0004\"a\u000b\u0019\u000e\u00031R!!\f\u0018\u0002\u000bMdg\r\u000e6\u000b\u0003=\n\u0001b\u001a:jujdW\rZ\u0005\u0003c1\u0012q\u0001T8hO&tw\r\u0005\u00024i5\tA#\u0003\u00026)\t1B)Z:fe&\fG.\u001b>bi&|gnU;qa>\u0014H/A\buCN\\\u0007+\u001a:tSN$XM\\2f+\u0005A\u0004CA\u001d=\u001b\u0005Q$BA\u001e\u0015\u0003-\u0001XM]:jgR,gnY3\n\u0005uR$a\u0004+bg.\u0004VM]:jgR,gnY3\u0002!Q\f7o\u001b)feNL7\u000f^3oG\u0016\u0004\u0013AE2p[6,g\u000e\u001e)feNL7\u000f^3oG\u0016,\u0012!\u0011\t\u0003s\tK!a\u0011\u001e\u0003%\r{W.\\3oiB+'o]5ti\u0016t7-Z\u0001\u0014G>lW.\u001a8u!\u0016\u00148/[:uK:\u001cW\rI\u0001\u0012e\u0016\u0004xn]5u_JL\u0018\tZ1qi\u0016\u0014X#A$\u0011\u0005MB\u0015BA%\u0015\u0005Q\u0019\u0016\u000f\u001c*fa>\u001c\u0018\u000e^8ss\u0006#\u0017\r\u001d;fe\u0006\u0011\"/\u001a9pg&$xN]=BI\u0006\u0004H/\u001a:!\u0003\u0019a\u0014N\\5u}Q!QJT(Q!\t\u0019\u0004\u0001C\u00037\u000f\u0001\u0007\u0001\bC\u0003@\u000f\u0001\u0007\u0011\tC\u0003F\u000f\u0001\u0007q)\u0001\u0004fq&\u001cHo\u001d\u000b\u0003'Z\u0003\"!\t+\n\u0005U\u0013#a\u0002\"p_2,\u0017M\u001c\u0005\u0006/\"\u0001\r\u0001W\u0001\nG>lW.\u001a8u\u0013\u0012\u0004\"!W6\u000f\u0005iKgBA.i\u001d\tavM\u0004\u0002^M:\u0011a,\u001a\b\u0003?\u0012t!\u0001Y2\u000e\u0003\u0005T!A\u0019\u0010\u0002\rq\u0012xn\u001c;?\u0013\u0005i\u0012BA\u000e\u001d\u0013\tI\"$\u0003\u0002\u00181%\u0011QCF\u0005\u0003wQI!A\u001b\u001e\u0002\t\rK\u0017\nZ\u0005\u0003Y6\u0014AaQ5JI*\u0011!N\u000f\u0015\u0003\u0011=\u0004\"\u0001]<\u000e\u0003ET!A]:\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002uk\u00069Q.\u001a;sS\u000e\u001c(B\u0001<\u001d\u0003!\u0019w\u000eZ1iC2,\u0017B\u0001=r\u0005\u0015!\u0016.\\3e\u0003\u0019\u0019'/Z1uKR\u00111k\u001f\u0005\u0006y&\u0001\r!`\u0001\bGJ,\u0017\r^3e!\rq\u00181A\u0007\u0002\u007f*\u0019\u0011\u0011\u0001\r\u0002\r\u0011|W.Y5o\u0013\r\t)a \u0002\b\u0007>lW.\u001a8uQ\tIq.A\u0005de\u0016\fG/Z!mYR1\u0011QBA\n\u0003/\u00012!IA\b\u0013\r\t\tB\t\u0002\u0004\u0013:$\bBBA\u000b\u0015\u0001\u0007\u0001,\u0001\u0004uCN\\\u0017\n\u001a\u0005\b\u00033Q\u0001\u0019AA\u000e\u0003!\u0019w.\\7f]R\u001c\b#BA\u000f\u0003Oih\u0002BA\u0010\u0003Gq1\u0001YA\u0011\u0013\u0005\u0019\u0013bAA\u0013E\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u0015\u0003W\u00111aU3r\u0015\r\t)C\t\u0015\u0003\u0015=\fa!\u001e9eCR,GcB*\u00024\u0005U\u0012\u0011\n\u0005\u0006/.\u0001\r\u0001\u0017\u0005\b\u0003oY\u0001\u0019AA\u001d\u0003\u001d)\b\u000fZ1uK\u0012\u0004B!a\u000f\u0002D9!\u0011QHA !\t\u0001'%C\u0002\u0002B\t\na\u0001\u0015:fI\u00164\u0017\u0002BA#\u0003\u000f\u0012aa\u0015;sS:<'bAA!E!9\u00111J\u0006A\u0002\u00055\u0013\u0001C7pI&4\u0017.\u001a3\u0011\u000b\u0005\ny%a\u0015\n\u0007\u0005E#E\u0001\u0004PaRLwN\u001c\t\u0005\u0003+\n\u0019'\u0004\u0002\u0002X)!\u0011\u0011LA.\u0003\u0011!\u0018.\\3\u000b\t\u0005u\u0013qL\u0001\u0005U>$\u0017M\u0003\u0002\u0002b\u0005\u0019qN]4\n\t\u0005\u0015\u0014q\u000b\u0002\t\t\u0006$X\rV5nK\"\u00121b\\\u0001\tM&tGMQ=JIR\u0019Q0!\u001c\t\u000b]c\u0001\u0019\u0001-)\u00051y\u0017A\u00034j]\u0012\u0014\u0015\u0010V1tWR!\u00111DA;\u0011\u001d\t)\"\u0004a\u0001\u0003sA#!D8\u0002\u0019\u0011,G.\u001a;f\u0005f$\u0016m]6\u0015\t\u0005u\u00141\u0011\t\u0004C\u0005}\u0014bAAAE\t!QK\\5u\u0011\u001d\t)I\u0004a\u0001\u0003\u000f\u000bA\u0001^1tWB\u0019a0!#\n\u0007\u0005-uP\u0001\u0003UCN\\\u0007F\u0001\bp\u0003\u0019!W\r\\3uKR!\u0011QPAJ\u0011\u0019\t)j\u0004a\u0001{\u000691m\\7nK:$\bFA\bp\u0003!!WmY8sCR,G\u0003BAD\u0003;Cq!!\"\u0011\u0001\u0004\t9\t\u000b\u0002\u0011_\u0006Aq/\u001b;i)\u0006\u001c8.\u0006\u0003\u0002&\u00065F\u0003BAT\u0003+$B!!+\u0002@B!\u00111VAW\u0019\u0001!q!a,\u0012\u0005\u0004\t\tLA\u0001B#\u0011\t\u0019,!/\u0011\u0007\u0005\n),C\u0002\u00028\n\u0012qAT8uQ&tw\rE\u0002\"\u0003wK1!!0#\u0005\r\te.\u001f\u0005\b\u0003\u0003\f\u0002\u0019AAb\u0003\u00051\u0007cB\u0011\u0002F\u0006%\u0017\u0011V\u0005\u0004\u0003\u000f\u0014#!\u0003$v]\u000e$\u0018n\u001c82!\u0011\tY-a4\u000f\u0007i\u000bi-C\u0002\u0002&iJA!!5\u0002T\n)1)[+jI*\u0019\u0011Q\u0005\u001e\t\r\u0005U\u0011\u00031\u0001Y\u0003%9\u0018\u000e\u001e5UCN\\\u0007'\u0006\u0003\u0002\\\u0006\rH\u0003BAo\u0003S$B!a8\u0002fB)\u0011%a\u0014\u0002bB!\u00111VAr\t\u001d\tyK\u0005b\u0001\u0003cCq!!1\u0013\u0001\u0004\t9\u000fE\u0004\"\u0003\u000b\fI-!9\t\r\u0005U!\u00031\u0001YQ\r\u0001\u0011Q\u001e\t\u0005\u0003_\fY0\u0004\u0002\u0002r*!\u00111_A{\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\u000b\u0007U\t9PC\u0002\u0002zb\t!\u0001\u001a2\n\t\u0005u\u0018\u0011\u001f\u0002\u0010\u0013N$&/\u00198tC\u000e$\u0018n\u001c8bY\u0002")
public class SqlCommentRepository
implements CommentRepository,
Logging,
DeserializationSupport {
    private final TaskPersistence taskPersistence;
    private final CommentPersistence commentPersistence;
    private final SqlRepositoryAdapter repositoryAdapter;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public Release deserializeRelease(ReleaseRow releaseData, ResolveOptions resolveOptions) {
        return DeserializationSupport.deserializeRelease$(this, releaseData, resolveOptions);
    }

    @Override
    public Option<Release> tryDeserializeRelease(ReleaseRow releaseData, ResolveOptions resolveOptions) {
        return DeserializationSupport.tryDeserializeRelease$(this, releaseData, resolveOptions);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean update(String commentId, String content) {
        return CommentRepository.update$((CommentRepository)this, (String)commentId, (String)content);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlCommentRepository sqlCommentRepository = this;
        synchronized (sqlCommentRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public TaskPersistence taskPersistence() {
        return this.taskPersistence;
    }

    public CommentPersistence commentPersistence() {
        return this.commentPersistence;
    }

    @Override
    public SqlRepositoryAdapter repositoryAdapter() {
        return this.repositoryAdapter;
    }

    @Timed
    public boolean exists(String commentId) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(8).append("exists(").append(commentId).append(")").toString());
        String taskId = Ids.getParentId((String)commentId);
        return BoxesRunTime.unboxToBoolean((Object)this.withTask0(taskId, (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SqlCommentRepository.$anonfun$exists$2(this, commentId, x$1))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false));
    }

    @Timed
    public boolean create(Comment created) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(8).append("create(").append(created.getId()).append(")").toString());
        String taskId = Ids.getParentId((String)created.getId());
        return BoxesRunTime.unboxToBoolean(this.withTask(taskId, (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)SqlCommentRepository.$anonfun$create$2(this, created, x$2))));
    }

    @Timed
    public int createAll(String taskId, Seq<Comment> comments) {
        Seq aliens = (Seq)comments.filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)SqlCommentRepository.$anonfun$createAll$1(taskId, x$3)));
        if (aliens.nonEmpty()) {
            throw new IllegalArgumentException(new StringBuilder(35).append(aliens.length()).append(" comment(s) don't belong to task [").append(taskId).append("]").toString());
        }
        return BoxesRunTime.unboxToInt(this.withTask(taskId, (Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)SqlCommentRepository.$anonfun$createAll$2(this, comments, x$4))));
    }

    @Timed
    public boolean update(String commentId, String updated, Option<DateTime> modified) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(10).append("update(").append(commentId).append(", ").append(updated).append(")").toString());
        String taskId = Ids.getParentId((String)commentId);
        return BoxesRunTime.unboxToBoolean(this.withTask(taskId, (Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)SqlCommentRepository.$anonfun$update$2(this, commentId, updated, modified, x$5))));
    }

    @Timed
    public Comment findById(String commentId) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(10).append("findById(").append(commentId).append(")").toString());
        String taskId = Ids.getParentId((String)commentId);
        return (Comment)this.withTask(taskId, (Function1 & Serializable)taskUid -> (Comment)this.commentPersistence().read((Integer)taskUid, commentId).map((Function1 & Serializable)x$6 -> CommentPersistence$CommentRow$CommentRowOps$.MODULE$.toComment$extension(CommentPersistence$CommentRow$.MODULE$.CommentRowOps((CommentPersistence.CommentRow)x$6), taskId)).getOrElse((Function0 & Serializable)() -> {
            this.logger().warn((Function0 & Serializable)() -> new StringBuilder(32).append("Comment [").append(commentId).append("] not found in database").toString());
            throw new NotFoundException(new StringBuilder(21).append("Comment [").append(commentId).append("] not found.").toString(), new Object[0]);
        }));
    }

    @Timed
    public Seq<Comment> findByTask(String taskId) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(12).append("findByTask(").append(taskId).append(")").toString());
        return (Seq)this.withTask(taskId, (Function1 & Serializable)taskUid -> {
            void var3_3;
            Seq found = (Seq)this.commentPersistence().readAll((Integer)taskUid).map((Function1 & Serializable)x$7 -> CommentPersistence$CommentRow$CommentRowOps$.MODULE$.toComment$extension(CommentPersistence$CommentRow$.MODULE$.CommentRowOps((CommentPersistence.CommentRow)x$7), taskId));
            this.logger().info((Function0 & Serializable)() -> new StringBuilder(20).append("Found ").append(found.size()).append(" comments for ").append(taskId).toString());
            return var3_3;
        });
    }

    @Timed
    public void deleteByTask(Task task) {
        this.withTask(task.getId(), (Function1 & Serializable)taskUid -> BoxesRunTime.boxToInteger((int)SqlCommentRepository.$anonfun$deleteByTask$1(this, taskUid)));
    }

    @Timed
    public void delete(Comment comment) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(8).append("delete(").append(comment.getId()).append(")").toString());
        String taskId = Ids.getParentId((String)comment.getId());
        this.withTask(taskId, (Function1 & Serializable)taskUid -> BoxesRunTime.boxToInteger((int)SqlCommentRepository.$anonfun$delete$2(this, comment, taskUid)));
    }

    @Timed
    public Task decorate(Task task) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(10).append("decorate(").append(task.getId()).append(")").toString());
        return (Task)this.withTask(task.getId(), (Function1 & Serializable)taskUid -> this.commentPersistence().decorate((Integer)taskUid, task));
    }

    private <A> A withTask(String taskId, Function1<Integer, A> f) {
        return (A)this.withTask0(taskId, f).getOrElse((Function0 & Serializable)() -> {
            Task task = (Task)this.repositoryAdapter().read(taskId);
            this.logger().warn((Function0 & Serializable)() -> new StringBuilder(57).append("Task with id [").append(taskId).append("] not found in the database, reinserting...").toString());
            return f.apply((Object)this.taskPersistence().insert(task, Predef$.MODULE$.Integer2int(task.getRelease().getCiUid())));
        });
    }

    private <A> Option<A> withTask0(String taskId, Function1<Integer, A> f) {
        return this.taskPersistence().getTaskUidById(taskId).map(f);
    }

    public static final /* synthetic */ boolean $anonfun$exists$2(SqlCommentRepository $this, String commentId$1, Integer x$1) {
        return $this.commentPersistence().exists(x$1, commentId$1);
    }

    public static final /* synthetic */ boolean $anonfun$create$2(SqlCommentRepository $this, Comment created$1, Integer x$2) {
        return $this.commentPersistence().create(x$2, CommentPersistence$CommentRow$.MODULE$.fromComment(created$1));
    }

    public static final /* synthetic */ boolean $anonfun$createAll$1(String taskId$1, Comment x$3) {
        return !x$3.getId().startsWith(taskId$1);
    }

    public static final /* synthetic */ int $anonfun$createAll$2(SqlCommentRepository $this, Seq comments$1, Integer x$4) {
        return $this.commentPersistence().createAll(x$4, (Seq<CommentPersistence.CommentRow>)((Seq)comments$1.map((Function1 & Serializable)comment -> CommentPersistence$CommentRow$.MODULE$.fromComment((Comment)comment))));
    }

    public static final /* synthetic */ boolean $anonfun$update$2(SqlCommentRepository $this, String commentId$2, String updated$1, Option modified$1, Integer x$5) {
        return $this.commentPersistence().update(x$5, commentId$2, updated$1, (Option<DateTime>)modified$1);
    }

    public static final /* synthetic */ int $anonfun$deleteByTask$1(SqlCommentRepository $this, Integer taskUid) {
        return $this.commentPersistence().deleteAll(taskUid);
    }

    public static final /* synthetic */ int $anonfun$delete$2(SqlCommentRepository $this, Comment comment$1, Integer taskUid) {
        return $this.commentPersistence().delete(taskUid, comment$1.getId());
    }

    public SqlCommentRepository(TaskPersistence taskPersistence, CommentPersistence commentPersistence, SqlRepositoryAdapter repositoryAdapter) {
        this.taskPersistence = taskPersistence;
        this.commentPersistence = commentPersistence;
        this.repositoryAdapter = repositoryAdapter;
        CommentRepository.$init$((CommentRepository)this);
        Logging.$init$((Logging)this);
        DeserializationSupport.$init$(this);
    }
}

