/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.ItemAlreadyExistsException;
import com.xebialabs.deployit.repository.ItemInUseException;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.CiWithUid;
import com.xebialabs.xlrelease.domain.Comment;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.events.ReleaseCreationSource;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.utils.Diff$;
import com.xebialabs.xlrelease.domain.utils.syntax;
import com.xebialabs.xlrelease.domain.utils.syntax$;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.repository.FacetRepositoryDispatcher;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.Page$;
import com.xebialabs.xlrelease.repository.PersistenceInterceptor;
import com.xebialabs.xlrelease.repository.ReleaseExtensionsRepository;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.ReleaseSearchByParams;
import com.xebialabs.xlrelease.repository.TeamRepository;
import com.xebialabs.xlrelease.repository.query.ResolveOptions;
import com.xebialabs.xlrelease.repository.query.ResolveOptionsBuilder;
import com.xebialabs.xlrelease.repository.sql.ConfigurationReferencesSupport;
import com.xebialabs.xlrelease.repository.sql.DeserializationSupport;
import com.xebialabs.xlrelease.repository.sql.InterceptedRepository;
import com.xebialabs.xlrelease.repository.sql.SqlReleaseRepositoryHelper;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$RichCiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.CommentPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.CommentPersistence$CommentRow$;
import com.xebialabs.xlrelease.repository.sql.persistence.DependencyPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasesSqlBuilder;
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.configuration.ConfigurationReferencePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.DependencyRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.DependencyRow$;
import com.xebialabs.xlrelease.repository.sql.persistence.data.ReleaseRow;
import com.xebialabs.xlrelease.security.SecuredCi;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.slf4j.Marker;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\rmf\u0001\u0002\u001a4\u0001yB\u0001\u0002\u001a\u0001\u0003\u0002\u0003\u0006I!\u001a\u0005\tW\u0002\u0011)\u0019!C\tY\"A\u0001\u000f\u0001B\u0001B\u0003%Q\u000e\u0003\u0005r\u0001\t\u0015\r\u0011\"\u0005s\u0011!1\bA!A!\u0002\u0013\u0019\b\u0002C<\u0001\u0005\u000b\u0007I\u0011\u0003=\t\u0011q\u0004!\u0011!Q\u0001\neD\u0001\" \u0001\u0003\u0006\u0004%\tB \u0005\n\u0003\u000b\u0001!\u0011!Q\u0001\n}D!\"a\u0002\u0001\u0005\u000b\u0007I\u0011CA\u0005\u0011)\t\t\u0002\u0001B\u0001B\u0003%\u00111\u0002\u0005\u000b\u0003'\u0001!Q1A\u0005\u0002\u0005U\u0001BCA\u0012\u0001\t\u0005\t\u0015!\u0003\u0002\u0018!Q\u0011Q\u0005\u0001\u0003\u0006\u0004%\t!a\n\t\u0015\u0005=\u0002A!A!\u0002\u0013\tI\u0003\u0003\u0006\u00022\u0001\u0011\t\u0011)A\u0005\u0003gA!\"!\u000f\u0001\u0005\u000b\u0007I1AA\u001e\u0011)\tY\u0007\u0001B\u0001B\u0003%\u0011Q\b\u0005\b\u0003[\u0002A\u0011AA8\u0011\u001d\tI\t\u0001C!\u0003\u0017Cq!a3\u0001\t\u0003\ni\rC\u0004\u0002f\u0002!\t%a:\t\u000f\u0005\u0015\b\u0001\"\u0011\u0002n\"9!1\u0001\u0001\u0005B\t\u0015\u0001b\u0002B \u0001\u0011\u0005#\u0011\t\u0005\b\u0005\u0013\u0002A\u0011\u0001B&\u0011\u001d\u0011y\u0007\u0001C!\u0005cBqAa!\u0001\t\u0003\u0011)\tC\u0004\u0003\u0014\u0002!\tE!&\t\u000f\t%\u0006\u0001\"\u0011\u0003,\"9!\u0011\u0017\u0001\u0005\n\tM\u0006b\u0002B^\u0001\u0011\u0005#Q\u0018\u0005\b\u0005\u000b\u0004A\u0011\tBd\u0011\u001d\u0011\u0019\u000e\u0001C!\u0005+DqAa>\u0001\t\u0003\u0012I\u0010C\u0004\u0003\u0000\u0002!\te!\u0001\t\u000f\r-\u0001\u0001\"\u0011\u0004\u000e!91q\u0003\u0001\u0005B\re\u0001bBB\u0014\u0001\u0011\u00053\u0011\u0006\u0005\b\u0007c\u0001A\u0011IB\u001a\u0011\u001d\u0019Y\u0004\u0001C!\u0007{Aqaa\u000f\u0001\t\u0003\u001a\u0019\u0005C\u0004\u0004P\u0001!\te!\u0015\t\u000f\re\u0003\u0001\"\u0011\u0004\\!911\u000e\u0001\u0005\n\r5\u0004bBBA\u0001\u0011%11\u0011\u0005\b\u0007\u0013\u0003A\u0011IBF\u0011\u001d\u0019\t\u000b\u0001C!\u0007GCqa!+\u0001\t\u0003\u001aYK\u0001\u000bTc2\u0014V\r\\3bg\u0016\u0014V\r]8tSR|'/\u001f\u0006\u0003iU\n1a]9m\u0015\t1t'\u0001\u0006sKB|7/\u001b;pefT!\u0001O\u001d\u0002\u0013ad'/\u001a7fCN,'B\u0001\u001e<\u0003%AXMY5bY\u0006\u00147OC\u0001=\u0003\r\u0019w.\\\u0002\u0001'!\u0001q(R%T7z\u000b\u0007C\u0001!D\u001b\u0005\t%\"\u0001\"\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011\u000b%AB!osJ+g\r\u0005\u0002G\u000f6\tQ'\u0003\u0002Ik\t\t\"+\u001a7fCN,'+\u001a9pg&$xN]=\u0011\u0007)[U*D\u00014\u0013\ta5GA\u000bJ]R,'oY3qi\u0016$'+\u001a9pg&$xN]=\u0011\u00059\u000bV\"A(\u000b\u0005A;\u0014A\u00023p[\u0006Lg.\u0003\u0002S\u001f\n9!+\u001a7fCN,\u0007C\u0001+Z\u001b\u0005)&B\u0001,X\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005A\u0016\u0001C4sSjTH.\u001a3\n\u0005i+&a\u0002'pO\u001eLgn\u001a\t\u0003\u0015rK!!X\u001a\u0003-\u0011+7/\u001a:jC2L'0\u0019;j_:\u001cV\u000f\u001d9peR\u0004\"AS0\n\u0005\u0001\u001c$AH\"p]\u001aLw-\u001e:bi&|gNU3gKJ,gnY3t'V\u0004\bo\u001c:u!\tQ%-\u0003\u0002dg\tQ2+\u001d7SK2,\u0017m]3SKB|7/\u001b;pefDU\r\u001c9fe\u0006\u0011\"/\u001a7fCN,\u0007+\u001a:tSN$XM\\2f!\t1\u0017.D\u0001h\u0015\tA7'A\u0006qKJ\u001c\u0018n\u001d;f]\u000e,\u0017B\u00016h\u0005I\u0011V\r\\3bg\u0016\u0004VM]:jgR,gnY3\u0002\u001fQ\f7o\u001b)feNL7\u000f^3oG\u0016,\u0012!\u001c\t\u0003M:L!a\\4\u0003\u001fQ\u000b7o\u001b)feNL7\u000f^3oG\u0016\f\u0001\u0003^1tWB+'o]5ti\u0016t7-\u001a\u0011\u0002+\u0011,\u0007/\u001a8eK:\u001c\u0017\u0010U3sg&\u001cH/\u001a8dKV\t1\u000f\u0005\u0002gi&\u0011Qo\u001a\u0002\u0016\t\u0016\u0004XM\u001c3f]\u000eL\b+\u001a:tSN$XM\\2f\u0003Y!W\r]3oI\u0016t7-\u001f)feNL7\u000f^3oG\u0016\u0004\u0013AE2p[6,g\u000e\u001e)feNL7\u000f^3oG\u0016,\u0012!\u001f\t\u0003MjL!a_4\u0003%\r{W.\\3oiB+'o]5ti\u0016t7-Z\u0001\u0014G>lW.\u001a8u!\u0016\u00148/[:uK:\u001cW\rI\u0001\u000fi\u0016\fWNU3q_NLGo\u001c:z+\u0005y\bc\u0001$\u0002\u0002%\u0019\u00111A\u001b\u0003\u001dQ+\u0017-\u001c*fa>\u001c\u0018\u000e^8ss\u0006yA/Z1n%\u0016\u0004xn]5u_JL\b%A\u000esK2,\u0017m]3FqR,gn]5p]N\u0014V\r]8tSR|'/_\u000b\u0003\u0003\u0017\u00012ARA\u0007\u0013\r\ty!\u000e\u0002\u001c%\u0016dW-Y:f\u000bb$XM\\:j_:\u001c(+\u001a9pg&$xN]=\u00029I,G.Z1tK\u0016CH/\u001a8tS>t7OU3q_NLGo\u001c:zA\u0005A2m\u001c8gS\u001e,(/\u0019;j_:\u0004VM]:jgR,gnY3\u0016\u0005\u0005]\u0001\u0003BA\r\u0003?i!!a\u0007\u000b\u0007\u0005uq-A\u0007d_:4\u0017nZ;sCRLwN\\\u0005\u0005\u0003C\tYBA\u0011D_:4\u0017nZ;sCRLwN\u001c*fM\u0016\u0014XM\\2f!\u0016\u00148/[:uK:\u001cW-A\rd_:4\u0017nZ;sCRLwN\u001c)feNL7\u000f^3oG\u0016\u0004\u0013!\u0005:fa>\u001c\u0018\u000e^8ss\u0006#\u0017\r\u001d;feV\u0011\u0011\u0011\u0006\t\u0004\u0015\u0006-\u0012bAA\u0017g\t!2+\u001d7SKB|7/\u001b;pef\fE-\u00199uKJ\f!C]3q_NLGo\u001c:z\u0003\u0012\f\u0007\u000f^3sA\u0005Ib-Y2fiJ+\u0007o\\:ji>\u0014\u0018\u0010R5ta\u0006$8\r[3s!\r1\u0015QG\u0005\u0004\u0003o)$!\u0007$bG\u0016$(+\u001a9pg&$xN]=ESN\u0004\u0018\r^2iKJ\f!b]9m\t&\fG.Z2u+\t\ti\u0004\u0005\u0003\u0002@\u0005\u0015d\u0002BA!\u0003?rA!a\u0011\u0002\\9!\u0011QIA,\u001d\u0011\t9%!\u0016\u000f\t\u0005%\u00131\u000b\b\u0005\u0003\u0017\n\t&\u0004\u0002\u0002N)\u0019\u0011qJ\u001f\u0002\rq\u0012xn\u001c;?\u0013\u0005a\u0014B\u0001\u001e<\u0013\tA\u0014(C\u0002\u0002Z]\n!\u0001\u001a2\n\u0007Q\niFC\u0002\u0002Z]JA!!\u0019\u0002d\u0005Q1+\u001d7Ck&dG-\u001a:\u000b\u0007Q\ni&\u0003\u0003\u0002h\u0005%$a\u0002#jC2,7\r\u001e\u0006\u0005\u0003C\n\u0019'A\u0006tc2$\u0015.\u00197fGR\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u000b\u0002r\u0005]\u0014\u0011PA>\u0003{\ny(!!\u0002\u0004\u0006\u0015\u0015q\u0011\u000b\u0005\u0003g\n)\b\u0005\u0002K\u0001!9\u0011\u0011H\nA\u0004\u0005u\u0002\"\u00023\u0014\u0001\u0004)\u0007\"B6\u0014\u0001\u0004i\u0007\"B9\u0014\u0001\u0004\u0019\b\"B<\u0014\u0001\u0004I\b\"B?\u0014\u0001\u0004y\bbBA\u0004'\u0001\u0007\u00111\u0002\u0005\b\u0003'\u0019\u0002\u0019AA\f\u0011\u001d\t)c\u0005a\u0001\u0003SAq!!\r\u0014\u0001\u0004\t\u0019$\u0001\u0004fq&\u001cHo\u001d\u000b\u0005\u0003\u001b\u000b\u0019\nE\u0002A\u0003\u001fK1!!%B\u0005\u001d\u0011un\u001c7fC:Dq!!&\u0015\u0001\u0004\t9*\u0001\u0002jIB!\u0011\u0011TAQ\u001d\u0011\tY*!(\u0011\u0007\u0005-\u0013)C\u0002\u0002 \u0006\u000ba\u0001\u0015:fI\u00164\u0017\u0002BAR\u0003K\u0013aa\u0015;sS:<'bAAP\u0003\"\u001aA#!+\u0011\t\u0005-\u0016\u0011W\u0007\u0003\u0003[SA!a,\u0002d\u0005YAO]1og\u0006\u001cG/[8o\u0013\u0011\t\u0019,!,\u0003\u0015%\u001b(+Z1e\u001f:d\u0017\u0010K\u0002\u0015\u0003o\u0003B!!/\u0002H6\u0011\u00111\u0018\u0006\u0005\u0003{\u000by,\u0001\u0006b]:|G/\u0019;j_:TA!!1\u0002D\u00069Q.\u001a;sS\u000e\u001c(bAAcw\u0005A1m\u001c3bQ\u0006dW-\u0003\u0003\u0002J\u0006m&!\u0002+j[\u0016$\u0017AB2sK\u0006$X\rF\u0003N\u0003\u001f\f\u0019\u000e\u0003\u0004\u0002RV\u0001\r!T\u0001\be\u0016dW-Y:f\u0011\u001d\t).\u0006a\u0001\u0003/\fQC]3mK\u0006\u001cXm\u0011:fCRLwN\\*pkJ\u001cW\r\u0005\u0003\u0002Z\u0006}WBAAn\u0015\r\tinT\u0001\u0007KZ,g\u000e^:\n\t\u0005\u0005\u00181\u001c\u0002\u0016%\u0016dW-Y:f\u0007J,\u0017\r^5p]N{WO]2fQ\r)\u0012qW\u0001\tM&tGMQ=JIR\u0019Q*!;\t\u000f\u0005Ue\u00031\u0001\u0002\u0018\"\u001aa#a.\u0015\u000b5\u000by/!=\t\u000f\u0005Uu\u00031\u0001\u0002\u0018\"9\u00111_\fA\u0002\u0005U\u0018A\u0004:fg>dg/Z(qi&|gn\u001d\t\u0005\u0003o\fi0\u0004\u0002\u0002z*\u0019\u00111`\u001b\u0002\u000bE,XM]=\n\t\u0005}\u0018\u0011 \u0002\u000f%\u0016\u001cx\u000e\u001c<f\u001fB$\u0018n\u001c8tQ\r9\u0012qW\u0001\u0010M&tG-\u00133t\u0005f\u001cF/\u0019;vgR!!q\u0001B\r!\u0019\u0011IAa\u0005\u0002\u0018:!!1\u0002B\b\u001d\u0011\tYE!\u0004\n\u0003\tK1A!\u0005B\u0003\u001d\u0001\u0018mY6bO\u0016LAA!\u0006\u0003\u0018\t\u00191+Z9\u000b\u0007\tE\u0011\tC\u0004\u0003\u001ca\u0001\rA!\b\u0002\u0011M$\u0018\r^;tKN\u0004R\u0001\u0011B\u0010\u0005GI1A!\tB\u0005)a$/\u001a9fCR,GM\u0010\t\u0005\u0005K\u0011Y#\u0004\u0002\u0003()\u0019!\u0011F(\u0002\rM$\u0018\r^;t\u0013\u0011\u0011iCa\n\u0003\u001bI+G.Z1tKN#\u0018\r^;tQ\rA\u0012\u0011\u0016\u0015\u00041\u0005]\u0006f\u0001\r\u00036A!!q\u0007B\u001e\u001b\t\u0011IDC\u0002\u0002>\u0006KAA!\u0010\u0003:\t9a/\u0019:be\u001e\u001c\u0018a\u00054j]\u0012\u0014\u0015pQ1mK:$\u0017M\u001d+pW\u0016tGcA'\u0003D!9!QI\rA\u0002\u0005]\u0015!D2bY\u0016tG-\u0019:U_.,g\u000eK\u0002\u001a\u0003o\u000b\u0001DZ5oI\u0006\u00138\r[5wC\ndWMU3mK\u0006\u001cX-\u00133t)\u0019\u00119A!\u0014\u0003b!9!q\n\u000eA\u0002\tE\u0013\u0001\u00023bi\u0016\u0004BAa\u0015\u0003^5\u0011!Q\u000b\u0006\u0005\u0005/\u0012I&\u0001\u0003vi&d'B\u0001B.\u0003\u0011Q\u0017M^1\n\t\t}#Q\u000b\u0002\u0005\t\u0006$X\rC\u0004\u0003di\u0001\rA!\u001a\u0002\u0011A\fw-Z*ju\u0016\u00042\u0001\u0011B4\u0013\r\u0011I'\u0011\u0002\u0004\u0013:$\bf\u0001\u000e\u0002*\"\u001a!$a.\u0002\u001dM,G\u000f\u0015:f\u0003J\u001c\u0007.\u001b<fIR1!1\u000fB=\u0005{\u00022\u0001\u0011B;\u0013\r\u00119(\u0011\u0002\u0005+:LG\u000fC\u0004\u0003|m\u0001\r!a&\u0002\u0013I,G.Z1tK&#\u0007b\u0002B@7\u0001\u0007\u0011QR\u0001\faJ,\u0017I]2iSZ,G\rK\u0002\u001c\u0003o\u000b\u0011DZ5oIB\u0013X-\u0011:dQ&4\u0018M\u00197f%\u0016dW-Y:fgR1!q\u0011BE\u0005\u001b\u0003RA!\u0003\u0003\u00145CqAa#\u001d\u0001\u0004\u0011)'\u0001\u0003qC\u001e,\u0007b\u0002B29\u0001\u0007!Q\r\u0015\u00049\u0005%\u0006f\u0001\u000f\u00028\u000611/Z1sG\"$BAa&\u0003\u001eB)!1\u000bBM\u001b&!!1\u0014B+\u0005\u0011a\u0015n\u001d;\t\u000f\t}U\u00041\u0001\u0003\"\u0006a1/Z1sG\"\u0004\u0016M]1ngB\u0019aIa)\n\u0007\t\u0015VGA\u000bSK2,\u0017m]3TK\u0006\u00148\r\u001b\"z!\u0006\u0014\u0018-\\:)\u0007u\t9,\u0001\u0004eK2,G/\u001a\u000b\u0005\u0005g\u0012i\u000bC\u0004\u0002\u0016z\u0001\r!a&)\u0007y\t9,A\feK2,G/\u001a*fY\u0016\f7/\u001a*fM\u0016\u0014XM\\2fgR1!1\u000fB[\u0005oCq!!& \u0001\u0004\t9\nC\u0004\u0003:~\u0001\rA!\u001a\u0002\u0015I,G.Z1tKVKG-A\u0007eK2,G/Z,ji\",\u0016\u000e\u001a\u000b\u0007\u0005g\u0012yL!1\t\u000f\u0005U\u0005\u00051\u0001\u0002\u0018\"9!\u0011\u0018\u0011A\u0002\t\u0015\u0004f\u0001\u0011\u00028\u0006!Qn\u001c<f)\u0019\u0011\u0019H!3\u0003N\"9!1Z\u0011A\u0002\u0005]\u0015AC8sS\u001eLg.\u00197JI\"9!qZ\u0011A\u0002\u0005]\u0015!\u00028fo&#\u0007fA\u0011\u00028\u00061q-\u001a;VS\u0012$BAa6\u0003vB)\u0001I!7\u0003^&\u0019!1\\!\u0003\r=\u0003H/[8o!\u0011\u0011yNa<\u000f\t\t\u0005(Q\u001e\b\u0005\u0005G\u0014YO\u0004\u0003\u0003f\n%h\u0002BA#\u0005OL!AN\u001c\n\u0005Q*\u0014B\u000154\u0013\r\u0011\tbZ\u0005\u0005\u0005c\u0014\u0019PA\u0003DSVKGMC\u0002\u0003\u0012\u001dDq!!&#\u0001\u0004\t9*A\u0005hKR\u001cF/\u0019;vgR!!1\u0005B~\u0011\u001d\t)j\ta\u0001\u0003/C3aIA\\\u0003-9W\r^*uCR,8/Z:\u0015\t\r\r1Q\u0001\t\u0007\u0005\u0013\u0011\u0019Ba\t\t\u000f\r\u001dA\u00051\u0001\u0003\b\u0005\u0019\u0011\u000eZ:)\u0007\u0011\n9,A\u0007hKR\u0014\u0016n]6TG>\u0014Xm\u001d\u000b\u0005\u0007\u001f\u0019\t\u0002\u0005\u0004\u0003\n\tM!Q\r\u0005\b\u0007\u000f)\u0003\u0019\u0001B\u0004Q\r)\u0013\u0011\u0016\u0015\u0004K\u0005]\u0016!D:fiJK7o[*d_J,7\u000f\u0006\u0005\u0003t\rm1QDB\u0011\u0011\u001d\u0011YH\na\u0001\u0003/Cqaa\b'\u0001\u0004\u0011)'A\u0003tG>\u0014X\rC\u0004\u0004$\u0019\u0002\rA!\u001a\u0002\u0015Q|G/\u00197TG>\u0014X\rK\u0002'\u0003o\u000b!\"[:UK6\u0004H.\u0019;f)\u0011\tiia\u000b\t\u000f\tmt\u00051\u0001\u0002\u0018\"\u001aq%!+)\u0007\u001d\n9,\u0001\u0005hKR$\u0016\u000e\u001e7f)\u0011\t9j!\u000e\t\u000f\u0005U\u0005\u00061\u0001\u0002\u0018\"\u001a\u0001&!+)\u0007!\n9,\u0001\u0004va\u0012\fG/\u001a\u000b\u0004\u001b\u000e}\u0002BBAiS\u0001\u0007Q\nK\u0002*\u0003o#R!TB#\u0007\u0013Baaa\u0012+\u0001\u0004i\u0015\u0001C8sS\u001eLg.\u00197\t\r\r-#\u00061\u0001N\u0003\u001d)\b\u000fZ1uK\u0012D3AKA\\\u0003\u001d\u0011X\r\u001d7bG\u0016$R!TB*\u0007+Baaa\u0012,\u0001\u0004i\u0005BBB&W\u0001\u0007Q\nK\u0002,\u0003o\u000b!bZ3u\u00032dG+Y4t)\u0011\u0019ifa\u0019\u0011\r\tM3qLAL\u0013\u0011\u0019\tG!\u0016\u0003\u0007M+G\u000fC\u0004\u0004f1\u0002\rA!\u001a\u0002\u00171LW.\u001b;Ok6\u0014WM\u001d\u0015\u0004Y\u0005%\u0006f\u0001\u0017\u00028\u0006Qq-\u001a;SK2,\u0017m]3\u0015\u000b5\u001byga \t\u000f\tmT\u00061\u0001\u0004rA!11OB=\u001d\u0011\u0011\to!\u001e\n\u0007\r]t-\u0001\u0003DS&#\u0017\u0002BB>\u0007{\u0012AaQ5JI*\u00191qO4\t\u000f\u0005MX\u00061\u0001\u0002v\u0006\u00113\r[3dW&\u001bhj\u001c;SK\u001a,'/\u001a8dK\u0012\u0014\u0015\u0010R3qK:$WM\\2jKN$BAa\u001d\u0004\u0006\"91q\u0011\u0018A\u0002\rE\u0014a\u00069mC:LE/Z7JI>\u0013\u0018\n^:DQ&dGM]3o\u0003=1\u0017N\u001c3T\u00076#\u0015\r^1Cs&#G\u0003BBG\u00077\u0003R\u0001\u0011Bm\u0007\u001f\u0003Ba!%\u0004\u00186\u001111\u0013\u0006\u0005\u0007+\u0013I&\u0001\u0003mC:<\u0017\u0002BBM\u0007'\u0013q!\u00138uK\u001e,'\u000fC\u0004\u0002\u0016>\u0002\r!a&)\u0007=\nI\u000bK\u00020\u0003o\u000bQCZ5oI>3XM\u001d3vKJ+G.Z1tK&#7\u000f\u0006\u0002\u0003\b!\u001a\u0001'!+)\u0007A\n9,\u0001\bhKR\u0014V\r\\3bg\u0016T5o\u001c8\u0015\t\u0005]5Q\u0016\u0005\b\u0005w\n\u0004\u0019AALQ\r\t\u0014\u0011\u0016\u0015\u0004c\u0005]\u0006f\u0001\u0001\u00046B!\u00111VB\\\u0013\u0011\u0019I,!,\u0003\u001f%\u001bHK]1og\u0006\u001cG/[8oC2\u0004")
public class SqlReleaseRepository
implements ReleaseRepository,
InterceptedRepository<Release>,
Logging,
DeserializationSupport,
ConfigurationReferencesSupport,
SqlReleaseRepositoryHelper {
    private final ReleasePersistence releasePersistence;
    private final TaskPersistence taskPersistence;
    private final DependencyPersistence dependencyPersistence;
    private final CommentPersistence commentPersistence;
    private final TeamRepository teamRepository;
    private final ReleaseExtensionsRepository releaseExtensionsRepository;
    private final ConfigurationReferencePersistence configurationPersistence;
    private final SqlRepositoryAdapter repositoryAdapter;
    private final FacetRepositoryDispatcher facetRepositoryDispatcher;
    private final SqlBuilder.Dialect sqlDialect;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private scala.collection.immutable.Seq<PersistenceInterceptor<Release>> persistenceInterceptors;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public void replaceTasks(Release original, Release updated) {
        SqlReleaseRepositoryHelper.replaceTasks$(this, original, updated);
    }

    @Override
    public void replaceReleaseExtensions(Release original, Release updated) {
        SqlReleaseRepositoryHelper.replaceReleaseExtensions$(this, original, updated);
    }

    @Override
    public void replaceReleaseTeams(Release original, Release updated) {
        SqlReleaseRepositoryHelper.replaceReleaseTeams$(this, original, updated);
    }

    @Override
    public void updateCommentsOnTasks(Task originalTask, Task updatedTask) {
        SqlReleaseRepositoryHelper.updateCommentsOnTasks$(this, originalTask, updatedTask);
    }

    @Override
    public void insertDependency(Integer gateTaskUid, Dependency dependency) {
        SqlReleaseRepositoryHelper.insertDependency$(this, gateTaskUid, dependency);
    }

    @Override
    public void updateConfigurationRefs(CiWithUid entity) {
        ConfigurationReferencesSupport.updateConfigurationRefs$(this, entity);
    }

    @Override
    public void deleteConfigurationRefs(Integer uid) {
        ConfigurationReferencesSupport.deleteConfigurationRefs$(this, uid);
    }

    @Override
    public Release deserializeRelease(ReleaseRow releaseData, ResolveOptions resolveOptions) {
        return DeserializationSupport.deserializeRelease$(this, releaseData, resolveOptions);
    }

    @Override
    public Option<Release> tryDeserializeRelease(ReleaseRow releaseData, ResolveOptions resolveOptions) {
        return DeserializationSupport.tryDeserializeRelease$(this, releaseData, resolveOptions);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    public void registerPersistenceInterceptor(PersistenceInterceptor<Release> persistenceInterceptor) {
        InterceptedRepository.registerPersistenceInterceptor$((InterceptedRepository)this, persistenceInterceptor);
    }

    public void interceptCreate(ConfigurationItem ci) {
        InterceptedRepository.interceptCreate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void interceptDelete(String ciId) {
        InterceptedRepository.interceptDelete$((InterceptedRepository)this, (String)ciId);
    }

    public void interceptUpdate(ConfigurationItem ci) {
        InterceptedRepository.interceptUpdate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterCreate(ConfigurationItem ci) {
        InterceptedRepository.afterCreate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterUpdate(ConfigurationItem ci) {
        InterceptedRepository.afterUpdate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterDelete(String ciId) {
        InterceptedRepository.afterDelete$((InterceptedRepository)this, (String)ciId);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlReleaseRepository sqlReleaseRepository = this;
        synchronized (sqlReleaseRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public scala.collection.immutable.Seq<PersistenceInterceptor<Release>> persistenceInterceptors() {
        return this.persistenceInterceptors;
    }

    public void persistenceInterceptors_$eq(scala.collection.immutable.Seq<PersistenceInterceptor<Release>> x$1) {
        this.persistenceInterceptors = x$1;
    }

    public scala.collection.immutable.Seq<String> findIdsByStatus(ReleaseStatus ... statuses) {
        return this.findIdsByStatus((scala.collection.immutable.Seq<ReleaseStatus>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])statuses));
    }

    public TaskPersistence taskPersistence() {
        return this.taskPersistence;
    }

    public DependencyPersistence dependencyPersistence() {
        return this.dependencyPersistence;
    }

    public CommentPersistence commentPersistence() {
        return this.commentPersistence;
    }

    public TeamRepository teamRepository() {
        return this.teamRepository;
    }

    public ReleaseExtensionsRepository releaseExtensionsRepository() {
        return this.releaseExtensionsRepository;
    }

    @Override
    public ConfigurationReferencePersistence configurationPersistence() {
        return this.configurationPersistence;
    }

    @Override
    public SqlRepositoryAdapter repositoryAdapter() {
        return this.repositoryAdapter;
    }

    public SqlBuilder.Dialect sqlDialect() {
        return this.sqlDialect;
    }

    @Timed
    @IsReadOnly
    public boolean exists(String id) {
        return this.releasePersistence.existsRelease(CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(id)));
    }

    @Timed
    public Release create(Release release, ReleaseCreationSource releaseCreationSource) {
        if (this.releasePersistence.existsRelease(release.getId())) {
            throw new ItemAlreadyExistsException("A release with ID [%s] already exists", new Object[]{release.getId()});
        }
        this.interceptCreate((ConfigurationItem)release);
        this.releasePersistence.insert(release);
        CollectionConverters$.MODULE$.ListHasAsScala(release.getAllTasks()).asScala().foreach((Function1 & Serializable)task -> {
            SqlReleaseRepository.$anonfun$create$1(this, release, task);
            return BoxedUnit.UNIT;
        });
        release.getExtensions().forEach(extension -> this.releaseExtensionsRepository().create(extension));
        this.updateConfigurationRefs((CiWithUid)release);
        this.facetRepositoryDispatcher.liveRepository().createFromTasks(CollectionConverters$.MODULE$.ListHasAsScala(release.getAllTasks()).asScala().toSeq(), this.facetRepositoryDispatcher.liveRepository().createFromTasks$default$2());
        return release;
    }

    @Timed
    public Release findById(String id) {
        return this.getRelease(id, new ResolveOptionsBuilder().withEverything().build());
    }

    @Timed
    public Release findById(String id, ResolveOptions resolveOptions) {
        return this.getRelease(id, resolveOptions);
    }

    @Timed
    @IsReadOnly
    public scala.collection.immutable.Seq<String> findIdsByStatus(scala.collection.immutable.Seq<ReleaseStatus> statuses) {
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseId().withOneOfStatuses(statuses).build();
        return this.releasePersistence.findReleaseIdsByQuery((Tuple2<String, scala.collection.immutable.Seq<Object>>)sqlWithParams).toSeq();
    }

    @Timed
    public Release findByCalendarToken(String calendarToken) {
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseData().withCalendarToken(calendarToken).build();
        scala.collection.immutable.Seq<ReleaseRow> releases = this.releasePersistence.findReleaseDatasByQuery((Tuple2<String, scala.collection.immutable.Seq<Object>>)sqlWithParams);
        return (Release)releases.headOption().map((Function1 & Serializable)x$1 -> this.deserializeRelease((ReleaseRow)x$1, new ResolveOptionsBuilder().withEverything().build())).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    @Timed
    @IsReadOnly
    public scala.collection.immutable.Seq<String> findArchivableReleaseIds(Date date, int pageSize) {
        ReleasesSqlBuilder qual$1 = (ReleasesSqlBuilder)new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseId().withOneOfStatuses((scala.collection.immutable.Seq<ReleaseStatus>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ReleaseStatus[]{ReleaseStatus.COMPLETED, ReleaseStatus.ABORTED})))).withEndDateBefore(date).withPage(new Page(0L, (long)pageSize, Predef$.MODULE$.int2Integer(0), Page$.MODULE$.apply$default$4()));
        boolean x$1 = qual$1.withPreArchived$default$1();
        Tuple2 sqlWithParams = qual$1.withPreArchived(x$1).build();
        return this.releasePersistence.findReleaseIdsByQuery((Tuple2<String, scala.collection.immutable.Seq<Object>>)sqlWithParams).toSeq();
    }

    @Timed
    public void setPreArchived(String releaseId, boolean preArchived) {
        this.releasePersistence.setPreArchived(releaseId, preArchived);
    }

    @Timed
    @IsReadOnly
    public scala.collection.immutable.Seq<Release> findPreArchivableReleases(int page, int pageSize) {
        scala.collection.immutable.Seq inactive = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ReleaseStatus[]{ReleaseStatus.COMPLETED, ReleaseStatus.ABORTED}));
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseData().withOneOfStatuses((scala.collection.immutable.Seq<ReleaseStatus>)inactive).withPreArchived(false).limitAndOffset(pageSize, page * pageSize).build();
        return (scala.collection.immutable.Seq)((IterableOps)((IterableOps)((IterableOps)this.releasePersistence.findReleaseDatasByQuery((Tuple2<String, scala.collection.immutable.Seq<Object>>)sqlWithParams).flatMap((Function1 & Serializable)x$2 -> this.tryDeserializeRelease((ReleaseRow)x$2, new ResolveOptionsBuilder().withEverything().build()))).filterNot((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isTutorial()))).map((Function1 & Serializable)release -> this.releaseExtensionsRepository().decorate(release))).map((Function1 & Serializable)release -> this.commentPersistence().decorate((Release)release));
    }

    @Timed
    public List<Release> search(ReleaseSearchByParams searchParams) {
        ReleaseSearchByParams releaseSearchByParams = searchParams;
        if (releaseSearchByParams == null) {
            throw new MatchError((Object)releaseSearchByParams);
        }
        Page page = releaseSearchByParams.page();
        Either folderId2 = releaseSearchByParams.folderId();
        ReleaseStatus[] statuses = releaseSearchByParams.statuses();
        String title = releaseSearchByParams.title();
        String rootReleaseId = releaseSearchByParams.rootReleaseId();
        boolean autoStart = releaseSearchByParams.autoStart();
        ReleasesSqlBuilder base = (ReleasesSqlBuilder)new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseData().withTitle(title).withRootReleaseId(rootReleaseId).withPage(page);
        ReleasesSqlBuilder sqlBuilder = folderId2 == null ? base : (ReleasesSqlBuilder)folderId2.fold((Function1 & Serializable)folderId -> base.withFolder((String)folderId), (Function1 & Serializable)ancestorId -> base.withAncestor((String)ancestorId));
        Object object = ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])statuses)) ? sqlBuilder.withOneOfStatuses((scala.collection.immutable.Seq<ReleaseStatus>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)statuses)) : BoxedUnit.UNIT;
        Object object2 = autoStart ? sqlBuilder.withAutoStart() : BoxedUnit.UNIT;
        List list = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOps)((IterableOps)this.releasePersistence.findReleaseDatasByQuery((Tuple2<String, scala.collection.immutable.Seq<Object>>)sqlBuilder.build()).flatMap((Function1 & Serializable)x$4 -> this.tryDeserializeRelease((ReleaseRow)x$4, new ResolveOptionsBuilder().withEverything().build()))).map((Function1 & Serializable)release -> this.releaseExtensionsRepository().decorate(release))).map((Function1 & Serializable)release -> this.commentPersistence().decorate((Release)release))).asJava();
        return list;
    }

    @Timed
    public void delete(String id) {
        this.checkIsNotReferencedByDependencies(id);
        this.releasePersistence.findUidByReleaseId(id).foreach((Function1 & Serializable)uid -> {
            this.deleteReleaseReferences(id, uid);
            return BoxedUnit.UNIT;
        });
        this.releasePersistence.deleteById(id);
    }

    private void deleteReleaseReferences(String id, int releaseUid) {
        this.dependencyPersistence().deleteByReleaseUid(Predef$.MODULE$.int2Integer(releaseUid));
        scala.collection.immutable.Seq<Integer> taskCiUids = this.taskPersistence().findTaskCiUidsByReleaseCiUid(Predef$.MODULE$.int2Integer(releaseUid));
        this.dependencyPersistence().deleteByTaskUids(taskCiUids);
        this.commentPersistence().deleteByRelease(Predef$.MODULE$.int2Integer(releaseUid), taskCiUids);
        this.taskPersistence().deleteTasksByReleaseUid(releaseUid);
        this.teamRepository().deleteTeamsFromPlatform(new SecuredCi(id, releaseUid));
        this.releaseExtensionsRepository().deleteAll(id);
        this.deleteConfigurationRefs(Predef$.MODULE$.int2Integer(releaseUid));
        this.interceptDelete(id);
    }

    @Timed
    public void deleteWithUid(String id, int releaseUid) {
        this.deleteReleaseReferences(id, releaseUid);
        this.releasePersistence.deleteById(id);
    }

    @Timed
    public void move(String originalId, String newId) {
        this.releasePersistence.move(originalId, newId);
    }

    public Option<Integer> getUid(String id) {
        return this.releasePersistence.findUidByReleaseId(id);
    }

    @Timed
    public ReleaseStatus getStatus(String id) {
        String status = (String)this.releasePersistence.findReleaseStatus(CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(id))).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return status == null ? null : ReleaseStatus.valueOf((String)status.toUpperCase());
    }

    @Timed
    public scala.collection.immutable.Seq<ReleaseStatus> getStatuses(scala.collection.immutable.Seq<String> ids) {
        return ids.isEmpty() ? (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$) : (scala.collection.immutable.Seq)this.releasePersistence.findReleaseStatuses(ids).map((Function1 & Serializable)status -> ReleaseStatus.valueOf((String)status.toUpperCase()));
    }

    @Timed
    @IsReadOnly
    public scala.collection.immutable.Seq<Object> getRiskScores(scala.collection.immutable.Seq<String> ids) {
        return this.releasePersistence.findReleaseRiskScores(ids);
    }

    @Timed
    public void setRiskScores(String releaseId, int score, int totalScore) {
        this.releasePersistence.updateReleaseRiskScores(releaseId, score, totalScore);
    }

    @Timed
    @IsReadOnly
    public boolean isTemplate(String releaseId) {
        return ReleaseStatus.TEMPLATE.equals(this.getStatus(releaseId));
    }

    @Timed
    @IsReadOnly
    public String getTitle(String id) {
        return (String)this.releasePersistence.findReleaseTitle(CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(id))).getOrElse((Function0 & Serializable)() -> {
            throw new LogFriendlyNotFoundException("Release [%s] not found", new Object[]{id});
        });
    }

    @Timed
    public Release update(Release release) {
        return this.update(null, release);
    }

    @Timed
    public Release update(Release original, Release updated) {
        Option originalReleaseOpt = Option$.MODULE$.apply((Object)original);
        this.releasePersistence.update((Option<Release>)Option$.MODULE$.apply((Object)original), updated);
        originalReleaseOpt.foreach((Function1 & Serializable)rel -> {
            SqlReleaseRepository.$anonfun$update$1(this, updated, rel);
            return BoxedUnit.UNIT;
        });
        this.updateConfigurationRefs((CiWithUid)updated);
        return updated;
    }

    @Timed
    public Release replace(Release original, Release updated) {
        if (Ids.isFolderId((String)original.getId())) {
            updated.setTeams(Collections.emptyList());
        }
        this.releasePersistence.update((Option<Release>)Option$.MODULE$.apply((Object)original), updated);
        if (original != null) {
            this.replaceTasks(original, updated);
            this.replaceReleaseExtensions(original, updated);
            this.replaceReleaseTeams(original, updated);
        }
        this.updateConfigurationRefs((CiWithUid)updated);
        return updated;
    }

    @Timed
    @IsReadOnly
    public Set<String> getAllTags(int limitNumber) {
        return CollectionConverters$.MODULE$.SetHasAsJava(this.releasePersistence.findAllTags(limitNumber)).asJava();
    }

    /*
     * WARNING - void declaration
     */
    private Release getRelease(String releaseId, ResolveOptions resolveOptions) {
        void var3_3;
        BoxedUnit boxedUnit;
        Release release = (Release)this.repositoryAdapter().read(releaseId, resolveOptions);
        if (release == null) {
            throw new LogFriendlyNotFoundException(new StringBuilder(30).append("Repository entity [").append(releaseId).append("] not found").toString(), new Object[0]);
        }
        if (resolveOptions.hasDecorators()) {
            this.releaseExtensionsRepository().decorate(release);
            boxedUnit = this.commentPersistence().decorate(release);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return var3_3;
    }

    private void checkIsNotReferencedByDependencies(String planItemIdOrItsChildren) {
        scala.collection.immutable.Seq externalIncomingDependencies = (scala.collection.immutable.Seq)((IterableOps)this.dependencyPersistence().findByPartialTargetIds((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{planItemIdOrItsChildren}))), (Option<scala.collection.immutable.Set<String>>)None$.MODULE$).map((Function1 & Serializable)x$6 -> DependencyRow$.MODULE$.DependencyRowOps((DependencyRow)x$6).fullDependencyId())).filterNot((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.startsWith(CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(planItemIdOrItsChildren)))));
        if (externalIncomingDependencies.nonEmpty()) {
            throw new ItemInUseException(new StringBuilder(0).append(new StringBuilder(68).append("Cannot delete [").append(planItemIdOrItsChildren).append("] because it or one of its children is referenced by ").toString()).append(new StringBuilder(28).append("one or more dependencies: [").append(externalIncomingDependencies.mkString(", ")).append("]").toString()).toString(), new Object[0]);
        }
    }

    @Timed
    @IsReadOnly
    public Option<Integer> findSCMDataById(String id) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(49).append("Finding scm data for template or release with id ").append(id).toString());
        return this.releasePersistence.findSCMDataById(id).map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1));
    }

    @Timed
    @IsReadOnly
    public scala.collection.immutable.Seq<String> findOverdueReleaseIds() {
        return this.releasePersistence.findOverdueReleaseIds();
    }

    @Timed
    @IsReadOnly
    public String getReleaseJson(String releaseId) {
        return (String)this.releasePersistence.findByReleaseId(releaseId).map((Function1 & Serializable)x$8 -> x$8.json()).getOrElse((Function0 & Serializable)() -> {
            throw new LogFriendlyNotFoundException(new StringBuilder(30).append("Repository entity [").append(releaseId).append("] not found").toString(), new Object[0]);
        });
    }

    public static final /* synthetic */ boolean $anonfun$create$2(SqlReleaseRepository $this, Integer taskUid$1, Comment comment) {
        return $this.commentPersistence().create(taskUid$1, CommentPersistence$CommentRow$.MODULE$.fromComment(comment));
    }

    public static final /* synthetic */ void $anonfun$create$1(SqlReleaseRepository $this, Release release$1, Task task) {
        Integer taskUid = $this.taskPersistence().insert(task, Predef$.MODULE$.Integer2int(release$1.getCiUid()));
        syntax.TaskOps$.MODULE$.comments$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable)comment -> BoxesRunTime.boxToBoolean((boolean)SqlReleaseRepository.$anonfun$create$2($this, taskUid, comment)));
        syntax.TaskOps$.MODULE$.dependencies$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable)dependency -> {
            $this.insertDependency(taskUid, dependency);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$update$3(SqlReleaseRepository $this, Integer taskUid$2, Comment c) {
        return $this.commentPersistence().create(taskUid$2, CommentPersistence$CommentRow$.MODULE$.fromComment(c));
    }

    public static final /* synthetic */ void $anonfun$update$2(SqlReleaseRepository $this, Release updated$1, Task task) {
        Integer taskUid = $this.taskPersistence().insert(task, Predef$.MODULE$.Integer2int(updated$1.getCiUid()));
        syntax.TaskOps$.MODULE$.comments$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)SqlReleaseRepository.$anonfun$update$3($this, taskUid, c)));
        ((IterableOnceOps)syntax.TaskOps$.MODULE$.dependencies$extension(syntax$.MODULE$.TaskOps(task)).filterNot((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isArchived()))).foreach((Function1 & Serializable)dependency -> {
            $this.insertDependency(taskUid, dependency);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$update$1(SqlReleaseRepository $this, Release updated$1, Release rel) {
        Diff$.MODULE$.apply((Iterable)CollectionConverters$.MODULE$.ListHasAsScala(rel.getAllTasks()).asScala(), (Iterable)CollectionConverters$.MODULE$.ListHasAsScala(updated$1.getAllTasks()).asScala()).newValues().foreach((Function1 & Serializable)task -> {
            SqlReleaseRepository.$anonfun$update$2($this, updated$1, task);
            return BoxedUnit.UNIT;
        });
    }

    public SqlReleaseRepository(ReleasePersistence releasePersistence, TaskPersistence taskPersistence, DependencyPersistence dependencyPersistence, CommentPersistence commentPersistence, TeamRepository teamRepository, ReleaseExtensionsRepository releaseExtensionsRepository, ConfigurationReferencePersistence configurationPersistence, SqlRepositoryAdapter repositoryAdapter, FacetRepositoryDispatcher facetRepositoryDispatcher, SqlBuilder.Dialect sqlDialect) {
        this.releasePersistence = releasePersistence;
        this.taskPersistence = taskPersistence;
        this.dependencyPersistence = dependencyPersistence;
        this.commentPersistence = commentPersistence;
        this.teamRepository = teamRepository;
        this.releaseExtensionsRepository = releaseExtensionsRepository;
        this.configurationPersistence = configurationPersistence;
        this.repositoryAdapter = repositoryAdapter;
        this.facetRepositoryDispatcher = facetRepositoryDispatcher;
        this.sqlDialect = sqlDialect;
        InterceptedRepository.$init$((InterceptedRepository)this);
        Logging.$init$((Logging)this);
        DeserializationSupport.$init$(this);
        ConfigurationReferencesSupport.$init$(this);
        SqlReleaseRepositoryHelper.$init$(this);
    }
}

