/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.repository.FolderVariableRepository;
import com.xebialabs.xlrelease.repository.IdMatchers;
import com.xebialabs.xlrelease.repository.query.ResolveOptionsBuilder;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.FolderVariablePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.FolderVariableRow;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@Repository
@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\u00055c\u0001B\u0007\u000f\u0001eA\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!\f\u0005\tg\u0001\u0011\t\u0011)A\u0005i!)\u0001\b\u0001C\u0001s!)A\n\u0001C!\u001b\")a\f\u0001C!?\")\u0011\u000e\u0001C!U\")q\u000e\u0001C!a\")1\u000f\u0001C!i\")a\u000f\u0001C!o\")A\u0010\u0001C!{\"9\u0011\u0011\u0003\u0001\u0005B\u0005M\u0001bBA\f\u0001\u0011%\u0011\u0011\u0004\u0002\u001c'Fdgi\u001c7eKJ4\u0016M]5bE2,'+\u001a9pg&$xN]=\u000b\u0005=\u0001\u0012aA:rY*\u0011\u0011CE\u0001\u000be\u0016\u0004xn]5u_JL(BA\n\u0015\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\u0016-\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002/\u0005\u00191m\\7\u0004\u0001M!\u0001A\u0007\u0011%!\tYb$D\u0001\u001d\u0015\u0005i\u0012!B:dC2\f\u0017BA\u0010\u001d\u0005\u0019\te.\u001f*fMB\u0011\u0011EI\u0007\u0002!%\u00111\u0005\u0005\u0002\u0019\r>dG-\u001a:WCJL\u0017M\u00197f%\u0016\u0004xn]5u_JL\bCA\u0013+\u001b\u00051#BA\u0014)\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005I\u0013\u0001C4sSjTH.\u001a3\n\u0005-2#a\u0002'pO\u001eLgnZ\u0001\u0014m\u0006\u0014\u0018.\u00192mKB+'o]5ti\u0016t7-\u001a\t\u0003]Ej\u0011a\f\u0006\u0003a9\t1\u0002]3sg&\u001cH/\u001a8dK&\u0011!g\f\u0002\u001a\r>dG-\u001a:WCJL\u0017M\u00197f!\u0016\u00148/[:uK:\u001cW-A\tsKB|7/\u001b;pef\fE-\u00199uKJ\u0004\"!\u000e\u001c\u000e\u00039I!a\u000e\b\u0003)M\u000bHNU3q_NLGo\u001c:z\u0003\u0012\f\u0007\u000f^3s\u0003\u0019a\u0014N\\5u}Q\u0019!h\u000f\u001f\u0011\u0005U\u0002\u0001\"\u0002\u0017\u0004\u0001\u0004i\u0003\"B\u001a\u0004\u0001\u0004!\u0004FA\u0002?!\ty$*D\u0001A\u0015\t\t%)\u0001\u0006b]:|G/\u0019;j_:T!a\u0011#\u0002\u000f\u0019\f7\r^8ss*\u0011QIR\u0001\u0006E\u0016\fgn\u001d\u0006\u0003\u000f\"\u000bqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002\u0013\u0006\u0019qN]4\n\u0005-\u0003%!C!vi><\u0018N]3e\u0003\u0019)\u00070[:ugR\u0011a*\u0015\t\u00037=K!\u0001\u0015\u000f\u0003\u000f\t{w\u000e\\3b]\")!\u000b\u0002a\u0001'\u0006Qa/\u0019:jC\ndW-\u00133\u0011\u0005Q[fBA+Z!\t1F$D\u0001X\u0015\tA\u0006$\u0001\u0004=e>|GOP\u0005\u00035r\ta\u0001\u0015:fI\u00164\u0017B\u0001/^\u0005\u0019\u0019FO]5oO*\u0011!\fH\u0001\tM&tGMQ=JIR\u0011\u0001\r\u001b\t\u0003C\u001al\u0011A\u0019\u0006\u0003G\u0012\f\u0011B^1sS\u0006\u0014G.Z:\u000b\u0005\u0015\u0014\u0012A\u00023p[\u0006Lg.\u0003\u0002hE\nAa+\u0019:jC\ndW\rC\u0003S\u000b\u0001\u00071+A\u0005gS:$')_&fsR\u0019\u0001m[7\t\u000b14\u0001\u0019A*\u0002\u0017Y\f'/[1cY\u0016\\U-\u001f\u0005\u0006]\u001a\u0001\raU\u0001\tM>dG-\u001a:JI\u000611M]3bi\u0016$\"\u0001Y9\t\u000bI<\u0001\u0019\u00011\u0002\u0011Y\f'/[1cY\u0016\fa!\u001e9eCR,GC\u00011v\u0011\u0015\u0011\b\u00021\u0001a\u0003\u0019!W\r\\3uKR\u0011\u0001p\u001f\t\u00037eL!A\u001f\u000f\u0003\tUs\u0017\u000e\u001e\u0005\u0006%&\u0001\raU\u0001\u0011O\u0016$\u0018\t\u001c7Ge>l\u0007+\u0019:f]R$2A`A\u0007!\u0011y\u0018\u0011\u00021\u000e\u0005\u0005\u0005!\u0002BA\u0002\u0003\u000b\tA!\u001e;jY*\u0011\u0011qA\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\f\u0005\u0005!\u0001\u0002'jgRDa!a\u0004\u000b\u0001\u0004\u0019\u0016\u0001\u0005<be&\f'\r\\3QCJ,g\u000e^%e\u0003I9W\r^!mY\u001a\u0013x.\\!oG\u0016\u001cHO]=\u0015\u0007y\f)\u0002\u0003\u0004\u0002\u0010-\u0001\raU\u0001\u000bi>4\u0016M]5bE2,Gc\u00011\u0002\u001c!9\u0011Q\u0004\u0007A\u0002\u0005}\u0011a\u0003<be&\f'\r\\3S_^\u0004B!!\t\u0002(5\u0011\u00111\u0005\u0006\u0004\u0003Ky\u0013\u0001\u00023bi\u0006LA!!\u000b\u0002$\t\tbi\u001c7eKJ4\u0016M]5bE2,'k\\<)\u0007\u0001\ti\u0003\u0005\u0003\u00020\u0005mRBAA\u0019\u0015\u0011\t\u0019$!\u000e\u0002\u0017Q\u0014\u0018M\\:bGRLwN\u001c\u0006\u0004\u001f\u0005]\"bAA\u001d%\u0005\u0011AMY\u0005\u0005\u0003{\t\tDA\bJgR\u0013\u0018M\\:bGRLwN\\1mQ\r\u0001\u0011\u0011\t\t\u0005\u0003\u0007\nI%\u0004\u0002\u0002F)\u0019\u0011q\t$\u0002\u0015M$XM]3pif\u0004X-\u0003\u0003\u0002L\u0005\u0015#A\u0003*fa>\u001c\u0018\u000e^8ss\u0002")
public class SqlFolderVariableRepository
implements FolderVariableRepository,
Logging {
    private final FolderVariablePersistence variablePersistence;
    private final SqlRepositoryAdapter repositoryAdapter;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlFolderVariableRepository sqlFolderVariableRepository = this;
        synchronized (sqlFolderVariableRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public boolean exists(String variableId) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(34).append("checking folder variable exists [").append(variableId).append("]").toString());
        return this.variablePersistence.exists(variableId);
    }

    public Variable findById(String variableId) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(26).append("finding folder variable [").append(variableId).append("]").toString());
        return (Variable)this.variablePersistence.findById(variableId).map((Function1 & Serializable)variableRow -> this.toVariable((FolderVariableRow)variableRow)).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Variable with id='%s' not found", new Object[]{variableId});
        });
    }

    public Variable findByKey(String variableKey, String folderId) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(43).append("finding folder variable [key=").append(variableKey).append("], [folderId=").append(folderId).append("]").toString());
        return (Variable)this.variablePersistence.findVariableByKey(variableKey, folderId).map((Function1 & Serializable)variableRow -> this.toVariable((FolderVariableRow)variableRow)).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Variable with key='%s' not found", new Object[]{variableKey});
        });
    }

    public Variable create(Variable variable) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(48).append("creating new folder variable [key=").append(variable.getKey()).append("], [folderId=").append(variable.getFolderId()).append("]").toString());
        Integer ciUid = this.variablePersistence.create(variable);
        return (Variable)this.variablePersistence.findByCiUid(ciUid).map((Function1 & Serializable)variableRow -> this.toVariable((FolderVariableRow)variableRow)).get();
    }

    public Variable update(Variable variable) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(44).append("updating folder variable [key=").append(variable.getKey()).append("], [folderId=").append(variable.getFolderId()).append("]").toString());
        this.variablePersistence.update(variable);
        return this.findById(variable.getId());
    }

    public void delete(String variableId) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(28).append("deleting folder variable [").append(variableId).append("])").toString());
        this.variablePersistence.delete(variableId);
    }

    public List<Variable> getAllFromParent(String variableParentId) {
        List list;
        Option option;
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(44).append("getting all folder variables by parent [id=").append(variableParentId).append("]").toString());
        String string = variableParentId;
        if (string != null && !(option = IdMatchers.FolderId$.MODULE$.unapply(string)).isEmpty()) {
            String folderId = (String)option.get();
            list = CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)this.variablePersistence.findByFolderId(folderId).map((Function1 & Serializable)variableRow -> this.toVariable((FolderVariableRow)variableRow))).asJava();
        } else {
            list = CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)Buffer$.MODULE$.empty()).asJava();
        }
        return list;
    }

    public List<Variable> getAllFromAncestry(String variableParentId) {
        List list;
        Option option;
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(48).append("getting all folder variables from ancestry [id=").append(variableParentId).append("]").toString());
        String string = variableParentId;
        if (string != null && !(option = IdMatchers.FolderId$.MODULE$.unapply(string)).isEmpty()) {
            String folderId = (String)option.get();
            list = CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)this.variablePersistence.findByParentIdIncludingAncestors(folderId).map((Function1 & Serializable)variableRow -> this.toVariable((FolderVariableRow)variableRow))).asJava();
        } else {
            list = CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)Buffer$.MODULE$.empty()).asJava();
        }
        return list;
    }

    private Variable toVariable(FolderVariableRow variableRow) {
        return (Variable)this.repositoryAdapter.deserialize(variableRow.json(), new ResolveOptionsBuilder().withEverything().build()).map((Function1 & Serializable)variable -> {
            variable.setFolderId(variableRow.folderId().absolute());
            return variable;
        }).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(60).append("Error reading folder variable '").append(variableRow.ciUid()).append("', see logs for more details.").toString(), new Object[0]);
        });
    }

    @Autowired
    public SqlFolderVariableRepository(FolderVariablePersistence variablePersistence, SqlRepositoryAdapter repositoryAdapter) {
        this.variablePersistence = variablePersistence;
        this.repositoryAdapter = repositoryAdapter;
        Logging.$init$((Logging)this);
    }
}

