/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.xlrelease.api.internal.DecoratorsCache;
import com.xebialabs.xlrelease.api.internal.DecoratorsCache$;
import com.xebialabs.xlrelease.api.internal.EffectiveSecurityDecorator$;
import com.xebialabs.xlrelease.api.internal.FolderVariablesDecorator$;
import com.xebialabs.xlrelease.api.internal.InternalMetadataDecoratorService;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.folder.Folder;
import com.xebialabs.xlrelease.domain.utils.Tree;
import com.xebialabs.xlrelease.domain.utils.Tree$;
import com.xebialabs.xlrelease.repository.FolderRepository;
import com.xebialabs.xlrelease.repository.FoldersStoreException;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.PersistenceInterceptor;
import com.xebialabs.xlrelease.repository.TeamRepository;
import com.xebialabs.xlrelease.repository.sql.InterceptedRepository;
import com.xebialabs.xlrelease.repository.sql.SqlRepository;
import com.xebialabs.xlrelease.repository.sql.persistence.FolderPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.FolderRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.FolderRow$;
import com.xebialabs.xlrelease.repository.sql.persistence.data.FolderRow$FolderDataOps$;
import com.xebialabs.xlrelease.repository.sql.persistence.data.FolderRow$NodeFolderDataOps$;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.security.core.Authentication;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\r}a\u0001\u0002\u0015*\u0001QB\u0001B\u0016\u0001\u0003\u0002\u0003\u0006Ia\u0016\u0005\t;\u0002\u0011\t\u0011)A\u0005=\"A\u0011\r\u0001B\u0001B\u0003%!\r\u0003\u0005f\u0001\t\u0005\t\u0015!\u0003g\u0011!q\u0007A!b\u0001\n\u0003y\u0007\u0002\u0003=\u0001\u0005\u0003\u0005\u000b\u0011\u00029\t\u0011e\u0004!Q1A\u0005\u0004iD\u0011\"a\u0004\u0001\u0005\u0003\u0005\u000b\u0011B>\t\u0015\u0005E\u0001A!b\u0001\n\u0007\t\u0019\u0002\u0003\u0006\u0002D\u0001\u0011\t\u0011)A\u0005\u0003+Aq!!\u0012\u0001\t\u0003\t9\u0005C\u0004\u0002Z\u0001!\t%a\u0017\t\u000f\u0005m\u0005\u0001\"\u0011\u0002\u001e\"9\u00111\u0016\u0001\u0005B\u00055\u0006bBAd\u0001\u0011\u0005\u0011\u0011\u001a\u0005\b\u0003S\u0004A\u0011IAv\u0011\u001d\ti\u0010\u0001C!\u0003\u007fDqAa\u0002\u0001\t\u0003\u0012I\u0001C\u0005\u0003\"\u0001\t\n\u0011\"\u0001\u0003$!9!q\u0007\u0001\u0005\u0002\te\u0002b\u0002B#\u0001\u0011\u0005!q\t\u0005\b\u0005\u001b\u0002A\u0011\tB(\u0011\u001d\u00119\u0006\u0001C!\u00053BqA!\u001b\u0001\t\u0003\u0012Y\u0007C\u0004\u0003v\u0001!\tEa\u001e\t\u000f\t\u0005\u0005\u0001\"\u0011\u0003\u0004\"I!Q\u0012\u0001\u0012\u0002\u0013\u0005!q\u0012\u0005\b\u0005'\u0003A\u0011\tBK\u0011\u001d\u0011y\n\u0001C!\u0005CC\u0001B!+\u0001\t\u0003I#1\u0016\u0005\t\u0005\u007f\u0003A\u0011A\u0015\u0003B\"A!q\u001d\u0001\u0005\u0002%\u0012I\u000f\u0003\u0006\u0003p\u0002\t\n\u0011\"\u0001*\u0005\u001fC\u0001B!=\u0001\t\u0003I#1\u001f\u0005\u000b\u0005w\u0004\u0011\u0013!C\u0001S\t=\u0005b\u0002B\u007f\u0001\u0011%!q \u0005\n\u0007\u0017\u0001\u0011\u0013!C\u0005\u0005\u001fC\u0001b!\u0004\u0001\t\u0003I3q\u0002\u0005\u000b\u0007+\u0001\u0011\u0013!C\u0001S\t=%aE*rY\u001a{G\u000eZ3s%\u0016\u0004xn]5u_JL(B\u0001\u0016,\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003Y5\n!B]3q_NLGo\u001c:z\u0015\tqs&A\u0005yYJ,G.Z1tK*\u0011\u0001'M\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011AM\u0001\u0004G>l7\u0001A\n\u0007\u0001UZth\u0013(\u0011\u0005YJT\"A\u001c\u000b\u0003a\nQa]2bY\u0006L!AO\u001c\u0003\r\u0005s\u0017PU3g!\taT(D\u0001,\u0013\tq4F\u0001\tG_2$WM\u001d*fa>\u001c\u0018\u000e^8ssB\u0019\u0001)Q\"\u000e\u0003%J!AQ\u0015\u0003+%sG/\u001a:dKB$X\r\u001a*fa>\u001c\u0018\u000e^8ssB\u0011A)S\u0007\u0002\u000b*\u0011aiR\u0001\u0007M>dG-\u001a:\u000b\u0005!k\u0013A\u00023p[\u0006Lg.\u0003\u0002K\u000b\n1ai\u001c7eKJ\u0004\"\u0001\u0011'\n\u00055K#!D*rYJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002P)6\t\u0001K\u0003\u0002R%\u0006)1\u000f\u001c45U*\t1+\u0001\u0005he&T(\u0010\\3e\u0013\t)\u0006KA\u0004M_\u001e<\u0017N\\4\u0002#\u0019|G\u000eZ3s!\u0016\u00148/[:uK:\u001cW\r\u0005\u0002Y76\t\u0011L\u0003\u0002[S\u0005Y\u0001/\u001a:tSN$XM\\2f\u0013\ta\u0016LA\tG_2$WM\u001d)feNL7\u000f^3oG\u0016\f!C]3mK\u0006\u001cX\rU3sg&\u001cH/\u001a8dKB\u0011\u0001lX\u0005\u0003Af\u0013!CU3mK\u0006\u001cX\rU3sg&\u001cH/\u001a8dK\u0006qA/Z1n%\u0016\u0004xn]5u_JL\bC\u0001\u001fd\u0013\t!7F\u0001\bUK\u0006l'+\u001a9pg&$xN]=\u0002%A,'/\\5tg&|g.\u00128g_J\u001cWM\u001d\t\u0003O2l\u0011\u0001\u001b\u0006\u0003S*\f\u0001b]3dkJLG/\u001f\u0006\u0003W>\n\u0001\u0002Z3qY>L\u0018\u000e^\u0005\u0003[\"\u0014!\u0003U3s[&\u001c8/[8o\u000b:4wN]2fe\u0006\u0001B-Z2pe\u0006$xN]*feZL7-Z\u000b\u0002aB\u0011\u0011O^\u0007\u0002e*\u00111\u000f^\u0001\tS:$XM\u001d8bY*\u0011Q/L\u0001\u0004CBL\u0017BA<s\u0005\u0001Je\u000e^3s]\u0006dW*\u001a;bI\u0006$\u0018\rR3d_J\fGo\u001c:TKJ4\u0018nY3\u0002#\u0011,7m\u001c:bi>\u00148+\u001a:wS\u000e,\u0007%\u0001\u0007kI\n\u001cG+Z7qY\u0006$X-F\u0001|!\ra\u00181B\u0007\u0002{*\u0011ap`\u0001\u0005G>\u0014XM\u0003\u0003\u0002\u0002\u0005\r\u0011\u0001\u00026eE\u000eTA!!\u0002\u0002\b\u0005y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148N\u0003\u0002\u0002\n\u0005\u0019qN]4\n\u0007\u00055QP\u0001\u0007KI\n\u001cG+Z7qY\u0006$X-A\u0007kI\n\u001cG+Z7qY\u0006$X\rI\u0001\bI&\fG.Z2u+\t\t)\u0002\u0005\u0003\u0002\u0018\u0005ub\u0002BA\r\u0003oqA!a\u0007\u000249!\u0011QDA\u0018\u001d\u0011\ty\"!\f\u000f\t\u0005\u0005\u00121\u0006\b\u0005\u0003G\tI#\u0004\u0002\u0002&)\u0019\u0011qE\u001a\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0011\u0014B\u0001\u00192\u0013\tqs&C\u0002\u000225\n!\u0001\u001a2\n\u0007)\n)DC\u0002\u000225JA!!\u000f\u0002<\u0005Q1+\u001d7Ck&dG-\u001a:\u000b\u0007)\n)$\u0003\u0003\u0002@\u0005\u0005#a\u0002#jC2,7\r\u001e\u0006\u0005\u0003s\tY$\u0001\u0005eS\u0006dWm\u0019;!\u0003\u0019a\u0014N\\5u}Q\u0001\u0012\u0011JA&\u0003\u001b\ny%!\u0015\u0002T\u0005U\u0013q\u000b\t\u0003\u0001\u0002AQAV\u0006A\u0002]CQ!X\u0006A\u0002yCQ!Y\u0006A\u0002\tDQ!Z\u0006A\u0002\u0019DQA\\\u0006A\u0002ADQ!_\u0006A\u0004mDq!!\u0005\f\u0001\b\t)\"\u0001\u0004fq&\u001cHo\u001d\u000b\u0005\u0003;\n\u0019\u0007E\u00027\u0003?J1!!\u00198\u0005\u001d\u0011un\u001c7fC:Dq!!\u001a\r\u0001\u0004\t9'\u0001\u0005g_2$WM]%e!\u0011\tI'!\u001d\u000f\t\u0005-\u0014Q\u000e\t\u0004\u0003G9\u0014bAA8o\u00051\u0001K]3eK\u001aLA!a\u001d\u0002v\t11\u000b\u001e:j]\u001eT1!a\u001c8Q\ra\u0011\u0011\u0010\t\u0005\u0003w\n\t)\u0004\u0002\u0002~)!\u0011qPA\u001e\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\n\t\u0005\r\u0015Q\u0010\u0002\u000b\u0013N\u0014V-\u00193P]2L\bf\u0001\u0007\u0002\bB!\u0011\u0011RAL\u001b\t\tYI\u0003\u0003\u0002\u000e\u0006=\u0015AC1o]>$\u0018\r^5p]*!\u0011\u0011SAJ\u0003\u001diW\r\u001e:jGNT1!!&2\u0003!\u0019w\u000eZ1iC2,\u0017\u0002BAM\u0003\u0017\u0013Q\u0001V5nK\u0012\f\u0001bZ3u)&$H.\u001a\u000b\u0005\u0003?\u000b)\u000bE\u00037\u0003C\u000b9'C\u0002\u0002$^\u0012aa\u00149uS>t\u0007bBA3\u001b\u0001\u0007\u0011q\r\u0015\u0004\u001b\u0005e\u0004fA\u0007\u0002\b\u00069q-\u001a;QCRDG\u0003BAX\u0003\u0003\u0004b!!-\u0002<\u0006\u001dd\u0002BAZ\u0003osA!a\t\u00026&\t\u0001(C\u0002\u0002:^\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002>\u0006}&aA*fc*\u0019\u0011\u0011X\u001c\t\u000f\u0005\u0015d\u00021\u0001\u0002h!\u001aa\"!\u001f)\u00079\t9)\u0001\u0004hKR,\u0016\u000e\u001a\u000b\u0005\u0003\u0017\f\u0019\u000f\u0005\u0003\u0002N\u0006ug\u0002BAh\u00037tA!!5\u0002Z:!\u00111[Al\u001d\u0011\ti\"!6\n\u00051j\u0013B\u0001\u0016,\u0013\tQ\u0016&C\u0002\u0002:fKA!a8\u0002b\n)1)[+jI*\u0019\u0011\u0011X-\t\u000f\u0005\u0015t\u00021\u0001\u0002h!\u001aq\"!\u001f)\u0007=\t9)\u0001\u0005gS:$')_%e)\u0019\ti/a<\u0002rB!a'!)D\u0011\u001d\t)\u0007\u0005a\u0001\u0003OB\u0011\"a=\u0011!\u0003\u0005\r!!>\u0002\u000b\u0011,\u0007\u000f\u001e5\u0011\u0007Y\n90C\u0002\u0002z^\u00121!\u00138uQ\r\u0001\u0012qQ\u0001\u0018M&tGMV5fo\u0006\u0014G.\u001a$pY\u0012,'o\u001d\"z\u0013\u0012$b!!<\u0003\u0002\t\r\u0001bBA3#\u0001\u0007\u0011q\r\u0005\n\u0003g\f\u0002\u0013!a\u0001\u0003kD3!EAD\u0003Ma\u0017n\u001d;WS\u0016<\u0018M\u00197f\r>dG-\u001a:t)!\u0011YA!\u0004\u0003\u0012\tm\u0001#BAY\u0003w\u001b\u0005b\u0002B\b%\u0001\u0007\u0011qM\u0001\ta\u0006\u0014XM\u001c;JI\"9!1\u0003\nA\u0002\tU\u0011\u0001\u00029bO\u0016\u00042\u0001\u0010B\f\u0013\r\u0011Ib\u000b\u0002\u0005!\u0006<W\rC\u0005\u0003\u001eI\u0001\n\u00111\u0001\u0002^\u00059B-Z2pe\u0006$XmV5uQB+'/\\5tg&|gn\u001d\u0015\u0004%\u0005\u001d\u0015!\b7jgR4\u0016.Z<bE2,gi\u001c7eKJ\u001cH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\t\u0015\"\u0006BA/\u0005OY#A!\u000b\u0011\t\t-\"1G\u0007\u0003\u0005[QAAa\f\u00032\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u001b;\u0014\u0002\u0002B\u001b\u0005[\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003a\u0019X\r^!t\u000b\u001a4Wm\u0019;jm\u0016\u001cVmY;sSRL\u0018\n\u001a\u000b\u0005\u0005w\u0011\t\u0005E\u00027\u0005{I1Aa\u00108\u0005\u0011)f.\u001b;\t\u000f\u0005\u0015D\u00031\u0001\u0002h!\u001aA#a\"\u00025%t\u0007.\u001a:ji\u00163g-Z2uSZ,7+Z2ve&$\u00180\u00133\u0015\t\tm\"\u0011\n\u0005\b\u0003K*\u0002\u0019AA4Q\r)\u0012qQ\u0001\u0007GJ,\u0017\r^3\u0015\u000b\r\u0013\tFa\u0015\t\u000f\t=a\u00031\u0001\u0002h!)aI\u0006a\u0001\u0007\"\u001aa#a\"\u0002\r\u0011,G.\u001a;f)\u0019\u0011YDa\u0017\u0003^!9\u0011QM\fA\u0002\u0005\u001d\u0004\"\u0003B0/A\u0005\t\u0019\u0001B1\u00035!W\r\\3uKJ+G.Z1tKBIaGa\u0019\u0002v\u0006\u001d$1H\u0005\u0004\u0005K:$!\u0003$v]\u000e$\u0018n\u001c83Q\r9\u0012qQ\u0001\u0007e\u0016t\u0017-\\3\u0015\u000b\r\u0013iGa\u001c\t\u000f\u0005\u0015\u0004\u00041\u0001\u0002h!9!\u0011\u000f\rA\u0002\u0005\u001d\u0014a\u00028fo:\u000bW.\u001a\u0015\u00041\u0005\u001d\u0015\u0001B7pm\u0016$Ra\u0011B=\u0005wBq!!\u001a\u001a\u0001\u0004\t9\u0007C\u0004\u0003~e\u0001\r!a\u001a\u0002\u00179,w\u000fU1sK:$\u0018\n\u001a\u0015\u00043\u0005\u001d\u0015A\u00034j]\u0012\u0014\u0015\u0010U1uQR)1I!\"\u0003\n\"9!q\u0011\u000eA\u0002\u0005\u001d\u0014!\u0003;ji2,\u0007+\u0019;i\u0011%\t\u0019P\u0007I\u0001\u0002\u0004\t)\u0010K\u0002\u001b\u0003\u000f\u000bACZ5oI\nK\b+\u0019;iI\u0011,g-Y;mi\u0012\u0012TC\u0001BIU\u0011\t)Pa\n\u0002)\u0019Lg\u000eZ*vE\u001a{G\u000eZ3s\u0005f$\u0016\u000e\u001e7f)\u0019\tiOa&\u0003\u001a\"9!q\u0002\u000fA\u0002\u0005\u001d\u0004b\u0002BN9\u0001\u0007\u0011qM\u0001\u0005]\u0006lW\rK\u0002\u001d\u0003\u000f\u000b\u0011#[:G_2$WM]%oQ\u0016\u0014\u0018\u000e^3e)\u0011\tiFa)\t\u000f\u0005\u0015T\u00041\u0001\u0002h!\u001aQ$!\u001f)\u0007u\t9)\u0001\rgS:$7+\u001e2G_2$WM\u001d#bi\u0006\u0014\u0015\u0010V5uY\u0016$bA!,\u0003<\nu\u0006#\u0002\u001c\u0002\"\n=\u0006\u0003\u0002BY\u0005ok!Aa-\u000b\u0007\tU\u0016,\u0001\u0003eCR\f\u0017\u0002\u0002B]\u0005g\u0013\u0011BR8mI\u0016\u0014(k\\<\t\u000f\u0005\u0015d\u00041\u0001\u0002h!9!1\u0014\u0010A\u0002\u0005\u001d\u0014AC5og\u0016\u0014HOT8eKRA!1\u0019Bo\u0005?\u0014\u0019\u000f\u0005\u0004\u0003F\n]'q\u0016\b\u0005\u0005\u000f\u0014\tN\u0004\u0003\u0003J\n5g\u0002BA\u000f\u0005\u0017L!\u0001S\u0017\n\u0007\t=w)A\u0003vi&d7/\u0003\u0003\u0003T\nU\u0017\u0001\u0002+sK\u0016T1Aa4H\u0013\u0011\u0011INa7\u0003\t9{G-\u001a\u0006\u0005\u0005'\u0014)\u000eC\u0004\u0003\u001c~\u0001\r!a\u001a\t\u000f\t\u0005x\u00041\u0001\u0002h\u00059q-\u001b<f]&#\u0007b\u0002Bs?\u0001\u0007\u0011qT\u0001\fa\u0006\u0014XM\u001c;JI>\u0003H/\u0001\u0007gS:$gj\u001c3f\u0005fLE\r\u0006\u0004\u0003D\n-(Q\u001e\u0005\b\u0003K\u0002\u0003\u0019AA4\u0011%\t\u0019\u0010\tI\u0001\u0002\u0004\t)0\u0001\fgS:$gj\u001c3f\u0005fLE\r\n3fM\u0006,H\u000e\u001e\u00133\u000351\u0017N\u001c3O_\u0012,')_+jIR1!1\u0019B{\u0005sDqAa>#\u0001\u0004\tY-A\u0003dSVKG\rC\u0005\u0002t\n\u0002\n\u00111\u0001\u0002v\u00069b-\u001b8e\u001d>$WMQ=VS\u0012$C-\u001a4bk2$HEM\u0001\u0012Y&\u001cHOV5fo\u0006\u0014G.\u001a(pI\u0016\u001cHCBB\u0001\u0007\u000f\u0019I\u0001\u0005\u0004\u00022\u000e\r!1Y\u0005\u0005\u0007\u000b\tyL\u0001\u0003MSN$\bbBA3I\u0001\u0007\u0011q\r\u0005\n\u0003g$\u0003\u0013!a\u0001\u0003k\f1\u0004\\5tiZKWm^1cY\u0016tu\u000eZ3tI\u0011,g-Y;mi\u0012\u0012\u0014!\u00064j]\u00124\u0016.Z<bE2,gj\u001c3fg\nK\u0018\n\u001a\u000b\u0007\u0005\u0007\u001c\tba\u0005\t\u000f\u0005\u0015d\u00051\u0001\u0002h!I\u00111\u001f\u0014\u0011\u0002\u0003\u0007\u0011Q_\u0001 M&tGMV5fo\u0006\u0014G.\u001a(pI\u0016\u001c()_%eI\u0011,g-Y;mi\u0012\u0012\u0004f\u0001\u0001\u0004\u001aA!\u00111PB\u000e\u0013\u0011\u0019i\"! \u0003\u001f%\u001bHK]1og\u0006\u001cG/[8oC2\u0004")
public class SqlFolderRepository
implements FolderRepository,
InterceptedRepository<Folder>,
SqlRepository {
    private final FolderPersistence folderPersistence;
    private final ReleasePersistence releasePersistence;
    private final TeamRepository teamRepository;
    private final PermissionEnforcer permissionEnforcer;
    private final InternalMetadataDecoratorService decoratorService;
    private final JdbcTemplate jdbcTemplate;
    private final SqlBuilder.Dialect dialect;
    private scala.collection.immutable.Seq<PersistenceInterceptor<Folder>> persistenceInterceptors;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public void registerPersistenceInterceptor(PersistenceInterceptor<Folder> persistenceInterceptor) {
        InterceptedRepository.registerPersistenceInterceptor$((InterceptedRepository)this, persistenceInterceptor);
    }

    public void interceptCreate(ConfigurationItem ci) {
        InterceptedRepository.interceptCreate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void interceptDelete(String ciId) {
        InterceptedRepository.interceptDelete$((InterceptedRepository)this, (String)ciId);
    }

    public void interceptUpdate(ConfigurationItem ci) {
        InterceptedRepository.interceptUpdate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterCreate(ConfigurationItem ci) {
        InterceptedRepository.afterCreate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterUpdate(ConfigurationItem ci) {
        InterceptedRepository.afterUpdate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterDelete(String ciId) {
        InterceptedRepository.afterDelete$((InterceptedRepository)this, (String)ciId);
    }

    public Function2<Object, String, BoxedUnit> delete$default$2() {
        return FolderRepository.delete$default$2$((FolderRepository)this);
    }

    public int findById$default$2() {
        return FolderRepository.findById$default$2$((FolderRepository)this);
    }

    public int findViewableFoldersById$default$2() {
        return FolderRepository.findViewableFoldersById$default$2$((FolderRepository)this);
    }

    public void checkFolderExists(String folderId) {
        FolderRepository.checkFolderExists$((FolderRepository)this, (String)folderId);
    }

    public void checkNameIsUnique(String parentId, String name) {
        FolderRepository.checkNameIsUnique$((FolderRepository)this, (String)parentId, (String)name);
    }

    public scala.collection.immutable.Seq<Folder> paginate(scala.collection.immutable.Seq<Folder> folders, Page page) {
        return FolderRepository.paginate$((FolderRepository)this, folders, (Page)page);
    }

    public scala.collection.immutable.Seq<Folder> decorateWithEffectiveSecurity(scala.collection.immutable.Seq<Folder> folders, DecoratorsCache cache) {
        return FolderRepository.decorateWithEffectiveSecurity$((FolderRepository)this, folders, (DecoratorsCache)cache);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    public scala.collection.immutable.Seq<PersistenceInterceptor<Folder>> persistenceInterceptors() {
        return this.persistenceInterceptors;
    }

    public void persistenceInterceptors_$eq(scala.collection.immutable.Seq<PersistenceInterceptor<Folder>> x$1) {
        this.persistenceInterceptors = x$1;
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlFolderRepository sqlFolderRepository = this;
        synchronized (sqlFolderRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public InternalMetadataDecoratorService decoratorService() {
        return this.decoratorService;
    }

    @Override
    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    @Override
    public SqlBuilder.Dialect dialect() {
        return this.dialect;
    }

    @Timed
    @IsReadOnly
    public boolean exists(String folderId) {
        return this.folderPersistence.exists(folderId);
    }

    @Timed
    @IsReadOnly
    public Option<String> getTitle(String folderId) {
        return this.findById(folderId, 0).map((Function1 & Serializable)x$1 -> x$1.getTitle());
    }

    @Timed
    @IsReadOnly
    public scala.collection.immutable.Seq<String> getPath(String folderId) {
        return this.folderPersistence.getFolderPathSegments(folderId);
    }

    @Timed
    @IsReadOnly
    public Integer getUid(String folderId) {
        return this.folderPersistence.getUid(folderId);
    }

    @Timed
    public Option<Folder> findById(String folderId, int depth) {
        return Tree.TreeOps$.MODULE$.toOption$extension(Tree$.MODULE$.TreeOps(this.findNodeById(folderId, depth))).map((Function1 & Serializable)tree -> {
            void var2_2;
            Folder folder = FolderRow$NodeFolderDataOps$.MODULE$.toFolder$extension(FolderRow$.MODULE$.NodeFolderDataOps((Tree.Node<FolderRow>)tree));
            this.decoratorService().decorate((ConfigurationItem)folder, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{EffectiveSecurityDecorator$.MODULE$.EFFECTIVE_SECURITY(), FolderVariablesDecorator$.MODULE$.FOLDER_VARIABLES()}))).asJava());
            return var2_2;
        });
    }

    @Timed
    public Option<Folder> findViewableFoldersById(String folderId, int depth) {
        DecoratorsCache cache = new DecoratorsCache(DecoratorsCache$.MODULE$.$lessinit$greater$default$1());
        return Tree.TreeOps$.MODULE$.toOption$extension(Tree$.MODULE$.TreeOps(this.findViewableNodesById(folderId, depth))).map((Function1 & Serializable)tree -> {
            void var3_3;
            Folder folder = FolderRow$NodeFolderDataOps$.MODULE$.toFolder$extension(FolderRow$.MODULE$.NodeFolderDataOps((Tree.Node<FolderRow>)tree));
            this.decoratorService().decorate((ConfigurationItem)folder, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{EffectiveSecurityDecorator$.MODULE$.EFFECTIVE_SECURITY(), FolderVariablesDecorator$.MODULE$.FOLDER_VARIABLES()}))).asJava(), cache);
            folder.setChildren(CollectionConverters$.MODULE$.SetHasAsJava((Set)this.decorateWithEffectiveSecurity((scala.collection.immutable.Seq<Folder>)CollectionConverters$.MODULE$.SetHasAsScala(folder.getChildren()).asScala().toSeq(), cache).toSet()).asJava());
            return var3_3;
        });
    }

    @Timed
    public scala.collection.immutable.Seq<Folder> listViewableFolders(String parentId, Page page, boolean decorateWithPermissions) {
        scala.collection.immutable.Seq<Folder> results = this.listViewableNodes(parentId, page.depth()).map((Function1 & Serializable)x$2 -> FolderRow$NodeFolderDataOps$.MODULE$.toFolder$extension(FolderRow$.MODULE$.NodeFolderDataOps((Tree.Node<FolderRow>)x$2)));
        DecoratorsCache decoratorsCache = new DecoratorsCache(DecoratorsCache$.MODULE$.$lessinit$greater$default$1());
        return this.paginate(decorateWithPermissions ? this.decorateWithEffectiveSecurity(results, decoratorsCache) : results, page);
    }

    public boolean listViewableFolders$default$3() {
        return true;
    }

    @Timed
    public void setAsEffectiveSecurityId(String folderId) {
        this.folderPersistence.setAsEffectiveSecuredCi(folderId);
    }

    @Timed
    public void inheritEffectiveSecurityId(String folderId) {
        this.folderPersistence.inheritEffectiveSecuredCi(folderId);
    }

    @Timed
    public Folder create(String parentId, Folder folder) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> {
            this.interceptCreate((ConfigurationItem)folder);
            return this.insertNode(folder.getTitle(), folder.getId(), (Option<String>)new Some((Object)parentId));
        });
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                throw new FoldersStoreException(new StringBuilder(28).append("Cannot create folder ").append(folder.getId()).append(" under ").append(parentId).toString(), e);
            }
            throw new MatchError((Object)try_);
        }
        Success success = (Success)try_;
        Tree.Node created = (Tree.Node)success.value();
        Folder folder2 = FolderRow$NodeFolderDataOps$.MODULE$.toFolder$extension(FolderRow$.MODULE$.NodeFolderDataOps((Tree.Node<FolderRow>)created));
        return folder2;
    }

    @Timed
    public void delete(String folderId, Function2<Object, String, BoxedUnit> deleteRelease) {
        Integer ciUid = ((FolderRow)this.findNodeById(folderId, 0).value()).uid();
        this.folderPersistence.deleteReleases(ciUid, deleteRelease);
        Tree.TreeOps$.MODULE$.bottomUp$extension(Tree$.MODULE$.TreeOps(this.findNodeById(folderId, this.findNodeById$default$2()))).foreach((Function1 & Serializable)data -> {
            SqlFolderRepository.$anonfun$delete$1(this, data);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public Folder rename(String folderId, String newName) {
        return this.folderPersistence.rename(folderId, newName, this.folderPersistence.rename$default$3());
    }

    @Timed
    public Folder move(String folderId, String newParentId) {
        Integer oldSubtreeSecurityUid = ((FolderRow)this.findNodeById(folderId, 0).value()).securityUid();
        Tree.Node<FolderRow> moved = this.folderPersistence.move(folderId, newParentId, this.folderPersistence.move$default$3());
        Integer newSubtreeSecurityUid = ((FolderRow)moved.value()).securityUid();
        this.releasePersistence.replaceSecurityUid(((FolderRow)moved.value()).uid(), oldSubtreeSecurityUid, newSubtreeSecurityUid);
        return FolderRow$NodeFolderDataOps$.MODULE$.toFolder$extension(FolderRow$.MODULE$.NodeFolderDataOps(moved));
    }

    @Timed
    public Folder findByPath(String titlePath, int depth) {
        if (Strings.isEmpty((String)titlePath)) {
            throw new NotFoundException(new StringBuilder(34).append("Cannot find folder by empty path: ").append(titlePath).toString(), new Object[0]);
        }
        String pathFromRoot = titlePath.startsWith("/") ? titlePath.substring(1) : titlePath;
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(23).append("Finding folder by path ").append(pathFromRoot).toString());
        String[] pathElements = (String[])ArrayOps$.MODULE$.filterNot$extension(Predef$.MODULE$.refArrayOps((Object[])pathFromRoot.split("/")), (Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isEmpty()));
        if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])pathElements))) {
            throw new IllegalArgumentException("No folder path specified, the root path is not supported");
        }
        Option option = ArrayOps$.MODULE$.headOption$extension(Predef$.MODULE$.refArrayOps((Object[])pathElements));
        if (None$.MODULE$.equals(option)) {
            throw new NotFoundException(new StringBuilder(34).append("Cannot find folder by empty path: ").append(titlePath).toString(), new Object[0]);
        }
        if (!(option instanceof Some)) {
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        String topName = (String)some.value();
        Option<FolderRow> option2 = this.findSubFolderDataByTitle(Ids.ROOT_FOLDER_ID, topName);
        Option<FolderRow> topLevelData = option2;
        Integer topLevelUid = (Integer)topLevelData.map((Function1 & Serializable)x$4 -> x$4.uid()).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(35).append("Could not find folder [").append(ArrayOps$.MODULE$.headOption$extension(Predef$.MODULE$.refArrayOps((Object[])pathElements)).getOrElse((Function0 & Serializable)() -> "")).append("] in path [").append(titlePath).append("]").toString(), new Object[0]);
        });
        Tree.Node topNode = (Tree.Node)Tree.TreeOps$.MODULE$.toOption$extension(Tree$.MODULE$.TreeOps(this.findNodeByUid(topLevelUid, Math.max(depth, ((String[])ArrayOps$.MODULE$.tail$extension(Predef$.MODULE$.refArrayOps((Object[])pathElements))).length)))).get();
        return FolderRow$NodeFolderDataOps$.MODULE$.toFolder$extension(FolderRow$.MODULE$.NodeFolderDataOps((Tree.Node<FolderRow>)((Tree.Node)ArrayOps$.MODULE$.foldLeft$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.tail$extension(Predef$.MODULE$.refArrayOps((Object[])pathElements))), (Object)topNode, (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Tree.Node node = (Tree.Node)tuple2._1();
            String pathElement = (String)tuple2._2();
            Tree.Node node2 = (Tree.Node)node.children().find((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)SqlFolderRepository.$anonfun$findByPath$7(pathElement, x$5))).getOrElse((Function0 & Serializable)() -> {
                throw new NotFoundException(new StringBuilder(35).append("Could not find folder [").append(pathElement).append("] in path [").append(titlePath).append("]").toString(), new Object[0]);
            });
            return node2;
        }))));
    }

    public int findByPath$default$2() {
        return Integer.MAX_VALUE;
    }

    @Timed
    public Option<Folder> findSubFolderByTitle(String parentId, String name) {
        return this.findSubFolderDataByTitle(parentId, name).map((Function1 & Serializable)x$6 -> FolderRow$FolderDataOps$.MODULE$.asFolder$extension(FolderRow$.MODULE$.FolderDataOps((FolderRow)x$6)));
    }

    @Timed
    @IsReadOnly
    public boolean isFolderInherited(String folderId) {
        return this.folderPersistence.isInherited(folderId);
    }

    public Option<FolderRow> findSubFolderDataByTitle(String folderId, String name) {
        return this.folderPersistence.findSubFolderByTitle(name, folderId);
    }

    public Tree.Node<FolderRow> insertNode(String name, String givenId, Option<String> parentIdOpt) {
        return this.folderPersistence.create(name, givenId, parentIdOpt);
    }

    public Tree.Node<FolderRow> findNodeById(String folderId, int depth) {
        return this.folderPersistence.findById(folderId, depth);
    }

    public int findNodeById$default$2() {
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - void declaration
     */
    public Tree.Node<FolderRow> findNodeByUid(Integer ciUid, int depth) {
        void var3_3;
        Tree.Node<FolderRow> viewableTree = this.permissionEnforcer.isCurrentUserAdmin() || this.permissionEnforcer.hasLoggedInUserPermission(new Permission[]{XLReleasePermissions.AUDIT_ALL}) ? this.folderPersistence.findByUid(ciUid, depth) : this.folderPersistence.findByUidHavingPermission(ciUid, XLReleasePermissions.VIEW_FOLDER, (Iterable<String>)CollectionConverters$.MODULE$.CollectionHasAsScala(Permissions.authenticationToPrincipals((Authentication)Permissions.getAuthentication())).asScala(), depth);
        return var3_3;
    }

    public int findNodeByUid$default$2() {
        return Integer.MAX_VALUE;
    }

    private List<Tree.Node<FolderRow>> listViewableNodes(String folderId, int depth) {
        Tree.Node<FolderRow> viewableTree = this.findViewableNodesById(folderId, depth);
        return (List)Tree.TreeOps$.MODULE$.toOption$extension(Tree$.MODULE$.TreeOps(viewableTree)).fold((Function0 & Serializable)() -> package$.MODULE$.List().empty(), (Function1 & Serializable)x$7 -> x$7.children());
    }

    private int listViewableNodes$default$2() {
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - void declaration
     */
    public Tree.Node<FolderRow> findViewableNodesById(String folderId, int depth) {
        void var3_3;
        Tree.Node<FolderRow> viewableTree = this.permissionEnforcer.isCurrentUserAdmin() || this.permissionEnforcer.hasLoggedInUserPermission(new Permission[]{XLReleasePermissions.AUDIT_ALL}) ? this.folderPersistence.findById(folderId, depth) : this.folderPersistence.findByIdHavingPermission(folderId, XLReleasePermissions.VIEW_FOLDER, (Iterable<String>)CollectionConverters$.MODULE$.CollectionHasAsScala(Permissions.authenticationToPrincipals((Authentication)Permissions.getAuthentication())).asScala(), depth);
        return var3_3;
    }

    public int findViewableNodesById$default$2() {
        return Integer.MAX_VALUE;
    }

    public static final /* synthetic */ void $anonfun$delete$1(SqlFolderRepository $this, FolderRow data) {
        if (data.hasSecurity()) {
            $this.teamRepository.deleteTeamsFromPlatform(data.folderId().absolute());
        }
        $this.folderPersistence.deleteByUid(data.uid());
        $this.interceptDelete(data.folderId().absolute());
    }

    public static final /* synthetic */ boolean $anonfun$findByPath$7(String pathElement$1, Tree.Node x$5) {
        String string = ((FolderRow)x$5.value()).name();
        String string2 = pathElement$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public SqlFolderRepository(FolderPersistence folderPersistence, ReleasePersistence releasePersistence, TeamRepository teamRepository, PermissionEnforcer permissionEnforcer, InternalMetadataDecoratorService decoratorService, JdbcTemplate jdbcTemplate, SqlBuilder.Dialect dialect) {
        this.folderPersistence = folderPersistence;
        this.releasePersistence = releasePersistence;
        this.teamRepository = teamRepository;
        this.permissionEnforcer = permissionEnforcer;
        this.decoratorService = decoratorService;
        this.jdbcTemplate = jdbcTemplate;
        this.dialect = dialect;
        Logging.$init$((Logging)this);
        FolderRepository.$init$((FolderRepository)this);
        InterceptedRepository.$init$((InterceptedRepository)this);
    }
}

