/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.repository.IdMatchers;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.PlanItemRepository;
import com.xebialabs.xlrelease.repository.ResolveOptions;
import com.xebialabs.xlrelease.repository.ResolveOptions$;
import com.xebialabs.xlrelease.repository.ResolveOptionsBuilder;
import com.xebialabs.xlrelease.repository.sql.DeserializationSupport;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$RichCiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.ReleaseRow;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\u0005Ed\u0001B\u0006\r\u0001]A\u0001B\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\tk\u0001\u0011\t\u0011)A\u0005m!A\u0011\b\u0001BC\u0002\u0013\u0005!\b\u0003\u0005?\u0001\t\u0005\t\u0015!\u0003<\u0011\u0015y\u0004\u0001\"\u0001A\u0011\u0015)\u0005\u0001\"\u0011G\u0011\u00159\b\u0001\"\u0011y\u0011\u00199\b\u0001\"\u0011\u0002\u001a!9\u0011\u0011\t\u0001\u0005\n\u0005\r\u0003bBA(\u0001\u0011%\u0011\u0011\u000b\u0002\u0016'Fd\u0007\u000b\\1o\u0013R,WNU3q_NLGo\u001c:z\u0015\tia\"A\u0002tc2T!a\u0004\t\u0002\u0015I,\u0007o\\:ji>\u0014\u0018P\u0003\u0002\u0012%\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003'Q\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003U\t1aY8n\u0007\u0001\u0019R\u0001\u0001\r\u001fE\u0019\u0002\"!\u0007\u000f\u000e\u0003iQ\u0011aG\u0001\u0006g\u000e\fG.Y\u0005\u0003;i\u0011a!\u00118z%\u00164\u0007CA\u0010!\u001b\u0005q\u0011BA\u0011\u000f\u0005I\u0001F.\u00198Ji\u0016l'+\u001a9pg&$xN]=\u0011\u0005\r\"S\"\u0001\u0007\n\u0005\u0015b!A\u0006#fg\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8TkB\u0004xN\u001d;\u0011\u0005\u001dbS\"\u0001\u0015\u000b\u0005%R\u0013!B:mMRR'\"A\u0016\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!!\f\u0015\u0003\u000f1{wmZ5oO\u0006\u0011\"/\u001a7fCN,\u0007+\u001a:tSN$XM\\2f!\t\u00014'D\u00012\u0015\t\u0011D\"A\u0006qKJ\u001c\u0018n\u001d;f]\u000e,\u0017B\u0001\u001b2\u0005I\u0011V\r\\3bg\u0016\u0004VM]:jgR,gnY3\u0002\u001fQ\f7o\u001b)feNL7\u000f^3oG\u0016\u0004\"\u0001M\u001c\n\u0005a\n$a\u0004+bg.\u0004VM]:jgR,gnY3\u0002#I,\u0007o\\:ji>\u0014\u00180\u00113baR,'/F\u0001<!\t\u0019C(\u0003\u0002>\u0019\t!2+\u001d7SKB|7/\u001b;pef\fE-\u00199uKJ\f!C]3q_NLGo\u001c:z\u0003\u0012\f\u0007\u000f^3sA\u00051A(\u001b8jiz\"B!\u0011\"D\tB\u00111\u0005\u0001\u0005\u0006]\u0015\u0001\ra\f\u0005\u0006k\u0015\u0001\rA\u000e\u0005\u0006s\u0015\u0001\raO\u0001\u0007KbL7\u000f^:\u0015\u0005\u001dS\u0005CA\rI\u0013\tI%DA\u0004C_>dW-\u00198\t\u000b-3\u0001\u0019\u0001'\u0002\t\rL\u0017\n\u001a\t\u0003\u001b~s!AT/\u000f\u0005=cfB\u0001)\\\u001d\t\t&L\u0004\u0002S3:\u00111\u000b\u0017\b\u0003)^k\u0011!\u0016\u0006\u0003-Z\ta\u0001\u0010:p_Rt\u0014\"A\u000b\n\u0005M!\u0012BA\t\u0013\u0013\ty\u0001#\u0003\u0002\u000e\u001d%\u0011!\u0007D\u0005\u0003=F\nAaQ5JI&\u0011\u0001-\u0019\u0002\u0005\u0007&LEM\u0003\u0002_c!\u0012aa\u0019\t\u0003I*l\u0011!\u001a\u0006\u0003M\u001e\f1\u0002\u001e:b]N\f7\r^5p]*\u0011Q\u0002\u001b\u0006\u0003SB\t!\u0001\u001a2\n\u0005-,'AC%t%\u0016\fGm\u00148ms\"\u0012a!\u001c\t\u0003]Vl\u0011a\u001c\u0006\u0003aF\f!\"\u00198o_R\fG/[8o\u0015\t\u00118/A\u0004nKR\u0014\u0018nY:\u000b\u0005Q$\u0012\u0001C2pI\u0006D\u0017\r\\3\n\u0005Y|'!\u0002+j[\u0016$\u0017\u0001\u00034j]\u0012\u0014\u00150\u00133\u0016\u0005edHc\u0001>\u0002\u0012A\u00111\u0010 \u0007\u0001\t\u0015ixA1\u0001\u007f\u0005\u0005!\u0016cA@\u0002\u0006A\u0019\u0011$!\u0001\n\u0007\u0005\r!DA\u0004O_RD\u0017N\\4\u0011\t\u0005\u001d\u0011QB\u0007\u0003\u0003\u0013Q1!a\u0003\u0011\u0003\u0019!w.\\1j]&!\u0011qBA\u0005\u0005!\u0001F.\u00198Ji\u0016l\u0007BBA\n\u000f\u0001\u0007A*\u0001\u0002jI\"\u0012qa\u0019\u0015\u0003\u000f5,B!a\u0007\u0002 Q1\u0011QDA\u0011\u0003g\u00012a_A\u0010\t\u0015i\bB1\u0001\u007f\u0011\u001d\t\u0019\u0002\u0003a\u0001\u0003G\u0001B!!\n\u0002.9!\u0011qEA\u0015!\t!&$C\u0002\u0002,i\ta\u0001\u0015:fI\u00164\u0017\u0002BA\u0018\u0003c\u0011aa\u0015;sS:<'bAA\u00165!9\u0011Q\u0007\u0005A\u0002\u0005]\u0012A\u0004:fg>dg/Z(qi&|gn\u001d\t\u0004?\u0005e\u0012bAA\u001e\u001d\tq!+Z:pYZ,w\n\u001d;j_:\u001c\bF\u0001\u0005dQ\tAQ.\u0001\u0007gS:$\u0007\u000b\\1o\u0013R,W.\u0006\u0003\u0002F\u0005%CCBA$\u0003\u0017\ni\u0005E\u0002|\u0003\u0013\"Q!`\u0005C\u0002yDQaS\u0005A\u00021Cq!!\u000e\n\u0001\u0004\t9$A\u0006gS:$'+\u001a7fCN,W\u0003BA*\u0003?\"b!!\u0016\u0002\\\u0005u\u0003\u0003BA\u0004\u0003/JA!!\u0017\u0002\n\t9!+\u001a7fCN,\u0007BBA\n\u0015\u0001\u0007A\nC\u0004\u00026)\u0001\r!a\u000e\u0005\u000f\u0005e#B1\u0001\u0002bE\u0019q0a\u0019\u0011\u0007e\t)'C\u0002\u0002hi\u00111!\u00118zQ\r\u0001\u00111\u000e\t\u0004I\u00065\u0014bAA8K\ny\u0011j\u001d+sC:\u001c\u0018m\u0019;j_:\fG\u000e")
public class SqlPlanItemRepository
implements PlanItemRepository,
DeserializationSupport,
Logging {
    private final ReleasePersistence releasePersistence;
    private final TaskPersistence taskPersistence;
    private final SqlRepositoryAdapter repositoryAdapter;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public Release deserializeRelease(ReleaseRow releaseData, ResolveOptions resolveOptions) {
        return DeserializationSupport.deserializeRelease$(this, releaseData, resolveOptions);
    }

    @Override
    public Option<Release> tryDeserializeRelease(ReleaseRow releaseData, ResolveOptions resolveOptions) {
        return DeserializationSupport.tryDeserializeRelease$(this, releaseData, resolveOptions);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlPlanItemRepository sqlPlanItemRepository = this;
        synchronized (sqlPlanItemRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Override
    public SqlRepositoryAdapter repositoryAdapter() {
        return this.repositoryAdapter;
    }

    @Timed
    @IsReadOnly
    public boolean exists(String ciId) {
        Option option;
        Option option2;
        boolean bl;
        Option option3;
        String string = CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(ciId));
        if (string != null && !(option3 = IdMatchers.ReleaseId$.MODULE$.unapply(string)).isEmpty()) {
            String id = (String)option3.get();
            bl = this.releasePersistence.existsRelease(Ids.releaseIdFrom((String)id));
        } else if (string != null && !(option2 = IdMatchers.PhaseId$.MODULE$.unapply(string)).isEmpty()) {
            bl = BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> this.findPlanItem(ciId, ResolveOptions$.MODULE$.MINIMAL()) != null).toOption().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false));
        } else if (string != null && !(option = IdMatchers.TaskId$.MODULE$.unapply(string)).isEmpty()) {
            bl = this.taskPersistence.exists(ciId);
        } else {
            this.logger().warn((Function0 & Serializable)() -> new StringBuilder(17).append("Item [").append(string).append("] not found").toString());
            bl = false;
        }
        return bl;
    }

    @Timed
    @IsReadOnly
    public <T extends PlanItem> T findById(String id) {
        return this.findById(id, new ResolveOptionsBuilder().withEverything().build());
    }

    @Timed
    @IsReadOnly
    public <T extends PlanItem> T findById(String id, ResolveOptions resolveOptions) {
        return this.findPlanItem(id, resolveOptions);
    }

    private <T extends PlanItem> T findPlanItem(String ciId, ResolveOptions resolveOptions) {
        Option option;
        Option option2;
        Release release;
        Option option3;
        String string = CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(ciId));
        if (string != null && !(option3 = IdMatchers.ReleaseId$.MODULE$.unapply(string)).isEmpty()) {
            String id = (String)option3.get();
            release = this.findRelease(id, resolveOptions);
        } else if (string != null && !(option2 = IdMatchers.PhaseId$.MODULE$.unapply(string)).isEmpty()) {
            String id = (String)option2.get();
            release = this.findRelease(Ids.releaseIdFrom((String)id), resolveOptions).getPhase(id);
        } else if (string != null && !(option = IdMatchers.TaskId$.MODULE$.unapply(string)).isEmpty()) {
            String id = (String)option.get();
            release = this.findRelease(Ids.releaseIdFrom((String)id), resolveOptions).getTask(id);
        } else {
            throw new NotFoundException(new StringBuilder(17).append("Item [").append(string).append("] not found").toString(), new Object[0]);
        }
        return (T)release;
    }

    private <Release> Release findRelease(String id, ResolveOptions resolveOptions) {
        String releaseId = Ids.releaseIdFrom((String)CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(id)));
        return (Release)this.releasePersistence.findByReleaseId(releaseId).map((Function1 & Serializable)x$1 -> this.deserializeRelease((ReleaseRow)x$1, resolveOptions)).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(20).append("Release [").append(id).append("] not found").toString(), new Object[0]);
        });
    }

    public SqlPlanItemRepository(ReleasePersistence releasePersistence, TaskPersistence taskPersistence, SqlRepositoryAdapter repositoryAdapter) {
        this.releasePersistence = releasePersistence;
        this.taskPersistence = taskPersistence;
        this.repositoryAdapter = repositoryAdapter;
        DeserializationSupport.$init$(this);
        Logging.$init$((Logging)this);
    }
}

