/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.CiWithUid;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskContainer;
import com.xebialabs.xlrelease.domain.TaskGroup;
import com.xebialabs.xlrelease.domain.blackout.BlackoutMetadata$;
import com.xebialabs.xlrelease.domain.calendar.Blackout;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.domain.utils.syntax;
import com.xebialabs.xlrelease.domain.utils.syntax$;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.repository.CommentRepository;
import com.xebialabs.xlrelease.repository.FacetRepositoryDispatcher;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ResolveOptions;
import com.xebialabs.xlrelease.repository.ResolveOptionsBuilder;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.repository.query.TaskBasicData;
import com.xebialabs.xlrelease.repository.sql.BaseReleaseItemRepository;
import com.xebialabs.xlrelease.repository.sql.ConfigurationReferencesSupport;
import com.xebialabs.xlrelease.repository.sql.DeserializationSupport;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$RichCiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.DependencyPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasesSqlBuilder;
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.TasksSqlBuilder;
import com.xebialabs.xlrelease.repository.sql.persistence.configuration.ConfigurationReferencePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.ReleaseRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.TaskRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.TaskRow$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\r\ra\u0001B\u0014)\u0001MB\u0001\u0002\u0015\u0001\u0003\u0006\u0004%\t!\u0015\u0005\t1\u0002\u0011\t\u0011)A\u0005%\"A\u0011\f\u0001BC\u0002\u0013\u0005!\f\u0003\u0005_\u0001\t\u0005\t\u0015!\u0003\\\u0011!y\u0006A!b\u0001\n\u0003\u0001\u0007\u0002\u00033\u0001\u0005\u0003\u0005\u000b\u0011B1\t\u0011\u0015\u0004!Q1A\u0005\u0002\u0019D\u0001B\u001b\u0001\u0003\u0002\u0003\u0006Ia\u001a\u0005\tW\u0002\u0011)\u0019!C\u0001Y\"A\u0001\u000f\u0001B\u0001B\u0003%Q\u000e\u0003\u0005r\u0001\t\u0015\r\u0011\"\u0001s\u0011!I\bA!A!\u0002\u0013\u0019\b\u0002\u0003>\u0001\u0005\u000b\u0007I\u0011A>\t\u0011}\u0004!\u0011!Q\u0001\nqD!\"!\u0001\u0001\u0005\u000b\u0007I1AA\u0002\u0011)\t\u0019\u0004\u0001B\u0001B\u0003%\u0011Q\u0001\u0005\b\u0003k\u0001A\u0011AA\u001c\u0011\u001d\tY\u0005\u0001C!\u0003\u001bBq!a\u0013\u0001\t\u0003\n9\nC\u0004\u0002.\u0002!\t%a,\t\u000f\u0005\r\b\u0001\"\u0011\u0002f\"9\u00111\u001f\u0001\u0005B\u0005U\bbBA\u007f\u0001\u0011\u0005\u0013q \u0005\b\u0005?\u0001A\u0011\tB\u0011\u0011\u001d\u00119\u0003\u0001C!\u0005SAqA!\u000f\u0001\t\u0003\u0012Y\u0004C\u0004\u0003B\u0001!\tEa\u0011\t\u000f\t%\u0003\u0001\"\u0003\u0003L!9!\u0011\u000b\u0001\u0005B\tM\u0003b\u0002B-\u0001\u0011\u0005#1\f\u0005\b\u0005k\u0002A\u0011\tB<\u0011\u001d\u0011Y\t\u0001C!\u0005\u001bCqA!%\u0001\t\u0003\u0012\u0019\nC\u0004\u0003\u001c\u0002!\tE!(\t\u000f\tM\u0006\u0001\"\u0011\u00036\"9!Q\u001a\u0001\u0005B\tU\u0006b\u0002Bj\u0001\u0011\u0005#Q\u001b\u0005\b\u0005S\u0004A\u0011\tBv\u0005E\u0019\u0016\u000f\u001c+bg.\u0014V\r]8tSR|'/\u001f\u0006\u0003S)\n1a]9m\u0015\tYC&\u0001\u0006sKB|7/\u001b;pefT!!\f\u0018\u0002\u0013ad'/\u001a7fCN,'BA\u00181\u0003%AXMY5bY\u0006\u00147OC\u00012\u0003\r\u0019w.\\\u0002\u0001'\u001d\u0001AG\u000f C\u000b\"\u0003\"!\u000e\u001d\u000e\u0003YR\u0011aN\u0001\u0006g\u000e\fG.Y\u0005\u0003sY\u0012a!\u00118z%\u00164\u0007CA\u001e=\u001b\u0005Q\u0013BA\u001f+\u00059!\u0016m]6SKB|7/\u001b;pef\u0004\"a\u0010!\u000e\u0003!J!!\u0011\u0015\u00033\t\u000b7/\u001a*fY\u0016\f7/Z%uK6\u0014V\r]8tSR|'/\u001f\t\u0003\u007f\rK!\u0001\u0012\u0015\u0003-\u0011+7/\u001a:jC2L'0\u0019;j_:\u001cV\u000f\u001d9peR\u0004\"a\u0010$\n\u0005\u001dC#AH\"p]\u001aLw-\u001e:bi&|gNU3gKJ,gnY3t'V\u0004\bo\u001c:u!\tIe*D\u0001K\u0015\tYE*A\u0003tY\u001a$$NC\u0001N\u0003!9'/\u001b>{Y\u0016$\u0017BA(K\u0005\u001daunZ4j]\u001e\f!C]3mK\u0006\u001cX\rU3sg&\u001cH/\u001a8dKV\t!\u000b\u0005\u0002T-6\tAK\u0003\u0002VQ\u0005Y\u0001/\u001a:tSN$XM\\2f\u0013\t9FK\u0001\nSK2,\u0017m]3QKJ\u001c\u0018n\u001d;f]\u000e,\u0017a\u0005:fY\u0016\f7/\u001a)feNL7\u000f^3oG\u0016\u0004\u0013!\u00063fa\u0016tG-\u001a8dsB+'o]5ti\u0016t7-Z\u000b\u00027B\u00111\u000bX\u0005\u0003;R\u0013Q\u0003R3qK:$WM\\2z!\u0016\u00148/[:uK:\u001cW-\u0001\feKB,g\u000eZ3oGf\u0004VM]:jgR,gnY3!\u0003=!\u0018m]6QKJ\u001c\u0018n\u001d;f]\u000e,W#A1\u0011\u0005M\u0013\u0017BA2U\u0005=!\u0016m]6QKJ\u001c\u0018n\u001d;f]\u000e,\u0017\u0001\u0005;bg.\u0004VM]:jgR,gnY3!\u0003E\u0019w.\\7f]R\u0014V\r]8tSR|'/_\u000b\u0002OB\u00111\b[\u0005\u0003S*\u0012\u0011cQ8n[\u0016tGOU3q_NLGo\u001c:z\u0003I\u0019w.\\7f]R\u0014V\r]8tSR|'/\u001f\u0011\u0002#I,\u0007o\\:ji>\u0014\u00180\u00113baR,'/F\u0001n!\tyd.\u0003\u0002pQ\t!2+\u001d7SKB|7/\u001b;pef\fE-\u00199uKJ\f!C]3q_NLGo\u001c:z\u0003\u0012\f\u0007\u000f^3sA\u0005A2m\u001c8gS\u001e,(/\u0019;j_:\u0004VM]:jgR,gnY3\u0016\u0003M\u0004\"\u0001^<\u000e\u0003UT!A\u001e+\u0002\u001b\r|gNZ5hkJ\fG/[8o\u0013\tAXOA\u0011D_:4\u0017nZ;sCRLwN\u001c*fM\u0016\u0014XM\\2f!\u0016\u00148/[:uK:\u001cW-A\rd_:4\u0017nZ;sCRLwN\u001c)feNL7\u000f^3oG\u0016\u0004\u0013!\u00074bG\u0016$(+\u001a9pg&$xN]=ESN\u0004\u0018\r^2iKJ,\u0012\u0001 \t\u0003wuL!A \u0016\u00033\u0019\u000b7-\u001a;SKB|7/\u001b;pef$\u0015n\u001d9bi\u000eDWM]\u0001\u001bM\u0006\u001cW\r\u001e*fa>\u001c\u0018\u000e^8ss\u0012K7\u000f]1uG\",'\u000fI\u0001\bI&\fG.Z2u+\t\t)\u0001\u0005\u0003\u0002\b\u00055b\u0002BA\u0005\u0003OqA!a\u0003\u0002$9!\u0011QBA\u0010\u001d\u0011\ty!!\b\u000f\t\u0005E\u00111\u0004\b\u0005\u0003'\tI\"\u0004\u0002\u0002\u0016)\u0019\u0011q\u0003\u001a\u0002\rq\u0012xn\u001c;?\u0013\u0005\t\u0014BA\u00181\u0013\tic&C\u0002\u0002\"1\n!\u0001\u001a2\n\u0007%\n)CC\u0002\u0002\"1JA!!\u000b\u0002,\u0005Q1+\u001d7Ck&dG-\u001a:\u000b\u0007%\n)#\u0003\u0003\u00020\u0005E\"a\u0002#jC2,7\r\u001e\u0006\u0005\u0003S\tY#\u0001\u0005eS\u0006dWm\u0019;!\u0003\u0019a\u0014N\\5u}Q\u0011\u0012\u0011HA\u001e\u0003{\ty$!\u0011\u0002D\u0005\u0015\u0013qIA%!\ty\u0004\u0001C\u0003Q#\u0001\u0007!\u000bC\u0003Z#\u0001\u00071\fC\u0003`#\u0001\u0007\u0011\rC\u0003f#\u0001\u0007q\rC\u0003l#\u0001\u0007Q\u000eC\u0003r#\u0001\u00071\u000fC\u0003{#\u0001\u0007A\u0010C\u0004\u0002\u0002E\u0001\u001d!!\u0002\u0002\u0011\u0019Lg\u000e\u001a\"z\u0013\u0012,B!a\u0014\u0002VQ!\u0011\u0011KA7!\u0011\t\u0019&!\u0016\r\u0001\u00119\u0011q\u000b\nC\u0002\u0005e#!\u0001+\u0012\t\u0005m\u0013\u0011\r\t\u0004k\u0005u\u0013bAA0m\t9aj\u001c;iS:<\u0007\u0003BA2\u0003Sj!!!\u001a\u000b\u0007\u0005\u001dD&\u0001\u0004e_6\f\u0017N\\\u0005\u0005\u0003W\n)G\u0001\u0003UCN\\\u0007bBA8%\u0001\u0007\u0011\u0011O\u0001\u0007i\u0006\u001c8.\u00133\u0011\t\u0005M\u00141\u0010\b\u0005\u0003k\n9\bE\u0002\u0002\u0014YJ1!!\u001f7\u0003\u0019\u0001&/\u001a3fM&!\u0011QPA@\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011\u0010\u001c)\u0007I\t\u0019\t\u0005\u0003\u0002\u0006\u0006MUBAAD\u0015\u0011\tI)a#\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0003\u0002\u000e\u0006=\u0015aB7fiJL7m\u001d\u0006\u0004\u0003#\u0003\u0014\u0001C2pI\u0006D\u0017\r\\3\n\t\u0005U\u0015q\u0011\u0002\u0006)&lW\rZ\u000b\u0005\u00033\u000bi\n\u0006\u0004\u0002\u001c\u0006}\u0015\u0011\u0015\t\u0005\u0003'\ni\nB\u0004\u0002XM\u0011\r!!\u0017\t\u000f\u0005=4\u00031\u0001\u0002r!9\u00111U\nA\u0002\u0005\u0015\u0016A\u0004:fg>dg/Z(qi&|gn\u001d\t\u0004w\u0005\u001d\u0016bAAUU\tq!+Z:pYZ,w\n\u001d;j_:\u001c\bfA\n\u0002\u0004\u0006\u0011b-\u001b8e)\u0006\u001c8n\u001d\"bg&\u001cG)\u0019;b)\u0011\t\t,!4\u0011\r\u0005M\u0016QXAa\u001b\t\t)L\u0003\u0003\u00028\u0006e\u0016\u0001B;uS2T!!a/\u0002\t)\fg/Y\u0005\u0005\u0003\u007f\u000b)L\u0001\u0003MSN$\b\u0003BAb\u0003\u0013l!!!2\u000b\u0007\u0005\u001d'&A\u0003rk\u0016\u0014\u00180\u0003\u0003\u0002L\u0006\u0015'!\u0004+bg.\u0014\u0015m]5d\t\u0006$\u0018\rC\u0004\u0002PR\u0001\r!!5\u0002\u000fQ\f7o[%egB1\u00111WA_\u0003cB3\u0001FAk!\u0011\t9.!8\u000e\u0005\u0005e'\u0002BAn\u0003W\t1\u0002\u001e:b]N\f7\r^5p]&!\u0011q\\Am\u0005)I5OU3bI>sG.\u001f\u0015\u0004)\u0005\r\u0015AB3ySN$8\u000f\u0006\u0003\u0002h\u00065\bcA\u001b\u0002j&\u0019\u00111\u001e\u001c\u0003\u000f\t{w\u000e\\3b]\"9\u0011qN\u000bA\u0002\u0005E\u0004fA\u000b\u0002V\"\u001aQ#a!\u0002\rU\u0004H-\u0019;f)\u0011\t\t'a>\t\u000f\u0005eh\u00031\u0001\u0002b\u0005!A/Y:lQ\r1\u00121Q\u0001\fkB$\u0017\r^3UCN\\7\u000f\u0006\u0003\u0003\u0002\t\u001d\u0001cA\u001b\u0003\u0004%\u0019!Q\u0001\u001c\u0003\tUs\u0017\u000e\u001e\u0005\b\u0005\u00139\u0002\u0019\u0001B\u0006\u0003\u0015!\u0018m]6t!\u0015)$QBA1\u0013\r\u0011yA\u000e\u0002\u000byI,\u0007/Z1uK\u0012t\u0004fA\f\u0003\u0014A!!Q\u0003B\r\u001b\t\u00119BC\u0002\u0002\nZJAAa\u0007\u0003\u0018\t9a/\u0019:be\u001e\u001c\bfA\f\u0002\u0004\u0006!R\u000f\u001d3bi\u0016$\u0016m]6Qe>\u0004XM\u001d;jKN$BA!\u0001\u0003$!9\u0011\u0011 \rA\u0002\u0005\u0005\u0004f\u0001\r\u0002\u0004\u0006qR\u000f\u001d3bi\u0016$\u0016m]6B]\u0012\u0014V\r\\3bg\u00164E.Y4Ti\u0006$Xo\u001d\u000b\u0007\u0003C\u0012YC!\f\t\u000f\u0005e\u0018\u00041\u0001\u0002b!9!qF\rA\u0002\tE\u0012a\u0002:fY\u0016\f7/\u001a\t\u0005\u0003G\u0012\u0019$\u0003\u0003\u00036\u0005\u0015$a\u0002*fY\u0016\f7/\u001a\u0015\u00043\u0005\r\u0015AC;qI\u0006$X\rV=qKR!\u0011\u0011\rB\u001f\u0011\u001d\tIP\u0007a\u0001\u0003CB3AGAB\u0003\u0019!W\r\\3uKR!!\u0011\u0001B#\u0011\u001d\tIp\u0007a\u0001\u0003CB3aGAB\u0003)\u0019'/Z1uKR\u000b7o\u001b\u000b\u0005\u0003C\u0012i\u0005C\u0004\u0003Pq\u0001\r!!\u0019\u0002\u000f9,w\u000fV1tW\u000611M]3bi\u0016$B!!\u0019\u0003V!9!qJ\u000fA\u0002\u0005\u0005\u0004fA\u000f\u0002\u0004\u0006AQn\u001c<f)\u0006\u001c8\u000e\u0006\u0006\u0002b\tu#\u0011\rB3\u0005_BqAa\u0018\u001f\u0001\u0004\t\t'\u0001\u0006uCN\\Gk\\'pm\u0016DqAa\u0019\u001f\u0001\u0004\t\t'A\u0005n_Z,G\rV1tW\"9!q\r\u0010A\u0002\t%\u0014AF;qI\u0006$X\rZ(sS\u001eLgnQ8oi\u0006Lg.\u001a:\u0011\t\u0005\r$1N\u0005\u0005\u0005[\n)GA\u0007UCN\\7i\u001c8uC&tWM\u001d\u0005\b\u0005cr\u0002\u0019\u0001B5\u0003Y)\b\u000fZ1uK\u0012$\u0016M]4fi\u000e{g\u000e^1j]\u0016\u0014\bf\u0001\u0010\u0002\u0004\u00061b-\u001b8e\u0003\u001a4Wm\u0019;fI\nK(\t\\1dW>,H\u000f\u0006\u0003\u0002R\ne\u0004b\u0002B>?\u0001\u0007!QP\u0001\tE2\f7m[8viB!!q\u0010BC\u001b\t\u0011\tI\u0003\u0003\u0003\u0004\u0006\u0015\u0014\u0001C2bY\u0016tG-\u0019:\n\t\t\u001d%\u0011\u0011\u0002\t\u00052\f7m[8vi\"\u001aq$a!\u00025\u0019Lg\u000e\u001a)f]\u0012Lgn\u001a+bg.\u001cx+\u001b;i\r\u0006\u001cW\r^:\u0015\u0005\u0005E\u0007f\u0001\u0011\u0002\u0004\u0006Aq-\u001a;USRdW\r\u0006\u0003\u0002r\tU\u0005bBA8C\u0001\u0007\u0011\u0011\u000f\u0015\u0004C\u0005U\u0007fA\u0011\u0002\u0004\u0006Qq-\u001a;BY2$\u0016mZ:\u0015\t\t}%Q\u0015\t\u0007\u0003g\u0013\t+!\u001d\n\t\t\r\u0016Q\u0017\u0002\u0004'\u0016$\bb\u0002BTE\u0001\u0007!\u0011V\u0001\fY&l\u0017\u000e\u001e(v[\n,'\u000fE\u00026\u0005WK1A!,7\u0005\rIe\u000e\u001e\u0015\u0004E\u0005U\u0007f\u0001\u0012\u0002\u0004\u0006\u0011b-\u001b8e\u001fZ,'\u000fZ;f)\u0006\u001c8.\u00133t)\t\u00119\f\u0005\u0004\u0003:\n\r\u0017\u0011\u000f\b\u0005\u0005w\u0013yL\u0004\u0003\u0002\u0014\tu\u0016\"A\u001c\n\u0007\t\u0005g'A\u0004qC\u000e\\\u0017mZ3\n\t\t\u0015'q\u0019\u0002\u0004'\u0016\f(b\u0001Bam!\u001a1%!6)\u0007\r\n\u0019)\u0001\ngS:$G)^3T_>tG+Y:l\u0013\u0012\u001c\bf\u0001\u0013\u0002V\"\u001aA%a!\u0002\u0013\u001d,Go\u0015;biV\u001cH\u0003\u0002Bl\u0005G\u0004BA!7\u0003`6\u0011!1\u001c\u0006\u0005\u0005;\f)'\u0001\u0004ti\u0006$Xo]\u0005\u0005\u0005C\u0014YN\u0001\u0006UCN\\7\u000b^1ukNDq!a\u001c&\u0001\u0004\t\t\bK\u0002&\u0003+D3!JAB\u0003=9W\r\u001e+bg.\u001cF/\u0019;vg\u0016\u001cH\u0003\u0002Bw\u0005g\u0004\u0002\"a-\u0003p\u0006E$q[\u0005\u0005\u0005c\f)LA\u0002NCBDqA!>'\u0001\u0004\t\t(A\u0005sK2,\u0017m]3JI\"\u001aa%!6)\u0007\u0019\n\u0019\tK\u0002\u0001\u0005{\u0004B!a6\u0003\u0000&!1\u0011AAm\u0005=I5\u000f\u0016:b]N\f7\r^5p]\u0006d\u0007")
public class SqlTaskRepository
implements TaskRepository,
BaseReleaseItemRepository,
DeserializationSupport,
ConfigurationReferencesSupport,
Logging {
    private final ReleasePersistence releasePersistence;
    private final DependencyPersistence dependencyPersistence;
    private final TaskPersistence taskPersistence;
    private final CommentRepository commentRepository;
    private final SqlRepositoryAdapter repositoryAdapter;
    private final ConfigurationReferencePersistence configurationPersistence;
    private final FacetRepositoryDispatcher facetRepositoryDispatcher;
    private final SqlBuilder.Dialect dialect;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public void updateConfigurationRefs(CiWithUid entity) {
        ConfigurationReferencesSupport.updateConfigurationRefs$(this, entity);
    }

    @Override
    public void deleteConfigurationRefs(Integer uid) {
        ConfigurationReferencesSupport.deleteConfigurationRefs$(this, uid);
    }

    @Override
    public Release deserializeRelease(ReleaseRow releaseData, ResolveOptions resolveOptions) {
        return DeserializationSupport.deserializeRelease$(this, releaseData, resolveOptions);
    }

    @Override
    public Option<Release> tryDeserializeRelease(ReleaseRow releaseData, ResolveOptions resolveOptions) {
        return DeserializationSupport.tryDeserializeRelease$(this, releaseData, resolveOptions);
    }

    @Override
    public Release getRelease(String releaseId, String entityId) {
        return BaseReleaseItemRepository.getRelease$(this, releaseId, entityId);
    }

    @Override
    public Release getRelease(String releaseId, String entityId, ResolveOptions resolveOptions) {
        return BaseReleaseItemRepository.getRelease$(this, releaseId, entityId, resolveOptions);
    }

    @Override
    public <T> T notNull(T ci, String ciId) {
        return (T)BaseReleaseItemRepository.notNull$(this, ci, ciId);
    }

    @Override
    public void insertDependencyWithGateTaskUid(Integer gateTaskUid, Dependency dependency) {
        BaseReleaseItemRepository.insertDependencyWithGateTaskUid$(this, gateTaskUid, dependency);
    }

    @Override
    public void insertDependency(Dependency dependency) {
        BaseReleaseItemRepository.insertDependency$(this, dependency);
    }

    @Override
    public void checkIsNotReferencedByDependencies(String planItemIdOrItsChildren) {
        BaseReleaseItemRepository.checkIsNotReferencedByDependencies$(this, planItemIdOrItsChildren);
    }

    public TaskBasicData findTaskBasicData(String taskId) {
        return TaskRepository.findTaskBasicData$((TaskRepository)this, (String)taskId);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlTaskRepository sqlTaskRepository = this;
        synchronized (sqlTaskRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public void updateTasks(Task ... tasks) {
        this.updateTasks((scala.collection.immutable.Seq<Task>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])tasks));
    }

    public ReleasePersistence releasePersistence() {
        return this.releasePersistence;
    }

    @Override
    public DependencyPersistence dependencyPersistence() {
        return this.dependencyPersistence;
    }

    public TaskPersistence taskPersistence() {
        return this.taskPersistence;
    }

    public CommentRepository commentRepository() {
        return this.commentRepository;
    }

    @Override
    public SqlRepositoryAdapter repositoryAdapter() {
        return this.repositoryAdapter;
    }

    @Override
    public ConfigurationReferencePersistence configurationPersistence() {
        return this.configurationPersistence;
    }

    public FacetRepositoryDispatcher facetRepositoryDispatcher() {
        return this.facetRepositoryDispatcher;
    }

    public SqlBuilder.Dialect dialect() {
        return this.dialect;
    }

    @Timed
    public <T extends Task> T findById(String taskId) {
        return this.findById(taskId, new ResolveOptionsBuilder().withEverything().build());
    }

    @Timed
    public <T extends Task> T findById(String taskId, ResolveOptions resolveOptions) {
        if (!this.exists(taskId)) {
            throw new NotFoundException(new StringBuilder(30).append("Repository entity [").append(taskId).append("] not found").toString(), new Object[0]);
        }
        Release release = this.getRelease(Ids.releaseIdFrom((String)taskId), taskId, resolveOptions);
        return (T)((Task)Option$.MODULE$.apply((Object)release.getTask(CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(taskId)))).fold((Function0 & Serializable)() -> {
            throw new NotFoundException(new StringBuilder(41).append("Repository entity [").append(taskId).append("] not found in release").toString(), new Object[0]);
        }, (Function1 & Serializable)task -> {
            task.getAllTasks().forEach(t -> this.commentRepository().decorate(t));
            return task;
        }));
    }

    @Timed
    @IsReadOnly
    public List<TaskBasicData> findTasksBasicData(List<String> taskIds) {
        List list;
        if (taskIds.isEmpty()) {
            list = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Seq().empty()).asJava();
        } else {
            scala.collection.immutable.Seq<TaskRow> tasksData = this.taskPersistence().findByIds((Iterable<String>)CollectionConverters$.MODULE$.ListHasAsScala(taskIds).asScala());
            list = CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(taskIds).asScala().map((Function1 & Serializable)taskId -> new Tuple2(taskId, (Object)tasksData.find((Function1 & Serializable)data -> BoxesRunTime.boxToBoolean((boolean)taskId.endsWith(data.taskId())))))).flatMap((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) return None$.MODULE$;
                String id = (String)tuple2._1();
                Option option = (Option)tuple2._2();
                if (!(option instanceof Some)) return None$.MODULE$;
                Some some = (Some)option;
                TaskRow data = (TaskRow)some.value();
                return new Some((Object)TaskRow$.MODULE$.TaskDataOps(data).asTaskData(id));
            })).asJava();
        }
        return list;
    }

    @Timed
    @IsReadOnly
    public boolean exists(String taskId) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(26).append("Checking if exists task [").append(taskId).append("]").toString());
        return this.taskPersistence().exists(taskId);
    }

    @Timed
    public Task update(Task task) {
        Release release = task.getRelease();
        this.releasePersistence().update(release);
        this.updateTaskProperties(task);
        this.updateConfigurationRefs((CiWithUid)release);
        return task;
    }

    @Timed
    public void updateTasks(scala.collection.immutable.Seq<Task> tasks) {
        tasks.groupBy((Function1 & Serializable)x$1 -> x$1.getRelease()).foreach((Function1 & Serializable)x0$1 -> {
            SqlTaskRepository.$anonfun$updateTasks$2(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public void updateTaskProperties(Task task) {
        this.taskPersistence().updateProperties(task);
        syntax.TaskOps$.MODULE$.dependencies$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable)x0$1 -> {
            SqlTaskRepository.$anonfun$updateTaskProperties$1(this, task, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Timed
    public Task updateTaskAndReleaseFlagStatus(Task task, Release release) {
        return this.update(task);
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Task updateType(Task task) {
        void var2_2;
        Task updated = this.update(task);
        this.taskPersistence().updateType(task);
        return var2_2;
    }

    @Timed
    public void delete(Task task) {
        this.checkIsNotReferencedByDependencies(task.getId());
        this.releasePersistence().update(task.getRelease());
        syntax.TaskOps$.MODULE$.allDependencies$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable)dependency -> {
            SqlTaskRepository.$anonfun$delete$1(this, dependency);
            return BoxedUnit.UNIT;
        });
        task.getAllTasks().forEach(t -> {
            this.commentRepository().deleteByTask(t);
            this.taskPersistence().delete((Task)t);
        });
        this.updateConfigurationRefs((CiWithUid)task.getRelease());
    }

    private Task createTask(Task newTask2) {
        this.taskPersistence().insert(newTask2, Predef$.MODULE$.Integer2int(newTask2.getRelease().getCiUid()));
        Object object = newTask2 instanceof TaskGroup ? ((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(newTask2.getAllTasks()).asScala().filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)SqlTaskRepository.$anonfun$createTask$1(newTask2, x$2)))).map((Function1 & Serializable)newTask -> this.createTask((Task)newTask)) : BoxedUnit.UNIT;
        return newTask2;
    }

    /*
     * WARNING - void declaration
     */
    @Timed
    public Task create(Task newTask) {
        void var2_2;
        this.releasePersistence().update(newTask.getRelease());
        Task createdTask = this.createTask(newTask);
        syntax.TaskOps$.MODULE$.allDependencies$extension(syntax$.MODULE$.TaskOps(createdTask)).foreach((Function1 & Serializable)dependency -> {
            this.insertDependency(dependency);
            return BoxedUnit.UNIT;
        });
        this.updateConfigurationRefs((CiWithUid)createdTask.getRelease());
        this.facetRepositoryDispatcher().liveRepository().createFromTasks(CollectionConverters$.MODULE$.ListHasAsScala(newTask.getAllTasks()).asScala().toSeq(), this.facetRepositoryDispatcher().liveRepository().createFromTasks$default$2());
        return var2_2;
    }

    @Timed
    public Task moveTask(Task taskToMove, Task movedTask, TaskContainer updatedOriginContainer, TaskContainer updatedTargetContainer) {
        TaskContainer taskContainer = updatedOriginContainer;
        TaskContainer taskContainer2 = updatedTargetContainer;
        if (taskContainer == null ? taskContainer2 != null : !taskContainer.equals(taskContainer2)) {
            this.checkIsNotReferencedByDependencies(taskToMove.getId());
            CollectionConverters$.MODULE$.ListHasAsScala(taskToMove.getAllTasks()).asScala().foreach((Function1 & Serializable)taskWithOldId -> {
                SqlTaskRepository.$anonfun$moveTask$1(this, taskToMove, movedTask, taskWithOldId);
                return BoxedUnit.UNIT;
            });
        }
        this.releasePersistence().update(movedTask.getRelease());
        return movedTask;
    }

    @Timed
    public List<String> findAffectedByBlackout(Blackout blackout) {
        Date endDate = BlackoutMetadata$.MODULE$.toStartOfNextMinute(blackout.getEndDate());
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.dialect()).selectReleaseData().withOneOfStatuses((scala.collection.immutable.Seq<ReleaseStatus>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)ReleaseStatus.ACTIVE_STATUSES)).build();
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOps)((IterableOps)((IterableOps)this.releasePersistence().findReleaseDatasByQuery((Tuple2<String, scala.collection.immutable.Seq<Object>>)sqlWithParams).flatMap((Function1 & Serializable)x$3 -> this.tryDeserializeRelease((ReleaseRow)x$3, new ResolveOptionsBuilder().build()))).flatMap((Function1 & Serializable)rel -> CollectionConverters$.MODULE$.ListHasAsScala(rel.getAllTasks()).asScala())).filter((Function1 & Serializable)task -> BoxesRunTime.boxToBoolean((boolean)SqlTaskRepository.$anonfun$findAffectedByBlackout$3(endDate, task)))).map((Function1 & Serializable)x$4 -> x$4.getId())).asJava();
    }

    @Timed
    public List<String> findPendingTasksWithFacets() {
        Tuple2 sqlWithParams = new TasksSqlBuilder(this.dialect()).selectTaskId().withOneOfTaskStatuses((scala.collection.immutable.Seq<TaskStatus>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TaskStatus[]{TaskStatus.PENDING})))).withAnyFacets().build();
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)this.taskPersistence().findTaskIdsByQuery((Tuple2<String, scala.collection.immutable.Seq<Object>>)sqlWithParams).toSet().toList()).asJava();
    }

    @Timed
    @IsReadOnly
    public String getTitle(String taskId) {
        return (String)this.taskPersistence().getTitle(taskId).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Task [%s] not found", new Object[]{taskId});
        });
    }

    @Timed
    @IsReadOnly
    public Set<String> getAllTags(int limitNumber) {
        return CollectionConverters$.MODULE$.SetHasAsJava(this.taskPersistence().findAllTags(limitNumber)).asJava();
    }

    @Timed
    @IsReadOnly
    public scala.collection.immutable.Seq<String> findOverdueTaskIds() {
        return this.taskPersistence().findOverdueTaskIds();
    }

    @Timed
    @IsReadOnly
    public scala.collection.immutable.Seq<String> findDueSoonTaskIds() {
        return this.taskPersistence().findDueSoonTaskIds();
    }

    @Timed
    @IsReadOnly
    public TaskStatus getStatus(String taskId) {
        return (TaskStatus)this.taskPersistence().getStatus(taskId).getOrElse((Function0 & Serializable)() -> {
            throw new LogFriendlyNotFoundException(new StringBuilder(33).append("getStatus: could not find task '").append(taskId).append("'").toString(), new Object[0]);
        });
    }

    @Timed
    @IsReadOnly
    public Map<String, TaskStatus> getTaskStatuses(String releaseId) {
        return this.taskPersistence().getTaskStatuses(releaseId);
    }

    public static final /* synthetic */ void $anonfun$updateTasks$2(SqlTaskRepository $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Release release = (Release)tuple2._1();
        scala.collection.immutable.Seq tasks = (scala.collection.immutable.Seq)tuple2._2();
        $this.releasePersistence().update(release);
        tasks.foreach((Function1 & Serializable)task -> {
            $this.updateTaskProperties(task);
            return BoxedUnit.UNIT;
        });
        $this.updateConfigurationRefs((CiWithUid)release);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$updateTaskProperties$1(SqlTaskRepository $this, Task task$1, Dependency x0$1) {
        Dependency dependency = x0$1;
        if (dependency.isArchived()) {
            $this.dependencyPersistence().deleteDependency(dependency);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit;
            try {
                $this.dependencyPersistence().updateDependency(dependency);
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (NotFoundException e) {
                $this.logger().error((Function0 & Serializable)() -> new StringBuilder(41).append("Dependency ").append(dependency).append(" not found when updating task ").append(task$1).toString(), (Function0 & Serializable)() -> e);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }
    }

    public static final /* synthetic */ void $anonfun$delete$1(SqlTaskRepository $this, Dependency dependency) {
        $this.dependencyPersistence().deleteDependency(dependency);
    }

    public static final /* synthetic */ boolean $anonfun$createTask$1(Task newTask$1, Task x$2) {
        String string = x$2.getContainer().getId();
        String string2 = newTask$1.getId();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$moveTask$1(SqlTaskRepository $this, Task taskToMove$1, Task movedTask$1, Task taskWithOldId) {
        String oldId = taskWithOldId.getId();
        String newId = oldId.replace(taskToMove$1.getId(), movedTask$1.getId());
        $this.taskPersistence().move(oldId, newId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$findAffectedByBlackout$3(Date endDate$1, Task task) {
        TaskStatus taskStatus = task.getStatus();
        TaskStatus taskStatus2 = TaskStatus.PENDING;
        if (taskStatus == null) {
            if (taskStatus2 != null) {
                return false;
            }
        } else if (!taskStatus.equals(taskStatus2)) return false;
        if (!task.isPostponedDueToBlackout()) return false;
        Date date = task.getScheduledStartDate();
        Date date2 = endDate$1;
        if (date == null) {
            if (date2 == null) return true;
            return false;
        } else {
            if (!((Object)date).equals(date2)) return false;
            return true;
        }
    }

    public SqlTaskRepository(ReleasePersistence releasePersistence, DependencyPersistence dependencyPersistence, TaskPersistence taskPersistence, CommentRepository commentRepository, SqlRepositoryAdapter repositoryAdapter, ConfigurationReferencePersistence configurationPersistence, FacetRepositoryDispatcher facetRepositoryDispatcher, SqlBuilder.Dialect dialect) {
        this.releasePersistence = releasePersistence;
        this.dependencyPersistence = dependencyPersistence;
        this.taskPersistence = taskPersistence;
        this.commentRepository = commentRepository;
        this.repositoryAdapter = repositoryAdapter;
        this.configurationPersistence = configurationPersistence;
        this.facetRepositoryDispatcher = facetRepositoryDispatcher;
        this.dialect = dialect;
        TaskRepository.$init$((TaskRepository)this);
        BaseReleaseItemRepository.$init$(this);
        DeserializationSupport.$init$(this);
        ConfigurationReferencesSupport.$init$(this);
        Logging.$init$((Logging)this);
    }
}

