/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.ItemAlreadyExistsException;
import com.xebialabs.deployit.repository.ItemInUseException;
import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.CiWithUid;
import com.xebialabs.xlrelease.domain.Comment;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.events.ReleaseCreationSource;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.utils.syntax;
import com.xebialabs.xlrelease.domain.utils.syntax$;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.repository.FacetRepositoryDispatcher;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.repository.Page$;
import com.xebialabs.xlrelease.repository.PersistenceInterceptor;
import com.xebialabs.xlrelease.repository.ReleaseExtensionsRepository;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.ReleaseSearchByParams;
import com.xebialabs.xlrelease.repository.TeamRepository;
import com.xebialabs.xlrelease.repository.sql.ConfigurationReferencesSupport;
import com.xebialabs.xlrelease.repository.sql.DeserializationSupport;
import com.xebialabs.xlrelease.repository.sql.InterceptedRepository;
import com.xebialabs.xlrelease.repository.sql.SqlReleaseRepositoryHelper;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.CiId$RichCiId$;
import com.xebialabs.xlrelease.repository.sql.persistence.CommentPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.CommentPersistence$CommentRow$;
import com.xebialabs.xlrelease.repository.sql.persistence.DependencyPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasesSqlBuilder;
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.configuration.ConfigurationReferencePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.BasicReleaseRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.DependencyRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.DependencyRow$;
import com.xebialabs.xlrelease.repository.sql.persistence.data.ReleaseRow;
import com.xebialabs.xlrelease.security.SecuredCi;
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptions;
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptions$;
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptionsBuilder;
import com.xebialabs.xlrelease.utils.Diff$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import org.slf4j.Marker;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\r\u0005h\u0001\u0002\u001b6\u0001\u0001C\u0001B\u001a\u0001\u0003\u0002\u0003\u0006Ia\u001a\u0005\t[\u0002\u0011)\u0019!C\t]\"A!\u000f\u0001B\u0001B\u0003%q\u000e\u0003\u0005t\u0001\t\u0015\r\u0011\"\u0005u\u0011!A\bA!A!\u0002\u0013)\b\u0002C=\u0001\u0005\u000b\u0007I\u0011\u0003>\t\u0011y\u0004!\u0011!Q\u0001\nmD\u0011b \u0001\u0003\u0006\u0004%\t\"!\u0001\t\u0015\u0005%\u0001A!A!\u0002\u0013\t\u0019\u0001\u0003\u0006\u0002\f\u0001\u0011)\u0019!C\t\u0003\u001bA!\"!\u0006\u0001\u0005\u0003\u0005\u000b\u0011BA\b\u0011)\t9\u0002\u0001BC\u0002\u0013\u0005\u0011\u0011\u0004\u0005\u000b\u0003O\u0001!\u0011!Q\u0001\n\u0005m\u0001BCA\u0015\u0001\t\u0015\r\u0011\"\u0001\u0002,!Q\u00111\u0007\u0001\u0003\u0002\u0003\u0006I!!\f\t\u0015\u0005U\u0002A!A!\u0002\u0013\t9\u0004\u0003\u0006\u0002>\u0001\u0011)\u0019!C\u0002\u0003\u007fA!\"a\u001c\u0001\u0005\u0003\u0005\u000b\u0011BA!\u0011\u001d\t\t\b\u0001C\u0001\u0003gBq!!$\u0001\t\u0003\ny\tC\u0004\u0002P\u0002!\t%!5\t\u000f\u0005%\b\u0001\"\u0011\u0002l\"9\u0011\u0011\u001e\u0001\u0005B\u0005E\bb\u0002B\u0007\u0001\u0011\u0005#q\u0002\u0005\b\u0005\u0013\u0002A\u0011\tB&\u0011\u001d\u0011\u0019\u0006\u0001C\u0001\u0005+BqA!\u001f\u0001\t\u0003\u0012Y\bC\u0004\u0003\u000e\u0002!\tAa$\t\u000f\tu\u0005\u0001\"\u0011\u0003 \"9!1\u0017\u0001\u0005B\tU\u0006b\u0002B^\u0001\u0011%!Q\u0018\u0005\b\u0005\u000b\u0004A\u0011\tBd\u0011\u001d\u0011y\r\u0001C!\u0005#DqA!8\u0001\t\u0003\u0012y\u000eC\u0004\u0004\u0002\u0001!\tea\u0001\t\u000f\r%\u0001\u0001\"\u0011\u0004\f!91Q\u0003\u0001\u0005B\r]\u0001bBB\u0011\u0001\u0011\u000531\u0005\u0005\b\u0007c\u0001A\u0011IB\u001a\u0011\u001d\u0019Y\u0004\u0001C!\u0007{Aqa!\u0012\u0001\t\u0003\u001a9\u0005C\u0004\u0004F\u0001!\te!\u0014\t\u000f\re\u0003\u0001\"\u0011\u0004\\!911\r\u0001\u0005B\r\u0015\u0004bBB;\u0001\u0011%1q\u000f\u0005\b\u0007\u0017\u0003A\u0011BBG\u0011\u001d\u0019\u0019\n\u0001C!\u0007+Cqaa+\u0001\t\u0003\u001ai\u000bC\u0004\u00044\u0002!\te!.\t\u000f\ru\u0006\u0001\"\u0011\u0004@\"91q\u0019\u0001\u0005B\r%'\u0001F*rYJ+G.Z1tKJ+\u0007o\\:ji>\u0014\u0018P\u0003\u00027o\u0005\u00191/\u001d7\u000b\u0005aJ\u0014A\u0003:fa>\u001c\u0018\u000e^8ss*\u0011!hO\u0001\nq2\u0014X\r\\3bg\u0016T!\u0001P\u001f\u0002\u0013a,'-[1mC\n\u001c(\"\u0001 \u0002\u0007\r|Wn\u0001\u0001\u0014\u0011\u0001\tuiS+^A\u000e\u0004\"AQ#\u000e\u0003\rS\u0011\u0001R\u0001\u0006g\u000e\fG.Y\u0005\u0003\r\u000e\u0013a!\u00118z%\u00164\u0007C\u0001%J\u001b\u00059\u0014B\u0001&8\u0005E\u0011V\r\\3bg\u0016\u0014V\r]8tSR|'/\u001f\t\u0004\u00196{U\"A\u001b\n\u00059+$!F%oi\u0016\u00148-\u001a9uK\u0012\u0014V\r]8tSR|'/\u001f\t\u0003!Nk\u0011!\u0015\u0006\u0003%f\na\u0001Z8nC&t\u0017B\u0001+R\u0005\u001d\u0011V\r\\3bg\u0016\u0004\"AV.\u000e\u0003]S!\u0001W-\u0002\u000bMdg\r\u000e6\u000b\u0003i\u000b\u0001b\u001a:jujdW\rZ\u0005\u00039^\u0013q\u0001T8hO&tw\r\u0005\u0002M=&\u0011q,\u000e\u0002\u0017\t\u0016\u001cXM]5bY&T\u0018\r^5p]N+\b\u000f]8siB\u0011A*Y\u0005\u0003EV\u0012adQ8oM&<WO]1uS>t'+\u001a4fe\u0016t7-Z:TkB\u0004xN\u001d;\u0011\u00051#\u0017BA36\u0005i\u0019\u0016\u000f\u001c*fY\u0016\f7/\u001a*fa>\u001c\u0018\u000e^8ss\"+G\u000e]3s\u0003I\u0011X\r\\3bg\u0016\u0004VM]:jgR,gnY3\u0011\u0005!\\W\"A5\u000b\u0005),\u0014a\u00039feNL7\u000f^3oG\u0016L!\u0001\\5\u0003%I+G.Z1tKB+'o]5ti\u0016t7-Z\u0001\u0010i\u0006\u001c8\u000eU3sg&\u001cH/\u001a8dKV\tq\u000e\u0005\u0002ia&\u0011\u0011/\u001b\u0002\u0010)\u0006\u001c8\u000eU3sg&\u001cH/\u001a8dK\u0006\u0001B/Y:l!\u0016\u00148/[:uK:\u001cW\rI\u0001\u0016I\u0016\u0004XM\u001c3f]\u000eL\b+\u001a:tSN$XM\\2f+\u0005)\bC\u00015w\u0013\t9\u0018NA\u000bEKB,g\u000eZ3oGf\u0004VM]:jgR,gnY3\u0002-\u0011,\u0007/\u001a8eK:\u001c\u0017\u0010U3sg&\u001cH/\u001a8dK\u0002\n!cY8n[\u0016tG\u000fU3sg&\u001cH/\u001a8dKV\t1\u0010\u0005\u0002iy&\u0011Q0\u001b\u0002\u0013\u0007>lW.\u001a8u!\u0016\u00148/[:uK:\u001cW-A\nd_6lWM\u001c;QKJ\u001c\u0018n\u001d;f]\u000e,\u0007%\u0001\buK\u0006l'+\u001a9pg&$xN]=\u0016\u0005\u0005\r\u0001c\u0001%\u0002\u0006%\u0019\u0011qA\u001c\u0003\u001dQ+\u0017-\u001c*fa>\u001c\u0018\u000e^8ss\u0006yA/Z1n%\u0016\u0004xn]5u_JL\b%A\u000esK2,\u0017m]3FqR,gn]5p]N\u0014V\r]8tSR|'/_\u000b\u0003\u0003\u001f\u00012\u0001SA\t\u0013\r\t\u0019b\u000e\u0002\u001c%\u0016dW-Y:f\u000bb$XM\\:j_:\u001c(+\u001a9pg&$xN]=\u00029I,G.Z1tK\u0016CH/\u001a8tS>t7OU3q_NLGo\u001c:zA\u0005A2m\u001c8gS\u001e,(/\u0019;j_:\u0004VM]:jgR,gnY3\u0016\u0005\u0005m\u0001\u0003BA\u000f\u0003Gi!!a\b\u000b\u0007\u0005\u0005\u0012.A\u0007d_:4\u0017nZ;sCRLwN\\\u0005\u0005\u0003K\tyBA\u0011D_:4\u0017nZ;sCRLwN\u001c*fM\u0016\u0014XM\\2f!\u0016\u00148/[:uK:\u001cW-A\rd_:4\u0017nZ;sCRLwN\u001c)feNL7\u000f^3oG\u0016\u0004\u0013!\u0005:fa>\u001c\u0018\u000e^8ss\u0006#\u0017\r\u001d;feV\u0011\u0011Q\u0006\t\u0004\u0019\u0006=\u0012bAA\u0019k\t!2+\u001d7SKB|7/\u001b;pef\fE-\u00199uKJ\f!C]3q_NLGo\u001c:z\u0003\u0012\f\u0007\u000f^3sA\u0005Ib-Y2fiJ+\u0007o\\:ji>\u0014\u0018\u0010R5ta\u0006$8\r[3s!\rA\u0015\u0011H\u0005\u0004\u0003w9$!\u0007$bG\u0016$(+\u001a9pg&$xN]=ESN\u0004\u0018\r^2iKJ\f!b]9m\t&\fG.Z2u+\t\t\t\u0005\u0005\u0003\u0002D\u0005%d\u0002BA#\u0003GrA!a\u0012\u0002`9!\u0011\u0011JA.\u001d\u0011\tY%!\u0017\u000f\t\u00055\u0013q\u000b\b\u0005\u0003\u001f\n)&\u0004\u0002\u0002R)\u0019\u00111K \u0002\rq\u0012xn\u001c;?\u0013\u0005q\u0014B\u0001\u001f>\u0013\tQ4(C\u0002\u0002^e\n!\u0001\u001a2\n\u0007Y\n\tGC\u0002\u0002^eJA!!\u001a\u0002h\u0005Q1+\u001d7Ck&dG-\u001a:\u000b\u0007Y\n\t'\u0003\u0003\u0002l\u00055$a\u0002#jC2,7\r\u001e\u0006\u0005\u0003K\n9'A\u0006tc2$\u0015.\u00197fGR\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u000b\u0002v\u0005m\u0014QPA@\u0003\u0003\u000b\u0019)!\"\u0002\b\u0006%\u00151\u0012\u000b\u0005\u0003o\nI\b\u0005\u0002M\u0001!9\u0011QH\nA\u0004\u0005\u0005\u0003\"\u00024\u0014\u0001\u00049\u0007\"B7\u0014\u0001\u0004y\u0007\"B:\u0014\u0001\u0004)\b\"B=\u0014\u0001\u0004Y\bBB@\u0014\u0001\u0004\t\u0019\u0001C\u0004\u0002\fM\u0001\r!a\u0004\t\u000f\u0005]1\u00031\u0001\u0002\u001c!9\u0011\u0011F\nA\u0002\u00055\u0002bBA\u001b'\u0001\u0007\u0011qG\u0001\u0007KbL7\u000f^:\u0015\t\u0005E\u0015q\u0013\t\u0004\u0005\u0006M\u0015bAAK\u0007\n9!i\\8mK\u0006t\u0007bBAM)\u0001\u0007\u00111T\u0001\u0003S\u0012\u0004B!!(\u0002&:!\u0011qTAQ!\r\tyeQ\u0005\u0004\u0003G\u001b\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002(\u0006%&AB*ue&twMC\u0002\u0002$\u000eC3\u0001FAW!\u0011\ty+!.\u000e\u0005\u0005E&\u0002BAZ\u0003O\n1\u0002\u001e:b]N\f7\r^5p]&!\u0011qWAY\u0005)I5OU3bI>sG.\u001f\u0015\u0004)\u0005m\u0006\u0003BA_\u0003\u0017l!!a0\u000b\t\u0005\u0005\u00171Y\u0001\u000bC:tw\u000e^1uS>t'\u0002BAc\u0003\u000f\fq!\\3ue&\u001c7OC\u0002\u0002Jv\n\u0001bY8eC\"\fG.Z\u0005\u0005\u0003\u001b\fyLA\u0003US6,G-\u0001\u0004de\u0016\fG/\u001a\u000b\u0006\u001f\u0006M\u0017q\u001b\u0005\u0007\u0003+,\u0002\u0019A(\u0002\u000fI,G.Z1tK\"9\u0011\u0011\\\u000bA\u0002\u0005m\u0017!\u0006:fY\u0016\f7/Z\"sK\u0006$\u0018n\u001c8T_V\u00148-\u001a\t\u0005\u0003;\f\u0019/\u0004\u0002\u0002`*\u0019\u0011\u0011])\u0002\r\u00154XM\u001c;t\u0013\u0011\t)/a8\u0003+I+G.Z1tK\u000e\u0013X-\u0019;j_:\u001cv.\u001e:dK\"\u001aQ#a/\u0002\u0011\u0019Lg\u000e\u001a\"z\u0013\u0012$2aTAw\u0011\u001d\tIJ\u0006a\u0001\u00037C3AFA^)\u0015y\u00151_A{\u0011\u001d\tIj\u0006a\u0001\u00037Cq!a>\u0018\u0001\u0004\tI0\u0001\bsKN|GN^3PaRLwN\\:\u0011\t\u0005m(qA\u0007\u0003\u0003{T1\u0001OA\u0000\u0015\u0011\u0011\tAa\u0001\u0002\t)\u001cxN\u001c\u0006\u0004\u0005\u000bI\u0014!D:fe&\fG.\u001b>bi&|g.\u0003\u0003\u0003\n\u0005u(A\u0004*fg>dg/Z(qi&|gn\u001d\u0015\u0004/\u0005m\u0016a\u00044j]\u0012LEm\u001d\"z'R\fG/^:\u0015\t\tE!1\u0005\t\u0007\u0005'\u0011i\"a'\u000f\t\tU!\u0011\u0004\b\u0005\u0003\u001f\u00129\"C\u0001E\u0013\r\u0011YbQ\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011yB!\t\u0003\u0007M+\u0017OC\u0002\u0003\u001c\rCqA!\n\u0019\u0001\u0004\u00119#\u0001\u0005ti\u0006$Xo]3t!\u0015\u0011%\u0011\u0006B\u0017\u0013\r\u0011Yc\u0011\u0002\u000byI,\u0007/Z1uK\u0012t\u0004\u0003\u0002B\u0018\u0005ki!A!\r\u000b\u0007\tM\u0012+\u0001\u0004ti\u0006$Xo]\u0005\u0005\u0005o\u0011\tDA\u0007SK2,\u0017m]3Ti\u0006$Xo\u001d\u0015\u00041\u00055\u0006f\u0001\r\u0002<\"\u001a\u0001Da\u0010\u0011\t\t\u0005#QI\u0007\u0003\u0005\u0007R1!!1D\u0013\u0011\u00119Ea\u0011\u0003\u000fY\f'/\u0019:hg\u0006\u0019b-\u001b8e\u0005f\u001c\u0015\r\\3oI\u0006\u0014Hk\\6f]R\u0019qJ!\u0014\t\u000f\t=\u0013\u00041\u0001\u0002\u001c\u0006i1-\u00197f]\u0012\f'\u000fV8lK:D3!GA^\u0003a1\u0017N\u001c3Be\u000eD\u0017N^1cY\u0016\u0014V\r\\3bg\u0016LEm\u001d\u000b\u0007\u0005#\u00119Fa\u001b\t\u000f\te#\u00041\u0001\u0003\\\u0005!A-\u0019;f!\u0011\u0011iFa\u001a\u000e\u0005\t}#\u0002\u0002B1\u0005G\nA!\u001e;jY*\u0011!QM\u0001\u0005U\u00064\u0018-\u0003\u0003\u0003j\t}#\u0001\u0002#bi\u0016DqA!\u001c\u001b\u0001\u0004\u0011y'\u0001\u0005qC\u001e,7+\u001b>f!\r\u0011%\u0011O\u0005\u0004\u0005g\u001a%aA%oi\"\u001a!$!,)\u0007i\tY,\u0001\btKR\u0004&/Z!sG\"Lg/\u001a3\u0015\r\tu$1\u0011BD!\r\u0011%qP\u0005\u0004\u0005\u0003\u001b%\u0001B+oSRDqA!\"\u001c\u0001\u0004\tY*A\u0005sK2,\u0017m]3JI\"9!\u0011R\u000eA\u0002\u0005E\u0015a\u00039sK\u0006\u00138\r[5wK\u0012D3aGA^\u0003e1\u0017N\u001c3Qe\u0016\f%o\u00195jm\u0006\u0014G.\u001a*fY\u0016\f7/Z:\u0015\r\tE%1\u0013BL!\u0015\u0011\u0019B!\bP\u0011\u001d\u0011)\n\ba\u0001\u0005_\nA\u0001]1hK\"9!Q\u000e\u000fA\u0002\t=\u0004f\u0001\u000f\u0002.\"\u001aA$a/\u0002\rM,\u0017M]2i)\u0011\u0011\tKa*\u0011\u000b\tu#1U(\n\t\t\u0015&q\f\u0002\u0005\u0019&\u001cH\u000fC\u0004\u0003*v\u0001\rAa+\u0002\u0019M,\u0017M]2i!\u0006\u0014\u0018-\\:\u0011\u0007!\u0013i+C\u0002\u00030^\u0012QCU3mK\u0006\u001cXmU3be\u000eD')\u001f)be\u0006l7\u000fK\u0002\u001e\u0003w\u000ba\u0001Z3mKR,G\u0003\u0002B?\u0005oCq!!'\u001f\u0001\u0004\tY\nK\u0002\u001f\u0003w\u000bq\u0003Z3mKR,'+\u001a7fCN,'+\u001a4fe\u0016t7-Z:\u0015\r\tu$q\u0018Ba\u0011\u001d\tIj\ba\u0001\u00037CqAa1 \u0001\u0004\u0011y'\u0001\u0006sK2,\u0017m]3VS\u0012\fQ\u0002Z3mKR,w+\u001b;i+&$GC\u0002B?\u0005\u0013\u0014Y\rC\u0004\u0002\u001a\u0002\u0002\r!a'\t\u000f\t\r\u0007\u00051\u0001\u0003p!\u001a\u0001%a/\u0002\t5|g/\u001a\u000b\u0007\u0005{\u0012\u0019Na6\t\u000f\tU\u0017\u00051\u0001\u0002\u001c\u0006QqN]5hS:\fG.\u00133\t\u000f\te\u0017\u00051\u0001\u0002\u001c\u0006)a.Z<JI\"\u001a\u0011%a/\u0002\r\u001d,G/V5e)\u0011\u0011\tOa@\u0011\u000b\t\u0013\u0019Oa:\n\u0007\t\u00158I\u0001\u0004PaRLwN\u001c\t\u0005\u0005S\u0014IP\u0004\u0003\u0003l\n]h\u0002\u0002Bw\u0005ktAAa<\u0003t:!\u0011\u0011\nBy\u0013\tA\u0014(\u0003\u00027o%\u0011!.N\u0005\u0004\u00057I\u0017\u0002\u0002B~\u0005{\u0014QaQ5VS\u0012T1Aa\u0007j\u0011\u001d\tIJ\ta\u0001\u00037\u000b\u0011bZ3u'R\fG/^:\u0015\t\t52Q\u0001\u0005\b\u00033\u001b\u0003\u0019AANQ\r\u0019\u00131X\u0001\fO\u0016$8\u000b^1ukN,7\u000f\u0006\u0003\u0004\u000e\r=\u0001C\u0002B\n\u0005;\u0011i\u0003C\u0004\u0004\u0012\u0011\u0002\rA!\u0005\u0002\u0007%$7\u000fK\u0002%\u0003w\u000bQbZ3u%&\u001c8nU2pe\u0016\u001cH\u0003BB\r\u00077\u0001bAa\u0005\u0003\u001e\t=\u0004bBB\tK\u0001\u0007!\u0011\u0003\u0015\u0004K\u00055\u0006fA\u0013\u0002<\u0006i1/\u001a;SSN\\7kY8sKN$\u0002B! \u0004&\r\u001d21\u0006\u0005\b\u0005\u000b3\u0003\u0019AAN\u0011\u001d\u0019IC\na\u0001\u0005_\nQa]2pe\u0016Dqa!\f'\u0001\u0004\u0011y'\u0001\u0006u_R\fGnU2pe\u0016D3AJA^\u0003)I7\u000fV3na2\fG/\u001a\u000b\u0005\u0003#\u001b)\u0004C\u0004\u0003\u0006\u001e\u0002\r!a')\u0007\u001d\ni\u000bK\u0002(\u0003w\u000b\u0001bZ3u)&$H.\u001a\u000b\u0005\u00037\u001by\u0004C\u0004\u0002\u001a\"\u0002\r!a')\u0007!\ni\u000bK\u0002)\u0003w\u000ba!\u001e9eCR,GcA(\u0004J!1\u0011Q[\u0015A\u0002=C3!KA^)\u0015y5qJB*\u0011\u0019\u0019\tF\u000ba\u0001\u001f\u0006AqN]5hS:\fG\u000e\u0003\u0004\u0004V)\u0002\raT\u0001\bkB$\u0017\r^3eQ\rQ\u00131X\u0001\be\u0016\u0004H.Y2f)\u0015y5QLB0\u0011\u0019\u0019\tf\u000ba\u0001\u001f\"11QK\u0016A\u0002=C3aKA^\u0003)9W\r^!mYR\u000bwm\u001d\u000b\u0005\u0007O\u001ai\u0007\u0005\u0004\u0003^\r%\u00141T\u0005\u0005\u0007W\u0012yFA\u0002TKRDqaa\u001c-\u0001\u0004\u0011y'A\u0006mS6LGOT;nE\u0016\u0014\bf\u0001\u0017\u0002.\"\u001aA&a/\u0002\u0015\u001d,GOU3mK\u0006\u001cX\rF\u0003P\u0007s\u001aI\tC\u0004\u0003\u00066\u0002\raa\u001f\u0011\t\ru41\u0011\b\u0005\u0005W\u001cy(C\u0002\u0004\u0002&\fAaQ5JI&!1QQBD\u0005\u0011\u0019\u0015.\u00133\u000b\u0007\r\u0005\u0015\u000eC\u0004\u0002x6\u0002\r!!?\u0002E\rDWmY6Jg:{GOU3gKJ,gnY3e\u0005f$U\r]3oI\u0016t7-[3t)\u0011\u0011iha$\t\u000f\rEe\u00061\u0001\u0004|\u00059\u0002\u000f\\1o\u0013R,W.\u00133Pe&#8o\u00115jY\u0012\u0014XM\\\u0001\u0010M&tGmU\"N\t\u0006$\u0018MQ=JIR!1qSBS!\u0015\u0011%1]BM!\u0011\u0019Yj!)\u000e\u0005\ru%\u0002BBP\u0005G\nA\u0001\\1oO&!11UBO\u0005\u001dIe\u000e^3hKJDq!!'0\u0001\u0004\tY\nK\u00020\u0003[C3aLA^\u0003U1\u0017N\u001c3Pm\u0016\u0014H-^3SK2,\u0017m]3JIN$\"A!\u0005)\u0007A\ni\u000bK\u00021\u0003w\u000babZ3u%\u0016dW-Y:f\u0015N|g\u000e\u0006\u0003\u0002\u001c\u000e]\u0006b\u0002BCc\u0001\u0007\u00111\u0014\u0015\u0004c\u00055\u0006fA\u0019\u0002<\u0006Iq-\u001a;Gk2d\u0017\n\u001a\u000b\u0005\u00037\u001b\t\rC\u0004\u0003\u0006J\u0002\r!a')\u0007I\ni\u000bK\u00023\u0003w\u000b!dZ3u%\u0016dW-Y:fg^KG\u000f[8vi\u000e{W.\\3oiN$Baa3\u0004PB)!1CBg\u001f&!!Q\u0015B\u0011\u0011\u001d\u0019\tn\ra\u0001\u0007'\f!B]3mK\u0006\u001cX-\u00133t!\u0019\u0011\u0019b!4\u0002\u001c\"\u001a1'!,)\u0007M\nY\fK\u0002\u0001\u00077\u0004B!a,\u0004^&!1q\\AY\u0005=I5\u000f\u0016:b]N\f7\r^5p]\u0006d\u0007")
public class SqlReleaseRepository
implements ReleaseRepository,
InterceptedRepository<Release>,
Logging,
DeserializationSupport,
ConfigurationReferencesSupport,
SqlReleaseRepositoryHelper {
    private final ReleasePersistence releasePersistence;
    private final TaskPersistence taskPersistence;
    private final DependencyPersistence dependencyPersistence;
    private final CommentPersistence commentPersistence;
    private final TeamRepository teamRepository;
    private final ReleaseExtensionsRepository releaseExtensionsRepository;
    private final ConfigurationReferencePersistence configurationPersistence;
    private final SqlRepositoryAdapter repositoryAdapter;
    private final FacetRepositoryDispatcher facetRepositoryDispatcher;
    private final SqlBuilder.Dialect sqlDialect;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private scala.collection.immutable.Seq<PersistenceInterceptor<Release>> persistenceInterceptors;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public void replaceTasks(Release original, Release updated) {
        SqlReleaseRepositoryHelper.replaceTasks$(this, original, updated);
    }

    @Override
    public void replaceReleaseExtensions(Release original, Release updated) {
        SqlReleaseRepositoryHelper.replaceReleaseExtensions$(this, original, updated);
    }

    @Override
    public void replaceReleaseTeams(Release original, Release updated) {
        SqlReleaseRepositoryHelper.replaceReleaseTeams$(this, original, updated);
    }

    @Override
    public void updateCommentsOnTasks(Task originalTask, Task updatedTask) {
        SqlReleaseRepositoryHelper.updateCommentsOnTasks$(this, originalTask, updatedTask);
    }

    @Override
    public void insertDependency(Integer gateTaskUid, Dependency dependency) {
        SqlReleaseRepositoryHelper.insertDependency$(this, gateTaskUid, dependency);
    }

    @Override
    public void updateConfigurationRefs(CiWithUid entity) {
        ConfigurationReferencesSupport.updateConfigurationRefs$(this, entity);
    }

    @Override
    public void deleteConfigurationRefs(Integer uid) {
        ConfigurationReferencesSupport.deleteConfigurationRefs$(this, uid);
    }

    @Override
    public Release deserializeRelease(ReleaseRow releaseData, ResolveOptions resolveOptions) {
        return DeserializationSupport.deserializeRelease$(this, releaseData, resolveOptions);
    }

    @Override
    public Option<Release> tryDeserializeRelease(ReleaseRow releaseData, ResolveOptions resolveOptions) {
        return DeserializationSupport.tryDeserializeRelease$(this, releaseData, resolveOptions);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    public void registerPersistenceInterceptor(PersistenceInterceptor<Release> persistenceInterceptor) {
        InterceptedRepository.registerPersistenceInterceptor$((InterceptedRepository)this, persistenceInterceptor);
    }

    public void interceptCreate(ConfigurationItem ci) {
        InterceptedRepository.interceptCreate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void interceptDelete(String ciId) {
        InterceptedRepository.interceptDelete$((InterceptedRepository)this, (String)ciId);
    }

    public void interceptUpdate(ConfigurationItem ci) {
        InterceptedRepository.interceptUpdate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterCreate(ConfigurationItem ci) {
        InterceptedRepository.afterCreate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterUpdate(ConfigurationItem ci) {
        InterceptedRepository.afterUpdate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterDelete(String ciId) {
        InterceptedRepository.afterDelete$((InterceptedRepository)this, (String)ciId);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlReleaseRepository sqlReleaseRepository = this;
        synchronized (sqlReleaseRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public scala.collection.immutable.Seq<PersistenceInterceptor<Release>> persistenceInterceptors() {
        return this.persistenceInterceptors;
    }

    public void persistenceInterceptors_$eq(scala.collection.immutable.Seq<PersistenceInterceptor<Release>> x$1) {
        this.persistenceInterceptors = x$1;
    }

    public scala.collection.immutable.Seq<String> findIdsByStatus(ReleaseStatus ... statuses) {
        return this.findIdsByStatus((scala.collection.immutable.Seq<ReleaseStatus>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])statuses));
    }

    public TaskPersistence taskPersistence() {
        return this.taskPersistence;
    }

    public DependencyPersistence dependencyPersistence() {
        return this.dependencyPersistence;
    }

    public CommentPersistence commentPersistence() {
        return this.commentPersistence;
    }

    public TeamRepository teamRepository() {
        return this.teamRepository;
    }

    public ReleaseExtensionsRepository releaseExtensionsRepository() {
        return this.releaseExtensionsRepository;
    }

    @Override
    public ConfigurationReferencePersistence configurationPersistence() {
        return this.configurationPersistence;
    }

    @Override
    public SqlRepositoryAdapter repositoryAdapter() {
        return this.repositoryAdapter;
    }

    public SqlBuilder.Dialect sqlDialect() {
        return this.sqlDialect;
    }

    @Timed
    @IsReadOnly
    public boolean exists(String id) {
        return this.releasePersistence.existsRelease(CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(id)));
    }

    @Timed
    public Release create(Release release, ReleaseCreationSource releaseCreationSource) {
        if (this.releasePersistence.existsRelease(release.getId())) {
            throw new ItemAlreadyExistsException("A release with ID [%s] already exists", new Object[]{release.getId()});
        }
        this.interceptCreate((ConfigurationItem)release);
        this.releasePersistence.insert(release);
        CollectionConverters$.MODULE$.ListHasAsScala(release.getAllTasks()).asScala().foreach((Function1 & Serializable)task -> {
            SqlReleaseRepository.$anonfun$create$1(this, release, task);
            return BoxedUnit.UNIT;
        });
        release.getExtensions().forEach(extension -> this.releaseExtensionsRepository().create(extension));
        this.updateConfigurationRefs((CiWithUid)release);
        this.facetRepositoryDispatcher.liveRepository().createFromTasks(CollectionConverters$.MODULE$.ListHasAsScala(release.getAllTasks()).asScala().toSeq(), this.facetRepositoryDispatcher.liveRepository().createFromTasks$default$2());
        return release;
    }

    @Timed
    public Release findById(String id) {
        return this.getRelease(id, new ResolveOptionsBuilder().withEverything().build());
    }

    @Timed
    public Release findById(String id, ResolveOptions resolveOptions) {
        return this.getRelease(id, resolveOptions);
    }

    @Timed
    @IsReadOnly
    public scala.collection.immutable.Seq<String> findIdsByStatus(scala.collection.immutable.Seq<ReleaseStatus> statuses) {
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseId().withOneOfStatuses(statuses).build();
        return this.releasePersistence.findReleaseIdsByQuery((Tuple2<String, scala.collection.immutable.Seq<Object>>)sqlWithParams).toSeq();
    }

    @Timed
    public Release findByCalendarToken(String calendarToken) {
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseData().withCalendarToken(calendarToken).build();
        scala.collection.immutable.Seq<ReleaseRow> releases = this.releasePersistence.findReleaseDatasByQuery((Tuple2<String, scala.collection.immutable.Seq<Object>>)sqlWithParams);
        return (Release)releases.headOption().map((Function1 & Serializable)x$1 -> this.deserializeRelease((ReleaseRow)x$1, new ResolveOptionsBuilder().withEverything().build())).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    @Timed
    @IsReadOnly
    public scala.collection.immutable.Seq<String> findArchivableReleaseIds(Date date, int pageSize) {
        ReleasesSqlBuilder qual$1 = (ReleasesSqlBuilder)new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseId().withOneOfStatuses((scala.collection.immutable.Seq<ReleaseStatus>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ReleaseStatus[]{ReleaseStatus.COMPLETED, ReleaseStatus.ABORTED})))).withEndDateBefore(date).withPage(new Page(0L, (long)pageSize, Predef$.MODULE$.int2Integer(0), Page$.MODULE$.apply$default$4()));
        boolean x$1 = qual$1.withPreArchived$default$1();
        Tuple2 sqlWithParams = qual$1.withPreArchived(x$1).build();
        return this.releasePersistence.findReleaseIdsByQuery((Tuple2<String, scala.collection.immutable.Seq<Object>>)sqlWithParams).toSeq();
    }

    @Timed
    public void setPreArchived(String releaseId, boolean preArchived) {
        this.releasePersistence.setPreArchived(releaseId, preArchived);
    }

    @Timed
    @IsReadOnly
    public scala.collection.immutable.Seq<Release> findPreArchivableReleases(int page, int pageSize) {
        scala.collection.immutable.Seq inactive = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ReleaseStatus[]{ReleaseStatus.COMPLETED, ReleaseStatus.ABORTED}));
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseData().withOneOfStatuses((scala.collection.immutable.Seq<ReleaseStatus>)inactive).withPreArchived(false).limitAndOffset(pageSize, page * pageSize).build();
        return (scala.collection.immutable.Seq)((IterableOps)((IterableOps)((IterableOps)this.releasePersistence.findReleaseDatasByQuery((Tuple2<String, scala.collection.immutable.Seq<Object>>)sqlWithParams).flatMap((Function1 & Serializable)x$2 -> this.tryDeserializeRelease((ReleaseRow)x$2, new ResolveOptionsBuilder().withEverything().build()))).filterNot((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isTutorial()))).map((Function1 & Serializable)release -> this.releaseExtensionsRepository().decorate(release))).map((Function1 & Serializable)release -> this.commentPersistence().decorate((Release)release));
    }

    @Timed
    public java.util.List<Release> search(ReleaseSearchByParams searchParams) {
        ReleaseSearchByParams releaseSearchByParams = searchParams;
        if (releaseSearchByParams == null) {
            throw new MatchError((Object)releaseSearchByParams);
        }
        Page page = releaseSearchByParams.page();
        Either folderId2 = releaseSearchByParams.folderId();
        ReleaseStatus[] statuses = releaseSearchByParams.statuses();
        String title = releaseSearchByParams.title();
        String rootReleaseId = releaseSearchByParams.rootReleaseId();
        boolean autoStart = releaseSearchByParams.autoStart();
        ReleasesSqlBuilder base = (ReleasesSqlBuilder)new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseData().withTitle(title).withRootReleaseId(rootReleaseId).withPage(page);
        ReleasesSqlBuilder sqlBuilder = folderId2 == null ? base : (ReleasesSqlBuilder)folderId2.fold((Function1 & Serializable)folderId -> base.withFolder((String)folderId), (Function1 & Serializable)ancestorId -> base.withAncestor((String)ancestorId));
        Object object = ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])statuses)) ? sqlBuilder.withOneOfStatuses((scala.collection.immutable.Seq<ReleaseStatus>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)statuses)) : BoxedUnit.UNIT;
        Object object2 = autoStart ? sqlBuilder.withAutoStart() : BoxedUnit.UNIT;
        java.util.List list = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOps)((IterableOps)this.releasePersistence.findReleaseDatasByQuery((Tuple2<String, scala.collection.immutable.Seq<Object>>)sqlBuilder.build()).flatMap((Function1 & Serializable)x$4 -> this.tryDeserializeRelease((ReleaseRow)x$4, new ResolveOptionsBuilder().withEverything().build()))).map((Function1 & Serializable)release -> this.releaseExtensionsRepository().decorate(release))).map((Function1 & Serializable)release -> this.commentPersistence().decorate((Release)release))).asJava();
        return list;
    }

    @Timed
    public void delete(String id) {
        this.checkIsNotReferencedByDependencies(id);
        this.releasePersistence.findUidByReleaseId(id).foreach((Function1 & Serializable)uid -> {
            this.deleteReleaseReferences(id, uid);
            return BoxedUnit.UNIT;
        });
        this.releasePersistence.deleteById(id);
    }

    private void deleteReleaseReferences(String id, int releaseUid) {
        this.dependencyPersistence().deleteByReleaseUid(Predef$.MODULE$.int2Integer(releaseUid));
        scala.collection.immutable.Seq<Integer> taskCiUids = this.taskPersistence().findTaskCiUidsByReleaseCiUid(Predef$.MODULE$.int2Integer(releaseUid));
        this.dependencyPersistence().deleteByTaskUids(taskCiUids);
        this.commentPersistence().deleteByRelease(Predef$.MODULE$.int2Integer(releaseUid), taskCiUids);
        this.taskPersistence().deleteTasksByReleaseUid(releaseUid);
        this.teamRepository().deleteTeamsFromPlatform(new SecuredCi(id, releaseUid));
        this.releaseExtensionsRepository().deleteAll(id);
        this.deleteConfigurationRefs(Predef$.MODULE$.int2Integer(releaseUid));
        this.interceptDelete(id);
    }

    @Timed
    public void deleteWithUid(String id, int releaseUid) {
        this.deleteReleaseReferences(id, releaseUid);
        this.releasePersistence.deleteById(id);
    }

    @Timed
    public void move(String originalId, String newId) {
        this.releasePersistence.move(originalId, newId);
    }

    public Option<Integer> getUid(String id) {
        return this.releasePersistence.findUidByReleaseId(id);
    }

    @Timed
    public ReleaseStatus getStatus(String id) {
        String status = (String)this.releasePersistence.findReleaseStatus(CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(id))).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return status == null ? null : ReleaseStatus.valueOf((String)status.toUpperCase());
    }

    @Timed
    public scala.collection.immutable.Seq<ReleaseStatus> getStatuses(scala.collection.immutable.Seq<String> ids) {
        return ids.isEmpty() ? (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$) : (scala.collection.immutable.Seq)this.releasePersistence.findReleaseStatuses(ids).map((Function1 & Serializable)status -> ReleaseStatus.valueOf((String)status.toUpperCase()));
    }

    @Timed
    @IsReadOnly
    public scala.collection.immutable.Seq<Object> getRiskScores(scala.collection.immutable.Seq<String> ids) {
        return this.releasePersistence.findReleaseRiskScores(ids);
    }

    @Timed
    public void setRiskScores(String releaseId, int score, int totalScore) {
        this.releasePersistence.updateReleaseRiskScores(releaseId, score, totalScore);
    }

    @Timed
    @IsReadOnly
    public boolean isTemplate(String releaseId) {
        return ReleaseStatus.TEMPLATE.equals(this.getStatus(releaseId));
    }

    @Timed
    @IsReadOnly
    public String getTitle(String id) {
        return (String)this.releasePersistence.findReleaseTitle(CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(id))).getOrElse((Function0 & Serializable)() -> {
            throw new LogFriendlyNotFoundException("Release [%s] not found", new Object[]{id});
        });
    }

    @Timed
    public Release update(Release release) {
        return this.update(null, release);
    }

    @Timed
    public Release update(Release original, Release updated) {
        Option originalReleaseOpt = Option$.MODULE$.apply((Object)original);
        this.releasePersistence.update((Option<Release>)Option$.MODULE$.apply((Object)original), updated);
        originalReleaseOpt.foreach((Function1 & Serializable)rel -> {
            SqlReleaseRepository.$anonfun$update$1(this, updated, rel);
            return BoxedUnit.UNIT;
        });
        this.updateConfigurationRefs((CiWithUid)updated);
        return updated;
    }

    @Timed
    public Release replace(Release original, Release updated) {
        if (Ids.isFolderId((String)original.getId())) {
            updated.setTeams(Collections.emptyList());
        }
        this.releasePersistence.update((Option<Release>)Option$.MODULE$.apply((Object)original), updated);
        if (original != null) {
            this.replaceTasks(original, updated);
            this.replaceReleaseExtensions(original, updated);
            this.replaceReleaseTeams(original, updated);
        }
        this.updateConfigurationRefs((CiWithUid)updated);
        return updated;
    }

    @Timed
    @IsReadOnly
    public Set<String> getAllTags(int limitNumber) {
        return CollectionConverters$.MODULE$.SetHasAsJava(this.releasePersistence.findAllTags(limitNumber)).asJava();
    }

    /*
     * WARNING - void declaration
     */
    private Release getRelease(String releaseId, ResolveOptions resolveOptions) {
        void var3_3;
        BoxedUnit boxedUnit;
        Release release = (Release)this.repositoryAdapter().read(releaseId, resolveOptions);
        if (release == null) {
            throw new LogFriendlyNotFoundException(new StringBuilder(30).append("Repository entity [").append(releaseId).append("] not found").toString(), new Object[0]);
        }
        if (resolveOptions.hasDecorators()) {
            this.releaseExtensionsRepository().decorate(release);
            boxedUnit = this.commentPersistence().decorate(release);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return var3_3;
    }

    private void checkIsNotReferencedByDependencies(String planItemIdOrItsChildren) {
        scala.collection.immutable.Seq externalIncomingDependencies = (scala.collection.immutable.Seq)((IterableOps)this.dependencyPersistence().findByPartialTargetIds((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{planItemIdOrItsChildren}))), (Option<scala.collection.immutable.Set<String>>)None$.MODULE$).map((Function1 & Serializable)x$6 -> DependencyRow$.MODULE$.DependencyRowOps((DependencyRow)x$6).fullDependencyId())).filterNot((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.startsWith(CiId$RichCiId$.MODULE$.normalized$extension(CiId$.MODULE$.RichCiId(planItemIdOrItsChildren)))));
        if (externalIncomingDependencies.nonEmpty()) {
            throw new ItemInUseException(new StringBuilder(0).append(new StringBuilder(68).append("Cannot delete [").append(planItemIdOrItsChildren).append("] because it or one of its children is referenced by ").toString()).append(new StringBuilder(28).append("one or more dependencies: [").append(externalIncomingDependencies.mkString(", ")).append("]").toString()).toString(), new Object[0]);
        }
    }

    @Timed
    @IsReadOnly
    public Option<Integer> findSCMDataById(String id) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(49).append("Finding scm data for template or release with id ").append(id).toString());
        return this.releasePersistence.findSCMDataById(id).map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1));
    }

    @Timed
    @IsReadOnly
    public scala.collection.immutable.Seq<String> findOverdueReleaseIds() {
        return this.releasePersistence.findOverdueReleaseIds();
    }

    @Timed
    @IsReadOnly
    public String getReleaseJson(String releaseId) {
        return (String)this.releasePersistence.findByReleaseId(releaseId).map((Function1 & Serializable)x$8 -> x$8.json()).getOrElse((Function0 & Serializable)() -> {
            throw new LogFriendlyNotFoundException(new StringBuilder(30).append("Repository entity [").append(releaseId).append("] not found").toString(), new Object[0]);
        });
    }

    @Timed
    @IsReadOnly
    public String getFullId(String releaseId) {
        BasicReleaseRow row = (BasicReleaseRow)this.releasePersistence.getBasicReleaseRow(releaseId).getOrElse((Function0 & Serializable)() -> {
            throw new LogFriendlyNotFoundException(new StringBuilder(30).append("Repository entity [").append(releaseId).append("] not found").toString(), new Object[0]);
        });
        return Ids.formatWithFolderId((String)row.folderId(), (String)row.releaseId());
    }

    @Timed
    @IsReadOnly
    public List<Release> getReleasesWithoutComments(List<String> releaseIds) {
        Tuple2 sqlWithParams = new ReleasesSqlBuilder(this.sqlDialect()).selectReleaseData().withReleaseIds((scala.collection.immutable.Seq<String>)releaseIds).build();
        scala.collection.immutable.Seq releases = (scala.collection.immutable.Seq)((IterableOps)this.releasePersistence.findReleaseDatasByQuery((Tuple2<String, scala.collection.immutable.Seq<Object>>)sqlWithParams).flatMap((Function1 & Serializable)x$9 -> this.tryDeserializeRelease((ReleaseRow)x$9, ResolveOptions$.MODULE$.DEPENDENCIES()))).map((Function1 & Serializable)release -> this.releaseExtensionsRepository().decorate(release));
        return ((IterableOnceOps)releases.sortBy((Function1 & Serializable)r -> BoxesRunTime.boxToInteger((int)releaseIds.indexOf((Object)Ids.getName((String)r.getId()))), (Ordering)Ordering.Int$.MODULE$)).toList();
    }

    public static final /* synthetic */ boolean $anonfun$create$2(SqlReleaseRepository $this, Integer taskUid$1, Comment comment) {
        return $this.commentPersistence().create(taskUid$1, CommentPersistence$CommentRow$.MODULE$.fromComment(comment));
    }

    public static final /* synthetic */ void $anonfun$create$1(SqlReleaseRepository $this, Release release$1, Task task) {
        Integer taskUid = $this.taskPersistence().insert(task, Predef$.MODULE$.Integer2int(release$1.getCiUid()));
        syntax.TaskOps$.MODULE$.comments$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable)comment -> BoxesRunTime.boxToBoolean((boolean)SqlReleaseRepository.$anonfun$create$2($this, taskUid, comment)));
        syntax.TaskOps$.MODULE$.dependencies$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable)dependency -> {
            $this.insertDependency(taskUid, dependency);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$update$3(SqlReleaseRepository $this, Integer taskUid$2, Comment c) {
        return $this.commentPersistence().create(taskUid$2, CommentPersistence$CommentRow$.MODULE$.fromComment(c));
    }

    public static final /* synthetic */ void $anonfun$update$2(SqlReleaseRepository $this, Release updated$1, Task task) {
        Integer taskUid = $this.taskPersistence().insert(task, Predef$.MODULE$.Integer2int(updated$1.getCiUid()));
        syntax.TaskOps$.MODULE$.comments$extension(syntax$.MODULE$.TaskOps(task)).foreach((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)SqlReleaseRepository.$anonfun$update$3($this, taskUid, c)));
        ((IterableOnceOps)syntax.TaskOps$.MODULE$.dependencies$extension(syntax$.MODULE$.TaskOps(task)).filterNot((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isArchived()))).foreach((Function1 & Serializable)dependency -> {
            $this.insertDependency(taskUid, dependency);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$update$1(SqlReleaseRepository $this, Release updated$1, Release rel) {
        Diff$.MODULE$.apply((Iterable)CollectionConverters$.MODULE$.ListHasAsScala(rel.getAllTasks()).asScala(), (Iterable)CollectionConverters$.MODULE$.ListHasAsScala(updated$1.getAllTasks()).asScala()).newValues().foreach((Function1 & Serializable)task -> {
            SqlReleaseRepository.$anonfun$update$2($this, updated$1, task);
            return BoxedUnit.UNIT;
        });
    }

    public SqlReleaseRepository(ReleasePersistence releasePersistence, TaskPersistence taskPersistence, DependencyPersistence dependencyPersistence, CommentPersistence commentPersistence, TeamRepository teamRepository, ReleaseExtensionsRepository releaseExtensionsRepository, ConfigurationReferencePersistence configurationPersistence, SqlRepositoryAdapter repositoryAdapter, FacetRepositoryDispatcher facetRepositoryDispatcher, SqlBuilder.Dialect sqlDialect) {
        this.releasePersistence = releasePersistence;
        this.taskPersistence = taskPersistence;
        this.dependencyPersistence = dependencyPersistence;
        this.commentPersistence = commentPersistence;
        this.teamRepository = teamRepository;
        this.releaseExtensionsRepository = releaseExtensionsRepository;
        this.configurationPersistence = configurationPersistence;
        this.repositoryAdapter = repositoryAdapter;
        this.facetRepositoryDispatcher = facetRepositoryDispatcher;
        this.sqlDialect = sqlDialect;
        InterceptedRepository.$init$((InterceptedRepository)this);
        Logging.$init$((Logging)this);
        DeserializationSupport.$init$(this);
        ConfigurationReferencesSupport.$init$(this);
        SqlReleaseRepositoryHelper.$init$(this);
    }
}

