package com.xebialabs.xlrelease.upgrade.db

import com.xebialabs.deployit.security.permission.Permission
import com.xebialabs.deployit.security.{PermissionEditor, Role}
import com.xebialabs.xlrelease.domain.status.ReleaseStatus.{ACTIVE_STATUSES, PLANNED, TEMPLATE}
import com.xebialabs.xlrelease.repository.Ids.ROOT_FOLDER_ID
import com.xebialabs.xlrelease.repository.sql.persistence.Schema.RELEASES
import com.xebialabs.xlrelease.repository.sql.persistence.Utils.params
import com.xebialabs.xlrelease.repository.sql.persistence.{FolderPersistence, PersistenceSupport}
import grizzled.slf4j.Logging

import java.util
import scala.collection.mutable
import scala.jdk.CollectionConverters._

trait BasePermissionUpgrade extends PersistenceSupport
  with Logging {

  /**
   * Find folder and release Cis that contain the given existingPermission and apply the upgradePermission
  */
  def upgradePermission(folderPersistence: FolderPersistence, permissionEditor: PermissionEditor, existingPermission: Permission,
                        upgradePermission: Permission): Unit = {
    val securedCis: Seq[String] = folderPersistence.findDescendantsById(ROOT_FOLDER_ID).map(r => r.uid.toString).distinct.toSeq ++ getReleaseCis
    securedCis.foreach(securedCI => {
      val rolePermissionsMap: mutable.Map[Role, util.Set[Permission]] = permissionEditor.readPermissions(securedCI).asScala
      rolePermissionsMap.collect {
        case (role, permissions) if permissions.contains(existingPermission) =>
          permissions.add(upgradePermission)
          permissionEditor.editPermissions(securedCI, rolePermissionsMap.asJava)
          role
      }
    })
  }

  private val STMT_FIND_RELEASE_CIS =
    s"""
       |SELECT
       |  r.${RELEASES.CI_UID}
       |FROM
       |  ${RELEASES.TABLE} r
       |WHERE
       |  r.${RELEASES.STATUS} IN (:statuses) AND
       |  r.${RELEASES.CI_UID} = r.${RELEASES.SECURITY_UID}
     """.stripMargin

  private def getReleaseCis: Seq[String] = {
    val statuses = (ACTIVE_STATUSES :+ PLANNED :+ TEMPLATE).toSeq.map(_.value()).asJava
    sqlQuery(STMT_FIND_RELEASE_CIS, params("statuses" -> statuses), rs => rs.getString(RELEASES.CI_UID)).distinct.toSeq
  }
}
