package com.xebialabs.xlrelease.repository.sql

import com.codahale.metrics.annotation.Timed
import com.xebialabs.deployit.exception.NotFoundException
import com.xebialabs.xlrelease.db.sql.transaction.{IsReadOnly, IsTransactional}
import com.xebialabs.xlrelease.domain.{Link, ParallelGroup}
import com.xebialabs.xlrelease.repository.Ids.releaseIdFrom
import com.xebialabs.xlrelease.repository.sql.persistence.CiId._
import com.xebialabs.xlrelease.repository.sql.persistence.{DependencyPersistence, ReleasePersistence}
import com.xebialabs.xlrelease.repository.{Ids, LinkRepository}
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptionsBuilder

@IsTransactional
class SqlLinkRepository(val releasePersistence: ReleasePersistence,
                        val dependencyPersistence: DependencyPersistence,
                        val repositoryAdapter: SqlRepositoryAdapter) extends LinkRepository with BaseReleaseItemRepository{

  @Timed
  override def delete(link: Link): Link = {
    val release = link.getParallelGroup.getRelease
    releasePersistence.update(release)
    link
  }

  @Timed
  override def create(link: Link): Link = {
    val release = link.getParallelGroup.getRelease
    releasePersistence.update(release)
    link
  }

  @Timed
  @IsReadOnly
  override def findById(linkId: CiId): Link = {
    val task = getRelease(releaseIdFrom(linkId), linkId, new ResolveOptionsBuilder().withEverything.build)
      .getTask(Ids.getParentId(linkId.normalized))
    if (task.isParallelGroup) {
      notNull(task.asInstanceOf[ParallelGroup].findLink(linkId.normalized), linkId)
    } else {
      throw new NotFoundException("Repository entity [%s] not found", linkId)
    }
  }

}
