/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.scheduler.sql;

import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.repository.sql.persistence.CompressionSupport;
import com.xebialabs.xlrelease.repository.sql.persistence.PersistenceSupport;
import com.xebialabs.xlrelease.repository.sql.persistence.Schema;
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence$;
import com.xebialabs.xlrelease.repository.sql.persistence.Utils;
import com.xebialabs.xlrelease.repository.sql.persistence.Utils$;
import com.xebialabs.xlrelease.scheduler.JobOverview;
import com.xebialabs.xlrelease.scheduler.JobRow;
import com.xebialabs.xlrelease.scheduler.JobStatus;
import com.xebialabs.xlrelease.scheduler.JobType;
import com.xebialabs.xlrelease.scheduler.filters.JobFilters;
import com.xebialabs.xlrelease.scheduler.repository.DeleteById;
import com.xebialabs.xlrelease.scheduler.repository.DeleteByTaskId;
import com.xebialabs.xlrelease.scheduler.repository.DeleteByTaskIdAndExecutionId;
import com.xebialabs.xlrelease.scheduler.repository.DeleteJob;
import com.xebialabs.xlrelease.scheduler.repository.JobRepository;
import com.xebialabs.xlrelease.scheduler.repository.UpdateJob;
import com.xebialabs.xlrelease.scheduler.repository.UpdateJobStatus;
import com.xebialabs.xlrelease.scheduler.repository.UpdateNode;
import com.xebialabs.xlrelease.scheduler.repository.UpdateNodeAndStatus;
import com.xebialabs.xlrelease.scheduler.sql.JobRowMapper;
import com.xebialabs.xlrelease.scheduler.sql.SqlJobFiltersQueryBuilder$;
import com.xebialabs.xlrelease.scheduler.sql.SqlJobOverviewQueryBuilder$;
import com.xebialabs.xlrelease.spring.config.SqlConfiguration$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.UUID;
import org.slf4j.Marker;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\tmd\u0001B\u0015+\u0001UB\u0001\"\u0017\u0001\u0003\u0006\u0004%\tA\u0017\u0005\tO\u0002\u0011\t\u0011)A\u00057\"A\u0001\u000e\u0001BC\u0002\u0013\u0005\u0011\u000eC\u0005\u0002\u0004\u0001\u0011\t\u0011)A\u0005U\"Q\u0011Q\u0001\u0001\u0003\u0006\u0004%\t!a\u0002\t\u0015\u0005E\u0001A!A!\u0002\u0013\tI\u0001C\u0004\u0002\u0014\u0001!\t!!\u0006\t\u000f\u0005}\u0001\u0001\"\u0011\u0002\"!9\u0011q\u0006\u0001\u0005B\u0005E\u0002\"CA\"\u0001\t\u0007I\u0011BA#\u0011!\t9\u0006\u0001Q\u0001\n\u0005\u001d\u0003bBA-\u0001\u0011%\u00111\f\u0005\n\u0003?\u0002!\u0019!C\u0005\u0003CB\u0001\"!\u001d\u0001A\u0003%\u00111\r\u0005\n\u0003g\u0002!\u0019!C\u0005\u0003\u000bB\u0001\"!\u001e\u0001A\u0003%\u0011q\t\u0005\b\u0003o\u0002A\u0011IA=\u0011%\t)\t\u0001b\u0001\n\u0013\t)\u0005\u0003\u0005\u0002\b\u0002\u0001\u000b\u0011BA$\u0011%\tI\t\u0001b\u0001\n\u0013\t)\u0005\u0003\u0005\u0002\f\u0002\u0001\u000b\u0011BA$\u0011\u001d\ti\t\u0001C!\u0003\u001fC\u0011\"!.\u0001\u0005\u0004%I!!\u0012\t\u0011\u0005]\u0006\u0001)A\u0005\u0003\u000fBq!!/\u0001\t\u0013\tY\fC\u0004\u0002N\u0002!I!a4\t\u000f\u0005u\u0007\u0001\"\u0011\u0002`\"9!Q\u0002\u0001\u0005B\t=\u0001\"\u0003B\u0010\u0001\t\u0007I\u0011BA#\u0011!\u0011\t\u0003\u0001Q\u0001\n\u0005\u001d\u0003b\u0002B\u0012\u0001\u0011\u0005#Q\u0005\u0005\n\u0005_\u0001!\u0019!C\u0005\u0003\u000bB\u0001B!\r\u0001A\u0003%\u0011q\t\u0005\n\u0005g\u0001!\u0019!C\u0005\u0003\u000bB\u0001B!\u000e\u0001A\u0003%\u0011q\t\u0005\n\u0005o\u0001!\u0019!C\u0005\u0003\u000bB\u0001B!\u000f\u0001A\u0003%\u0011q\t\u0005\b\u0005w\u0001A\u0011\tB\u001f\u0011\u001d\u0011Y\u0005\u0001C!\u0005\u001bBqA!\u0018\u0001\t\u0013\u0011yF\u0001\tTc2TuN\u0019*fa>\u001c\u0018\u000e^8ss*\u00111\u0006L\u0001\u0004gFd'BA\u0017/\u0003%\u00198\r[3ek2,'O\u0003\u00020a\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003cI\n\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003M\n1aY8n\u0007\u0001\u0019r\u0001\u0001\u001c=\u0005*s\u0015\u000b\u0005\u00028u5\t\u0001HC\u0001:\u0003\u0015\u00198-\u00197b\u0013\tY\u0004H\u0001\u0004B]f\u0014VM\u001a\t\u0003{\u0001k\u0011A\u0010\u0006\u0003\u007f1\n!B]3q_NLGo\u001c:z\u0013\t\teHA\u0007K_\n\u0014V\r]8tSR|'/\u001f\t\u0003\u0007\"k\u0011\u0001\u0012\u0006\u0003\u000b\u001a\u000b1\u0002]3sg&\u001cH/\u001a8dK*\u00111f\u0012\u0006\u0003\u007f9J!!\u0013#\u0003%A+'o]5ti\u0016t7-Z*vaB|'\u000f\u001e\t\u0003\u00172k\u0011AK\u0005\u0003\u001b*\u0012ABS8c%><X*\u00199qKJ\u0004\"aQ(\n\u0005A#%!B+uS2\u001c\bC\u0001*X\u001b\u0005\u0019&B\u0001+V\u0003\u0015\u0019HN\u001a\u001bk\u0015\u00051\u0016\u0001C4sSjTH.\u001a3\n\u0005a\u001b&a\u0002'pO\u001eLgnZ\u0001\rU\u0012\u00147\rV3na2\fG/Z\u000b\u00027B\u0011A,Z\u0007\u0002;*\u0011alX\u0001\u0005G>\u0014XM\u0003\u0002aC\u0006!!\u000e\u001a2d\u0015\t\u00117-A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005!\u0017aA8sO&\u0011a-\u0018\u0002\r\u0015\u0012\u00147\rV3na2\fG/Z\u0001\u000eU\u0012\u00147\rV3na2\fG/\u001a\u0011\u0002\u000f\u0011L\u0017\r\\3diV\t!\u000e\u0005\u0002l}:\u0011An\u001f\b\u0003[ft!A\\<\u000f\u0005=4hB\u00019v\u001d\t\tH/D\u0001s\u0015\t\u0019H'\u0001\u0004=e>|GOP\u0005\u0002g%\u0011\u0011GM\u0005\u0003_AJ!\u0001\u001f\u0018\u0002\u0005\u0011\u0014\u0017BA\u0016{\u0015\tAh&\u0003\u0002}{\u0006Q1+\u001d7Ck&dG-\u001a:\u000b\u0005-R\u0018bA@\u0002\u0002\t9A)[1mK\u000e$(B\u0001?~\u0003!!\u0017.\u00197fGR\u0004\u0013A\u0004;bg.\u0014V\r]8tSR|'/_\u000b\u0003\u0003\u0013\u0001B!a\u0003\u0002\u000e5\tq)C\u0002\u0002\u0010\u001d\u0013a\u0002V1tWJ+\u0007o\\:ji>\u0014\u00180A\buCN\\'+\u001a9pg&$xN]=!\u0003\u0019a\u0014N\\5u}QA\u0011qCA\r\u00037\ti\u0002\u0005\u0002L\u0001!)\u0011l\u0002a\u00017\")\u0001n\u0002a\u0001U\"9\u0011QA\u0004A\u0002\u0005%\u0011AB2sK\u0006$X\r\u0006\u0003\u0002$\u0005-\u0002\u0003BA\u0013\u0003Oi\u0011\u0001L\u0005\u0004\u0003Sa#A\u0002&pEJ{w\u000fC\u0004\u0002.!\u0001\r!a\t\u0002\u0007)|'-A\u0004sKBd\u0017mY3\u0015\t\u0005\r\u00121\u0007\u0005\b\u0003[I\u0001\u0019AA\u0012Q\rI\u0011q\u0007\t\u0005\u0003s\ty$\u0004\u0002\u0002<)\u0019\u0011QH?\u0002\u0017Q\u0014\u0018M\\:bGRLwN\\\u0005\u0005\u0003\u0003\nYDA\bJgR\u0013\u0018M\\:bGRLwN\\1m\u0003=\u0019F+\u0014+`\u0013:\u001bVI\u0015+`\u0015>\u0013UCAA$!\u0011\tI%!\u0015\u000f\t\u0005-\u0013Q\n\t\u0003cbJ1!a\u00149\u0003\u0019\u0001&/\u001a3fM&!\u00111KA+\u0005\u0019\u0019FO]5oO*\u0019\u0011q\n\u001d\u0002!M#V\nV0J\u001dN+%\u000bV0K\u001f\n\u0003\u0013!D2sK\u0006$X\rV1tW*{'\r\u0006\u0003\u0002$\u0005u\u0003bBA\u0017\u0019\u0001\u0007\u00111E\u0001 !J+e+S(V'~3VIU*J\u001f:{\u0006+\u0011*B\u001b\u0016#VIU0O\u00036+UCAA2!\u0011\t)'a\u001c\u000e\u0005\u0005\u001d$\u0002BA5\u0003W\nA\u0001\\1oO*\u0011\u0011QN\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002T\u0005\u001d\u0014\u0001\t)S\u000bZKu*V*`-\u0016\u00136+S(O?B\u000b%+Q'F)\u0016\u0013vLT!N\u000b\u0002\nQb\u0015+N)~cujQ&`\u0015>\u0013\u0015AD*U\u001bR{FjT\"L?*{%\tI\u0001\u0017kB$\u0017\r^3XSRDg+\u001a:tS>t7\t[3dWR!\u00111PAA!\r9\u0014QP\u0005\u0004\u0003\u007fB$\u0001B+oSRDq!!\f\u0012\u0001\u0004\t\u0019\u0003K\u0002\u0012\u0003o\t\u0011e\u0015+N)~3\u0015J\u0014#`)\u0006\u001b6jX%E'~\u0013\u0015l\u0018*F\u0019\u0016\u000b5+R0V\u0013\u0012\u000b!e\u0015+N)~3\u0015J\u0014#`)\u0006\u001b6jX%E'~\u0013\u0015l\u0018*F\u0019\u0016\u000b5+R0V\u0013\u0012\u0003\u0013AG*U\u001bR{6iT+O)~{ej\u0018+B'.{\u0016\nR0I\u0003NC\u0015aG*U\u001bR{6iT+O)~{ej\u0018+B'.{\u0016\nR0I\u0003NC\u0005%A\u000fgS:$\u0017+^3vK\u0012$\u0016m]6JIN\u0014\u0015PU3mK\u0006\u001cX-V5e)\u0011\t\t*a)\u0011\r\u0005M\u0015QTA$\u001d\u0011\t)*!'\u000f\u0007E\f9*C\u0001:\u0013\r\tY\nO\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ty*!)\u0003\u0007M+\u0017OC\u0002\u0002\u001cbBq!!*\u0017\u0001\u0004\t9+\u0001\u0006sK2,\u0017m]3VS\u0012\u0004B!!\u001a\u0002*&!\u00111VA4\u0005\u001dIe\u000e^3hKJD3AFAX!\u0011\tI$!-\n\t\u0005M\u00161\b\u0002\u000b\u0013N\u0014V-\u00193P]2L\u0018aF*U\u001bR{f)\u0013(E?Z+%kU%P\u001d~\u0013\u0015lX%E\u0003a\u0019F+\u0014+`\r&sEi\u0018,F%NKuJT0C3~KE\tI\u0001\u0010M&tGMV3sg&|gNQ=JIR!\u0011QXAb!\u00159\u0014qXAT\u0013\r\t\t\r\u000f\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f\u0005\u0015\u0017\u00041\u0001\u0002H\u0006\u0011\u0011\u000e\u001a\t\u0004o\u0005%\u0017bAAfq\t!Aj\u001c8h\u00039I7\u000fV1tW&#W\t_5tiN$B!!5\u0002XB\u0019q'a5\n\u0007\u0005U\u0007HA\u0004C_>dW-\u00198\t\u000f\u0005e'\u00041\u0001\u0002H\u00051A/Y:l\u0013\u0012D3AGAX\u0003\u001d1\u0017N\u001c3BY2$b!!9\u0002r\n\u0005\u0001CBAr\u0003[\f\u0019#\u0004\u0002\u0002f*!\u0011q]Au\u0003\u0019!w.\\1j]*\u0019\u00111^1\u0002\t\u0011\fG/Y\u0005\u0005\u0003_\f)O\u0001\u0003QC\u001e,\u0007bBAz7\u0001\u0007\u0011Q_\u0001\u000bU>\u0014g)\u001b7uKJ\u001c\b\u0003BA|\u0003{l!!!?\u000b\u0007\u0005mH&A\u0004gS2$XM]:\n\t\u0005}\u0018\u0011 \u0002\u000b\u0015>\u0014g)\u001b7uKJ\u001c\bb\u0002B\u00027\u0001\u0007!QA\u0001\ta\u0006<W-\u00192mKB!\u00111\u001dB\u0004\u0013\u0011\u0011I!!:\u0003\u0011A\u000bw-Z1cY\u0016D3aGAX\u0003I1\u0017N\u001c3BY2TuNY(wKJ4\u0018.Z<\u0015\r\tE!\u0011\u0004B\u000e!\u0019\t\u0019/!<\u0003\u0014A!\u0011Q\u0005B\u000b\u0013\r\u00119\u0002\f\u0002\f\u0015>\u0014wJ^3sm&,w\u000fC\u0004\u0002tr\u0001\r!!>\t\u000f\t\rA\u00041\u0001\u0003\u0006!\u001aA$a,\u00027M#V\nV0G\u0013:#u\fR%T)&s5\tV0O\u001f\u0012+u,\u0013#T\u0003q\u0019F+\u0014+`\r&sEi\u0018#J'RKej\u0011+`\u001d>#UiX%E'\u0002\n1CZ5oI\u0012K7\u000f^5oGRtu\u000eZ3JIN$\"Aa\n\u0011\r\u0005%#\u0011FA$\u0013\u0011\u0011Y#!\u0016\u0003\u0007M+G\u000fK\u0002 \u0003_\u000bqb\u0015+N)~#U\tT#U\u000b~SuJQ\u0001\u0011'RkEk\u0018#F\u0019\u0016#Vi\u0018&P\u0005\u0002\n1d\u0015+N)~#U\tT#U\u000b~\u0013\u0015l\u0018+B'.{\u0016\nR0I\u0003NC\u0015\u0001H*U\u001bR{F)\u0012'F)\u0016{&)W0U\u0003N[u,\u0013#`\u0011\u0006\u001b\u0006\nI\u0001-'RkEk\u0018#F\u0019\u0016#Vi\u0018\"Z?R\u000b5kS0J\t~C\u0015i\u0015%`\u0003:#u,\u0012-F\u0007V#\u0016j\u0014(`\u0013\u0012\u000bQf\u0015+N)~#U\tT#U\u000b~\u0013\u0015l\u0018+B'.{\u0016\nR0I\u0003NCu,\u0011(E?\u0016CViQ+U\u0013>su,\u0013#!\u0003\u0019!W\r\\3uKR!\u00111\u0010B \u0011\u001d\u0011\tE\na\u0001\u0005\u0007\n\u0011\u0002Z3mKR,'j\u001c2\u0011\u0007u\u0012)%C\u0002\u0003Hy\u0012\u0011\u0002R3mKR,'j\u001c2)\u0007\u0019\n9$\u0001\u0004va\u0012\fG/\u001a\u000b\u0005\u0005\u001f\u0012\t\u0006E\u00038\u0003\u007f\u000b\u0019\u0003C\u0004\u0003T\u001d\u0002\rA!\u0016\u0002\u0013U\u0004H-\u0019;f\u0015>\u0014\u0007cA\u001f\u0003X%\u0019!\u0011\f \u0003\u0013U\u0003H-\u0019;f\u0015>\u0014\u0007fA\u0014\u00028\u00051\u0002.\u00198eY\u0016|\u0005\u000f^5nSN$\u0018nY+qI\u0006$X\r\u0006\u0004\u0003b\t5$q\u000e\t\bo\t\r$qMA>\u0013\r\u0011)\u0007\u000f\u0002\u0010!\u0006\u0014H/[1m\rVt7\r^5p]B\u0019qG!\u001b\n\u0007\t-\u0004HA\u0002J]RDq!!\f)\u0001\u0004\t\u0019\u0003C\u0004\u0003r!\u0002\rAa\u001d\u0002\u001b1|wMU3d_Z,'/\u001f$o!\u00159\u0014q\u0018B;!\u00159$qOA$\u0013\r\u0011I\b\u000f\u0002\n\rVt7\r^5p]B\u0002")
public class SqlJobRepository
implements JobRepository,
PersistenceSupport,
JobRowMapper,
Logging {
    private final JdbcTemplate jdbcTemplate;
    private final SqlBuilder.Dialect dialect;
    private final TaskRepository taskRepository;
    private final String STMT_INSERT_JOB;
    private final String PREVIOUS_VERSION_PARAMETER_NAME;
    private final String STMT_LOCK_JOB;
    private final String STMT_FIND_TASK_IDS_BY_RELEASE_UID;
    private final String STMT_COUNT_ON_TASK_ID_HASH;
    private final String STMT_FIND_VERSION_BY_ID;
    private final String STMT_FIND_DISTINCT_NODE_IDS;
    private final String STMT_DELETE_JOB;
    private final String STMT_DELETE_BY_TASK_ID_HASH;
    private final String STMT_DELETE_BY_TASK_ID_HASH_AND_EXECUTION_ID;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private NamedParameterJdbcTemplate namedTemplate;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public RowMapper<JobRow> jobMapper() {
        return JobRowMapper.jobMapper$(this);
    }

    @Override
    public MapSqlParameterSource paramMap2MapSqlParameterSource(Map<String, Object> params) {
        return PersistenceSupport.paramMap2MapSqlParameterSource$(this, params);
    }

    @Override
    public Integer sqlInsert(String pkColumn, String sqlStatement, Map<String, Object> params) {
        return PersistenceSupport.sqlInsert$(this, pkColumn, sqlStatement, params);
    }

    @Override
    public <R> R sqlInsert(String pkColumn, String sqlStatement, Map<String, Object> params, Function1<Integer, R> mapper) {
        return (R)PersistenceSupport.sqlInsert$((PersistenceSupport)this, pkColumn, sqlStatement, params, mapper);
    }

    @Override
    public <R> R sqlInsert(String pkColumn, String sqlStatement, MapSqlParameterSource params, Function1<Integer, R> mapper) {
        return (R)PersistenceSupport.sqlInsert$((PersistenceSupport)this, pkColumn, sqlStatement, params, mapper);
    }

    @Override
    public void sqlInsert(String sqlStatement, MapSqlParameterSource params) {
        PersistenceSupport.sqlInsert$(this, sqlStatement, params);
    }

    @Override
    public <R> R sqlExec(String sqlStatement, Map<String, Object> params, PreparedStatementCallback<R> callback) {
        return (R)PersistenceSupport.sqlExec$(this, sqlStatement, params, callback);
    }

    @Override
    public <R> R sqlExecWithContent(String sqlStatement, Map<String, Object> params, Tuple2<String, String> contentParam, Function1<Object, R> mapper) {
        return (R)PersistenceSupport.sqlExecWithContent$(this, sqlStatement, params, contentParam, mapper);
    }

    @Override
    public <R> R sqlInsertWithContent(String pkColumn, String sqlStatement, Map<String, Object> params, Tuple2<String, String> contentParam, Function1<Integer, R> mapper) {
        return (R)PersistenceSupport.sqlInsertWithContent$(this, pkColumn, sqlStatement, params, contentParam, mapper);
    }

    @Override
    public <R> R sqlUpdate(String sqlStatement, MapSqlParameterSource params, Function1<Object, R> mapper) {
        return (R)PersistenceSupport.sqlUpdate$(this, sqlStatement, params, mapper);
    }

    @Override
    public <R> R sqlSet(String sqlStatement, Function1<PreparedStatement, PreparedStatement> setup, Function1<Object, R> callback) {
        return (R)PersistenceSupport.sqlSet$(this, sqlStatement, setup, callback);
    }

    @Override
    public Function1<Object, BoxedUnit> checkCiUpdated(String entityId) {
        return PersistenceSupport.checkCiUpdated$(this, entityId);
    }

    @Override
    public Function1<Object, UUID> checkCiUpdated(Integer uid, Option<UUID> token, UUID freshToken) {
        return PersistenceSupport.checkCiUpdated$(this, uid, token, freshToken);
    }

    @Override
    public Function1<Object, BoxedUnit> checkCiDeleted(Integer uid) {
        return PersistenceSupport.checkCiDeleted$(this, uid);
    }

    @Override
    public <R> Buffer<R> sqlQuery(String sqlStatement, Map<String, Object> params, RowMapper<R> mapper) {
        return PersistenceSupport.sqlQuery$((PersistenceSupport)this, sqlStatement, params, mapper);
    }

    @Override
    public <R> Buffer<R> sqlQuery(String sqlStatement, Map<String, Object> params, Function1<ResultSet, R> mapper) {
        return PersistenceSupport.sqlQuery$((PersistenceSupport)this, sqlStatement, params, mapper);
    }

    @Override
    public <R> R sqlQuery(String sqlStatement, Map<String, Object> params, ResultSetExtractor<R> extractor) {
        return (R)PersistenceSupport.sqlQuery$((PersistenceSupport)this, sqlStatement, params, extractor);
    }

    @Override
    public Seq<Object> sqlBatch(String sqlStatement, Set<Map<String, Object>> parameters) {
        return PersistenceSupport.sqlBatch$(this, sqlStatement, parameters);
    }

    @Override
    public Seq<Object> sqlBatchWithContent(String sqlStatement, Seq<Tuple2<Map<String, Object>, Tuple2<String, String>>> params) {
        return PersistenceSupport.sqlBatchWithContent$(this, sqlStatement, params);
    }

    @Override
    public String pkName(String pkColumn) {
        return PersistenceSupport.pkName$(this, pkColumn);
    }

    @Override
    public MapSqlParameterSource paramSource(Seq<Tuple2<String, Object>> pairs) {
        return PersistenceSupport.paramSource$(this, pairs);
    }

    @Override
    public byte[] compress(String text) {
        return CompressionSupport.compress$((CompressionSupport)this, text);
    }

    @Override
    public String decompress(InputStream inputStream) {
        return CompressionSupport.decompress$((CompressionSupport)this, inputStream);
    }

    @Override
    public byte[] compress(byte[] byteArray) {
        return CompressionSupport.compress$((CompressionSupport)this, byteArray);
    }

    @Override
    public byte[] decompress(byte[] byteArray) {
        return CompressionSupport.decompress$((CompressionSupport)this, byteArray);
    }

    @Override
    public <A> Option<A> findOptional(Function1<JdbcTemplate, A> body, JdbcTemplate jdbcTemplate) {
        return Utils.findOptional$(this, body, jdbcTemplate);
    }

    @Override
    public <A> Option<A> findOne(Function0<Buffer<A>> body) {
        return Utils.findOne$(this, body);
    }

    @Override
    public <A> Seq<A> findMany(Function0<Buffer<A>> body) {
        return Utils.findMany$(this, body);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlJobRepository sqlJobRepository = this;
        synchronized (sqlJobRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    private NamedParameterJdbcTemplate namedTemplate$lzycompute() {
        SqlJobRepository sqlJobRepository = this;
        synchronized (sqlJobRepository) {
            if (!this.bitmap$0) {
                this.namedTemplate = PersistenceSupport.namedTemplate$(this);
                this.bitmap$0 = true;
            }
        }
        return this.namedTemplate;
    }

    @Override
    public NamedParameterJdbcTemplate namedTemplate() {
        if (!this.bitmap$0) {
            return this.namedTemplate$lzycompute();
        }
        return this.namedTemplate;
    }

    @Override
    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    @Override
    public SqlBuilder.Dialect dialect() {
        return this.dialect;
    }

    @Override
    public TaskRepository taskRepository() {
        return this.taskRepository;
    }

    public JobRow create(JobRow job) {
        JobRow jobRow;
        block3: {
            this.logger().trace((Function0 & Serializable)() -> new StringBuilder(13).append("creating job ").append(job).toString());
            try {
                if (SqlConfiguration$.MODULE$.isPostgresDB(this.dialect()) && this.isTaskIdExists(job.taskId())) {
                    jobRow = this.replace(job);
                    break block3;
                }
                jobRow = this.createTaskJob(job);
            }
            catch (Exception exception) {
                jobRow = this.replace(job);
            }
        }
        return jobRow;
    }

    @IsTransactional
    public JobRow replace(JobRow job) {
        this.logger().trace((Function0 & Serializable)() -> new StringBuilder(14).append("replacing job ").append(job).toString());
        this.delete((DeleteJob)new DeleteByTaskId(job.taskId()));
        return this.createTaskJob(job);
    }

    private String STMT_INSERT_JOB() {
        return this.STMT_INSERT_JOB;
    }

    private JobRow createTaskJob(JobRow job) {
        Map params = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TASK_JOBS$.MODULE$.TASK_ID()), (Object)job.taskId()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TASK_JOBS$.MODULE$.TASK_ID_HASH()), (Object)TaskPersistence$.MODULE$.hash(job.taskId())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TASK_JOBS$.MODULE$.RELEASE_UID()), (Object)job.releaseUid()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TASK_JOBS$.MODULE$.JOB_TYPE()), (Object)job.jobType().name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TASK_JOBS$.MODULE$.STATUS()), (Object)job.status().name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TASK_JOBS$.MODULE$.VERSION()), (Object)BoxesRunTime.boxToLong((long)job.version())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TASK_JOBS$.MODULE$.SUBMIT_TIME()), (Object)Timestamp.from(job.submitTime())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TASK_JOBS$.MODULE$.SCHEDULED_START_TIME()), (Object)Timestamp.from(job.scheduledStartTime())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TASK_JOBS$.MODULE$.EXECUTION_ID()), (Object)job.executionId()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TASK_JOBS$.MODULE$.NODE()), (Object)job.node())}));
        GeneratedKeyHolder holder = new GeneratedKeyHolder();
        this.namedTemplate().update(this.STMT_INSERT_JOB(), (SqlParameterSource)this.paramMap2MapSqlParameterSource((Map<String, Object>)params), (KeyHolder)holder, (String[])((Object[])new String[]{this.pkName(Schema.TASK_JOBS$.MODULE$.ID())}));
        return job.copy(holder.getKey().longValue(), job.copy$default$2(), job.copy$default$3(), job.copy$default$4(), job.copy$default$5(), job.copy$default$6(), job.copy$default$7(), job.copy$default$8(), job.copy$default$9(), job.copy$default$10(), job.copy$default$11());
    }

    private String PREVIOUS_VERSION_PARAMETER_NAME() {
        return this.PREVIOUS_VERSION_PARAMETER_NAME;
    }

    private String STMT_LOCK_JOB() {
        return this.STMT_LOCK_JOB;
    }

    @IsTransactional
    public void updateWithVersionCheck(JobRow job) {
        this.logger().trace((Function0 & Serializable)() -> new StringBuilder(38).append("going to update with version check to ").append(job).toString());
        long previousVersion = job.version() - 1L;
        Map params = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TASK_JOBS$.MODULE$.STATUS()), (Object)job.status().name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TASK_JOBS$.MODULE$.VERSION()), (Object)BoxesRunTime.boxToLong((long)job.version())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TASK_JOBS$.MODULE$.NODE()), (Object)job.node()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TASK_JOBS$.MODULE$.START_TIME()), Option$.MODULE$.apply((Object)job.startTime()).map((Function1 & Serializable)x$1 -> Timestamp.from(x$1)).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TASK_JOBS$.MODULE$.ID()), (Object)BoxesRunTime.boxToLong((long)job.id())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.PREVIOUS_VERSION_PARAMETER_NAME()), (Object)BoxesRunTime.boxToLong((long)previousVersion))}));
        this.sqlUpdate(this.STMT_LOCK_JOB(), this.paramMap2MapSqlParameterSource((Map<String, Object>)params), (Function1)this.handleOptimisticUpdate(job, (Option<Function0<String>>)new Some((Function0 & Serializable)() -> (String)this.findVersionById(job.id()).map((Function1 & Serializable)version -> new StringBuilder(19).append("current version is ").append(version).toString()).getOrElse((Function0 & Serializable)() -> "record not found"))));
    }

    private String STMT_FIND_TASK_IDS_BY_RELEASE_UID() {
        return this.STMT_FIND_TASK_IDS_BY_RELEASE_UID;
    }

    private String STMT_COUNT_ON_TASK_ID_HASH() {
        return this.STMT_COUNT_ON_TASK_ID_HASH;
    }

    @IsReadOnly
    public Seq<String> findQueuedTaskIdsByReleaseUid(Integer releaseUid) {
        return this.findMany((Function0 & Serializable)() -> this.sqlQuery(this.STMT_FIND_TASK_IDS_BY_RELEASE_UID(), Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TASK_JOBS$.MODULE$.RELEASE_UID()), (Object)releaseUid), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TASK_JOBS$.MODULE$.STATUS()), (Object)JobStatus.QUEUED.name())})), (Function1 & Serializable)rs -> rs.getString(Schema.TASK_JOBS$.MODULE$.TASK_ID())));
    }

    private String STMT_FIND_VERSION_BY_ID() {
        return this.STMT_FIND_VERSION_BY_ID;
    }

    private Option<Integer> findVersionById(long id) {
        return this.findOne((Function0 & Serializable)() -> this.sqlQuery(this.STMT_FIND_VERSION_BY_ID(), Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TASK_JOBS$.MODULE$.ID()), (Object)BoxesRunTime.boxToLong((long)id))})), (Function1 & Serializable)rs -> BoxesRunTime.boxToInteger((int)rs.getInt(Schema.TASK_JOBS$.MODULE$.VERSION()))));
    }

    @IsReadOnly
    private boolean isTaskIdExists(String taskId) {
        return BoxesRunTime.unboxToInt((Object)this.findOne((Function0 & Serializable)() -> this.sqlQuery(this.STMT_COUNT_ON_TASK_ID_HASH(), Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TASK_JOBS$.MODULE$.TASK_ID_HASH()), (Object)TaskPersistence$.MODULE$.hash(taskId))})), (Function1 & Serializable)rs -> BoxesRunTime.boxToInteger((int)rs.getInt(1)))).get()) > 0;
    }

    @IsReadOnly
    public Page<JobRow> findAll(JobFilters jobFilters, Pageable pageable) {
        return SqlJobFiltersQueryBuilder$.MODULE$.apply(this.dialect(), this.namedTemplate(), this.taskRepository()).from(jobFilters).withPageable(pageable).build().execute();
    }

    @IsReadOnly
    public Page<JobOverview> findAllJobOverview(JobFilters jobFilters, Pageable pageable) {
        return SqlJobOverviewQueryBuilder$.MODULE$.apply(this.dialect(), this.namedTemplate(), this.taskRepository()).from(jobFilters).withPageable(pageable).build().execute();
    }

    private String STMT_FIND_DISTINCT_NODE_IDS() {
        return this.STMT_FIND_DISTINCT_NODE_IDS;
    }

    @IsReadOnly
    public Set<String> findDistinctNodeIds() {
        return this.findMany((Function0 & Serializable)() -> this.sqlQuery(this.STMT_FIND_DISTINCT_NODE_IDS(), Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)Nil$.MODULE$), (Function1 & Serializable)rs -> rs.getString(Schema.TASK_JOBS$.MODULE$.NODE()))).toSet();
    }

    private String STMT_DELETE_JOB() {
        return this.STMT_DELETE_JOB;
    }

    private String STMT_DELETE_BY_TASK_ID_HASH() {
        return this.STMT_DELETE_BY_TASK_ID_HASH;
    }

    private String STMT_DELETE_BY_TASK_ID_HASH_AND_EXECUTION_ID() {
        return this.STMT_DELETE_BY_TASK_ID_HASH_AND_EXECUTION_ID;
    }

    @IsTransactional
    public void delete(DeleteJob deleteJob) {
        DeleteJob deleteJob2 = deleteJob;
        if (deleteJob2 instanceof DeleteById) {
            DeleteById deleteById = (DeleteById)deleteJob2;
            long id = deleteById.id();
            this.logger().trace((Function0 & Serializable)() -> new StringBuilder(24).append("deleting job with jobId ").append(id).toString());
            int deletedRows = BoxesRunTime.unboxToInt(this.sqlUpdate(this.STMT_DELETE_JOB(), this.paramMap2MapSqlParameterSource(Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TASK_JOBS$.MODULE$.ID()), (Object)BoxesRunTime.boxToLong((long)id))}))), (Function1)(JFunction1.mcII.sp & Serializable)rows -> rows));
            if (deletedRows != 1) {
                this.logger().trace((Function0 & Serializable)() -> new StringBuilder(58).append(deletedRows).append(" rows deleted when trying to delete scheduled job with id ").append(id).toString());
                return;
            }
            return;
        }
        if (deleteJob2 instanceof DeleteByTaskId) {
            DeleteByTaskId deleteByTaskId = (DeleteByTaskId)deleteJob2;
            String taskId = deleteByTaskId.taskId();
            this.logger().trace((Function0 & Serializable)() -> new StringBuilder(25).append("deleting job with taskId ").append(taskId).toString());
            this.sqlExec(this.STMT_DELETE_BY_TASK_ID_HASH(), Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TASK_JOBS$.MODULE$.TASK_ID_HASH()), (Object)TaskPersistence$.MODULE$.hash(taskId))})), x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.execute()));
            return;
        }
        if (deleteJob2 instanceof DeleteByTaskIdAndExecutionId) {
            DeleteByTaskIdAndExecutionId deleteByTaskIdAndExecutionId = (DeleteByTaskIdAndExecutionId)deleteJob2;
            String taskId = deleteByTaskIdAndExecutionId.taskId();
            String executionId = deleteByTaskIdAndExecutionId.executionId();
            this.logger().trace((Function0 & Serializable)() -> new StringBuilder(42).append("deleting job with taskId ").append(taskId).append(" and executionId ").append(executionId).toString());
            this.sqlExec(this.STMT_DELETE_BY_TASK_ID_HASH_AND_EXECUTION_ID(), Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TASK_JOBS$.MODULE$.TASK_ID_HASH()), (Object)TaskPersistence$.MODULE$.hash(taskId)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Schema.TASK_JOBS$.MODULE$.EXECUTION_ID()), (Object)executionId)})), x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.execute()));
            return;
        }
        throw new UnsupportedOperationException(new StringBuilder(27).append(deleteJob).append(" operation is not supported").toString());
    }

    @IsTransactional
    public Option<JobRow> update(UpdateJob updateJob) {
        JobRow jobRow;
        UpdateJob updateJob2 = updateJob;
        if (updateJob2 instanceof UpdateNode) {
            UpdateNode updateNode = (UpdateNode)updateJob2;
            JobRow job = updateNode.job();
            String nodeId = updateNode.nodeId();
            this.logger().trace((Function0 & Serializable)() -> new StringBuilder(22).append("changing job ").append(job).append(" node to ").append(nodeId).toString());
            long x$1 = job.version() + 1L;
            String x$2 = nodeId;
            long x$32 = job.copy$default$1();
            JobType x$4 = job.copy$default$3();
            JobStatus x$5 = job.copy$default$4();
            Instant x$6 = job.copy$default$6();
            Instant x$7 = job.copy$default$7();
            Instant x$8 = job.copy$default$8();
            String x$9 = job.copy$default$9();
            Integer x$10 = job.copy$default$10();
            String x$11 = job.copy$default$11();
            jobRow = job.copy(x$32, x$2, x$4, x$5, x$1, x$6, x$7, x$8, x$9, x$10, x$11);
        } else if (updateJob2 instanceof UpdateJobStatus) {
            UpdateJobStatus updateJobStatus = (UpdateJobStatus)updateJob2;
            JobRow job = updateJobStatus.job();
            JobStatus jobStatus = updateJobStatus.status();
            this.logger().trace((Function0 & Serializable)() -> new StringBuilder(27).append("changing status of job ").append(job).append(" to ").append(jobStatus).toString());
            long x$12 = job.version() + 1L;
            JobStatus x$13 = jobStatus;
            long x$14 = job.copy$default$1();
            String x$15 = job.copy$default$2();
            JobType x$16 = job.copy$default$3();
            Instant x$17 = job.copy$default$6();
            Instant x$18 = job.copy$default$7();
            Instant x$19 = job.copy$default$8();
            String x$20 = job.copy$default$9();
            Integer x$21 = job.copy$default$10();
            String x$22 = job.copy$default$11();
            jobRow = job.copy(x$14, x$15, x$16, x$13, x$12, x$17, x$18, x$19, x$20, x$21, x$22);
        } else if (updateJob2 instanceof UpdateNodeAndStatus) {
            UpdateNodeAndStatus updateNodeAndStatus = (UpdateNodeAndStatus)updateJob2;
            JobRow job = updateNodeAndStatus.job();
            String nodeId = updateNodeAndStatus.nodeId();
            JobStatus jobStatus = updateNodeAndStatus.status();
            this.logger().trace((Function0 & Serializable)() -> new StringBuilder(37).append("changing job ").append(job).append(" node to ").append(nodeId).append(" and status to ").append(jobStatus).toString());
            long x$23 = job.version() + 1L;
            String x$24 = nodeId;
            JobStatus x$25 = jobStatus;
            long x$26 = job.copy$default$1();
            JobType x$27 = job.copy$default$3();
            Instant x$28 = job.copy$default$6();
            Instant x$29 = job.copy$default$7();
            Instant x$30 = job.copy$default$8();
            String x$31 = job.copy$default$9();
            Integer x$32 = job.copy$default$10();
            String x$33 = job.copy$default$11();
            jobRow = job.copy(x$26, x$24, x$27, x$25, x$23, x$28, x$29, x$30, x$31, x$32, x$33);
        } else {
            throw new UnsupportedOperationException(new StringBuilder(27).append(updateJob).append(" operation is not supported").toString());
        }
        JobRow newJobRow = jobRow;
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.updateWithVersionCheck(newJobRow)).map((Function1 & Serializable)x$3 -> newJobRow).toOption();
    }

    private PartialFunction<Object, BoxedUnit> handleOptimisticUpdate(JobRow job, Option<Function0<String>> logRecoveryFn) {
        return new Serializable(this, job, logRecoveryFn){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ SqlJobRepository $outer;
            private final JobRow job$7;
            private final Option logRecoveryFn$1;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                switch (A1) {
                    case 0: {
                        String msg = new StringBuilder(38).append("Unable to update Job row ").append(this.job$7).append(" of version ").append(this.job$7.version()).append(" ").append(this.logRecoveryFn$1.map((Function1 & Serializable)fn -> new StringBuilder(2).append(", ").append(fn.apply()).toString()).getOrElse((Function0 & Serializable)() -> "")).toString();
                        this.$outer.logger().trace((Function0 & Serializable)() -> msg);
                        throw new OptimisticLockingFailureException(msg);
                    }
                    case 1: {
                        this.$outer.logger().trace((Function0 & Serializable)() -> new StringBuilder(28).append("Successfully updated job to ").append($this.job$7).toString());
                        return (B1)BoxedUnit.UNIT;
                    }
                }
                String msg = new StringBuilder(47).append("More than one row updated for job ").append(this.job$7.id()).append(" of version ").append(this.job$7.version()).append(" ").append(this.logRecoveryFn$1.map((Function1 & Serializable)fn -> new StringBuilder(2).append(", ").append(fn.apply()).toString()).getOrElse((Function0 & Serializable)() -> "")).toString();
                this.$outer.logger().trace((Function0 & Serializable)() -> msg);
                throw new IllegalStateException(msg);
            }

            public final boolean isDefinedAt(int x1) {
                int n = x1;
                switch (n) {
                    case 0: {
                        return true;
                    }
                    case 1: {
                        return true;
                    }
                }
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.job$7 = job$7;
                this.logRecoveryFn$1 = logRecoveryFn$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(scala.Function0 ), $anonfun$applyOrElse$2(), $anonfun$applyOrElse$3(java.lang.String ), $anonfun$applyOrElse$4(com.xebialabs.xlrelease.scheduler.sql.SqlJobRepository$$anonfun$handleOptimisticUpdate$1 ), $anonfun$applyOrElse$5(scala.Function0 ), $anonfun$applyOrElse$6(), $anonfun$applyOrElse$7(java.lang.String )}, serializedLambda);
            }
        };
    }

    public SqlJobRepository(JdbcTemplate jdbcTemplate, SqlBuilder.Dialect dialect, TaskRepository taskRepository) {
        this.jdbcTemplate = jdbcTemplate;
        this.dialect = dialect;
        this.taskRepository = taskRepository;
        Utils.$init$(this);
        CompressionSupport.$init$(this);
        PersistenceSupport.$init$(this);
        JobRowMapper.$init$(this);
        Logging.$init$((Logging)this);
        this.STMT_INSERT_JOB = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(302).append("INSERT INTO ").append(Schema.TASK_JOBS$.MODULE$.TABLE()).append(" (\n       |   ").append(Schema.TASK_JOBS$.MODULE$.TASK_ID()).append(",\n       |   ").append(Schema.TASK_JOBS$.MODULE$.TASK_ID_HASH()).append(",\n       |   ").append(Schema.TASK_JOBS$.MODULE$.RELEASE_UID()).append(",\n       |   ").append(Schema.TASK_JOBS$.MODULE$.JOB_TYPE()).append(",\n       |   ").append(Schema.TASK_JOBS$.MODULE$.STATUS()).append(",\n       |   ").append(Schema.TASK_JOBS$.MODULE$.VERSION()).append(",\n       |   ").append(Schema.TASK_JOBS$.MODULE$.SUBMIT_TIME()).append(",\n       |   ").append(Schema.TASK_JOBS$.MODULE$.SCHEDULED_START_TIME()).append(",\n       |   ").append(Schema.TASK_JOBS$.MODULE$.EXECUTION_ID()).append(",\n       |   ").append(Schema.TASK_JOBS$.MODULE$.NODE()).append("\n       | ) VALUES (\n       | :").append(Schema.TASK_JOBS$.MODULE$.TASK_ID()).append(",\n       | :").append(Schema.TASK_JOBS$.MODULE$.TASK_ID_HASH()).append(",\n       | :").append(Schema.TASK_JOBS$.MODULE$.RELEASE_UID()).append(",\n       | :").append(Schema.TASK_JOBS$.MODULE$.JOB_TYPE()).append(",\n       | :").append(Schema.TASK_JOBS$.MODULE$.STATUS()).append(",\n       | :").append(Schema.TASK_JOBS$.MODULE$.VERSION()).append(",\n       | :").append(Schema.TASK_JOBS$.MODULE$.SUBMIT_TIME()).append(",\n       | :").append(Schema.TASK_JOBS$.MODULE$.SCHEDULED_START_TIME()).append(",\n       | :").append(Schema.TASK_JOBS$.MODULE$.EXECUTION_ID()).append(",\n       | :").append(Schema.TASK_JOBS$.MODULE$.NODE()).append("\n       | )\n       |").toString()));
        this.PREVIOUS_VERSION_PARAMETER_NAME = "PREVIOUS_VERSION";
        this.STMT_LOCK_JOB = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(125).append("UPDATE ").append(Schema.TASK_JOBS$.MODULE$.TABLE()).append("\n       | SET\n       |   ").append(Schema.TASK_JOBS$.MODULE$.STATUS()).append(" = :").append(Schema.TASK_JOBS$.MODULE$.STATUS()).append(",\n       |   ").append(Schema.TASK_JOBS$.MODULE$.VERSION()).append(" = :").append(Schema.TASK_JOBS$.MODULE$.VERSION()).append(",\n       |   ").append(Schema.TASK_JOBS$.MODULE$.NODE()).append(" = :").append(Schema.TASK_JOBS$.MODULE$.NODE()).append(",\n       |   ").append(Schema.TASK_JOBS$.MODULE$.START_TIME()).append(" = :").append(Schema.TASK_JOBS$.MODULE$.START_TIME()).append("\n       | WHERE ").append(Schema.TASK_JOBS$.MODULE$.ID()).append(" = :").append(Schema.TASK_JOBS$.MODULE$.ID()).append(" AND ").append(Schema.TASK_JOBS$.MODULE$.VERSION()).append(" = :").append(this.PREVIOUS_VERSION_PARAMETER_NAME()).append("\n       |").toString()));
        this.STMT_FIND_TASK_IDS_BY_RELEASE_UID = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(94).append("\n       |SELECT\n       | ").append(Schema.TASK_JOBS$.MODULE$.TASK_ID()).append("\n       |FROM ").append(Schema.TASK_JOBS$.MODULE$.TABLE()).append("\n       |WHERE\n       | ").append(Schema.TASK_JOBS$.MODULE$.RELEASE_UID()).append(" = :").append(Schema.TASK_JOBS$.MODULE$.RELEASE_UID()).append(" AND\n       | ").append(Schema.TASK_JOBS$.MODULE$.STATUS()).append(" = :").append(Schema.TASK_JOBS$.MODULE$.STATUS()).append("\n       |").toString()));
        this.STMT_COUNT_ON_TASK_ID_HASH = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(83).append("\n       |SELECT\n       | count(").append(Schema.TASK_JOBS$.MODULE$.TASK_ID_HASH()).append(")\n       |FROM ").append(Schema.TASK_JOBS$.MODULE$.TABLE()).append("\n       |WHERE\n       | ").append(Schema.TASK_JOBS$.MODULE$.TASK_ID_HASH()).append(" = :").append(Schema.TASK_JOBS$.MODULE$.TASK_ID_HASH()).append("\n       |").toString()));
        this.STMT_FIND_VERSION_BY_ID = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(76).append("\n       |SELECT\n       | ").append(Schema.TASK_JOBS$.MODULE$.VERSION()).append("\n       |FROM ").append(Schema.TASK_JOBS$.MODULE$.TABLE()).append("\n       |WHERE\n       | ").append(Schema.TASK_JOBS$.MODULE$.ID()).append(" = :").append(Schema.TASK_JOBS$.MODULE$.ID()).append("\n       |").toString()));
        this.STMT_FIND_DISTINCT_NODE_IDS = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(57).append("\n       |SELECT DISTINCT\n       | ").append(Schema.TASK_JOBS$.MODULE$.NODE()).append("\n       |FROM ").append(Schema.TASK_JOBS$.MODULE$.TABLE()).append("\n       |").toString()));
        this.STMT_DELETE_JOB = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(41).append("DELETE FROM ").append(Schema.TASK_JOBS$.MODULE$.TABLE()).append("\n       | WHERE ").append(Schema.TASK_JOBS$.MODULE$.ID()).append(" = :").append(Schema.TASK_JOBS$.MODULE$.ID()).append("\n       |").toString()));
        this.STMT_DELETE_BY_TASK_ID_HASH = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(41).append("DELETE FROM ").append(Schema.TASK_JOBS$.MODULE$.TABLE()).append("\n       | WHERE ").append(Schema.TASK_JOBS$.MODULE$.TASK_ID_HASH()).append(" = :").append(Schema.TASK_JOBS$.MODULE$.TASK_ID_HASH()).append("\n       |").toString()));
        this.STMT_DELETE_BY_TASK_ID_HASH_AND_EXECUTION_ID = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(59).append("DELETE FROM ").append(Schema.TASK_JOBS$.MODULE$.TABLE()).append("\n       | WHERE ").append(Schema.TASK_JOBS$.MODULE$.TASK_ID_HASH()).append(" = :").append(Schema.TASK_JOBS$.MODULE$.TASK_ID_HASH()).append("\n       | AND ").append(Schema.TASK_JOBS$.MODULE$.EXECUTION_ID()).append(" = :").append(Schema.TASK_JOBS$.MODULE$.EXECUTION_ID()).append("\n       |").toString()));
    }
}

