/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Comment;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.repository.CommentRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.sql.DeserializationSupport;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.CommentPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.CommentPersistence$;
import com.xebialabs.xlrelease.repository.sql.persistence.CommentPersistence$CommentRow$;
import com.xebialabs.xlrelease.repository.sql.persistence.CommentPersistence$CommentRowOps$;
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.ReleaseRow;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.joda.time.DateTime;
import org.slf4j.Marker;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\t=a\u0001\u0002\u000b\u0016\u0001\u0001B\u0001b\u000e\u0001\u0003\u0006\u0004%\t\u0001\u000f\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005s!A\u0001\t\u0001BC\u0002\u0013\u0005\u0011\t\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003C\u0011!1\u0005A!b\u0001\n\u00039\u0005\u0002C&\u0001\u0005\u0003\u0005\u000b\u0011\u0002%\t\u000b1\u0003A\u0011A'\t\u000bI\u0003A\u0011I*\t\u000bi\u0004A\u0011I>\t\u000f\u0005-\u0001\u0001\"\u0011\u0002\u000e!9\u0011\u0011\u0007\u0001\u0005B\u0005M\u0002bBA6\u0001\u0011\u0005\u0013Q\u000e\u0005\b\u0003g\u0002A\u0011IA;\u0011\u001d\tY\b\u0001C!\u0003{Bq!!%\u0001\t\u0003\n\u0019\nC\u0004\u0002\u001c\u0002!\t%!(\t\u000f\u0005m\u0005\u0001\"\u0011\u0002$\"9\u0011\u0011\u0017\u0001\u0005\n\u0005M\u0006bBAt\u0001\u0011%\u0011\u0011\u001e\u0002\u0015'Fd7i\\7nK:$(+\u001a9pg&$xN]=\u000b\u0005Y9\u0012aA:rY*\u0011\u0001$G\u0001\u000be\u0016\u0004xn]5u_JL(B\u0001\u000e\u001c\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002\u001d;\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002=\u0005\u00191m\\7\u0004\u0001M)\u0001!I\u0014,gA\u0011!%J\u0007\u0002G)\tA%A\u0003tG\u0006d\u0017-\u0003\u0002'G\t1\u0011I\\=SK\u001a\u0004\"\u0001K\u0015\u000e\u0003]I!AK\f\u0003#\r{W.\\3oiJ+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002-c5\tQF\u0003\u0002/_\u0005)1\u000f\u001c45U*\t\u0001'\u0001\u0005he&T(\u0010\\3e\u0013\t\u0011TFA\u0004M_\u001e<\u0017N\\4\u0011\u0005Q*T\"A\u000b\n\u0005Y*\"A\u0006#fg\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8TkB\u0004xN\u001d;\u0002\u001fQ\f7o\u001b)feNL7\u000f^3oG\u0016,\u0012!\u000f\t\u0003uuj\u0011a\u000f\u0006\u0003yU\t1\u0002]3sg&\u001cH/\u001a8dK&\u0011ah\u000f\u0002\u0010)\u0006\u001c8\u000eU3sg&\u001cH/\u001a8dK\u0006\u0001B/Y:l!\u0016\u00148/[:uK:\u001cW\rI\u0001\u0013G>lW.\u001a8u!\u0016\u00148/[:uK:\u001cW-F\u0001C!\tQ4)\u0003\u0002Ew\t\u00112i\\7nK:$\b+\u001a:tSN$XM\\2f\u0003M\u0019w.\\7f]R\u0004VM]:jgR,gnY3!\u0003E\u0011X\r]8tSR|'/_!eCB$XM]\u000b\u0002\u0011B\u0011A'S\u0005\u0003\u0015V\u0011AcU9m%\u0016\u0004xn]5u_JL\u0018\tZ1qi\u0016\u0014\u0018A\u0005:fa>\u001c\u0018\u000e^8ss\u0006#\u0017\r\u001d;fe\u0002\na\u0001P5oSRtD\u0003\u0002(P!F\u0003\"\u0001\u000e\u0001\t\u000b]:\u0001\u0019A\u001d\t\u000b\u0001;\u0001\u0019\u0001\"\t\u000b\u0019;\u0001\u0019\u0001%\u0002\r\u0015D\u0018n\u001d;t)\t!v\u000b\u0005\u0002#+&\u0011ak\t\u0002\b\u0005>|G.Z1o\u0011\u0015A\u0006\u00021\u0001Z\u0003%\u0019w.\\7f]RLE\r\u0005\u0002[Y:\u00111L\u001b\b\u00039&t!!\u00185\u000f\u0005y;gBA0g\u001d\t\u0001WM\u0004\u0002bI6\t!M\u0003\u0002d?\u00051AH]8pizJ\u0011AH\u0005\u00039uI!AG\u000e\n\u0005aI\u0012B\u0001\f\u0018\u0013\taT#\u0003\u0002lw\u0005!1)[%e\u0013\tigN\u0001\u0003DS&#'BA6<Q\tA\u0001\u000f\u0005\u0002rq6\t!O\u0003\u0002ti\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005U4\u0018aB7fiJL7m\u001d\u0006\u0003ov\t\u0001bY8eC\"\fG.Z\u0005\u0003sJ\u0014Q\u0001V5nK\u0012\faa\u0019:fCR,GC\u0001+}\u0011\u0015i\u0018\u00021\u0001\u007f\u0003\u001d\u0019'/Z1uK\u0012\u00042a`A\u0003\u001b\t\t\tAC\u0002\u0002\u0004e\ta\u0001Z8nC&t\u0017\u0002BA\u0004\u0003\u0003\u0011qaQ8n[\u0016tG\u000f\u000b\u0002\na\u0006I1M]3bi\u0016\fE\u000e\u001c\u000b\u0007\u0003\u001f\t)\"!\u0007\u0011\u0007\t\n\t\"C\u0002\u0002\u0014\r\u00121!\u00138u\u0011\u0019\t9B\u0003a\u00013\u00061A/Y:l\u0013\u0012Dq!a\u0007\u000b\u0001\u0004\ti\"\u0001\u0005d_6lWM\u001c;t!\u0015\ty\"!\u000b\u007f\u001d\u0011\t\t#!\n\u000f\u0007\u0005\f\u0019#C\u0001%\u0013\r\t9cI\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tY#!\f\u0003\u0007M+\u0017OC\u0002\u0002(\rB#A\u00039\u0002\rU\u0004H-\u0019;f)\u001d!\u0016QGA\u001c\u0003\u0017BQ\u0001W\u0006A\u0002eCq!!\u000f\f\u0001\u0004\tY$A\u0004va\u0012\fG/\u001a3\u0011\t\u0005u\u0012Q\t\b\u0005\u0003\u007f\t\t\u0005\u0005\u0002bG%\u0019\u00111I\u0012\u0002\rA\u0013X\rZ3g\u0013\u0011\t9%!\u0013\u0003\rM#(/\u001b8h\u0015\r\t\u0019e\t\u0005\b\u0003\u001bZ\u0001\u0019AA(\u0003!iw\u000eZ5gS\u0016$\u0007#\u0002\u0012\u0002R\u0005U\u0013bAA*G\t1q\n\u001d;j_:\u0004B!a\u0016\u0002f5\u0011\u0011\u0011\f\u0006\u0005\u00037\ni&\u0001\u0003uS6,'\u0002BA0\u0003C\nAA[8eC*\u0011\u00111M\u0001\u0004_J<\u0017\u0002BA4\u00033\u0012\u0001\u0002R1uKRKW.\u001a\u0015\u0003\u0017A\f\u0001BZ5oI\nK\u0018\n\u001a\u000b\u0004}\u0006=\u0004\"\u0002-\r\u0001\u0004I\u0006F\u0001\u0007q\u0003)1\u0017N\u001c3CsR\u000b7o\u001b\u000b\u0005\u0003;\t9\bC\u0004\u0002\u00185\u0001\r!a\u000f)\u00055\u0001\u0018\u0001\u00043fY\u0016$XMQ=UCN\\G\u0003BA@\u0003\u000b\u00032AIAA\u0013\r\t\u0019i\t\u0002\u0005+:LG\u000fC\u0004\u0002\b:\u0001\r!!#\u0002\tQ\f7o\u001b\t\u0004\u007f\u0006-\u0015\u0002BAG\u0003\u0003\u0011A\u0001V1tW\"\u0012a\u0002]\u0001\u0007I\u0016dW\r^3\u0015\t\u0005}\u0014Q\u0013\u0005\u0007\u0003/{\u0001\u0019\u0001@\u0002\u000f\r|W.\\3oi\"\u0012q\u0002]\u0001\tI\u0016\u001cwN]1uKR!\u0011\u0011RAP\u0011\u001d\t9\t\u0005a\u0001\u0003\u0013C#\u0001\u00059\u0015\t\u0005\u0015\u00161\u0016\t\u0004\u007f\u0006\u001d\u0016\u0002BAU\u0003\u0003\u0011qAU3mK\u0006\u001cX\rC\u0004\u0002.F\u0001\r!!*\u0002\u000fI,G.Z1tK\"\u0012\u0011\u0003]\u0001\to&$\b\u000eV1tWV!\u0011QWA_)\u0011\t9,!:\u0015\t\u0005e\u0016q\u001a\t\u0005\u0003w\u000bi\f\u0004\u0001\u0005\u000f\u0005}&C1\u0001\u0002B\n\t\u0011)\u0005\u0003\u0002D\u0006%\u0007c\u0001\u0012\u0002F&\u0019\u0011qY\u0012\u0003\u000f9{G\u000f[5oOB\u0019!%a3\n\u0007\u000557EA\u0002B]fDq!!5\u0013\u0001\u0004\t\u0019.A\u0001g!\u001d\u0011\u0013Q[Am\u0003sK1!a6$\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0003\u0002\\\u0006}gbA.\u0002^&\u0019\u0011qE\u001e\n\t\u0005\u0005\u00181\u001d\u0002\u0006\u0007&,\u0016\u000e\u001a\u0006\u0004\u0003OY\u0004BBA\f%\u0001\u0007\u0011,A\u0005xSRDG+Y:laU!\u00111^Az)\u0011\ti/!?\u0015\t\u0005=\u0018Q\u001f\t\u0006E\u0005E\u0013\u0011\u001f\t\u0005\u0003w\u000b\u0019\u0010B\u0004\u0002@N\u0011\r!!1\t\u000f\u0005E7\u00031\u0001\u0002xB9!%!6\u0002Z\u0006E\bBBA\f'\u0001\u0007\u0011\fK\u0002\u0001\u0003{\u0004B!a@\u0003\f5\u0011!\u0011\u0001\u0006\u0005\u0005\u0007\u0011)!A\u0006ue\u0006t7/Y2uS>t'b\u0001\f\u0003\b)\u0019!\u0011B\r\u0002\u0005\u0011\u0014\u0017\u0002\u0002B\u0007\u0005\u0003\u0011q\"S:Ue\u0006t7/Y2uS>t\u0017\r\u001c")
public class SqlCommentRepository
implements CommentRepository,
Logging,
DeserializationSupport {
    private final TaskPersistence taskPersistence;
    private final CommentPersistence commentPersistence;
    private final SqlRepositoryAdapter repositoryAdapter;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public Release deserializeRelease(ReleaseRow releaseData) {
        return DeserializationSupport.deserializeRelease$(this, releaseData);
    }

    @Override
    public Option<Release> tryDeserializeRelease(ReleaseRow releaseData) {
        return DeserializationSupport.tryDeserializeRelease$(this, releaseData);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean update(String commentId, String content) {
        return CommentRepository.update$((CommentRepository)this, (String)commentId, (String)content);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlCommentRepository sqlCommentRepository = this;
        synchronized (sqlCommentRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public TaskPersistence taskPersistence() {
        return this.taskPersistence;
    }

    public CommentPersistence commentPersistence() {
        return this.commentPersistence;
    }

    @Override
    public SqlRepositoryAdapter repositoryAdapter() {
        return this.repositoryAdapter;
    }

    @Timed
    public boolean exists(String commentId) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(8).append("exists(").append(commentId).append(")").toString());
        String taskId = Ids.getParentId((String)commentId);
        return BoxesRunTime.unboxToBoolean((Object)this.withTask0(taskId, (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SqlCommentRepository.$anonfun$exists$2(this, commentId, x$1))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false));
    }

    @Timed
    public boolean create(Comment created) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(8).append("create(").append(created.getId()).append(")").toString());
        String taskId = Ids.getParentId((String)created.getId());
        return BoxesRunTime.unboxToBoolean(this.withTask(taskId, (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)SqlCommentRepository.$anonfun$create$2(this, created, x$2))));
    }

    @Timed
    public int createAll(String taskId, Seq<Comment> comments) {
        Seq aliens = (Seq)comments.filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)SqlCommentRepository.$anonfun$createAll$1(taskId, x$3)));
        if (aliens.nonEmpty()) {
            throw new IllegalArgumentException(new StringBuilder(35).append(aliens.length()).append(" comment(s) don't belong to task [").append(taskId).append("]").toString());
        }
        return BoxesRunTime.unboxToInt(this.withTask(taskId, (Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)SqlCommentRepository.$anonfun$createAll$2(this, comments, x$4))));
    }

    @Timed
    public boolean update(String commentId, String updated, Option<DateTime> modified) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(10).append("update(").append(commentId).append(", ").append(updated).append(")").toString());
        String taskId = Ids.getParentId((String)commentId);
        return BoxesRunTime.unboxToBoolean(this.withTask(taskId, (Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)SqlCommentRepository.$anonfun$update$2(this, commentId, updated, modified, x$5))));
    }

    @Timed
    public Comment findById(String commentId) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(10).append("findById(").append(commentId).append(")").toString());
        String taskId = Ids.getParentId((String)commentId);
        return (Comment)this.withTask(taskId, (Function1 & Serializable)taskUid -> (Comment)this.commentPersistence().read((Integer)taskUid, commentId).map((Function1 & Serializable)x$6 -> CommentPersistence$CommentRowOps$.MODULE$.toComment$extension(CommentPersistence$.MODULE$.CommentRowOps((CommentPersistence.CommentRow)x$6), taskId)).getOrElse((Function0 & Serializable)() -> {
            this.logger().warn((Function0 & Serializable)() -> new StringBuilder(32).append("Comment [").append(commentId).append("] not found in database").toString());
            throw new NotFoundException(new StringBuilder(21).append("Comment [").append(commentId).append("] not found.").toString(), new Object[0]);
        }));
    }

    @Timed
    public Seq<Comment> findByTask(String taskId) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(12).append("findByTask(").append(taskId).append(")").toString());
        return (Seq)this.withTask(taskId, (Function1 & Serializable)taskUid -> {
            Seq found = (Seq)this.commentPersistence().readAll((Integer)taskUid).map((Function1 & Serializable)x$7 -> CommentPersistence$CommentRowOps$.MODULE$.toComment$extension(CommentPersistence$.MODULE$.CommentRowOps((CommentPersistence.CommentRow)x$7), taskId));
            this.logger().info((Function0 & Serializable)() -> new StringBuilder(20).append("Found ").append(found.size()).append(" comments for ").append(taskId).toString());
            return found;
        });
    }

    @Timed
    public void deleteByTask(Task task) {
        this.withTask(task.getId(), (Function1 & Serializable)taskUid -> BoxesRunTime.boxToInteger((int)SqlCommentRepository.$anonfun$deleteByTask$1(this, taskUid)));
    }

    @Timed
    public void delete(Comment comment) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(8).append("delete(").append(comment.getId()).append(")").toString());
        String taskId = Ids.getParentId((String)comment.getId());
        this.withTask(taskId, (Function1 & Serializable)taskUid -> BoxesRunTime.boxToInteger((int)SqlCommentRepository.$anonfun$delete$2(this, comment, taskUid)));
    }

    @Timed
    public Task decorate(Task task) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(10).append("decorate(").append(task.getId()).append(")").toString());
        return (Task)this.withTask(task.getId(), (Function1 & Serializable)taskUid -> this.commentPersistence().decorate((Integer)taskUid, task));
    }

    @Timed
    public Release decorate(Release release) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(28).append("decorate tasks in release (").append(release.getId()).append(")").toString());
        return this.commentPersistence().decorate(release);
    }

    private <A> A withTask(String taskId, Function1<Integer, A> f) {
        return (A)this.withTask0(taskId, f).getOrElse((Function0 & Serializable)() -> {
            Task task = (Task)this.repositoryAdapter().read(taskId);
            this.logger().warn((Function0 & Serializable)() -> new StringBuilder(57).append("Task with id [").append(taskId).append("] not found in the database, reinserting...").toString());
            return f.apply((Object)this.taskPersistence().insert(task, Predef$.MODULE$.Integer2int(task.getRelease().getCiUid())));
        });
    }

    private <A> Option<A> withTask0(String taskId, Function1<Integer, A> f) {
        return this.taskPersistence().getTaskUidById(taskId).map(f);
    }

    public static final /* synthetic */ boolean $anonfun$exists$2(SqlCommentRepository $this, String commentId$1, Integer x$1) {
        return $this.commentPersistence().exists(x$1, commentId$1);
    }

    public static final /* synthetic */ boolean $anonfun$create$2(SqlCommentRepository $this, Comment created$1, Integer x$2) {
        return $this.commentPersistence().create(x$2, CommentPersistence$CommentRow$.MODULE$.fromComment(created$1));
    }

    public static final /* synthetic */ boolean $anonfun$createAll$1(String taskId$1, Comment x$3) {
        return !x$3.getId().startsWith(taskId$1);
    }

    public static final /* synthetic */ int $anonfun$createAll$2(SqlCommentRepository $this, Seq comments$1, Integer x$4) {
        return $this.commentPersistence().createAll(x$4, (Seq<CommentPersistence.CommentRow>)((Seq)comments$1.map((Function1 & Serializable)comment -> CommentPersistence$CommentRow$.MODULE$.fromComment((Comment)comment))));
    }

    public static final /* synthetic */ boolean $anonfun$update$2(SqlCommentRepository $this, String commentId$2, String updated$1, Option modified$1, Integer x$5) {
        return $this.commentPersistence().update(x$5, commentId$2, updated$1, (Option<DateTime>)modified$1);
    }

    public static final /* synthetic */ int $anonfun$deleteByTask$1(SqlCommentRepository $this, Integer taskUid) {
        return $this.commentPersistence().deleteAll(taskUid);
    }

    public static final /* synthetic */ int $anonfun$delete$2(SqlCommentRepository $this, Comment comment$1, Integer taskUid) {
        return $this.commentPersistence().delete(taskUid, comment$1.getId());
    }

    public SqlCommentRepository(TaskPersistence taskPersistence, CommentPersistence commentPersistence, SqlRepositoryAdapter repositoryAdapter) {
        this.taskPersistence = taskPersistence;
        this.commentPersistence = commentPersistence;
        this.repositoryAdapter = repositoryAdapter;
        CommentRepository.$init$((CommentRepository)this);
        Logging.$init$((Logging)this);
        DeserializationSupport.$init$(this);
    }
}

