package com.xebialabs.xlrelease.security.sql.snapshots.repository

import com.xebialabs.xlrelease.security.sql.snapshots.domain.RolesSnapshot
import com.xebialabs.xlrelease.security.sql.snapshots.persistence.SqlRolesSnapshotPersistence
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service

import java.util.Date

@Service
class SqlRolesSnapshotRepository @Autowired()(val sqlPermissionsSnapshotPersistence: SqlRolesSnapshotPersistence) {

  def saveSnapshot(snapshot: RolesSnapshot): Unit = sqlPermissionsSnapshotPersistence.saveSnapshot(snapshot)

  def findSnapshot(containerId: Option[String], byDate: Date): Option[RolesSnapshot] = sqlPermissionsSnapshotPersistence.findSnapshot(containerId, byDate)

  def findNextSnapshot(containerId: Option[String], date: Date): Option[RolesSnapshot] = sqlPermissionsSnapshotPersistence.findSnapshot(containerId, date, next = true)

}
