/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.VisitableItem;
import com.xebialabs.xlrelease.domain.status.PhaseStatus;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.events.XLReleaseOperations$;
import com.xebialabs.xlrelease.repository.CiCloneHelper;
import com.xebialabs.xlrelease.repository.FacetRepositoryDispatcher;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.PhaseVersion;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.RetryTitleGenerator;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.DependencyService;
import com.xebialabs.xlrelease.service.PhaseRestart;
import com.xebialabs.xlrelease.service.PhaseRestart$;
import com.xebialabs.xlrelease.service.RestartPhasesException;
import com.xebialabs.xlrelease.service.TaskBackup;
import com.xebialabs.xlrelease.utils.CiHelper;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper$;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@Component
@ScalaSignature(bytes="\u0006\u0005\u0005Mh\u0001\u0002\u000b\u0016\u0001yA\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\t[\u0001\u0011\t\u0011)A\u0005]!AA\u0007\u0001B\u0001B\u0003%Q\u0007\u0003\u0005<\u0001\t\u0005\t\u0015!\u0003=\u0011!y\u0004A!A!\u0002\u0013\u0001\u0005\u0002C\"\u0001\u0005\u0003\u0005\u000b\u0011\u0002#\t\u0011\u001d\u0003!\u0011!Q\u0001\n!C\u0001B\u0014\u0001\u0003\u0002\u0003\u0006Ia\u0014\u0005\t%\u0002\u0011\t\u0011)A\u0006'\")\u0011\f\u0001C\u00015\")Q\u000f\u0001C!m\"I\u00111\t\u0001\u0012\u0002\u0013\u0005\u0011Q\t\u0005\n\u00033\u0002\u0011\u0013!C\u0001\u00037Bq!a\u0018\u0001\t\u0003\n\t\u0007C\u0004\u0002~\u0001!I!a \t\u000f\u0005\u0015\u0005\u0001\"\u0003\u0002\b\"9\u0011q\u0014\u0001\u0005B\u0005\u0005\u0006bBA`\u0001\u0011%\u0011\u0011\u0019\u0005\b\u0003'\u0004A\u0011BAk\u0005=\u0019\u0016\u000f\u001c)iCN,'+Z:uCJ$(B\u0001\f\u0018\u0003\u001d\u0019XM\u001d<jG\u0016T!\u0001G\r\u0002\u0013ad'/\u001a7fCN,'B\u0001\u000e\u001c\u0003%AXMY5bY\u0006\u00147OC\u0001\u001d\u0003\r\u0019w.\\\u0002\u0001'\r\u0001q$\n\t\u0003A\rj\u0011!\t\u0006\u0002E\u0005)1oY1mC&\u0011A%\t\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0019:S\"A\u000b\n\u0005!*\"\u0001\u0004)iCN,'+Z:uCJ$\u0018A\u0003;bg.\u0014\u0015mY6vaB\u0011aeK\u0005\u0003YU\u0011!\u0002V1tW\n\u000b7m[;q\u0003-\u0001XM]7jgNLwN\\:\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0005E:\u0012\u0001C:fGV\u0014\u0018\u000e^=\n\u0005M\u0002$!\u0005)fe6L7o]5p]\u000eCWmY6fe\u0006\t\"/\u001a7fCN,'+\u001a9pg&$xN]=\u0011\u0005YJT\"A\u001c\u000b\u0005a:\u0012A\u0003:fa>\u001c\u0018\u000e^8ss&\u0011!h\u000e\u0002\u0012%\u0016dW-Y:f%\u0016\u0004xn]5u_JL\u0018aC2j\u0013\u0012\u001cVM\u001d<jG\u0016\u0004\"AJ\u001f\n\u0005y*\"aC\"j\u0013\u0012\u001cVM\u001d<jG\u0016\f\u0011\u0003Z3qK:$WM\\2z'\u0016\u0014h/[2f!\t1\u0013)\u0003\u0002C+\t\tB)\u001a9f]\u0012,gnY=TKJ4\u0018nY3\u0002\u001dQ\f7o\u001b*fa>\u001c\u0018\u000e^8ssB\u0011a'R\u0005\u0003\r^\u0012a\u0002V1tWJ+\u0007o\\:ji>\u0014\u00180A\nsK2,\u0017m]3BGR|'oU3sm&\u001cW\r\u0005\u0002J\u00196\t!J\u0003\u0002L/\u00051\u0011m\u0019;peNL!!\u0014&\u0003'I+G.Z1tK\u0006\u001bGo\u001c:TKJ4\u0018nY3\u00023\u0019\f7-\u001a;SKB|7/\u001b;pef$\u0015n\u001d9bi\u000eDWM\u001d\t\u0003mAK!!U\u001c\u00033\u0019\u000b7-\u001a;SKB|7/\u001b;pef$\u0015n\u001d9bi\u000eDWM]\u0001\tKZ,g\u000e\u001e\"vgB\u0011AkV\u0007\u0002+*\u0011akF\u0001\u0007KZ,g\u000e^:\n\u0005a+&!\u0005-M%\u0016dW-Y:f\u000bZ,g\u000e\u001e\"vg\u00061A(\u001b8jiz\"\u0012b\u00170`A\u0006\u00147\rZ3\u0015\u0005qk\u0006C\u0001\u0014\u0001\u0011\u0015\u0011&\u0002q\u0001T\u0011\u0015I#\u00021\u0001+\u0011\u0015i#\u00021\u0001/\u0011\u0015!$\u00021\u00016\u0011\u0015Y$\u00021\u0001=\u0011\u0015y$\u00021\u0001A\u0011\u0015\u0019%\u00021\u0001E\u0011\u00159%\u00021\u0001I\u0011\u0015q%\u00021\u0001PQ\tQq\r\u0005\u0002ig6\t\u0011N\u0003\u0002kW\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u00051l\u0017a\u00024bGR|'/\u001f\u0006\u0003]>\fQAY3b]NT!\u0001]9\u0002\u001fM\u0004(/\u001b8hMJ\fW.Z<pe.T\u0011A]\u0001\u0004_J<\u0017B\u0001;j\u0005%\tU\u000f^8xSJ,G-A\u0007sKN$\u0018M\u001d;QQ\u0006\u001cXm\u001d\u000b\roz\f9\"a\u0007\u0002 \u0005%\u00121\u0007\t\u0003qnt!AJ=\n\u0005i,\u0012\u0001\u0004)iCN,'+Z:uCJ$\u0018B\u0001?~\u0005I\u0011Vm\u001d;beR\u0004\u0006.Y:f%\u0016\u001cX\u000f\u001c;\u000b\u0005i,\u0002BB@\f\u0001\u0004\t\t!A\u0005sK2,\u0017m]3JIB!\u00111AA\t\u001d\u0011\t)!!\u0004\u0011\u0007\u0005\u001d\u0011%\u0004\u0002\u0002\n)\u0019\u00111B\u000f\u0002\rq\u0012xn\u001c;?\u0013\r\ty!I\u0001\u0007!J,G-\u001a4\n\t\u0005M\u0011Q\u0003\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005=\u0011\u0005C\u0004\u0002\u001a-\u0001\r!!\u0001\u0002\u000fAD\u0017m]3JI\"9\u0011QD\u0006A\u0002\u0005\u0005\u0011A\u0002;bg.LE\rC\u0005\u0002\"-\u0001\n\u00111\u0001\u0002$\u0005a\u0001\u000f[1tKZ+'o]5p]B\u0019a'!\n\n\u0007\u0005\u001drG\u0001\u0007QQ\u0006\u001cXMV3sg&|g\u000eC\u0005\u0002,-\u0001\n\u00111\u0001\u0002.\u0005i!/Z:v[\u0016\u0014V\r\\3bg\u0016\u00042\u0001IA\u0018\u0013\r\t\t$\t\u0002\b\u0005>|G.Z1o\u0011\u001d\t)d\u0003a\u0001\u0003o\tqA]3mK\u0006\u001cX\r\u0005\u0003\u0002:\u0005}RBAA\u001e\u0015\r\tidF\u0001\u0007I>l\u0017-\u001b8\n\t\u0005\u0005\u00131\b\u0002\b%\u0016dW-Y:f\u0003]\u0011Xm\u001d;beR\u0004\u0006.Y:fg\u0012\"WMZ1vYR$C'\u0006\u0002\u0002H)\"\u00111EA%W\t\tY\u0005\u0005\u0003\u0002N\u0005USBAA(\u0015\u0011\t\t&a\u0015\u0002\u0013Ut7\r[3dW\u0016$'B\u00016\"\u0013\u0011\t9&a\u0014\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\fsKN$\u0018M\u001d;QQ\u0006\u001cXm\u001d\u0013eK\u001a\fW\u000f\u001c;%kU\u0011\u0011Q\f\u0016\u0005\u0003[\tI%A\u0007sKN$xN]3QQ\u0006\u001cXm\u001d\u000b\u0005\u0003G\nI\b\u0005\u0004\u0002f\u0005=\u00141O\u0007\u0003\u0003ORA!!\u001b\u0002l\u0005!Q\u000f^5m\u0015\t\ti'\u0001\u0003kCZ\f\u0017\u0002BA9\u0003O\u0012A\u0001T5tiB!\u0011\u0011HA;\u0013\u0011\t9(a\u000f\u0003\u000bAC\u0017m]3\t\u000f\u0005md\u00021\u0001\u0002d\u0005y\u0001\u000f[1tKN$vNU3ti>\u0014X-\u0001\u0007sKN$xN]3QQ\u0006\u001cX\r\u0006\u0003\u0002t\u0005\u0005\u0005bBAB\u001f\u0001\u0007\u00111O\u0001\u0006a\"\f7/Z\u0001\re\u0016\u001cHo\u001c:f)\u0006\u001c8n\u001d\u000b\u0007\u0003\u0013\u000by)a'\u0011\u0007\u0001\nY)C\u0002\u0002\u000e\u0006\u0012A!\u00168ji\"9\u0011\u0011\u0013\tA\u0002\u0005M\u0015!D8sS\u001eLg.\u00197UCN\\7\u000f\u0005\u0004\u0002f\u0005=\u0014Q\u0013\t\u0005\u0003s\t9*\u0003\u0003\u0002\u001a\u0006m\"\u0001\u0002+bg.Dq!!(\u0011\u0001\u0004\t\u0019*\u0001\u0005oK^$\u0016m]6t\u0003q)\b\u000fZ1uK\u001e\u000bG/Z:SK\u001a,'/\u001a8dS:<\u0007\u000b[1tKN$\u0002\"!#\u0002$\u0006\u0015\u00161\u0018\u0005\b\u0003k\t\u0002\u0019AA\u001c\u0011\u001d\t9+\u0005a\u0001\u0003S\u000b!\u0003\u001d5bg\u0016\u001cHk\u001c*fgR|'/Z%egB1\u00111VA[\u0003\u0003qA!!,\u00022:!\u0011qAAX\u0013\u0005\u0011\u0013bAAZC\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\\\u0003s\u00131aU3r\u0015\r\t\u0019,\t\u0005\b\u0003{\u000b\u0002\u0019AAU\u0003E\u0011Xm\u001d;pe\u0016$\u0007\u000b[1tKNLEm]\u0001\u0010g.L\u0007\u000fV1tWN\u0014UMZ8sKRA\u00111YAe\u0003\u0017\fy\r\u0005\u0003\u0002:\u0005\u0015\u0017\u0002BAd\u0003w\u0011qa\u00115b]\u001e,7\u000fC\u0004\u0002\u001eI\u0001\r!!\u0001\t\u000f\u00055'\u00031\u0001\u0002t\u0005iqN]5hS:\fG\u000e\u00155bg\u0016Dq!!5\u0013\u0001\u0004\t\u0019(A\u0007sKN$xN]3e!\"\f7/Z\u0001\u000fa\u0016\u00148/[:u%\u0016dW-Y:f))\tI)a6\u0002\\\u0006u\u0017\u0011\u001d\u0005\b\u00033\u001c\u0002\u0019AA\u001c\u0003!y'/[4j]\u0006d\u0007bBA\u001b'\u0001\u0007\u0011q\u0007\u0005\b\u0003?\u001c\u0002\u0019AAb\u0003\u001d\u0019\u0007.\u00198hKNDq!a9\u0014\u0001\u0004\t\u0019'\u0001\bsKN$xN]3e!\"\f7/Z:)\u0007\u0001\t9\u000f\u0005\u0003\u0002j\u0006=XBAAv\u0015\r\tio\\\u0001\u000bgR,'/Z8usB,\u0017\u0002BAy\u0003W\u0014\u0011bQ8na>tWM\u001c;")
public class SqlPhaseRestart
implements PhaseRestart {
    private final TaskBackup taskBackup;
    private final PermissionChecker permissions;
    private final ReleaseRepository releaseRepository;
    private final CiIdService ciIdService;
    private final DependencyService dependencyService;
    private final TaskRepository taskRepository;
    private final ReleaseActorService releaseActorService;
    private final FacetRepositoryDispatcher facetRepositoryDispatcher;
    private final XLReleaseEventBus eventBus;

    @Timed
    public PhaseRestart.RestartPhaseResult restartPhases(String releaseId, String phaseId, String taskId, PhaseVersion phaseVersion, Release release) {
        return PhaseRestart.restartPhases$((PhaseRestart)this, (String)releaseId, (String)phaseId, (String)taskId, (PhaseVersion)phaseVersion, (Release)release);
    }

    public void checkCanRestartPhases(Release release, String phaseId, String taskId, PhaseVersion phaseVersion, boolean resumeRelease) {
        PhaseRestart.checkCanRestartPhases$((PhaseRestart)this, (Release)release, (String)phaseId, (String)taskId, (PhaseVersion)phaseVersion, (boolean)resumeRelease);
    }

    public PhaseRestart.RestartPhaseResult restartPhases(String releaseId, String phaseId, String taskId, PhaseVersion phaseVersion, boolean resumeRelease, Release release) {
        ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(release.getAllTasks()).asScala().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.canBeBackup()))).foreach((Function1 & Serializable)task -> {
            this.taskBackup.backupTask(task, release);
            return BoxedUnit.UNIT;
        });
        Release original = (Release)CiCloneHelper.cloneCi((ConfigurationItem)release);
        this.checkCanRestartPhases(release, phaseId, taskId, phaseVersion, resumeRelease);
        scala.collection.immutable.Seq phasesToRestore = CollectionConverters$.MODULE$.ListHasAsScala(PhaseRestart$.MODULE$.getPhasesToRestore(release, phaseId, phaseVersion)).asScala().toSeq();
        if (phasesToRestore.isEmpty()) {
            throw new RestartPhasesException(releaseId, phaseId, taskId, phaseVersion, resumeRelease, "There are no " + phaseVersion + " phases to restart from " + phaseId);
        }
        PhaseRestart$.MODULE$.checkIfPhaseCanBeRestartedFrom(release.getTask(taskId), (Phase)phasesToRestore.head(), this.permissions);
        List<Phase> restoredPhases = this.restorePhases(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)phasesToRestore).asJava());
        Changes changes = release.restorePhases(restoredPhases);
        changes.addAll(release.getCurrentPhase().close());
        changes.addAll(this.skipTasksBefore(taskId, (Phase)phasesToRestore.head(), restoredPhases.get(0)));
        this.persistRelease(original, release, changes, restoredPhases);
        return new PhaseRestart.RestartPhaseResult(release, (scala.collection.immutable.Seq)phasesToRestore.map((Function1 & Serializable)x$2 -> x$2.getId()), ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(restoredPhases).asScala().map((Function1 & Serializable)x$3 -> x$3.getId())).toSeq());
    }

    public PhaseVersion restartPhases$default$4() {
        return PhaseVersion.ALL;
    }

    public boolean restartPhases$default$5() {
        return false;
    }

    public List<Phase> restorePhases(List<Phase> phasesToRestore) {
        return CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)CollectionConverters$.MODULE$.ListHasAsScala(phasesToRestore).asScala().map((Function1 & Serializable)originalPhase -> {
            void var2_2;
            Phase restoredPhase = this.restorePhase((Phase)originalPhase);
            this.restoreTasks(originalPhase.getTasks(), restoredPhase.getTasks());
            return var2_2;
        })).asJava();
    }

    /*
     * WARNING - void declaration
     */
    private Phase restorePhase(Phase phase) {
        void var3_3;
        String restoredPhaseId = this.ciIdService.getUniqueId(Type.valueOf(Phase.class), Ids.releaseIdFrom((String)phase.getId()));
        Phase copiedPhase = (Phase)CiCloneHelper.cloneCi((ConfigurationItem)phase);
        CiHelper.rewriteWithNewId((ConfigurationItem)copiedPhase, (String)restoredPhaseId);
        String lastGeneratedTitle = (String)CollectionConverters$.MODULE$.ListHasAsScala(phase.getRelease().getPhases()).asScala().findLast((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)SqlPhaseRestart.$anonfun$restorePhase$1(phase, x$4))).map((Function1 & Serializable)x$5 -> x$5.getTitle()).getOrElse((Function0 & Serializable)() -> phase.getTitle());
        copiedPhase.setTitle(RetryTitleGenerator.getNextTitle((String)lastGeneratedTitle));
        copiedPhase.setStatus(PhaseStatus.PLANNED);
        copiedPhase.setStartDate(null);
        copiedPhase.setEndDate(null);
        copiedPhase.setOriginId(phase.getId());
        return var3_3;
    }

    private void restoreTasks(List<Task> originalTasks, List<Task> newTasks) {
        CollectionConverters$.MODULE$.ListHasAsScala(originalTasks).asScala().indices().foreach((Function1 & Serializable)i -> SqlPhaseRestart.$anonfun$restoreTasks$1(this, newTasks, originalTasks, BoxesRunTime.unboxToInt((Object)i)));
    }

    public void updateGatesReferencingPhases(Release release, scala.collection.immutable.Seq<String> phasesToRestoreIds, scala.collection.immutable.Seq<String> restoredPhasesIds) {
        scala.collection.immutable.Seq phasesToRestore = (scala.collection.immutable.Seq)phasesToRestoreIds.map((Function1 & Serializable)x$1 -> release.getPhase(x$1));
        scala.collection.immutable.Seq restoredPhases = (scala.collection.immutable.Seq)restoredPhasesIds.map((Function1 & Serializable)x$1 -> release.getPhase(x$1));
        scala.collection.immutable.Map originToRestored = PhaseRestart$.MODULE$.buildOriginToRestored(phasesToRestore, restoredPhases);
        ((IterableOnceOps)phasesToRestore.flatMap((Function1 & Serializable)phase -> $this.dependencyService.findActiveIncomingGateIdsWithoutExistsCheck(phase.getId()))).foreach((Function1 & Serializable)x$7 -> {
            this.releaseActorService.updateGateReferencingPhases(x$7, CollectionConverters$.MODULE$.MapHasAsJava((Map)originToRestored).asJava());
            return BoxedUnit.UNIT;
        });
    }

    private Changes skipTasksBefore(String taskId, Phase originalPhase, Phase restoredPhase) {
        Changes changes;
        block0: {
            int taskIndexToRestartFrom = ((SeqOps)CollectionConverters$.MODULE$.ListHasAsScala(originalPhase.getTasks()).asScala().map((Function1 & Serializable)x$8 -> (String)CiHelper.TO_ID.apply(x$8))).indexOf((Object)taskId);
            changes = new Changes();
            if (taskIndexToRestartFrom <= 0) break block0;
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), taskIndexToRestartFrom).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                Task task = (Task)restoredPhase.getTasks().get(i);
                changes.addAll(task.markAsDone(task.getId(), TaskStatus.SKIPPED_IN_ADVANCE));
            });
        }
        return changes;
    }

    private void persistRelease(Release original, Release release, Changes changes, List<Phase> restoredPhases) {
        XLReleaseOperations$.MODULE$.runActionInterceptors(changes.getOperations(), this.eventBus);
        VariablePersistenceHelper$.MODULE$.scanAndBuildNewVariables(release, (VisitableItem)release, this.ciIdService);
        this.releaseRepository.update(original, release);
        ((IterableOnceOps)CollectionConverters$.MODULE$.SetHasAsScala(changes.getUpdatedItems()).asScala().filter((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)SqlPhaseRestart.$anonfun$persistRelease$1(x$9)))).foreach((Function1 & Serializable)task -> {
            this.taskRepository.updateTaskProperties((Task)task);
            return BoxedUnit.UNIT;
        });
        this.facetRepositoryDispatcher.liveRepository().createFromTasks(((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(restoredPhases).asScala().flatMap((Function1 & Serializable)x$10 -> CollectionConverters$.MODULE$.ListHasAsScala(x$10.getAllTasks()).asScala())).toSeq(), this.facetRepositoryDispatcher.liveRepository().createFromTasks$default$2());
        XLReleaseOperations$.MODULE$.publishEvents(changes.getOperations(), this.eventBus);
    }

    public static final /* synthetic */ boolean $anonfun$restorePhase$1(Phase phase$1, Phase x$4) {
        String string = x$4.getOriginId();
        String string2 = phase$1.getId();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ Task $anonfun$restoreTasks$1(SqlPhaseRestart $this, List newTasks$1, List originalTasks$1, int i) {
        Task restoredTask = $this.taskBackup.restoreTask((Task)newTasks$1.get(i), ((BaseConfigurationItem)originalTasks$1.get(i)).getId(), true);
        restoredTask.getAllTasks().forEach(subTask -> subTask.setStatus(TaskStatus.PLANNED));
        restoredTask.clearComments();
        restoredTask.setStartDate(null);
        restoredTask.setEndDate(null);
        Task task = restoredTask;
        if (task instanceof GateTask) {
            GateTask gateTask = (GateTask)task;
            CollectionConverters$.MODULE$.ListHasAsScala(gateTask.getConditions()).asScala().foreach((Function1 & Serializable)x$6 -> {
                x$6.setChecked(false);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        return newTasks$1.set(i, restoredTask);
    }

    public static final /* synthetic */ boolean $anonfun$persistRelease$1(ConfigurationItem x$9) {
        return x$9 instanceof Task;
    }

    @Autowired
    public SqlPhaseRestart(TaskBackup taskBackup, PermissionChecker permissions, ReleaseRepository releaseRepository, CiIdService ciIdService, DependencyService dependencyService, TaskRepository taskRepository, ReleaseActorService releaseActorService, FacetRepositoryDispatcher facetRepositoryDispatcher, XLReleaseEventBus eventBus) {
        this.taskBackup = taskBackup;
        this.permissions = permissions;
        this.releaseRepository = releaseRepository;
        this.ciIdService = ciIdService;
        this.dependencyService = dependencyService;
        this.taskRepository = taskRepository;
        this.releaseActorService = releaseActorService;
        this.facetRepositoryDispatcher = facetRepositoryDispatcher;
        this.eventBus = eventBus;
        PhaseRestart.$init$((PhaseRestart)this);
    }
}

