/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.validation.ExtendedValidationContext;
import com.xebialabs.deployit.plumbing.serialization.ResolutionContext;
import com.xebialabs.deployit.plumbing.serialization.ResolutionContext$;
import com.xebialabs.deployit.repository.ItemAlreadyExistsException;
import com.xebialabs.deployit.repository.ItemInUseException;
import com.xebialabs.xlrelease.configuration.ThemeSettings;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.domain.Configuration;
import com.xebialabs.xlrelease.domain.runner.JobRunner;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.variables.reference.UsagePoint;
import com.xebialabs.xlrelease.repository.CiProperty;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.PersistenceInterceptor;
import com.xebialabs.xlrelease.repository.query.ReleaseBasicData;
import com.xebialabs.xlrelease.repository.sql.InterceptedRepository;
import com.xebialabs.xlrelease.repository.sql.ReferencedEntity;
import com.xebialabs.xlrelease.repository.sql.SqlConfigurationRepository$;
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter;
import com.xebialabs.xlrelease.repository.sql.persistence.FolderPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.configuration.ConfigurationPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.configuration.ConfigurationReferencePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.configuration.ReleaseConfigurationReferencePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.configuration.TriggerConfigurationReferencePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.ConfigurationReferenceRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.ConfigurationReferenceRow$;
import com.xebialabs.xlrelease.scheduler.filters.JobFilters;
import com.xebialabs.xlrelease.scheduler.repository.JobRepository;
import com.xebialabs.xlrelease.service.ConfigurationVariableService$;
import com.xebialabs.xlrelease.utils.FolderId;
import com.xebialabs.xlrelease.utils.TypeHelper$;
import com.xebialabs.xlrelease.validation.ExtendedValidationContextImpl;
import com.xebialabs.xlrelease.validation.XlrValidationsFailedException;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import org.slf4j.Marker;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\u0011%b\u0001\u0002!B\u00011C\u0001b\u0018\u0001\u0003\u0002\u0003\u0006I\u0001\u0019\u0005\tQ\u0002\u0011\t\u0011)A\u0005S\"AA\u000e\u0001B\u0001B\u0003%Q\u000e\u0003\u0005q\u0001\t\u0005\t\u0015!\u0003r\u0011!)\bA!A!\u0002\u00131\b\u0002\u0003>\u0001\u0005\u0003\u0005\u000b\u0011B>\t\u0011y\u0004!\u0011!Q\u0001\n}Dq!!\u0004\u0001\t\u0003\ty\u0001C\u0005\u0002\"\u0001\u0011\r\u0011\"\u0003\u0002$!A\u00111\b\u0001!\u0002\u0013\t)\u0003C\u0005\u0002>\u0001\u0011\r\u0011\"\u0003\u0002$!A\u0011q\b\u0001!\u0002\u0013\t)\u0003C\u0005\u0002B\u0001\u0011\r\u0011\"\u0003\u0002$!A\u00111\t\u0001!\u0002\u0013\t)\u0003C\u0005\u0002F\u0001\u0011\r\u0011\"\u0003\u0002$!A\u0011q\t\u0001!\u0002\u0013\t)\u0003C\u0005\u0002J\u0001\u0011\r\u0011\"\u0003\u0002L!A\u0011\u0011\r\u0001!\u0002\u0013\ti\u0005C\u0004\u0002d\u0001!\t%!\u001a\t\u000f\u0005\r\u0004\u0001\"\u0011\u0002\u001e\"9\u00111\u001b\u0001\u0005\n\u0005U\u0007bBAn\u0001\u0011%\u0011Q\u001c\u0005\b\u0003[\u0004A\u0011IAx\u0011\u001d\ti\u0010\u0001C!\u0003\u007fDq!!@\u0001\t\u0003\u0012Y\u0001C\u0004\u0003\u001a\u0001!\tEa\u0007\t\u000f\tE\u0003\u0001\"\u0011\u0003T!9!\u0011\u000b\u0001\u0005B\t\u0015\u0004\"\u0003BA\u0001E\u0005I\u0011\u0001BB\u0011\u001d\u0011Y\n\u0001C\u0005\u0005;CqA!1\u0001\t\u0003\u0011\u0019\rC\u0004\u0003P\u0002!\tA!5\t\u000f\t]\u0007\u0001\"\u0001\u0003Z\"I!\u0011 \u0001\u0012\u0002\u0013\u0005!1 \u0005\b\u0005\u007f\u0004A\u0011IB\u0001\u0011\u001d\u0011y\u0010\u0001C!\u0007'Aqa!\u000e\u0001\t\u0003\u001a9\u0004C\u0004\u0004@\u0001!Ia!\u0011\t\u000f\r-\u0004\u0001\"\u0011\u0004n!911\u000f\u0001\u0005\u0002\rU\u0004bBBA\u0001\u0011\u000511\u0011\u0005\b\u0007\u000f\u0003A\u0011IBE\u0011\u001d\u0019i\n\u0001C\u0005\u0007?Cqaa0\u0001\t\u0003\u001a\t\rC\u0004\u0004H\u0002!\te!3\t\u000f\rE\u0007\u0001\"\u0003\u0004T\u001e91q\\!\t\u0002\r\u0005hA\u0002!B\u0011\u0003\u0019\u0019\u000fC\u0004\u0002\u000eA\"\ta!:\u0007\r\r\u001d\b'BBu\u0011)\u0019YO\rB\u0001B\u0003%!q\u0007\u0005\b\u0003\u001b\u0011D\u0011ABw\u0011\u001d\u0019)P\rC\u0001\u0007oDqa!?3\t\u0003\u0019Y\u0010C\u0005\u0005\u0002A\n\t\u0011b\u0003\u0005\u0004\u00191Aq\u0001\u0019\u0006\t\u0013A!\u0002b\u00039\u0005\u0003\u0005\u000b\u0011BA=\u0011\u001d\ti\u0001\u000fC\u0001\t\u001bA\u0011B!\u000e9\u0005\u0004%I\u0001b\u0005\t\u0011\u0011U\u0001\b)A\u0005\u0005oAqa!>9\t\u0003\u00199\u0010C\u0004\u0005\u0018a\"\t\u0001\"\u0007\t\u0013\u0011\r\u0002'!A\u0005\f\u0011\u0015\"AG*rY\u000e{gNZ5hkJ\fG/[8o%\u0016\u0004xn]5u_JL(B\u0001\"D\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\t\u0016\u000b!B]3q_NLGo\u001c:z\u0015\t1u)A\u0005yYJ,G.Z1tK*\u0011\u0001*S\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011AS\u0001\u0004G>l7\u0001A\n\u0005\u00015\u001bv\u000b\u0005\u0002O#6\tqJC\u0001Q\u0003\u0015\u00198-\u00197b\u0013\t\u0011vJ\u0001\u0004B]f\u0014VM\u001a\t\u0003)Vk\u0011aQ\u0005\u0003-\u000e\u0013qcQ8oM&<WO]1uS>t'+\u001a9pg&$xN]=\u0011\u0005akV\"A-\u000b\u0005i[\u0016!B:mMRR'\"\u0001/\u0002\u0011\u001d\u0014\u0018N\u001f>mK\u0012L!AX-\u0003\u000f1{wmZ5oO\u0006A2m\u001c8gS\u001e,(/\u0019;j_:\u0004VM]:jgR,gnY3\u0011\u0005\u00054W\"\u00012\u000b\u0005\r$\u0017!D2p]\u001aLw-\u001e:bi&|gN\u0003\u0002f\u0003\u0006Y\u0001/\u001a:tSN$XM\\2f\u0013\t9'M\u0001\rD_:4\u0017nZ;sCRLwN\u001c)feNL7\u000f^3oG\u0016\f\u0001F]3mK\u0006\u001cXmQ8oM&<WO]1uS>t'+\u001a4fe\u0016t7-\u001a)feNL7\u000f^3oG\u0016\u0004\"!\u00196\n\u0005-\u0014'\u0001\u000b*fY\u0016\f7/Z\"p]\u001aLw-\u001e:bi&|gNU3gKJ,gnY3QKJ\u001c\u0018n\u001d;f]\u000e,\u0017\u0001\u000b;sS\u001e<WM]\"p]\u001aLw-\u001e:bi&|gNU3gKJ,gnY3QKJ\u001c\u0018n\u001d;f]\u000e,\u0007CA1o\u0013\ty'M\u0001\u0015Ue&<w-\u001a:D_:4\u0017nZ;sCRLwN\u001c*fM\u0016\u0014XM\\2f!\u0016\u00148/[:uK:\u001cW-\u0001\u000btc2\u0014V\r]8tSR|'/_!eCB$XM\u001d\t\u0003eNl\u0011!Q\u0005\u0003i\u0006\u0013AcU9m%\u0016\u0004xn]5u_JL\u0018\tZ1qi\u0016\u0014\u0018!\u00054pY\u0012,'\u000fU3sg&\u001cH/\u001a8dKB\u0011q\u000f_\u0007\u0002I&\u0011\u0011\u0010\u001a\u0002\u0012\r>dG-\u001a:QKJ\u001c\u0018n\u001d;f]\u000e,\u0017A\u0005:fY\u0016\f7/\u001a)feNL7\u000f^3oG\u0016\u0004\"a\u001e?\n\u0005u$'A\u0005*fY\u0016\f7/\u001a)feNL7\u000f^3oG\u0016\fQB[8c%\u0016\u0004xn]5u_JL\b\u0003BA\u0001\u0003\u0013i!!a\u0001\u000b\u0007\u0011\u000b)AC\u0002\u0002\b\u0015\u000b\u0011b]2iK\u0012,H.\u001a:\n\t\u0005-\u00111\u0001\u0002\u000e\u0015>\u0014'+\u001a9pg&$xN]=\u0002\rqJg.\u001b;?)A\t\t\"a\u0005\u0002\u0016\u0005]\u0011\u0011DA\u000e\u0003;\ty\u0002\u0005\u0002s\u0001!)q\f\u0003a\u0001A\")\u0001\u000e\u0003a\u0001S\")A\u000e\u0003a\u0001[\")\u0001\u000f\u0003a\u0001c\")Q\u000f\u0003a\u0001m\")!\u0010\u0003a\u0001w\")a\u0010\u0003a\u0001\u007f\u00061\"+\u0012'F\u0003N+uLU#G\u000bJ+ejQ#`)f\u0003V)\u0006\u0002\u0002&A!\u0011qEA\u001b\u001d\u0011\tI#!\r\u0011\u0007\u0005-r*\u0004\u0002\u0002.)\u0019\u0011qF&\u0002\rq\u0012xn\u001c;?\u0013\r\t\u0019dT\u0001\u0007!J,G-\u001a4\n\t\u0005]\u0012\u0011\b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005Mr*A\fS\u000b2+\u0015iU#`%\u00163UIU#O\u0007\u0016{F+\u0017)FA\u00059B+R'Q\u0019\u0006#Vi\u0018*F\r\u0016\u0013VIT\"F?RK\u0006+R\u0001\u0019)\u0016k\u0005\u000bT!U\u000b~\u0013VIR#S\u000b:\u001bUi\u0018+Z!\u0016\u0003\u0013A\u0006+S\u0013\u001e;UIU0S\u000b\u001a+%+\u0012(D\u000b~#\u0016\fU#\u0002/Q\u0013\u0016jR$F%~\u0013VIR#S\u000b:\u001bUi\u0018+Z!\u0016\u0003\u0013a\u0005+B'.{&+\u0012$F%\u0016s5)R0U3B+\u0015\u0001\u0006+B'.{&+\u0012$F%\u0016s5)R0U3B+\u0005%\u0001\u0004nCB\u0004XM]\u000b\u0003\u0003\u001b\u0002B!a\u0014\u0002^5\u0011\u0011\u0011\u000b\u0006\u0005\u0003'\n)&\u0001\u0005eCR\f'-\u001b8e\u0015\u0011\t9&!\u0017\u0002\u000f)\f7m[:p]*\u0019\u00111L%\u0002\u0013\u0019\f7\u000f^3sq6d\u0017\u0002BA0\u0003#\u0012Ab\u00142kK\u000e$X*\u00199qKJ\fq!\\1qa\u0016\u0014\b%\u0001\u0004de\u0016\fG/Z\u000b\u0005\u0003O\ni\u0007\u0006\u0003\u0002j\u0005\u0015\u0005\u0003BA6\u0003[b\u0001\u0001B\u0004\u0002pM\u0011\r!!\u001d\u0003\u0003Q\u000bB!a\u001d\u0002zA\u0019a*!\u001e\n\u0007\u0005]tJA\u0004O_RD\u0017N\\4\u0011\t\u0005m\u0014\u0011Q\u0007\u0003\u0003{R1!a F\u0003\u0019!w.\\1j]&!\u00111QA?\u0005E\u0011\u0015m]3D_:4\u0017nZ;sCRLwN\u001c\u0005\u0007GN\u0001\r!!\u001b)\u0007M\tI\t\u0005\u0003\u0002\f\u0006eUBAAG\u0015\u0011\ty)!%\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0003\u0002\u0014\u0006U\u0015aB7fiJL7m\u001d\u0006\u0004\u0003/K\u0015\u0001C2pI\u0006D\u0017\r\\3\n\t\u0005m\u0015Q\u0012\u0002\u0006)&lW\rZ\u000b\u0005\u0003?\u000b\u0019\u000b\u0006\u0004\u0002\"\u0006\u0015\u0016q\u0015\t\u0005\u0003W\n\u0019\u000bB\u0004\u0002pQ\u0011\r!!\u001d\t\r\r$\u0002\u0019AAQ\u0011\u001d\tI\u000b\u0006a\u0001\u0003W\u000b1BZ8mI\u0016\u00148)[+jIB!\u0011QVAf\u001d\u0011\ty+a2\u000f\t\u0005E\u0016Q\u0019\b\u0005\u0003g\u000b\u0019M\u0004\u0003\u00026\u0006\u0005g\u0002BA\\\u0003\u007fsA!!/\u0002>:!\u00111FA^\u0013\u0005Q\u0015B\u0001%J\u0013\t1u)\u0003\u0002E\u000b&\u0011!iQ\u0005\u0003K\u0006K1!!3e\u0003\u001d\u0001\u0018mY6bO\u0016LA!!4\u0002P\n)1)[+jI*\u0019\u0011\u0011\u001a3)\u0007Q\tI)\u0001\bhKR4u\u000e\u001c3fe\u000eKW+\u001b3\u0015\t\u0005-\u0016q\u001b\u0005\b\u00033,\u0002\u0019AA\u0013\u0003!1w\u000e\u001c3fe&#\u0017\u0001E2iK\u000e\\7)\u0019:eS:\fG.\u001b;z+\u0011\ty.a;\u0015\t\u0005\u0005\u0018q\u001d\t\u0004\u001d\u0006\r\u0018bAAs\u001f\n!QK\\5u\u0011\u0019\u0019g\u00031\u0001\u0002jB!\u00111NAv\t\u001d\tyG\u0006b\u0001\u0003c\nAA]3bIV!\u0011\u0011_A{)\u0011\t\u00190a>\u0011\t\u0005-\u0014Q\u001f\u0003\b\u0003_:\"\u0019AA9\u0011\u001d\tIp\u0006a\u0001\u0003K\tqbY8oM&<WO]1uS>t\u0017\n\u001a\u0015\u0004/\u0005%\u0015AB;qI\u0006$X-\u0006\u0003\u0003\u0002\t\u0015A\u0003\u0002B\u0002\u0005\u000f\u0001B!a\u001b\u0003\u0006\u00119\u0011q\u000e\rC\u0002\u0005E\u0004BB2\u0019\u0001\u0004\u0011\u0019\u0001K\u0002\u0019\u0003\u0013+BA!\u0004\u0003\u0012Q1!q\u0002B\n\u0005+\u0001B!a\u001b\u0003\u0012\u00119\u0011qN\rC\u0002\u0005E\u0004BB2\u001a\u0001\u0004\u0011y\u0001C\u0004\u0002*f\u0001\r!a+)\u0007e\tI)A\u0007gS:$\u0017\t\u001c7CsRK\b/Z\u000b\u0005\u0005;\u0011\t\u0004\u0006\u0003\u0003 \tM\u0002C\u0002B\u0011\u0005W\u0011y#\u0004\u0002\u0003$)!!Q\u0005B\u0014\u0003\u0011)H/\u001b7\u000b\u0005\t%\u0012\u0001\u00026bm\u0006LAA!\f\u0003$\t!A*[:u!\u0011\tYG!\r\u0005\u000f\u0005=$D1\u0001\u0002r!9!Q\u0007\u000eA\u0002\t]\u0012AB2j)f\u0004X\r\u0005\u0003\u0003:\t-SB\u0001B\u001e\u0015\u0011\u0011iDa\u0010\u0002\u000fI,g\r\\3di*!!\u0011\tB\"\u0003\r\t\u0007/\u001b\u0006\u0005\u0005\u000b\u00129%\u0001\u0004qYV<\u0017N\u001c\u0006\u0004\u0005\u0013:\u0015\u0001\u00033fa2|\u00170\u001b;\n\t\t5#1\b\u0002\u0005)f\u0004X\rK\u0002\u001b\u0003\u0013\u000bQCZ5oI\u0006cGNQ=UsB,\u0017I\u001c3USRdW-\u0006\u0003\u0003V\tmCC\u0002B,\u0005;\u0012y\u0006\u0005\u0004\u0003\"\t-\"\u0011\f\t\u0005\u0003W\u0012Y\u0006B\u0004\u0002pm\u0011\r!!\u001d\t\u000f\tU2\u00041\u0001\u00038!9!\u0011M\u000eA\u0002\u0005\u0015\u0012!\u0002;ji2,\u0007fA\u000e\u0002\nV!!q\rB7))\u0011IGa\u001c\u0003r\tM$Q\u000f\t\u0007\u0005C\u0011YCa\u001b\u0011\t\u0005-$Q\u000e\u0003\b\u0003_b\"\u0019AA9\u0011\u001d\u0011)\u0004\ba\u0001\u0005oA\u0011B!\u0019\u001d!\u0003\u0005\r!!\n\t\u000f\u0005eG\u00041\u0001\u0002&!9!q\u000f\u000fA\u0002\te\u0014A\u00034pY\u0012,'o\u00148msB\u0019aJa\u001f\n\u0007\tutJA\u0004C_>dW-\u00198)\u0007q\tI)A\u0010gS:$\u0017\t\u001c7CsRK\b/Z!oIRKG\u000f\\3%I\u00164\u0017-\u001e7uII*BA!\"\u0003\u001aV\u0011!q\u0011\u0016\u0005\u0003K\u0011Ii\u000b\u0002\u0003\fB!!Q\u0012BK\u001b\t\u0011yI\u0003\u0003\u0003\u0012\nM\u0015!C;oG\",7m[3e\u0015\r\tyiT\u0005\u0005\u0005/\u0013yIA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016$q!a\u001c\u001e\u0005\u0004\t\t(A\tsK\u0006$7i\u001c8gS\u001e,(/\u0019;j_:,BAa(\u0003*R!!\u0011\u0015BV!\u0015q%1\u0015BT\u0013\r\u0011)k\u0014\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005-$\u0011\u0016\u0003\b\u0003_r\"\u0019AA9\u0011\u001d\u0011iK\ba\u0001\u0005_\u000b1A]8x!\u0011\u0011\tLa/\u000f\t\tM&q\u0017\b\u0005\u0003_\u0013),\u0003\u0002dI&\u0019!\u0011\u00182\u00021\r{gNZ5hkJ\fG/[8o!\u0016\u00148/[:uK:\u001cW-\u0003\u0003\u0003>\n}&\u0001E\"p]\u001aLw-\u001e:bi&|gNU8x\u0015\r\u0011ILY\u0001\tM&tGMQ=JIV!!Q\u0019Bf)\u0011\t\tOa2\t\u000f\t%w\u00041\u0001\u0002&\u0005A1m\u001c8gS\u001eLE\rB\u0004\u0002p}\u0011\r!!\u001d)\u0007}\tI)\u0001\u000egS:$7i\u001c8gS\u001e,(/\u0019;j_:$\u0016\u000e\u001e7f\u0005fLE\r\u0006\u0003\u0002&\tM\u0007b\u0002BeA\u0001\u0007\u0011Q\u0005\u0015\u0004A\u0005%\u0015\u0001F3ySN$8OQ=UsB,\u0017I\u001c3USRdW-\u0006\u0003\u0003\\\n\u0005HC\u0002B=\u0005;\u0014y\u000eC\u0004\u00036\u0005\u0002\rAa\u000e\t\u0013\t\u0005\u0014\u0005%AA\u0002\u0005\u0015BaBA8C\t\u0007\u0011\u0011\u000f\u0015\u0004C\t\u0015\b\u0003\u0002Bt\u0005gl!A!;\u000b\t\t-(Q^\u0001\fiJ\fgn]1di&|gNC\u0002C\u0005_T1A!=F\u0003\t!'-\u0003\u0003\u0003v\n%(AC%t%\u0016\fGm\u00148ms\"\u001a\u0011%!#\u0002=\u0015D\u0018n\u001d;t\u0005f$\u0016\u0010]3B]\u0012$\u0016\u000e\u001e7fI\u0011,g-Y;mi\u0012\u0012T\u0003\u0002BC\u0005{$q!a\u001c#\u0005\u0004\t\t(A\bgS:$g)\u001b:ti\nKH+\u001f9f+\u0011\u0019\u0019a!\u0004\u0015\t\r\u00151q\u0002\t\u0007\u0005C\u00199aa\u0003\n\t\r%!1\u0005\u0002\t\u001fB$\u0018n\u001c8bYB!\u00111NB\u0007\t\u001d\tyg\tb\u0001\u0003cBqA!\u000e$\u0001\u0004\u00119\u0004K\u0002$\u0003\u0013+Ba!\u0006\u0004\u001cQ11qCB\u000f\u0007?\u0001bA!\t\u0004\b\re\u0001\u0003BA6\u00077!q!a\u001c%\u0005\u0004\t\t\bC\u0004\u00036\u0011\u0002\rAa\u000e\t\u000f\r\u0005B\u00051\u0001\u0004$\u000591m\u001c8uKb$\b\u0003BB\u0013\u0007_i!aa\n\u000b\t\r%21F\u0001\u000eg\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8\u000b\t\r5\"qI\u0001\ta2,XNY5oO&!1\u0011GB\u0014\u0005E\u0011Vm]8mkRLwN\\\"p]R,\u0007\u0010\u001e\u0015\u0004I\u0005%\u0015AB3ySN$8\u000f\u0006\u0003\u0003z\re\u0002bBA}K\u0001\u0007\u0011Q\u0005\u0015\u0004K\t\u0015\bfA\u0013\u0002\n\u00069r-\u001a;D_:4\u0017n\u001a*fM\u0016\u0014XM\\2fIJ{wo\u001d\u000b\u0007\u0007\u0007\u001ayf!\u0019\u0011\r\r\u00153QJB*\u001d\u0011\u00199ea\u0013\u000f\t\u0005-2\u0011J\u0005\u0002!&\u0019\u0011\u0011Z(\n\t\r=3\u0011\u000b\u0002\u0004'\u0016\f(bAAe\u001fB!1QKB.\u001b\t\u00199FC\u0002\u0004Z\u0011\fA\u0001Z1uC&!1QLB,\u0005e\u0019uN\u001c4jOV\u0014\u0018\r^5p]J+g-\u001a:f]\u000e,'k\\<\t\u000f\u0005eh\u00051\u0001\u0002&!911\r\u0014A\u0002\r\u0015\u0014!I2p]\u001aLw-\u001e:bi&|gNU3gKJ,gnY3QKJ\u001c\u0018n\u001d;f]\u000e,\u0007cA1\u0004h%\u00191\u0011\u000e2\u0003C\r{gNZ5hkJ\fG/[8o%\u00164WM]3oG\u0016\u0004VM]:jgR,gnY3\u0002\r\u0011,G.\u001a;f)\u0011\t\toa\u001c\t\u000f\u0005ex\u00051\u0001\u0002&!\u001aq%!#\u0002-\u001d,GOS8c%Vtg.\u001a:SK\u001a,'/\u001a8dKN$Baa\u001e\u0004\u0000A11QIB'\u0007s\u00022A]B>\u0013\r\u0019i(\u0011\u0002\u0011%\u00164WM]3oG\u0016$WI\u001c;jifDq!!?)\u0001\u0004\t)#\u0001\u000fhKR\u001cuN\u001c4jOJ+g-\u001a:f]\u000e,7/\u00138SK2,\u0017m]3\u0015\t\r]4Q\u0011\u0005\b\u0003sL\u0003\u0019AA\u0013\u0003Q9W\r\u001e*fM\u0016\u0014XM\\2f%\u0016dW-Y:fgR!11RBM!\u0019\u0011\tCa\u000b\u0004\u000eB!1qRBK\u001b\t\u0019\tJC\u0002\u0004\u0014\u000e\u000bQ!];fefLAaa&\u0004\u0012\n\u0001\"+\u001a7fCN,')Y:jG\u0012\u000bG/\u0019\u0005\b\u0003sT\u0003\u0019AA\u0013Q\rQ\u0013\u0011R\u0001\u0011O\u0016$\u0018\t\u001c7Tk\n$\u0016\u0010]3t\u001f\u001a,Ba!)\u0004>R!11UB^!\u0019\u0019)ka,\u000426\u00111q\u0015\u0006\u0005\u0007S\u001bY+A\u0005j[6,H/\u00192mK*\u00191QV(\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0004P\r\u001d\u0006\u0003BBZ\u0007sk!a!.\u000b\t\r]&qE\u0001\u0005Y\u0006tw-\u0003\u0003\u00028\rU\u0006b\u0002B\u001bW\u0001\u0007!q\u0007\u0003\b\u0003_Z#\u0019AA9\u0003-9W\r^!mYRK\b/Z:\u0016\u0005\r\r\u0007CBB#\u0007\u001b\n)\u0003K\u0002-\u0003\u0013\u000bQ\u0002Z3mKR,')\u001f+za\u0016\u001cH\u0003BAq\u0007\u0017Dqa!4.\u0001\u0004\u0019\u0019-A\u0004dSRK\b/Z:)\u00075\nI)\u0001\u0005wC2LG-\u0019;f)\u0011\t\to!6\t\r\rt\u0003\u0019AA=Q\r\u00011\u0011\u001c\t\u0005\u0005O\u001cY.\u0003\u0003\u0004^\n%(aD%t)J\fgn]1di&|g.\u00197\u00025M\u000bHnQ8oM&<WO]1uS>t'+\u001a9pg&$xN]=\u0011\u0005I\u00044C\u0001\u0019N)\t\u0019\tOA\u0004UsB,w\n]:\u0014\u0005Ij\u0015A\u0002=m)f\u0004X\r\u0006\u0003\u0004p\u000eM\bcABye5\t\u0001\u0007C\u0004\u0004lR\u0002\rAa\u000e\u0002\u001d!\f7oQ1sI&t\u0017\r\\5usV\u0011!\u0011P\u0001\fQ\u0006\u001c\bK]8qKJ$\u0018\u0010\u0006\u0003\u0003z\ru\bbBB\u0000m\u0001\u0007\u0011QE\u0001\raJ|\u0007/\u001a:us:\u000bW.Z\u0001\b)f\u0004Xm\u00149t)\u0011\u0019y\u000f\"\u0002\t\u000f\r-x\u00071\u0001\u00038\t!\")Y:f\u0007>tg-[4ve\u0006$\u0018n\u001c8PaN\u001c\"\u0001O'\u0002\u0005\rLG\u0003\u0002C\b\t#\u00012a!=9\u0011\u001d!YA\u000fa\u0001\u0003s*\"Aa\u000e\u0002\u000f\rLG+\u001f9fA\u0005qq-\u001a;DCJ$\u0017N\\1mSRLXC\u0001C\u000e!\u0015q%1\u0015C\u000f!\rqEqD\u0005\u0004\tCy%aA%oi\u0006!\")Y:f\u0007>tg-[4ve\u0006$\u0018n\u001c8PaN$B\u0001b\u0004\u0005(!9A1B A\u0002\u0005e\u0004")
public class SqlConfigurationRepository
implements ConfigurationRepository,
Logging {
    private final ConfigurationPersistence configurationPersistence;
    private final ReleaseConfigurationReferencePersistence releaseConfigurationReferencePersistence;
    private final TriggerConfigurationReferencePersistence triggerConfigurationReferencePersistence;
    private final SqlRepositoryAdapter sqlRepositoryAdapter;
    private final FolderPersistence folderPersistence;
    private final ReleasePersistence releasePersistence;
    private final JobRepository jobRepository;
    private final String RELEASE_REFERENCE_TYPE;
    private final String TEMPLATE_REFERENCE_TYPE;
    private final String TRIGGER_REFERENCE_TYPE;
    private final String TASK_REFERENCE_TYPE;
    private final ObjectMapper mapper;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private scala.collection.immutable.Seq<PersistenceInterceptor<BaseConfiguration>> persistenceInterceptors;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    public ThemeSettings getThemeSettings() {
        return ConfigurationRepository.getThemeSettings$((ConfigurationRepository)this);
    }

    public void registerPersistenceInterceptor(PersistenceInterceptor<BaseConfiguration> persistenceInterceptor) {
        InterceptedRepository.registerPersistenceInterceptor$((InterceptedRepository)this, persistenceInterceptor);
    }

    public void interceptCreate(ConfigurationItem ci) {
        InterceptedRepository.interceptCreate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void interceptDelete(String ciId) {
        InterceptedRepository.interceptDelete$((InterceptedRepository)this, (String)ciId);
    }

    public void interceptUpdate(ConfigurationItem ci) {
        InterceptedRepository.interceptUpdate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterCreate(ConfigurationItem ci) {
        InterceptedRepository.afterCreate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterUpdate(ConfigurationItem ci) {
        InterceptedRepository.afterUpdate$((InterceptedRepository)this, (ConfigurationItem)ci);
    }

    public void afterDelete(String ciId) {
        InterceptedRepository.afterDelete$((InterceptedRepository)this, (String)ciId);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlConfigurationRepository sqlConfigurationRepository = this;
        synchronized (sqlConfigurationRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    public scala.collection.immutable.Seq<PersistenceInterceptor<BaseConfiguration>> persistenceInterceptors() {
        return this.persistenceInterceptors;
    }

    public void persistenceInterceptors_$eq(scala.collection.immutable.Seq<PersistenceInterceptor<BaseConfiguration>> x$1) {
        this.persistenceInterceptors = x$1;
    }

    private String RELEASE_REFERENCE_TYPE() {
        return this.RELEASE_REFERENCE_TYPE;
    }

    private String TEMPLATE_REFERENCE_TYPE() {
        return this.TEMPLATE_REFERENCE_TYPE;
    }

    private String TRIGGER_REFERENCE_TYPE() {
        return this.TRIGGER_REFERENCE_TYPE;
    }

    private String TASK_REFERENCE_TYPE() {
        return this.TASK_REFERENCE_TYPE;
    }

    private ObjectMapper mapper() {
        return this.mapper;
    }

    @Timed
    public <T extends BaseConfiguration> T create(T configuration) {
        return this.create(configuration, this.getFolderCiUid(configuration.getFolderId()));
    }

    @Timed
    public <T extends BaseConfiguration> T create(T configuration, Integer folderCiUid) {
        this.checkCardinality(configuration);
        this.validate(configuration);
        this.interceptCreate((ConfigurationItem)configuration);
        this.configurationPersistence.insert(configuration, folderCiUid);
        this.afterCreate((ConfigurationItem)configuration);
        return configuration;
    }

    private Integer getFolderCiUid(String folderId) {
        Integer n;
        block3: {
            String string = folderId;
            switch (string == null ? 0 : string.hashCode()) {
                case 0: {
                    if (string != null) break;
                    n = null;
                    break block3;
                }
            }
            n = this.folderPersistence.getUid(string);
        }
        return n;
    }

    private <T extends BaseConfiguration> void checkCardinality(T configuration) {
        Type configurationType = Type.valueOf(BaseConfiguration.class);
        if (SqlConfigurationRepository$.MODULE$.com$xebialabs$xlrelease$repository$sql$SqlConfigurationRepository$$BaseConfigurationOps(configuration).hasCardinality()) {
            Type configGroupType = (Type)SqlConfigurationRepository.groupType$1(configuration, configurationType).getOrElse((Function0 & Serializable)() -> configuration.getType());
            Buffer foundConfigs = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(this.findAllByTypeAndTitle(configGroupType, null, configuration.getFolderId(), false)).asScala().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SqlConfigurationRepository.$anonfun$checkCardinality$3(configuration, x$1)));
            Option<Object> cardinality = SqlConfigurationRepository$.MODULE$.com$xebialabs$xlrelease$repository$sql$SqlConfigurationRepository$$BaseConfigurationOps(configuration).getCardinality();
            if (cardinality.isDefined() && foundConfigs.size() >= BoxesRunTime.unboxToInt((Object)cardinality.get())) {
                String folderId = configuration.getFolderId() == null ? Ids.ROOT_FOLDER_ID : configuration.getFolderId();
                throw new ItemAlreadyExistsException("There are already " + foundConfigs.length() + " items of type '" + configGroupType + "' defined on the folder '" + folderId + "'", new Object[0]);
            }
        }
    }

    @Timed
    public <T extends BaseConfiguration> T read(String configurationId) {
        return (T)((BaseConfiguration)Option$.MODULE$.apply(this.sqlRepositoryAdapter.read(configurationId)).getOrElse((Function0 & Serializable)() -> {
            throw new NotFoundException("Configuration " + configurationId + " not found", new Object[0]);
        }));
    }

    @Timed
    public <T extends BaseConfiguration> T update(T configuration) {
        return this.update(configuration, this.getFolderCiUid(configuration.getFolderId()));
    }

    @Timed
    public <T extends BaseConfiguration> T update(T configuration, Integer folderCiUid) {
        this.validate(configuration);
        this.interceptUpdate((ConfigurationItem)configuration);
        this.configurationPersistence.update(configuration);
        this.afterUpdate((ConfigurationItem)configuration);
        return configuration;
    }

    @Timed
    public <T extends BaseConfiguration> List<T> findAllByType(Type ciType) {
        return CollectionConverters$.MODULE$.BufferHasAsJava(((IterableOnceOps)this.configurationPersistence.findByTypes(this.getAllSubTypesOf(ciType)).flatMap((Function1 & Serializable)row -> this.readConfiguration((Tuple2<Option<FolderId>, String>)row))).toBuffer()).asJava();
    }

    @Timed
    public <T extends BaseConfiguration> List<T> findAllByTypeAndTitle(Type ciType, String title) {
        return this.findAllByTypeAndTitle(ciType, title, null, false);
    }

    @Timed
    public <T extends BaseConfiguration> List<T> findAllByTypeAndTitle(Type ciType, String title, String folderId, boolean folderOnly) {
        return CollectionConverters$.MODULE$.BufferHasAsJava(((IterableOnceOps)this.configurationPersistence.findByTypesTitleAndFolder(this.getAllSubTypesOf(ciType), (Option<String>)Option$.MODULE$.apply((Object)title).filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$2.trim())))), (Option<Either<String, String>>)Option$.MODULE$.apply((Object)folderId).map((Function1)(folderOnly ? (Function1 & Serializable)value -> package$.MODULE$.Right().apply(value) : (Function1 & Serializable)value -> package$.MODULE$.Left().apply(value)))).flatMap((Function1 & Serializable)row -> this.readConfiguration((Tuple2<Option<FolderId>, String>)row))).toBuffer()).asJava();
    }

    public <T extends BaseConfiguration> String findAllByTypeAndTitle$default$2() {
        return null;
    }

    private <T extends BaseConfiguration> Option<T> readConfiguration(Tuple2<Option<FolderId>, String> row) {
        Tuple2<Option<FolderId>, String> tuple2 = row;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Option folderIdOpt = (Option)tuple2._1();
        String rawConfiguration = (String)tuple2._2();
        Option option = this.sqlRepositoryAdapter.deserialize(rawConfiguration).map((Function1 & Serializable)conf -> (BaseConfiguration)folderIdOpt.fold((Function0 & Serializable)() -> conf, (Function1 & Serializable)folderId -> {
            conf.setFolderId(folderId.absolute());
            return conf;
        }));
        return option;
    }

    @Timed
    public <T extends BaseConfiguration> void findById(String configId) {
        this.configurationPersistence.findById(configId);
    }

    @Timed
    public String findConfigurationTitleById(String configId) {
        return this.configurationPersistence.findConfigurationTitleById(configId);
    }

    @Timed
    @IsReadOnly
    public <T extends BaseConfiguration> boolean existsByTypeAndTitle(Type ciType, String title) {
        return this.configurationPersistence.existsByTypeAndTitle(this.getAllSubTypesOf(ciType), title);
    }

    @Timed
    public <T extends BaseConfiguration> Optional<T> findFirstByType(Type ciType) {
        return this.findFirstByType(ciType, ResolutionContext$.MODULE$.GLOBAL());
    }

    @Timed
    public <T extends BaseConfiguration> Optional<T> findFirstByType(Type ciType, ResolutionContext context) {
        return OptionConverters.RichOption$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOption(this.configurationPersistence.findFirstByTypes(this.getAllSubTypesOf(ciType), (Option<String>)context.folderId()).flatMap((Function1 & Serializable)row -> this.readConfiguration((Tuple2<Option<FolderId>, String>)row))));
    }

    @Timed
    @IsReadOnly
    public boolean exists(String configurationId) {
        return this.configurationPersistence.exists(configurationId);
    }

    public <T extends BaseConfiguration> String existsByTypeAndTitle$default$2() {
        return null;
    }

    private scala.collection.immutable.Seq<ConfigurationReferenceRow> getConfigReferencedRows(String configurationId, ConfigurationReferencePersistence configurationReferencePersistence) {
        return configurationReferencePersistence.isReferenced(configurationId) ? configurationReferencePersistence.getReferencingEntities(configurationId) : (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
    }

    @Timed
    public void delete(String configurationId) {
        if (this.exists(configurationId)) {
            SeqOps seqOps;
            scala.collection.immutable.Seq allReferences;
            scala.collection.immutable.Seq seq;
            Object config = this.read(configurationId);
            if (config.getType().isSubTypeOf(Type.valueOf(JobRunner.class))) {
                seq = this.getJobRunnerReferences(configurationId);
            } else {
                scala.collection.immutable.Seq<ReferencedEntity> configReferencesInRelease = this.getConfigReferencesInRelease(configurationId);
                scala.collection.immutable.Seq configReferencesInTrigger = (scala.collection.immutable.Seq)this.getConfigReferencedRows(configurationId, this.triggerConfigurationReferencePersistence).map((Function1 & Serializable)configRef -> new ReferencedEntity(configRef.id(), configRef.title(), this.TRIGGER_REFERENCE_TYPE()));
                seq = (scala.collection.immutable.Seq)configReferencesInRelease.$plus$plus((IterableOnce)configReferencesInTrigger);
            }
            scala.collection.immutable.Seq seq2 = allReferences = seq;
            if (seq2 != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq(seq2)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0) == 0) {
                this.interceptDelete(configurationId);
                this.configurationPersistence.delete(configurationId);
                this.afterDelete(configurationId);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                this.mapper().registerModule((Module)DefaultScalaModule$.MODULE$);
                String json = this.mapper().writeValueAsString((Object)allReferences);
                throw new ItemInUseException("%s", new Object[]{json});
            }
        }
    }

    public scala.collection.immutable.Seq<ReferencedEntity> getJobRunnerReferences(String configurationId) {
        JobFilters jobFilters = new JobFilters();
        jobFilters.runnerId_$eq(configurationId);
        Page jobs = this.jobRepository.findAllJobOverview(jobFilters, Pageable.unpaged());
        return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(jobs.getContent()).asScala().map((Function1 & Serializable)overview -> new ReferencedEntity(overview.taskId(), overview.taskTitle(), this.TASK_REFERENCE_TYPE()))).toSeq();
    }

    public scala.collection.immutable.Seq<ReferencedEntity> getConfigReferencesInRelease(String configurationId) {
        scala.collection.immutable.Seq<ConfigurationReferenceRow> configReferences = this.getConfigReferencedRows(configurationId, this.releaseConfigurationReferencePersistence);
        scala.collection.immutable.Seq ids = (scala.collection.immutable.Seq)configReferences.map((Function1 & Serializable)ref -> Ids.getFolderlessId((String)ref.id()));
        scala.collection.immutable.Seq statusesWithIds = ids.isEmpty() ? (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)Nil$.MODULE$) : (scala.collection.immutable.Seq)this.releasePersistence.findReleaseStatuses((scala.collection.immutable.Seq<String>)ids).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String id = (String)tuple2._1();
            String status = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)id, (Object)ReleaseStatus.valueOf((String)status.toUpperCase()));
            return tuple22;
        });
        scala.collection.immutable.Seq configRefsWithFolderlessIds = (scala.collection.immutable.Seq)configReferences.map((Function1 & Serializable)ref -> new ConfigurationReferenceRow(ref.title(), ref.id()));
        return (scala.collection.immutable.Seq)configRefsWithFolderlessIds.map((Function1 & Serializable)reference -> {
            String folderlessId = Ids.getFolderlessId((String)reference.id());
            ReleaseStatus status = (ReleaseStatus)((Tuple2)((IterableOps)statusesWithIds.filter((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)SqlConfigurationRepository.$anonfun$getConfigReferencesInRelease$5(folderlessId, t)))).head())._2();
            ReleaseStatus releaseStatus = status;
            String string = ReleaseStatus.TEMPLATE.equals(releaseStatus) ? this.TEMPLATE_REFERENCE_TYPE() : this.RELEASE_REFERENCE_TYPE();
            String referencedBy = string;
            return new ReferencedEntity(reference.id(), reference.title(), referencedBy);
        });
    }

    @Timed
    public List<ReleaseBasicData> getReferenceReleases(String configurationId) {
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)this.releaseConfigurationReferencePersistence.getReferencingEntities(configurationId).map((Function1 & Serializable)x$3 -> ConfigurationReferenceRow$.MODULE$.ConfigurationReferenceDataOps((ConfigurationReferenceRow)x$3).asReleaseData())).asJava();
    }

    private <T extends BaseConfiguration> scala.collection.immutable.Seq<String> getAllSubTypesOf(Type ciType) {
        return (scala.collection.immutable.Seq)TypeHelper$.MODULE$.getAllSubtypesOf(ciType).map((Function1 & Serializable)x$4 -> x$4.toString());
    }

    @Timed
    public scala.collection.immutable.Seq<String> getAllTypes() {
        return this.configurationPersistence.findAllConfigurationTypes();
    }

    @Timed
    public void deleteByTypes(scala.collection.immutable.Seq<String> ciTypes) {
        scala.collection.immutable.Seq<Integer> configurationCiUids = this.configurationPersistence.findUidsByTypes(ciTypes);
        this.releaseConfigurationReferencePersistence.deleteRefsByConfigurationUids(configurationCiUids);
        this.triggerConfigurationReferencePersistence.deleteRefsByConfigurationUids(configurationCiUids);
        this.configurationPersistence.deleteByTypes(ciTypes);
    }

    private void validate(BaseConfiguration configuration) {
        ListBuffer passVarUsagePoints = ListBuffer$.MODULE$.empty();
        BaseConfiguration baseConfiguration = configuration;
        if (baseConfiguration instanceof Configuration) {
            Configuration configuration2 = (Configuration)baseConfiguration;
            ConfigurationVariableService$.MODULE$.getUsagePointsByVars((Iterable)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Configuration[]{configuration2}))).values().foreach((Function1 & Serializable)usagePoints -> {
                usagePoints.foreach((Function1 & Serializable)up -> {
                    CiProperty targetProperty = up.getTargetProperty();
                    PropertyDescriptor desc = targetProperty.getDescriptor();
                    PropertyKind propertyKind = desc.getKind();
                    PropertyKind propertyKind2 = PropertyKind.STRING;
                    Checks.checkArgument((!(propertyKind != null ? !propertyKind.equals(propertyKind2) : propertyKind2 != null) && desc.isPassword() ? 1 : 0) != 0, (String)"Non-password-type variables in configuration variableMapping are not supported", (Object[])new Object[0]);
                    targetProperty.setValue((Object)"<temporary_value>");
                    return (ListBuffer)passVarUsagePoints$1.$plus$eq(up);
                });
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        Descriptor desc = configuration.getType().getDescriptor();
        ExtendedValidationContextImpl extendedValidationContext = new ExtendedValidationContextImpl((ConfigurationItem)configuration);
        desc.validate((ExtendedValidationContext)extendedValidationContext, (ConfigurationItem)configuration);
        List messages = extendedValidationContext.getMessages();
        Object object = !messages.isEmpty() ? BoxesRunTime.boxToBoolean((boolean)configuration.get$validationMessages().addAll(messages)) : BoxedUnit.UNIT;
        if (!configuration.get$validationMessages().isEmpty()) {
            throw new XlrValidationsFailedException((ConfigurationItem)configuration);
        }
        passVarUsagePoints.toList().foreach((Function1 & Serializable)up -> {
            SqlConfigurationRepository.$anonfun$validate$3(up);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$checkCardinality$1(Type configurationType$1, BaseConfiguration configuration$1, Type superType) {
        if (!superType.isSubTypeOf(configurationType$1)) return false;
        if (!SqlConfigurationRepository$.MODULE$.com$xebialabs$xlrelease$repository$sql$SqlConfigurationRepository$$TypeOps(superType).hasCardinality()) return false;
        Integer n = BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)superType.getDescriptor().getPropertyDescriptor("cardinality").getDefaultValue()));
        Option<Object> option = SqlConfigurationRepository$.MODULE$.com$xebialabs$xlrelease$repository$sql$SqlConfigurationRepository$$BaseConfigurationOps(configuration$1).getCardinality();
        if (n != null) {
            if (!((Object)n).equals(option)) return false;
            return true;
        }
        if (option == null) return true;
        return false;
    }

    private static final Option groupType$1(BaseConfiguration configuration, Type configurationType$1) {
        List superClasses = configuration.getType().getDescriptor().getSuperClasses();
        return CollectionConverters$.MODULE$.ListHasAsScala(superClasses).asScala().find((Function1 & Serializable)superType -> BoxesRunTime.boxToBoolean((boolean)SqlConfigurationRepository.$anonfun$checkCardinality$1(configurationType$1, configuration, superType)));
    }

    public static final /* synthetic */ boolean $anonfun$checkCardinality$3(BaseConfiguration configuration$2, BaseConfiguration x$1) {
        String string = x$1.getFolderId();
        String string2 = configuration$2.getFolderId();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getConfigReferencesInRelease$5(String folderlessId$1, Tuple2 t) {
        return ((String)t._1()).equals(folderlessId$1);
    }

    public static final /* synthetic */ void $anonfun$validate$3(UsagePoint up) {
        up.getTargetProperty().setValue(null);
    }

    public SqlConfigurationRepository(ConfigurationPersistence configurationPersistence, ReleaseConfigurationReferencePersistence releaseConfigurationReferencePersistence, TriggerConfigurationReferencePersistence triggerConfigurationReferencePersistence, SqlRepositoryAdapter sqlRepositoryAdapter, FolderPersistence folderPersistence, ReleasePersistence releasePersistence, JobRepository jobRepository) {
        this.configurationPersistence = configurationPersistence;
        this.releaseConfigurationReferencePersistence = releaseConfigurationReferencePersistence;
        this.triggerConfigurationReferencePersistence = triggerConfigurationReferencePersistence;
        this.sqlRepositoryAdapter = sqlRepositoryAdapter;
        this.folderPersistence = folderPersistence;
        this.releasePersistence = releasePersistence;
        this.jobRepository = jobRepository;
        InterceptedRepository.$init$((InterceptedRepository)this);
        ConfigurationRepository.$init$((ConfigurationRepository)this);
        Logging.$init$((Logging)this);
        this.RELEASE_REFERENCE_TYPE = "Release";
        this.TEMPLATE_REFERENCE_TYPE = "Template";
        this.TRIGGER_REFERENCE_TYPE = "Trigger";
        this.TASK_REFERENCE_TYPE = "Task";
        this.mapper = new ObjectMapper();
    }

    private static class BaseConfigurationOps {
        private final BaseConfiguration ci;
        private final Type ciType;

        private Type ciType() {
            return this.ciType;
        }

        public boolean hasCardinality() {
            return this.ci.hasProperty("cardinality");
        }

        public Option<Object> getCardinality() {
            return this.hasCardinality() ? new Some((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)this.ciType().getDescriptor().getPropertyDescriptor("cardinality").getDefaultValue()))) : None$.MODULE$;
        }

        public BaseConfigurationOps(BaseConfiguration ci) {
            this.ci = ci;
            this.ciType = ci.getType();
        }
    }

    private static class TypeOps {
        private final Type xlType;

        public boolean hasCardinality() {
            return this.hasProperty("cardinality");
        }

        public boolean hasProperty(String propertyName) {
            return this.xlType.getDescriptor().getPropertyDescriptor(propertyName) != null;
        }

        public TypeOps(Type xlType) {
            this.xlType = xlType;
        }
    }
}

