package com.xebialabs.xlrelease.repository.sql.proxy


import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem
import com.xebialabs.deployit.plugin.api.udm.{ConfigurationItem, LazyConfigurationItem}
import com.xebialabs.xlrelease.repository.proxy.{CiReferenceProxyFactory, ResolvableConfigurationItemReference, ResolvableLazyConfigurationItem}
import com.xebialabs.xlrelease.serialization.json.repository.ResolverRepository
import com.xebialabs.xlrelease.support.akka.spring.ScalaSpringSupport
import grizzled.slf4j.Logging
import org.springframework.cglib.proxy.{Enhancer, Factory}
import org.springframework.context.{ApplicationContext, ApplicationContextAware}

import java.util.concurrent.ConcurrentHashMap
import scala.beans.BeanProperty
import scala.jdk.CollectionConverters._


object DefaultCiReferenceProxyFactory extends CiReferenceProxyFactory with ApplicationContextAware with ScalaSpringSupport with Logging {

  @BeanProperty
  protected var applicationContext: ApplicationContext = _

  private val proxyClassPerType: ConcurrentHashMap[Class[_], Class[_]] = new ConcurrentHashMap[Class[_], Class[_]]()

  private lazy val proxyInitializers: Seq[ProxyInstanceInitializer] = springBeans[ProxyInstanceInitializer].values().asScala.toSeq

  override def proxy(resolverRepository: ResolverRepository, ci: ResolvableConfigurationItemReference): ConfigurationItem = {
    cglibProxy(resolverRepository, ci)
  }

  private def cglibProxy(resolverRepository: ResolverRepository, ci: ResolvableConfigurationItemReference): ConfigurationItem = {
    val targetClazz = ci.targetType.getDescriptor.getClazz
    val propertyType = ci.ciReference.getProperty.getReferencedType
    logger.trace(s"Creating proxy reference ${ci.ciReference} of class ${targetClazz.getName} for property of type: $propertyType")
    val classForProxy = proxyClassPerType.computeIfAbsent(targetClazz, targetClazz => {
      val enhancer = new Enhancer()
      enhancer.setSuperclass(targetClazz)
      enhancer.setInterfaces(Array(classOf[ConfigurationItem], classOf[LazyConfigurationItem], classOf[ResolvableLazyConfigurationItem]))
      enhancer.setCallbackType(classOf[ConfigurationItemCallback])
      val classForProxy = enhancer.createClass()
      classForProxy
    })
    val proxy = classForProxy.getDeclaredConstructor().newInstance().asInstanceOf[ConfigurationItem]
    proxy.asInstanceOf[Factory].setCallbacks(Array(ConfigurationItemCallback(ci)))
    proxy.setId(ci.referencedId)
    proxy.asInstanceOf[BaseConfigurationItem].setType(ci.targetType)
    val resolvableLazyConfigurationItem = proxy.asInstanceOf[ResolvableLazyConfigurationItem]
    val preInitializedMethods = proxyInitializers.filter(_.accept(proxy)).sortBy(_.getOrder).flatMap(_.initialize(proxy)).asJava
    resolvableLazyConfigurationItem.set$preinitializedMethods(preInitializedMethods)
    resolvableLazyConfigurationItem.set$resolverRepository(resolverRepository)
    resolvableLazyConfigurationItem.set$proxyInstanceInitialized(true)
    proxy
  }
}
