package com.xebialabs.xlrelease.repository.sql

import com.xebialabs.xlrelease.db.sql.transaction.{IsReadOnly, IsTransactional}
import com.xebialabs.xlrelease.domain.UserProfile
import com.xebialabs.xlrelease.repository.UserProfileRepository
import com.xebialabs.xlrelease.repository.sql.persistence.UserProfilePersistence

import java.util.{Date, List => JList}
import scala.jdk.CollectionConverters._

@IsTransactional
class SqlUserProfileRepository(userProfilePersistence: UserProfilePersistence) extends UserProfileRepository {

  override def create(userProfile: UserProfile): Unit = userProfilePersistence.insert(userProfile)

  override def update(userProfiles: JList[UserProfile]): Unit = {
    userProfiles.asScala.foreach(userProfilePersistence.updateUserProfile)
  }

  override def updateLastActive(canonicalId: String, lastActive: Date): Boolean = {
    userProfilePersistence.updateLastActive(canonicalId, lastActive)
  }

  override def updateLastActiveBatch(entries: Map[String, Date]): Int = {
    userProfilePersistence.updateLastActiveBatch(entries)
  }

  override def delete(userProfileId: String): Unit = userProfilePersistence.delete(userProfileId)

  override def findById(canonicalId: String): Option[UserProfile] = userProfilePersistence.findById(canonicalId)

  override def findAll(fullProfile: Boolean = false): JList[UserProfile] = userProfilePersistence.findAll(fullProfile).asJava

  @IsReadOnly
  override def exists(canonicalId: String): Boolean = userProfilePersistence.exists(canonicalId)

  override def customSearch(email: String, fullName: String, loginAllowed: java.lang.Boolean,
                            lastActiveAfter: Date, lastActiveBefore: Date, pageOption: Option[Long], resultsPerPageOption: Option[Long]): JList[UserProfile] = {
    userProfilePersistence.search(
      email,
      fullName,
      loginAllowed,
      lastActiveAfter,
      lastActiveBefore,
      resultsPerPageOption,
      pageOption.flatMap(page => resultsPerPageOption.map(resultsPerPage => page * resultsPerPage))
    ).asJava
  }

  @IsReadOnly
  override def countUserWithLoginAllowed(): Int = userProfilePersistence.countUserWithLoginAllowed()
}
