package com.xebialabs.xlrelease.upgrade.db

import com.xebialabs.deployit.security.PermissionEditor
import com.xebialabs.deployit.server.api.upgrade.{Upgrade, Version}
import com.xebialabs.xlrelease.db.sql.SqlBuilder.Dialect
import com.xebialabs.xlrelease.repository.sql.persistence.FolderPersistence
import com.xebialabs.xlrelease.security.XLReleasePermissions._
import com.xebialabs.xlrelease.security.XlrPermissionLabels.PermissionOperations
import com.xebialabs.xlrelease.upgrade.Components.XL_RELEASE_COMPONENT
import org.springframework.beans.factory.annotation.Qualifier
import org.springframework.jdbc.core.JdbcTemplate
import org.springframework.stereotype.Component

@Component
class XLRelease222RestartPhasePermissionUpgrader(folderPersistence: FolderPersistence,
                                                 permissionEditor: PermissionEditor,
                                                 @Qualifier("xlrRepositoryJdbcTemplate") val jdbcTemplate: JdbcTemplate,
                                                 @Qualifier("xlrRepositorySqlDialect") implicit val dialect: Dialect)
  extends Upgrade with BasePermissionUpgrade {

  override def upgradeVersion(): Version = Version.valueOf(XL_RELEASE_COMPONENT, "22.2.0#1")

  override def doUpgrade(): Boolean = {
    logger.info(s"Adding ${RESTART_PHASE.label()}")
    upgradePermission(folderPersistence, permissionEditor, EDIT_RELEASE, RESTART_PHASE)
    logger.info(s"Finished adding ${RESTART_PHASE.label()}")
    true
  }
}
