package com.xebialabs.xlrelease.spring.config

import com.xebialabs.deployit.security.PermissionEnforcer
import com.xebialabs.xlrelease.api.internal.InternalMetadataDecoratorService
import com.xebialabs.xlrelease.repository.sql.SqlFolderRepository
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.context.annotation.{Bean, Configuration}

@Configuration
class SqlFoldersConfiguration(sqlConfiguration: SqlConfiguration,
                              sqlPersistenceConfiguration: SqlPersistenceConfiguration,
                              sqlRepositories: SqlRepositoriesConfiguration,
                              permissionEnforcer: PermissionEnforcer) {

  @Autowired
  var decoratorService: InternalMetadataDecoratorService = _

  @Bean
  def folders(): SqlFolderRepository = {
    new SqlFolderRepository(
      sqlPersistenceConfiguration.folderPersistence(),
      sqlPersistenceConfiguration.releasePersistence(),
      sqlRepositories.teamRepository(),
      permissionEnforcer,
      decoratorService,
      sqlConfiguration.xlrRepositoryJdbcTemplate(),
      sqlConfiguration.xlrRepositorySqlDialect()
    )
  }

}
