package com.xebialabs.xlrelease.repository.sql

import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional
import com.xebialabs.xlrelease.repository.MetadataRepository
import com.xebialabs.xlrelease.repository.sql.persistence.MetadataPersistence

@IsTransactional
class SqlMetadataRepository(metadataPersistence: MetadataPersistence) extends MetadataRepository {

  def isTableExists: Boolean = metadataPersistence.isTableExists

  def create(name: String, entry: String): Unit = metadataPersistence.insert(name, entry)

  def update(name: String, entry: String): Unit = metadataPersistence.update(name, entry)

  def delete(name: String): Unit = metadataPersistence.delete(name)

  def exists(name: String): Boolean = metadataPersistence.exists(name)

  def getEntry(name: String): String = metadataPersistence.getEntry(name)

}
