package com.xebialabs.xlrelease.spring.config

import com.xebialabs.deployit.engine.spi.services.RepositoryFactory
import com.xebialabs.deployit.service.validation.Validator
import com.xebialabs.xlrelease.db.ArchivedReleases
import com.xebialabs.xlrelease.db.sql.SqlBuilder._
import com.xebialabs.xlrelease.repository.proxy.CiReferenceProxyFactory
import com.xebialabs.xlrelease.repository.sql.persistence.configuration.{ConfigurationPersistence, ReleaseConfigurationReferencePersistence, TriggerConfigurationReferencePersistence}
import com.xebialabs.xlrelease.repository.sql.persistence.{CalendarEntryPersistence, CommentPersistence, DependencyPersistence, FacetPersistence, FolderPersistence, LicensePersistence, MetadataPersistence, ReleaseExtensionPersistence, ReleasePersistence, SecurablePersistence, SpringSessionPersistence, TaskBackupPersistence, TaskPersistence, TaskTagsPersistence}
import com.xebialabs.xlrelease.repository.sql.proxy._
import com.xebialabs.xlrelease.repository.sql.{SqlRepositoryAdapter, SqlRepositoryAdapterFactory}
import com.xebialabs.xlrelease.service.NonDecryptingPasswordEncrypter
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.context.annotation.{Bean, Configuration, Primary}
import org.springframework.jdbc.core.JdbcTemplate

//noinspection SpringConfigurationProxyMethods
@Configuration()
class SqlPersistenceConfiguration(sqlConfiguration: SqlConfiguration) {

  @Autowired
  var archivedReleases: ArchivedReleases = _

  @Autowired
  var validator: Validator = _

  @Bean
  def ciReferenceProxyFactory: CiReferenceProxyFactory = DefaultCiReferenceProxyFactory

  @Bean
  def sqlRepositoryAdapter(): SqlRepositoryAdapter = {
    new SqlRepositoryAdapter(
      releasePersistence(),
      dependencyPersistence(),
      releaseConfigurationReferencePersistence(),
      facetPersistence(),
      taskPersistence(),
      validator,
      new NonDecryptingPasswordEncrypter(),
      referenceTargetTypeResolver,
      archivedReleases
    )
  }

  @Bean
  def referenceTypeRepository(): ReferenceTypeRepository = new SqlReferenceTypeRepository(sqlConfiguration.xlrRepositoryJdbcTemplate())

  @Bean
  def referenceTargetTypeResolver(): CiReferenceTargetTypeResolver = new DefaultCiReferenceTargetTypeResolver(referenceTypeRepository())

  @Primary
  @Bean
  def repositoryFactory(): RepositoryFactory = new SqlRepositoryAdapterFactory(sqlRepositoryAdapter())

  @Bean
  def securablePersistence(): SecurablePersistence = {
    new SecurablePersistence()(sqlConfiguration.xlrRepositoryJdbcTemplate(), sqlConfiguration.xlrRepositorySqlDialect())
  }

  @Bean
  def releasePersistence(): ReleasePersistence = {
    new ReleasePersistence(securablePersistence(), folderPersistence(), sqlConfiguration.ciIdService(), sqlConfiguration.xlrDbInfo(), sqlConfiguration.xlrRepositoryJdbcTemplate(), sqlConfiguration.xlrRepositorySqlDialect())
  }

  @Bean
  def taskPersistence(): TaskPersistence = {
    new TaskPersistence(taskTagsPersistence(), sqlConfiguration.xlrDbInfo())(sqlConfiguration.xlrRepositoryJdbcTemplate(), sqlConfiguration.xlrRepositorySqlDialect())
  }

  @Bean
  def licensePersistence(): LicensePersistence = {
    new LicensePersistence(sqlConfiguration.xlrRepositoryJdbcTemplate(), sqlConfiguration.xlrRepositorySqlDialect())
  }

  @Bean
  def taskTagsPersistence(): TaskTagsPersistence = {
    new TaskTagsPersistence(sqlConfiguration.xlrRepositoryJdbcTemplate(), sqlConfiguration.xlrRepositorySqlDialect())
  }

  @Bean
  def taskBackupPersistence(): TaskBackupPersistence = {
    implicit val jdbcTemplate = sqlConfiguration.xlrRepositoryJdbcTemplate()
    implicit val dialect = sqlConfiguration.xlrRepositorySqlDialect()
    new TaskBackupPersistence()
  }

  @Bean
  def dependencyPersistence(): DependencyPersistence = {
    new DependencyPersistence(sqlConfiguration.xlrRepositoryJdbcTemplate(), sqlConfiguration.xlrRepositorySqlDialect())
  }

  @Bean
  def configurationPersistence(): ConfigurationPersistence = {
    new ConfigurationPersistence(folderPersistence(), sqlConfiguration.xlrRepositoryJdbcTemplate(), sqlConfiguration.xlrRepositorySqlDialect())
  }

  @Bean
  def releaseConfigurationReferencePersistence(): ReleaseConfigurationReferencePersistence = {
    new ReleaseConfigurationReferencePersistence(folderPersistence(), sqlConfiguration.xlrRepositoryJdbcTemplate(), sqlConfiguration.xlrRepositorySqlDialect())
  }

  @Bean
  def triggerConfigurationReferencePersistence(): TriggerConfigurationReferencePersistence = {
    new TriggerConfigurationReferencePersistence(folderPersistence(), sqlConfiguration.xlrRepositoryJdbcTemplate(), sqlConfiguration.xlrRepositorySqlDialect())
  }

  @Bean
  def commentPersistence(): CommentPersistence = {
    new CommentPersistence(sqlConfiguration.xlrRepositoryJdbcTemplate(), sqlConfiguration.xlrRepositorySqlDialect())
  }

  @Bean
  def facetPersistence(): FacetPersistence = {
    new FacetPersistence(taskPersistence(), sqlConfiguration.xlrRepositoryJdbcTemplate(), sqlConfiguration.xlrRepositorySqlDialect())
  }

  @Bean
  def releaseExtensionPersistence(): ReleaseExtensionPersistence = {
    new ReleaseExtensionPersistence(sqlConfiguration.xlrRepositoryJdbcTemplate(), sqlConfiguration.xlrRepositorySqlDialect())
  }

  @Bean
  def folderPersistence(): FolderPersistence = {
    new FolderPersistence(securablePersistence())(sqlConfiguration.xlrRepositoryJdbcTemplate(), sqlConfiguration.xlrRepositorySqlDialect())
  }

  @Bean
  def calendarEntryPersistence(): CalendarEntryPersistence = {
    implicit val jdbcTemplate: JdbcTemplate = sqlConfiguration.xlrRepositoryJdbcTemplate()
    implicit val dialect: Dialect = sqlConfiguration.xlrRepositorySqlDialect()
    new CalendarEntryPersistence()
  }

  @Bean
  def springSessionPersistence(): SpringSessionPersistence = {
    implicit val jdbcTemplate: JdbcTemplate = sqlConfiguration.xlrRepositoryJdbcTemplate()
    implicit val dialect: Dialect = sqlConfiguration.xlrRepositorySqlDialect()
    new SpringSessionPersistence()
  }

  @Bean
  def metadataPersistence(): MetadataPersistence = {
    implicit val jdbcTemplate: JdbcTemplate = sqlConfiguration.xlrRepositoryJdbcTemplate()
    implicit val dialect: Dialect = sqlConfiguration.xlrRepositorySqlDialect()
    new MetadataPersistence()
  }

}
