/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.repository.AttachmentRepository;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import org.slf4j.Marker;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\u0005]d\u0001B\u0006\r\u0001]A\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\u0006c\u0001!\tA\r\u0005\u0006m\u0001!\te\u000e\u0005\u0006-\u0002!\te\u0016\u0005\u0006-\u0002!\tE\u0019\u0005\u0006M\u0002!\te\u001a\u0005\u0006_\u0002!\t\u0005\u001d\u0005\u0006_\u0002!\te\u001e\u0005\u0007\u007f\u0002!\t!!\u0001\t\u000f\u0005m\u0001\u0001\"\u0001\u0002\u001e\t92+\u001d7BiR\f7\r[7f]R\u0014V\r]8tSR|'/\u001f\u0006\u0003\u001b9\t1a]9m\u0015\ty\u0001#\u0001\u0006sKB|7/\u001b;pefT!!\u0005\n\u0002\u0013ad'/\u001a7fCN,'BA\n\u0015\u0003%AXMY5bY\u0006\u00147OC\u0001\u0016\u0003\r\u0019w.\\\u0002\u0001'\u0011\u0001\u0001D\b\u0012\u0011\u0005eaR\"\u0001\u000e\u000b\u0003m\tQa]2bY\u0006L!!\b\u000e\u0003\r\u0005s\u0017PU3g!\ty\u0002%D\u0001\u000f\u0013\t\tcB\u0001\u000bBiR\f7\r[7f]R\u0014V\r]8tSR|'/\u001f\t\u0003G!j\u0011\u0001\n\u0006\u0003K\u0019\nQa\u001d7gi)T\u0011aJ\u0001\tOJL'P\u001f7fI&\u0011\u0011\u0006\n\u0002\b\u0019><w-\u001b8h\u0003I\u0011X\r\\3bg\u0016\u0004VM]:jgR,gnY3\u0011\u00051zS\"A\u0017\u000b\u00059b\u0011a\u00039feNL7\u000f^3oG\u0016L!\u0001M\u0017\u0003%I+G.Z1tKB+'o]5ti\u0016t7-Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005M*\u0004C\u0001\u001b\u0001\u001b\u0005a\u0001\"\u0002\u0016\u0003\u0001\u0004Y\u0013\u0001\u00034j]\u0012\u0014\u00150\u00133\u0015\u0005ar\u0004CA\u001d=\u001b\u0005Q$BA\u001e\u0011\u0003\u0019!w.\\1j]&\u0011QH\u000f\u0002\u000b\u0003R$\u0018m\u00195nK:$\b\"B \u0004\u0001\u0004\u0001\u0015\u0001D1ui\u0006\u001c\u0007.\\3oi&#\u0007CA!I\u001d\t\u0011e\t\u0005\u0002D55\tAI\u0003\u0002F-\u00051AH]8pizJ!a\u0012\u000e\u0002\rA\u0013X\rZ3g\u0013\tI%J\u0001\u0004TiJLgn\u001a\u0006\u0003\u000fjA#a\u0001'\u0011\u00055#V\"\u0001(\u000b\u0005=\u0003\u0016AC1o]>$\u0018\r^5p]*\u0011\u0011KU\u0001\b[\u0016$(/[2t\u0015\t\u0019F#\u0001\u0005d_\u0012\f\u0007.\u00197f\u0013\t)fJA\u0003US6,G-\u0001\u0004de\u0016\fG/\u001a\u000b\u0005qakv\fC\u0003Z\t\u0001\u0007!,A\u0004sK2,\u0017m]3\u0011\u0005eZ\u0016B\u0001/;\u0005\u001d\u0011V\r\\3bg\u0016DQA\u0018\u0003A\u0002\u0001\u000ba\u0001^1tW&#\u0007\"\u00021\u0005\u0001\u0004A\u0014AC1ui\u0006\u001c\u0007.\\3oi\"\u0012A\u0001\u0014\u000b\u0004q\r$\u0007\"B-\u0006\u0001\u0004Q\u0006\"\u00021\u0006\u0001\u0004A\u0004FA\u0003M\u0003AIgn]3si\u0006#H/Y2i[\u0016tG\u000fF\u0002iW6\u0004\"!G5\n\u0005)T\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006Y\u001a\u0001\r\u0001Q\u0001\ne\u0016dW-Y:f\u0013\u0012DQ\u0001\u0019\u0004A\u0002aB#A\u0002'\u0002\r\u0011,G.\u001a;f)\r\tH/\u001e\t\u00033IL!a\u001d\u000e\u0003\tUs\u0017\u000e\u001e\u0005\u00063\u001e\u0001\rA\u0017\u0005\u0006A\u001e\u0001\r\u0001\u000f\u0015\u0003\u000f1#2!\u001d=~\u0011\u0015I\b\u00021\u0001{\u0003\u0011!\u0018m]6\u0011\u0005eZ\u0018B\u0001?;\u0005\u0011!\u0016m]6\t\u000b\u0001D\u0001\u0019\u0001\u001d)\u0005!a\u0015a\u00032bi\u000eD\u0017J\\:feR$R\u0001[A\u0002\u0003\u000bAQ!W\u0005A\u0002iCq!a\u0002\n\u0001\u0004\tI!A\u0006biR\f7\r[7f]R\u001c\b#BA\u0006\u0003+Ad\u0002BA\u0007\u0003#q1aQA\b\u0013\u0005Y\u0012bAA\n5\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\f\u00033\u00111aU3r\u0015\r\t\u0019BG\u0001\u0007S:\u001cXM\u001d;\u0015\u0013!\fy\"a\u0012\u0002L\u0005=\u0003bBA\u0011\u0015\u0001\u0007\u00111E\u0001\u000be\u0016dW-Y:f+&$\u0007\u0003BA\u0013\u0003\u0003rA!a\n\u0002@9!\u0011\u0011FA\u001f\u001d\u0011\tY#a\u000f\u000f\t\u00055\u0012\u0011\b\b\u0005\u0003_\t9D\u0004\u0003\u00022\u0005UbbA\"\u00024%\tQ#\u0003\u0002\u0014)%\u0011\u0011CE\u0005\u0003\u001fAI!!\u0004\b\n\u00059b\u0011bAA\n[%!\u00111IA#\u0005\u0015\u0019\u0015.V5e\u0015\r\t\u0019\"\f\u0005\u0007\u0003\u0013R\u0001\u0019\u0001!\u0002\u0015\u0005\u0014H/\u001b4bGRLE\r\u0003\u0004\u0002N)\u0001\r\u0001Q\u0001\rCJ$\u0018NZ1di:\u000bW.\u001a\u0005\b\u0003#R\u0001\u0019AA*\u0003\u001d\u0019wN\u001c;f]R\u0004B!!\u0016\u0002`5\u0011\u0011q\u000b\u0006\u0005\u00033\nY&\u0001\u0002j_*\u0011\u0011QL\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002b\u0005]#aC%oaV$8\u000b\u001e:fC6D3\u0001AA3!\u0011\t9'a\u001d\u000e\u0005\u0005%$\u0002BA6\u0003[\n1\u0002\u001e:b]N\f7\r^5p]*\u0019Q\"a\u001c\u000b\u0007\u0005E\u0004#\u0001\u0002eE&!\u0011QOA5\u0005=I5\u000f\u0016:b]N\f7\r^5p]\u0006d\u0007")
public class SqlAttachmentRepository
implements AttachmentRepository,
Logging {
    private final ReleasePersistence releasePersistence;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlAttachmentRepository sqlAttachmentRepository = this;
        synchronized (sqlAttachmentRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @Timed
    public Attachment findById(String attachmentId) {
        this.logger().debug((Function0 & Serializable)() -> "Searching for attachment [" + attachmentId + "]");
        return (Attachment)this.releasePersistence.findAttachmentById(attachmentId).getOrElse((Function0 & Serializable)() -> {
            throw new LogFriendlyNotFoundException("Repository entity [%s] not found", new Object[]{attachmentId});
        });
    }

    @Timed
    public Attachment create(Release release, String taskId, Attachment attachment) {
        this.logger().debug((Function0 & Serializable)() -> "Adding attachment to task [" + taskId + "]");
        Task releaseTask = release.getTask(taskId);
        HashSet<Attachment> taskAttachments = new HashSet<Attachment>(releaseTask.getAttachments());
        taskAttachments.add(attachment);
        releaseTask.setAttachments(new ArrayList(taskAttachments));
        return this.create(release, attachment);
    }

    @Timed
    public Attachment create(Release release, Attachment attachment) {
        this.logger().debug((Function0 & Serializable)() -> "Adding attachment to release [" + release.getId() + "]");
        release.getAttachments().add(attachment);
        this.releasePersistence.update((Option<Release>)None$.MODULE$, release);
        return attachment;
    }

    @Timed
    public boolean insertAttachment(String releaseId, Attachment attachment) {
        return this.releasePersistence.insertAttachments(releaseId, (Seq<SourceArtifact>)new .colon.colon((Object)attachment, (List)Nil$.MODULE$));
    }

    @Timed
    public void delete(Release release, Attachment attachment) {
        this.logger().info((Function0 & Serializable)() -> "Deleting attachment reference '" + attachment.getId() + "' from release '" + release.getId() + "'");
        release.deleteAttachment(attachment.getId());
        this.releasePersistence.update(release);
        if (!release.isTemplate()) {
            this.releasePersistence.deleteAttachmentById(attachment.getId(), release.getCiUid());
            return;
        }
    }

    @Timed
    public void delete(Task task, Attachment attachment) {
        task.deleteAttachment(attachment.getId());
        Release release = task.getRelease();
        if (release.getTasksUsingAttachment(attachment.getId()).isEmpty()) {
            this.delete(release, attachment);
            return;
        }
        this.logger().info((Function0 & Serializable)() -> "Deleting attachment reference " + attachment.getId() + " from task " + task.getId());
        this.releasePersistence.update(release);
    }

    public boolean batchInsert(Release release, Seq<Attachment> attachments) {
        boolean bl;
        try {
            bl = this.releasePersistence.insertAttachments(release.getId(), attachments);
        }
        catch (RuntimeException e) {
            this.logger().error((Function0 & Serializable)() -> e.getMessage(), (Function0 & Serializable)() -> e);
            bl = false;
        }
        return bl;
    }

    public boolean insert(Integer releaseUid, String artifactId, String artifactName, InputStream content) {
        boolean bl;
        try {
            bl = this.releasePersistence.insertArtifact(Predef$.MODULE$.Integer2int(releaseUid), artifactId, artifactName, content);
        }
        catch (RuntimeException e) {
            this.logger().error((Function0 & Serializable)() -> e.getMessage(), (Function0 & Serializable)() -> e);
            bl = false;
        }
        return bl;
    }

    public SqlAttachmentRepository(ReleasePersistence releasePersistence) {
        this.releasePersistence = releasePersistence;
        Logging.$init$((Logging)this);
    }
}

