package com.xebialabs.xlrelease.scheduler.logs

import com.xebialabs.xlrelease.repository.sql.persistence.Schema.TASK_EXECUTIONS
import org.springframework.jdbc.core.RowMapper

trait TaskExecutionRowMapper {
  def taskExecutionRowMapper: RowMapper[TaskExecutionEntry] = (rs, _) => {
    TaskExecutionEntry(
      rs.getString(TASK_EXECUTIONS.TASK_ID_HASH),
      rs.getString(TASK_EXECUTIONS.EXECUTION_ID),
      rs.getInt(TASK_EXECUTIONS.LAST_JOB),
      rs.getInt(TASK_EXECUTIONS.LAST_CHUNK),
      Option(rs.getTimestamp(TASK_EXECUTIONS.LAST_MODIFIED_DATE)).map(_.toInstant).orNull,
      Option(rs.getTimestamp(TASK_EXECUTIONS.END_DATE)).map(_.toInstant).orNull
    )
  }
}
