package com.xebialabs.xlrelease.repository.sql.persistence.configuration

import com.xebialabs.xlrelease.db.sql.SqlBuilder.Dialect
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional
import com.xebialabs.xlrelease.repository.sql.persistence.Schema.{ConfigurationRefs, FOLDERS, RELEASES, RELEASE_CONFIGURATION_REFS}
import com.xebialabs.xlrelease.repository.sql.persistence.Utils.params
import com.xebialabs.xlrelease.repository.sql.persistence.data.ConfigurationReferenceRow
import com.xebialabs.xlrelease.repository.sql.persistence.{CiUid, FolderPersistence}
import com.xebialabs.xlrelease.utils.FolderId
import org.springframework.jdbc.core.{JdbcTemplate, RowMapper}

import java.sql.ResultSet

@IsTransactional
class ReleaseConfigurationReferencePersistence(override val folderPersistence: FolderPersistence,
                                               override val jdbcTemplate: JdbcTemplate,
                                               override implicit val dialect: Dialect)
  extends ConfigurationReferencePersistenceCommon {

  override protected val table: ConfigurationRefs = RELEASE_CONFIGURATION_REFS

  override protected def STMT_GET_REFS: String =
    s"""|SELECT
        |   entity.${RELEASES.RELEASE_TITLE},
        |   entity.${RELEASES.RELEASE_ID},
        |   folders.${FOLDERS.FOLDER_ID}
        | FROM
        |   ${table.TABLE} refs
        |   JOIN ${RELEASES.TABLE} entity ON refs.${table.USED_BY_UID} = entity.${RELEASES.CI_UID}
        |   JOIN ${FOLDERS.TABLE} folders ON folders.${FOLDERS.CI_UID} = entity.${RELEASES.FOLDER_CI_UID}
        | WHERE
        |   refs.${table.CONFIGURATION_UID} = :configurationCiUid""".stripMargin

  override def findAllByUid(uid: CiUid): Seq[(Option[FolderId], String)] = {
    logger.trace(s"Eager fetching configurations for release with uid: $uid")
    sqlQuery(STMT_ALL_CONFIGURATIONS_BY_UID, params("uid" -> uid), configurationBinaryStreamRowMapper).toSeq
  }

  override protected def configurationReferenceRowMapper: RowMapper[ConfigurationReferenceRow] = (rs: ResultSet, _: Int) => {
    val title = rs.getString(RELEASES.RELEASE_TITLE)
    val id = rs.getString(RELEASES.RELEASE_ID)
    val folderId = FolderId(rs.getString(FOLDERS.FOLDER_ID))

    ConfigurationReferenceRow(
      title = title,
      id = (folderId / id).absolute
    )
  }
}
