package com.xebialabs.xlrelease.upgrade.db

import com.xebialabs.deployit.server.api.upgrade.Version
import com.xebialabs.xlrelease.db.sql.SqlBuilder.Dialect
import com.xebialabs.xlrelease.repository.TeamRepository
import com.xebialabs.xlrelease.security.XLReleasePermissions._
import com.xebialabs.xlrelease.upgrade.Components.XL_RELEASE_COMPONENT
import org.springframework.beans.factory.annotation.{Autowired, Qualifier}
import org.springframework.jdbc.core.JdbcTemplate

class XLRelease820EditFailureHandlerAndPreconditionPermissionsUpgrade @Autowired()(@Qualifier("xlrRepositoryJdbcTemplate") val jdbcTemplate: JdbcTemplate,
                                                                                   @Qualifier("xlrRepositorySqlDialect") implicit val dialect: Dialect,
                                                                                   val teamRepository: TeamRepository)
  extends BaseAdminTeamsPermissionsUpgrade {

  override def upgradeVersion(): Version = Version.valueOf(XL_RELEASE_COMPONENT, "8.2.0#1")

  override def doUpgrade(): Boolean = {
    logger.info("Edit failure handler and precondition permissions upgrade")
    val securedCis = findFolderSecuredCis ++ findReleaseSecuredCis
    for (ci <- securedCis) {
      upgradeCiTeams(ci,
        releasePermissions = Seq(EDIT_RELEASE_FAILURE_HANDLER, EDIT_RELEASE_PRECONDITION),
        templatePermissions = Seq(EDIT_TEMPLATE_FAILURE_HANDLER, EDIT_TEMPLATE_PRECONDITION)
      )
    }
    logger.debug("Finished edit failure handler and precondition permissions upgrade")
    true
  }
}
