/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.TemplateLogo;
import com.xebialabs.xlrelease.repository.TemplateMetadata;
import com.xebialabs.xlrelease.repository.TemplateMetadataRepository;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\u0005Ub\u0001B\u0005\u000b\u0001UA\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\u0006_\u0001!\t\u0001\r\u0005\u0006i\u0001!\t%\u000e\u0005\u0006\r\u0002!\te\u0012\u0005\u0006G\u0002!\t\u0005\u001a\u0005\u0006_\u0002!\t\u0005\u001d\u0005\u0006m\u0002!\te\u001e\u0005\b\u0003\u001f\u0001A\u0011IA\t\u0005u\u0019\u0016\u000f\u001c+f[Bd\u0017\r^3NKR\fG-\u0019;b%\u0016\u0004xn]5u_JL(BA\u0006\r\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u001b9\t!B]3q_NLGo\u001c:z\u0015\ty\u0001#A\u0005yYJ,G.Z1tK*\u0011\u0011CE\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011aE\u0001\u0004G>l7\u0001A\n\u0005\u0001Ya\u0002\u0005\u0005\u0002\u001855\t\u0001DC\u0001\u001a\u0003\u0015\u00198-\u00197b\u0013\tY\u0002D\u0001\u0004B]f\u0014VM\u001a\t\u0003;yi\u0011\u0001D\u0005\u0003?1\u0011!\u0004V3na2\fG/Z'fi\u0006$\u0017\r^1SKB|7/\u001b;pef\u0004\"!\t\u0014\u000e\u0003\tR!a\t\u0013\u0002\u000bMdg\r\u000e6\u000b\u0003\u0015\n\u0001b\u001a:jujdW\rZ\u0005\u0003O\t\u0012q\u0001T8hO&tw-\u0001\nsK2,\u0017m]3QKJ\u001c\u0018n\u001d;f]\u000e,\u0007C\u0001\u0016.\u001b\u0005Y#B\u0001\u0017\u000b\u0003-\u0001XM]:jgR,gnY3\n\u00059Z#A\u0005*fY\u0016\f7/\u001a)feNL7\u000f^3oG\u0016\fa\u0001P5oSRtDCA\u00194!\t\u0011\u0004!D\u0001\u000b\u0011\u0015A#\u00011\u0001*\u00039\u0019'/Z1uK>\u0013X\u000b\u001d3bi\u0016$\"AN\u001d\u0011\u0005u9\u0014B\u0001\u001d\r\u0005A!V-\u001c9mCR,W*\u001a;bI\u0006$\u0018\rC\u0003;\u0007\u0001\u0007a'\u0001\u0007uK6\u0004H.\u0019;f\u001b\u0016$\u0018\r\u000b\u0002\u0004yA\u0011Q\bR\u0007\u0002})\u0011q\bQ\u0001\u000bC:tw\u000e^1uS>t'BA!C\u0003\u001diW\r\u001e:jGNT!a\u0011\n\u0002\u0011\r|G-\u00195bY\u0016L!!\u0012 \u0003\u000bQKW.\u001a3\u0002\rU\u0004H-\u0019;f)\r1\u0004\n\u0019\u0005\u0006\u0013\u0012\u0001\rAS\u0001\u000be\u0016dW-Y:f+&$\u0007CA&^\u001d\ta5L\u0004\u0002N5:\u0011a*\u0017\b\u0003\u001fbs!\u0001U,\u000f\u0005E3fB\u0001*V\u001b\u0005\u0019&B\u0001+\u0015\u0003\u0019a$o\\8u}%\t1#\u0003\u0002\u0012%%\u0011q\u0002E\u0005\u0003\u001b9I!a\u0003\u0007\n\u00051R\u0011B\u0001/,\u0003\u001d\u0001\u0018mY6bO\u0016L!AX0\u0003\u000b\rKW+\u001b3\u000b\u0005q[\u0003\"B1\u0005\u0001\u00041\u0014\u0001\u0005;f[Bd\u0017\r^3NKR\fG-\u0019;bQ\t!A(\u0001\nde\u0016\fG/Z(s+B$\u0017\r^3M_\u001e|GcA3lYB\u0011a-[\u0007\u0002O*\u0011\u0001ND\u0001\u0007I>l\u0017-\u001b8\n\u0005)<'\u0001\u0004+f[Bd\u0017\r^3M_\u001e|\u0007\"B%\u0006\u0001\u0004Q\u0005\"B7\u0006\u0001\u0004)\u0017\u0001\u0004;f[Bd\u0017\r^3M_\u001e|\u0007FA\u0003=\u0003\u0019!W\r\\3uKR\u0011\u0011\u000f\u001e\t\u0003/IL!a\u001d\r\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u0013\u001a\u0001\rA\u0013\u0015\u0003\rq\nAAZ5oIR\u0011\u0001p\u001f\t\u0004/e4\u0014B\u0001>\u0019\u0005\u0019y\u0005\u000f^5p]\")\u0011j\u0002a\u0001\u0015\"\u0012q\u0001\u0010\u0015\u0003\u000fy\u00042a`A\u0006\u001b\t\t\tA\u0003\u0003\u0002\u0004\u0005\u0015\u0011a\u0003;sC:\u001c\u0018m\u0019;j_:T1aCA\u0004\u0015\r\tIAD\u0001\u0003I\nLA!!\u0004\u0002\u0002\tQ\u0011j\u001d*fC\u0012|e\u000e\\=\u0002)\u0019Lg\u000e\u001a+f[Bd\u0017\r^3M_\u001e|')_%e)\u0011\t\u0019\"!\u0006\u0011\u0007]IX\rC\u0004\u0002\u0018!\u0001\r!!\u0007\u0002\r1|wm\\%e!\u0011\tY\"a\t\u000f\t\u0005u\u0011q\u0004\t\u0003%bI1!!\t\u0019\u0003\u0019\u0001&/\u001a3fM&!\u0011QEA\u0014\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011\u0005\r)\u0005!a\u0004F\u0001\u0005\u007fQ\r\u0001\u0011q\u0006\t\u0004\u007f\u0006E\u0012\u0002BA\u001a\u0003\u0003\u0011q\"S:Ue\u0006t7/Y2uS>t\u0017\r\u001c")
public class SqlTemplateMetadataRepository
implements TemplateMetadataRepository,
Logging {
    private final ReleasePersistence releasePersistence;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlTemplateMetadataRepository sqlTemplateMetadataRepository = this;
        synchronized (sqlTemplateMetadataRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @Timed
    public TemplateMetadata createOrUpdate(TemplateMetadata templateMeta) {
        Integer releaseUid = templateMeta.releaseUid();
        Option<TemplateMetadata> option = this.releasePersistence.findTemplateMetadata(releaseUid);
        if (option instanceof Some) {
            Some some = (Some)option;
            TemplateMetadata v = (TemplateMetadata)some.value();
            this.releasePersistence.updateTemplateMetadata(releaseUid, templateMeta);
            if (templateMeta.templateLogo() != null) {
                BoxesRunTime.boxToBoolean((boolean)this.releasePersistence.updateLogo(releaseUid, (Option<TemplateLogo>)Option$.MODULE$.apply((Object)v.templateLogo()), templateMeta.templateLogo()));
            }
        } else if (None$.MODULE$.equals(option)) {
            this.releasePersistence.createTemplateMetadata(templateMeta);
        } else {
            throw new MatchError(option);
        }
        return templateMeta;
    }

    @Timed
    public TemplateMetadata update(Integer releaseUid, TemplateMetadata templateMetadata) {
        this.releasePersistence.updateTemplateMetadata(releaseUid, templateMetadata);
        return templateMetadata;
    }

    @Timed
    public TemplateLogo createOrUpdateLogo(Integer releaseUid, TemplateLogo templateLogo) {
        Option<TemplateMetadata> option = this.releasePersistence.findTemplateMetadata(releaseUid);
        if (option instanceof Some) {
            Some some = (Some)option;
            TemplateMetadata v = (TemplateMetadata)some.value();
            BoxesRunTime.boxToBoolean((boolean)this.releasePersistence.updateLogo(releaseUid, (Option<TemplateLogo>)Option$.MODULE$.apply((Object)v.templateLogo()), templateLogo));
        } else if (None$.MODULE$.equals(option)) {
            TemplateMetadata templateMetadata = new TemplateMetadata(releaseUid, null, null, null, true, templateLogo);
            this.releasePersistence.createTemplateMetadata(templateMetadata);
        } else {
            throw new MatchError(option);
        }
        return ((TemplateMetadata)this.releasePersistence.findTemplateMetadata(releaseUid).get()).templateLogo();
    }

    @Timed
    public void delete(Integer releaseUid) {
        this.releasePersistence.deleteTemplateMetadata(releaseUid);
    }

    @Timed
    @IsReadOnly
    public Option<TemplateMetadata> find(Integer releaseUid) {
        return this.releasePersistence.findTemplateMetadata(releaseUid);
    }

    @Timed
    @IsReadOnly
    public Option<TemplateLogo> findTemplateLogoById(String logoId) {
        this.logger().debug((Function0 & Serializable)() -> "Searching for template logo [" + logoId + "]");
        return this.releasePersistence.findTemplateLogoById(logoId);
    }

    public SqlTemplateMetadataRepository(ReleasePersistence releasePersistence) {
        this.releasePersistence = releasePersistence;
        Logging.$init$((Logging)this);
    }
}

