package com.xebialabs.xlrelease.upgrade.db

import com.xebialabs.deployit.server.api.upgrade.{Upgrade, Version}
import com.xebialabs.xlrelease.configuration.ReportsSettings
import com.xebialabs.xlrelease.domain.BaseConfiguration
import com.xebialabs.xlrelease.repository.ConfigurationRepository
import com.xebialabs.xlrelease.upgrade.Components.XL_RELEASE_COMPONENT
import grizzled.slf4j.Logging
import org.springframework.stereotype.Component

/**
 * Updates the ReportSettings id
 * On new repositories the ReportSettings will have already the proper id
 * On upgrading repositories the id will change
 */
@Component
class XLRelease2410ReportSettingsUpgrade(configurationRepository: ConfigurationRepository) extends Upgrade with Logging {

  override def doUpgrade(): Boolean = {
    val oldReportSettingsId = "Configuration/reports/ReportsSettings"
    if (configurationRepository.exists(oldReportSettingsId)) {
      val reportSettings: BaseConfiguration = configurationRepository.read[BaseConfiguration](oldReportSettingsId)
      configurationRepository.delete(oldReportSettingsId)
      reportSettings.setId(ReportsSettings.REPORTS_SETTINGS_ID)
      // SettingsInitializer might have created the report settings already
      if (configurationRepository.exists(ReportsSettings.REPORTS_SETTINGS_ID)) {
        configurationRepository.update(reportSettings)
      } else {
        configurationRepository.create(reportSettings)
      }
    }
    true
  }

  override def upgradeVersion(): Version = Version.valueOf(XL_RELEASE_COMPONENT, "24.1.0#0")
}
