package com.xebialabs.xlrelease.security

import com.xebialabs.xlrelease.repository.sql.persistence.Schema.USER_PROFILE
import com.xebialabs.xlrelease.security.SqlReleaseRoleRepository.GlobalRolePrincipalTableView
import com.xebialabs.xlrelease.security.sql.db.SecuritySchema.{ROLES, ROLE_PRINCIPALS}
import org.springframework.jdbc.core.RowMapper

trait GlobalRolePrincipalTableViewMapper {
  def globalRolePrincipalViewMapper: RowMapper[GlobalRolePrincipalTableView] = (rs, _) => {
    GlobalRolePrincipalTableView(
      id = rs.getString(ROLES.id),
      name = rs.getString(ROLES.name),
      ciId = rs.getInt(ROLES.ciId),
      principalName = rs.getString(ROLE_PRINCIPALS.principalName),
      fullName = rs.getString(USER_PROFILE.FULL_NAME)
    )
  }
}
