package com.xebialabs.xlrelease.security.entities;

import java.io.Serializable;
import java.util.Objects;
import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import org.hibernate.Hibernate;
import org.hibernate.annotations.Nationalized;

@Embeddable
public class XlRoleRoleId implements Serializable {
    private static final long serialVersionUID = 8139358512192285580L;
    @Size(max = 255)
    @NotNull
    @Nationalized
    @Column(name = "ROLE_ID", nullable = false)
    private String roleId;

    @Size(max = 255)
    @NotNull
    @Nationalized
    @Column(name = "MEMBER_ROLE_ID", nullable = false)
    private String memberRoleId;

    public XlRoleRoleId() {
    }

    public XlRoleRoleId(final String roleId, final String memberRoleId) {
        this.roleId = roleId;
        this.memberRoleId = memberRoleId;
    }

    public String getRoleId() {
        return roleId;
    }

    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    public String getMemberRoleId() {
        return memberRoleId;
    }

    public void setMemberRoleId(String memberRoleId) {
        this.memberRoleId = memberRoleId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || Hibernate.getClass(this) != Hibernate.getClass(o)) return false;
        XlRoleRoleId entity = (XlRoleRoleId) o;
        return Objects.equals(this.memberRoleId, entity.memberRoleId) &&
                Objects.equals(this.roleId, entity.roleId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(memberRoleId, roleId);
    }

}