package com.xebialabs.xlrelease.upgrade.db

import com.xebialabs.deployit.server.api.upgrade.{Upgrade, Version}
import com.xebialabs.xlrelease.configuration.PollingSettings
import com.xebialabs.xlrelease.repository.ConfigurationRepository
import com.xebialabs.xlrelease.repository.sql.SqlRepositoryAdapter
import com.xebialabs.xlrelease.repository.sql.persistence.configuration.ConfigurationPersistence
import com.xebialabs.xlrelease.upgrade.Components.XL_RELEASE_COMPONENT
import grizzled.slf4j.Logging
import org.codehaus.jettison.json.JSONObject
import org.springframework.stereotype.Component

import scala.util.{Failure, Try}

@Component
class XLRelease2230PollingSettingsUpgrade(configurationRepository: ConfigurationRepository,
                                          configurationPersistence: ConfigurationPersistence,
                                          sqlRepositoryAdapter: SqlRepositoryAdapter) extends Upgrade with Logging {

  override def doUpgrade(): Boolean = {
    Try(upgradePollingVersionSettings()) match {
      case Failure(_) => logger.error("Unable to upgrade Polling Settings configuration")
      case _ =>
    }
    true

  }

  def upgradePollingVersionSettings(): Unit = {
    configurationPersistence.findById(PollingSettings.POLLING_SETTINGS_ID)
      .map(configurationRow => new JSONObject(configurationRow._2))
      .filter(_.has("pollingInterval")).foreach(pollingSettingJson => {
      logger.info("Found Polling Settings configuration for upgrade")
      val pollingInterval = pollingSettingJson.getInt("pollingInterval");
      pollingSettingJson.remove("pollingInterval")
      sqlRepositoryAdapter.readConfiguration[PollingSettings]((None, pollingSettingJson.toString))
        .foreach(pollSettings => {
          pollSettings.setTaskStatusInterval(pollingInterval)
          configurationRepository.update[PollingSettings](pollSettings)
          logger.info("Polling Settings configuration upgrade is completed ")
        })
    })
  }

  override def upgradeVersion(): Version = Version.valueOf(XL_RELEASE_COMPONENT, "22.3.0#1")
}
