package com.xebialabs.xlrelease.repository.sql

import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional
import com.xebialabs.xlrelease.domain.metadata.MetadataEntry
import com.xebialabs.xlrelease.repository.MetadataRepository
import com.xebialabs.xlrelease.repository.sql.persistence.MetadataPersistence

@IsTransactional
class SqlMetadataRepository(metadataPersistence: MetadataPersistence) extends MetadataRepository {

  def isTableExists: Boolean = metadataPersistence.isTableExists

  def create(name: String, entry: String): Unit = metadataPersistence.insert(name, entry)

  def create(name: String,  metadataEntry: MetadataEntry): Unit = metadataPersistence.insert(name, metadataEntry)

  def update(name: String, entry: String): Unit = metadataPersistence.update(name, entry)

  def update(name: String, metadataEntry: MetadataEntry): Unit = metadataPersistence.update(name, metadataEntry)

  def delete(name: String): Unit = metadataPersistence.delete(name)

  def exists(name: String): Boolean = metadataPersistence.exists(name)

  def getEntry(name: String): Option[MetadataEntry] = metadataPersistence.getEntry(name)
}
