package com.xebialabs.xlrelease.repository.sql.persistence

import com.xebialabs.xlrelease.repository.sql.persistence.SecurableSqlBuilder.{createMemberRoleIdInRoleIdsClause, createMemberRoleIdsInRoleIdsClause}
import com.xebialabs.xlrelease.security.sql.db.SecuritySchema.{ROLES, ROLE_PERMISSIONS, ROLE_PRINCIPALS, ROLE_ROLES}
import com.xebialabs.xlrelease.utils.QueryParamUtils.MAX_IN_CLAUSE_SIZE

trait SecurableSqlBuilder {

  protected def selectCiIdsWithPermission(principalNames: Iterable[String], roleIds: Iterable[String]): String = {
    s"""|SELECT DISTINCT teamPermissions.${ROLE_PERMISSIONS.ciId}
        |FROM
        |  ${ROLES.TABLE} teams
        |  LEFT JOIN ${ROLE_ROLES.TABLE} teamRoles ON teams.${ROLES.id} = teamRoles.${ROLE_ROLES.roleId}
        |  LEFT JOIN ${ROLE_PRINCIPALS.TABLE} teamPrincipals ON teams.${ROLES.id} = teamPrincipals.${ROLE_PRINCIPALS.roleId}
        |  JOIN ${ROLE_PERMISSIONS.TABLE} teamPermissions ON teams.${ROLES.id} = teamPermissions.${ROLE_PERMISSIONS.roleId}
        |WHERE
        |  teamPermissions.${ROLE_PERMISSIONS.permissionName} = ?
        |  AND (
        |    LOWER(teamPrincipals.${ROLE_PRINCIPALS.principalName}) IN (${principalNames.map(_ => "LOWER(?)").mkString(",")})
        |    ${createMemberRoleIdsInRoleIdsClause(roleIds)}
        |  )""".stripMargin
  }

  protected def selectCiIdsWithPermissions(permissionNames: Iterable[String], principalNames: Iterable[String], roleIds: Iterable[String]): String = {
    s"""|SELECT DISTINCT teamPermissions.${ROLE_PERMISSIONS.ciId}
        |FROM
        |  ${ROLES.TABLE} teams
        |  LEFT JOIN ${ROLE_ROLES.TABLE} teamRoles ON teams.${ROLES.id} = teamRoles.${ROLE_ROLES.roleId}
        |  LEFT JOIN ${ROLE_PRINCIPALS.TABLE} teamPrincipals ON teams.${ROLES.id} = teamPrincipals.${ROLE_PRINCIPALS.roleId}
        |  JOIN ${ROLE_PERMISSIONS.TABLE} teamPermissions ON teams.${ROLES.id} = teamPermissions.${ROLE_PERMISSIONS.roleId}
        |WHERE
        |  teamPermissions.${ROLE_PERMISSIONS.permissionName} IN (${permissionNames.map(_ => "?").mkString(",")})
        |  AND (
        |    LOWER(teamPrincipals.${ROLE_PRINCIPALS.principalName}) IN (${principalNames.map(_ => "LOWER(?)").mkString(",")})
        |    ${createMemberRoleIdsInRoleIdsClause(roleIds)}
        |  )""".stripMargin
  }

  protected def selectCiIdsWithPermission(roleIds: Iterable[String]): String = {
    s"""|SELECT DISTINCT teamPermissions.${ROLE_PERMISSIONS.ciId}
        |FROM
        |  ${ROLES.TABLE} teams
        |  LEFT JOIN ${ROLE_ROLES.TABLE} teamRoles ON teams.${ROLES.id} = teamRoles.${ROLE_ROLES.roleId}
        |  LEFT JOIN ${ROLE_PRINCIPALS.TABLE} teamPrincipals ON teams.${ROLES.id} = teamPrincipals.${ROLE_PRINCIPALS.roleId}
        |  JOIN ${ROLE_PERMISSIONS.TABLE} teamPermissions ON teams.${ROLES.id} = teamPermissions.${ROLE_PERMISSIONS.roleId}
        |WHERE
        |  teamPermissions.${ROLE_PERMISSIONS.permissionName} = :permissionName
        |  AND (
        |    LOWER(teamPrincipals.${ROLE_PRINCIPALS.principalName}) IN (:principalNames)
        |    ${createMemberRoleIdInRoleIdsClause(roleIds)}
        |  )""".stripMargin
  }

}

object SecurableSqlBuilder {

  def createMemberRoleIdsInRoleIdsClause(roleIds: Iterable[String]): String = {
    val roleIdsGrouped = roleIds.grouped(MAX_IN_CLAUSE_SIZE)
    roleIdsGrouped.collect(group => s"OR teamRoles.${ROLE_ROLES.memberRoleId} IN (${group.map(_ => "?").mkString(",")})").mkString(" ")
  }

  def createMemberRoleIdInRoleIdsClause(roleIds: Iterable[String]): String = {
    val groupedIds = roleIds.grouped(MAX_IN_CLAUSE_SIZE)
    groupedIds.zipWithIndex.map { case (_, i) => s"OR teamRoles.${ROLE_ROLES.memberRoleId} IN (:roleIds$i)" }.mkString(" ")
  }
}