package com.xebialabs.xlrelease.upgrade.db

import com.xebialabs.deployit.security.PermissionEditor
import com.xebialabs.deployit.server.api.upgrade.Version
import com.xebialabs.xlrelease.db.sql.SqlBuilder.Dialect
import com.xebialabs.xlrelease.repository.sql.persistence.FolderPersistence
import com.xebialabs.xlrelease.security.XLReleasePermissions._
import com.xebialabs.xlrelease.upgrade.Components.XL_RELEASE_COMPONENT
import org.springframework.beans.factory.annotation.Qualifier
import org.springframework.jdbc.core.JdbcTemplate
import org.springframework.stereotype.Component

@Component
class XLRelease220CreatePermissionUpgrade(val folderPersistence: FolderPersistence,
                                          val permissionEditor: PermissionEditor,
                                          @Qualifier("xlrRepositoryJdbcTemplate") val jdbcTemplate: JdbcTemplate,
                                          @Qualifier("xlrRepositorySqlDialect") implicit val dialect: Dialect)
  extends BasePermissionUpgrade {

  override def upgradeVersion(): Version = Version.valueOf(XL_RELEASE_COMPONENT, "22.0.0#3")

  override def doUpgrade(): Boolean = grantPermissionToRolesWithPermission(VIEW_TEMPLATE, CREATE_RELEASE_IN_ANOTHER_FOLDER)
}
