package com.xebialabs.xlrelease.upgrade.db

import com.xebialabs.deployit.security.PermissionEditor
import com.xebialabs.deployit.server.api.upgrade.{Upgrade, Version}
import com.xebialabs.xlrelease.domain.Team.FOLDER_OWNER_TEAMNAME
import com.xebialabs.xlrelease.repository.Ids.ROOT_FOLDER_ID
import com.xebialabs.xlrelease.repository.sql.persistence.FolderPersistence
import com.xebialabs.xlrelease.security.XLReleasePermissions
import com.xebialabs.xlrelease.upgrade.Components.XL_RELEASE_COMPONENT
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import scala.jdk.CollectionConverters._

@Component
class XLRelease860EditFolderVariablePermissionsUpgrader @Autowired()(folderPersistence: FolderPersistence, permissionEditor: PermissionEditor)
  extends Upgrade with Logging {

  override def upgradeVersion(): Version = Version.valueOf(XL_RELEASE_COMPONENT, "8.6.0#2")

  override def doUpgrade(): Boolean = {
    upgradeReleaseGroupPermissions()
    true
  }

  private def upgradeReleaseGroupPermissions(): Unit = {
    logger.info("Starting edit folder variable permissions upgrade")

    val folderUids = folderPersistence.findDescendantsById(ROOT_FOLDER_ID, Int.MaxValue).map(_.uid).distinct

    folderUids.foreach(folderUid => {
      val permissions = permissionEditor.readPermissions(folderUid.toString)

      if (permissions != null && !permissions.isEmpty) {
        permissions.asScala
          .find(_._1.getName == FOLDER_OWNER_TEAMNAME)
          .foreach(_._2.add(XLReleasePermissions.EDIT_FOLDER_VARIABLES))

        permissionEditor.editPermissions(folderUid.toString, permissions)
      }
    })
    logger.info("Finished edit folder variable permissions upgrade")
  }
}
