package com.xebialabs.xlrelease.repository.sql.proxy


import com.esotericsoftware.kryo.DefaultSerializer
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem
import com.xebialabs.deployit.plugin.api.udm.{ConfigurationItem, LazyConfigurationItem}
import com.xebialabs.xlrelease.actors.kryoserializers.{ResolvableLazyConfigurationItemSerializer, ResolvableLazyConfigurationItemSerializerFactory}
import com.xebialabs.xlrelease.repository.proxy.{CiReferenceProxyFactory, ResolvableConfigurationItemReference, ResolvableLazyConfigurationItem}
import com.xebialabs.xlrelease.serialization.json.repository.ResolverRepository
import com.xebialabs.xlrelease.support.pekko.spring.ScalaSpringSupport
import grizzled.slf4j.Logging
import org.springframework.asm.Type
import org.springframework.cglib.core.{ClassGenerator, DefaultGeneratorStrategy, GeneratorStrategy}
import org.springframework.cglib.proxy.{Enhancer, Factory}
import org.springframework.cglib.transform.{ClassEmitterTransformer, TransformingClassGenerator}
import org.springframework.context.{ApplicationContext, ApplicationContextAware}

import java.util.concurrent.ConcurrentHashMap
import scala.beans.BeanProperty
import scala.jdk.CollectionConverters._


object DefaultCiReferenceProxyFactory extends CiReferenceProxyFactory with ApplicationContextAware with ScalaSpringSupport with Logging {

  @BeanProperty
  protected var applicationContext: ApplicationContext = _

  private val proxyClassPerType: ConcurrentHashMap[Class[_], Class[_]] = new ConcurrentHashMap[Class[_], Class[_]]()

  private lazy val proxyInitializers: Seq[ProxyInstanceInitializer] = springBeans[ProxyInstanceInitializer].values().asScala.toSeq

  override def proxy(resolverRepository: ResolverRepository, ci: ResolvableConfigurationItemReference): ConfigurationItem = {
    cglibProxy(resolverRepository, ci)
  }

  private def cglibProxy(resolverRepository: ResolverRepository, ci: ResolvableConfigurationItemReference): ConfigurationItem = {
    val targetClazz = ci.targetType.getDescriptor.getClazz
    val propertyType = ci.ciReference.getProperty.getReferencedType
    logger.trace(s"Creating proxy reference ${ci.ciReference} of class ${targetClazz.getName} for property of type: $propertyType")
    val classForProxy = proxyClassPerType.computeIfAbsent(targetClazz, targetClazz => {
      val enhancer = new Enhancer()
      enhancer.setSuperclass(targetClazz)
      enhancer.setInterfaces(Array(classOf[ConfigurationItem], classOf[LazyConfigurationItem], classOf[ResolvableLazyConfigurationItem]))
      enhancer.setCallbackType(classOf[ConfigurationItemCallback])
      enhancer.setStrategy(resolvableCiGeneratorStrategy())
      val classForProxy = enhancer.createClass()
      classForProxy
    })
    val proxy = classForProxy.getDeclaredConstructor().newInstance().asInstanceOf[ConfigurationItem]
    proxy.asInstanceOf[Factory].setCallbacks(Array(ConfigurationItemCallback(ci)))
    proxy.setId(ci.referencedId)
    proxy.asInstanceOf[BaseConfigurationItem].setType(ci.targetType)
    val resolvableLazyConfigurationItem = proxy.asInstanceOf[ResolvableLazyConfigurationItem]
    val preInitializedMethods = proxyInitializers.filter(_.accept(proxy)).sortBy(_.getOrder).flatMap(_.initialize(proxy)).asJava
    resolvableLazyConfigurationItem.set$preinitializedMethods(preInitializedMethods)
    resolvableLazyConfigurationItem.set$resolverRepository(resolverRepository)
    resolvableLazyConfigurationItem.set$proxyInstanceInitialized(true)
    proxy
  }

  // generator strategy that adds Kryo specific annotation to classes generated by cglib
  private def resolvableCiGeneratorStrategy(): GeneratorStrategy = new DefaultGeneratorStrategy {
    val ANNOTATION_TYPE_NAME = Type.getType(classOf[DefaultSerializer]).getDescriptor

    override def transform(cg: ClassGenerator): ClassGenerator = {
      val transformer: ClassEmitterTransformer = new ClassEmitterTransformer {
        override def visit(version: Int, access: Int, name: String, signature: String, superName: String, interfaces: Array[String]): Unit = {
          val av = visitAnnotation(ANNOTATION_TYPE_NAME, true)
          av.visit("value",
            Type.getType(classOf[ResolvableLazyConfigurationItemSerializer.type])
          )
          av.visit("serializerFactory",
            Type.getType(classOf[ResolvableLazyConfigurationItemSerializerFactory])
          )
          super.visit(version, access, name, signature, superName, interfaces)
        }
      }
      new TransformingClassGenerator(cg, transformer)
    }
  }

}
