/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.SecuredCis;
import com.xebialabs.xlrelease.repository.sql.persistence.FolderPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.FolderRow;
import com.xebialabs.xlrelease.security.SecuredCi;
import io.micrometer.core.annotation.Timed;
import java.io.Serializable;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0005q4A\u0001C\u0005\u0001)!Aq\u0004\u0001B\u0001B\u0003%\u0001\u0005\u0003\u0005'\u0001\t\u0005\t\u0015!\u0003(\u0011\u0015Q\u0003\u0001\"\u0001,\u0011\u0015\u0001\u0004\u0001\"\u00112\u0011\u0015\u0011\u0006\u0001\"\u0011T\u0011\u00151\u0006\u0001\"\u0003X\u0011\u00151\u0007\u0001\"\u0011h\u00055\u0019\u0016\u000f\\*fGV\u0014X\rZ\"jg*\u0011!bC\u0001\u0004gFd'B\u0001\u0007\u000e\u0003)\u0011X\r]8tSR|'/\u001f\u0006\u0003\u001d=\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005A\t\u0012!\u0003=fE&\fG.\u00192t\u0015\u0005\u0011\u0012aA2p[\u000e\u00011c\u0001\u0001\u00167A\u0011a#G\u0007\u0002/)\t\u0001$A\u0003tG\u0006d\u0017-\u0003\u0002\u001b/\t1\u0011I\\=SK\u001a\u0004\"\u0001H\u000f\u000e\u0003-I!AH\u0006\u0003\u0015M+7-\u001e:fI\u000eK7/A\tg_2$WM\u001d)feNL7\u000f^3oG\u0016\u0004\"!\t\u0013\u000e\u0003\tR!aI\u0005\u0002\u0017A,'o]5ti\u0016t7-Z\u0005\u0003K\t\u0012\u0011CR8mI\u0016\u0014\b+\u001a:tSN$XM\\2f\u0003I\u0011X\r\\3bg\u0016\u0004VM]:jgR,gnY3\u0011\u0005\u0005B\u0013BA\u0015#\u0005I\u0011V\r\\3bg\u0016\u0004VM]:jgR,gnY3\u0002\rqJg.\u001b;?)\racf\f\t\u0003[\u0001i\u0011!\u0003\u0005\u0006?\r\u0001\r\u0001\t\u0005\u0006M\r\u0001\raJ\u0001\u0016O\u0016$XI\u001a4fGRLg/Z*fGV\u0014X\rZ\"j)\t\u0011\u0004\b\u0005\u00024m5\tAG\u0003\u00026\u001b\u0005A1/Z2ve&$\u00180\u0003\u00028i\tI1+Z2ve\u0016$7)\u001b\u0005\u0006s\u0011\u0001\rAO\u0001\fG>tG/Y5oKJLE\r\u0005\u0002<\u0005:\u0011A\b\u0011\t\u0003{]i\u0011A\u0010\u0006\u0003\u007fM\ta\u0001\u0010:p_Rt\u0014BA!\u0018\u0003\u0019\u0001&/\u001a3fM&\u00111\t\u0012\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0005;\u0002F\u0001\u0003G!\t9\u0005+D\u0001I\u0015\tI%*\u0001\u0006b]:|G/\u0019;j_:T!a\u0013'\u0002\t\r|'/\u001a\u0006\u0003\u001b:\u000b!\"\\5de>lW\r^3s\u0015\u0005y\u0015AA5p\u0013\t\t\u0006JA\u0003US6,G-\u0001\u0007hKR\u001cVmY;sK\u0012\u001c\u0015\u000e\u0006\u00023)\")\u0011(\u0002a\u0001u!\u0012QAR\u0001\fCN\u001cVmY;sK\u0012\u001c\u0015\u000eF\u000231fCQ!\u000f\u0004A\u0002iBQA\u0017\u0004A\u0002m\u000b1!^5e!\r1BLX\u0005\u0003;^\u0011aa\u00149uS>t\u0007CA0e\u001b\u0005\u0001'BA1c\u0003\u0011a\u0017M\\4\u000b\u0003\r\fAA[1wC&\u0011Q\r\u0019\u0002\b\u0013:$XmZ3s\u0003]\u0019X\r^!t\u000b\u001a4Wm\u0019;jm\u0016\u001cVmY;sK\u0012\u001c\u0015\u000eF\u0002iW2\u0004\"AF5\n\u0005)<\"\u0001B+oSRDQ!O\u0004A\u0002iBQ!\\\u0004A\u00029\f1\"[:FM\u001a,7\r^5wKB\u0011ac\\\u0005\u0003a^\u0011qAQ8pY\u0016\fg\u000e\u000b\u0002\b\r\"\u0012\u0001a\u001d\t\u0003ijl\u0011!\u001e\u0006\u0003m^\f1\u0002\u001e:b]N\f7\r^5p]*\u0011!\u0002\u001f\u0006\u0003s6\t!\u0001\u001a2\n\u0005m,(aD%t)J\fgn]1di&|g.\u00197")
public class SqlSecuredCis
implements SecuredCis {
    private final FolderPersistence folderPersistence;
    private final ReleasePersistence releasePersistence;

    @Timed
    public SecuredCi getEffectiveSecuredCi(String containerId) {
        String string = containerId;
        switch (string == null ? 0 : string.hashCode()) {
            default: 
        }
        if (Ids.isFolderId((String)string)) {
            return this.folderPersistence.getEffectiveSecuredCi(string);
        }
        if (Ids.isReleaseId((String)string)) {
            return this.releasePersistence.getEffectiveSecuredCi(string);
        }
        return this.getSecuredCi(string);
    }

    @Timed
    public SecuredCi getSecuredCi(String containerId) {
        String string = containerId;
        switch (string == null ? 0 : string.hashCode()) {
            default: 
        }
        if (Ids.isFolderId((String)string)) {
            return this.folderPersistence.getSecuredCi(containerId);
        }
        if (Ids.isReleaseId((String)string)) {
            return this.asSecuredCi(string, this.releasePersistence.findUidByReleaseId(string));
        }
        throw new IllegalArgumentException("Unable to get UID for unsupported ID format [" + containerId + "]");
    }

    private SecuredCi asSecuredCi(String containerId, Option<Integer> uid) {
        return new SecuredCi(containerId, ((Integer)uid.getOrElse((Function0 & Serializable)() -> {
            throw new IllegalArgumentException("Unable to find release by ID [" + containerId + "]");
        })).toString());
    }

    @Timed
    public void setAsEffectiveSecuredCi(String containerId, boolean isEffective) {
        if (Ids.isFolderId((String)containerId)) {
            int oldSecurityUid = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(this.folderPersistence.getEffectiveSecuredCi(containerId).getSecurityUid()));
            FolderRow newFolderData = isEffective ? this.folderPersistence.setAsEffectiveSecuredCi(containerId) : this.folderPersistence.inheritEffectiveSecuredCi(containerId);
            this.releasePersistence.replaceSecurityUid(newFolderData.uid(), Predef$.MODULE$.int2Integer(oldSecurityUid), newFolderData.securityUid());
            return;
        }
        if (isEffective) {
            this.releasePersistence.setAsEffectiveSecuredCi(containerId);
            return;
        }
        SecuredCi effectiveFolder = this.folderPersistence.getEffectiveSecuredCi(Ids.getParentId((String)containerId));
        this.releasePersistence.inheritSecurityFromFolder(containerId, Predef$.MODULE$.int2Integer(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(effectiveFolder.getSecurityUid()))));
    }

    public SqlSecuredCis(FolderPersistence folderPersistence, ReleasePersistence releasePersistence) {
        this.folderPersistence = folderPersistence;
        this.releasePersistence = releasePersistence;
    }
}

