/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.spring.config;

import com.xebialabs.deployit.security.PermissionChecker;
import com.xebialabs.deployit.security.PermissionEditor;
import com.xebialabs.deployit.security.UserService;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.security.DefaultReleaseRoleService;
import com.xebialabs.xlrelease.security.DefaultUserGroupService;
import com.xebialabs.xlrelease.security.ReleaseRolePermissionRepository;
import com.xebialabs.xlrelease.security.ReleaseRoleRepository;
import com.xebialabs.xlrelease.security.ReleaseRoleService;
import com.xebialabs.xlrelease.security.SqlReleaseRoleRepository;
import com.xebialabs.xlrelease.security.SqlUserGroupRepository;
import com.xebialabs.xlrelease.security.SqlUserGroupRepositoryCache;
import com.xebialabs.xlrelease.security.UserGroupRepository;
import com.xebialabs.xlrelease.security.UserGroupService;
import com.xebialabs.xlrelease.security.sql.CachingPermissionEditor;
import com.xebialabs.xlrelease.security.sql.CachingPermissionLister;
import com.xebialabs.xlrelease.security.sql.CachingSqlRoleService;
import com.xebialabs.xlrelease.security.sql.CachingSqlUserService;
import com.xebialabs.xlrelease.security.sql.SqlPermissionChecker;
import com.xebialabs.xlrelease.security.sql.SqlPermissionEditor;
import com.xebialabs.xlrelease.security.sql.SqlPermissionLister;
import com.xebialabs.xlrelease.security.sql.SqlReleaseRolePermissionRepository;
import com.xebialabs.xlrelease.security.sql.SqlRoleService;
import com.xebialabs.xlrelease.security.sql.SqlUserService;
import com.xebialabs.xlrelease.security.sql.UserCacheEvicter;
import com.xebialabs.xlrelease.service.BroadcastService;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.spring.config.SqlConfiguration;
import java.util.Optional;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import scala.reflect.ScalaSignature;

@Configuration
@ScalaSignature(bytes="\u0006\u0005\u0005mc\u0001B\t\u0013\u0001uA\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!\n\u0005\tS\u0001\u0011\t\u0011)A\u0005U!Aq\u0006\u0001B\u0001B\u0003%\u0001\u0007\u0003\u00057\u0001\t\u0005\t\u0015!\u00038\u0011\u0015i\u0004\u0001\"\u0001?\u0011!!\u0005\u0001#b\u0001\n\u0003)\u0005\"B%\u0001\t\u0003Q\u0005\"\u00021\u0001\t\u0003\t\u0007\"B<\u0001\t\u0003A\b\"\u0002@\u0001\t\u0003y\bbBA\u0005\u0001\u0011\u0005\u00111\u0002\u0005\b\u0003+\u0001A\u0011AA\f\u0011\u001d\t\t\u0003\u0001C\u0001\u0003GAq!!\f\u0001\t\u0003\ty\u0003C\u0004\u0002:\u0001!\t!a\u000f\t\u000f\u0005\u001d\u0003\u0001\"\u0001\u0002J\tA2+\u001d7TK\u000e,(/\u001b;z\u0007>tg-[4ve\u0006$\u0018n\u001c8\u000b\u0005M!\u0012AB2p]\u001aLwM\u0003\u0002\u0016-\u000511\u000f\u001d:j]\u001eT!a\u0006\r\u0002\u0013ad'/\u001a7fCN,'BA\r\u001b\u0003%AXMY5bY\u0006\u00147OC\u0001\u001c\u0003\r\u0019w.\\\u0002\u0001'\t\u0001a\u0004\u0005\u0002 E5\t\u0001EC\u0001\"\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0003E\u0001\u0004B]f\u0014VMZ\u0001\u0011gFd7i\u001c8gS\u001e,(/\u0019;j_:\u0004\"AJ\u0014\u000e\u0003II!\u0001\u000b\n\u0003!M\u000bHnQ8oM&<WO]1uS>t\u0017!\u0003=me\u000e{gNZ5h!\tYS&D\u0001-\u0015\t\u0019b#\u0003\u0002/Y\tI\u0001\f\u001c:D_:4\u0017nZ\u0001\u0011EJ|\u0017\rZ2bgR\u001cVM\u001d<jG\u0016\u0004\"!\r\u001b\u000e\u0003IR!a\r\f\u0002\u000fM,'O^5dK&\u0011QG\r\u0002\u0011\u0005J|\u0017\rZ2bgR\u001cVM\u001d<jG\u0016\f\u0001\"\u001a<f]R\u0014Uo\u001d\t\u0003qmj\u0011!\u000f\u0006\u0003uY\ta!\u001a<f]R\u001c\u0018B\u0001\u001f:\u0005EAFJU3mK\u0006\u001cX-\u0012<f]R\u0014Uo]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b}\u0002\u0015IQ\"\u0011\u0005\u0019\u0002\u0001\"\u0002\u0013\u0006\u0001\u0004)\u0003\"B\u0015\u0006\u0001\u0004Q\u0003\"B\u0018\u0006\u0001\u0004\u0001\u0004\"\u0002\u001c\u0006\u0001\u00049\u0014AD2bG\"LgnZ#oC\ndW\rZ\u000b\u0002\rB\u0011qdR\u0005\u0003\u0011\u0002\u0012qAQ8pY\u0016\fg.A\u0006s_2,7+\u001a:wS\u000e,G#A&\u0011\u00051\u000bV\"A'\u000b\u00059{\u0015aA:rY*\u0011\u0001KF\u0001\tg\u0016\u001cWO]5us&\u0011!+\u0014\u0002\u000f'Fd'k\u001c7f'\u0016\u0014h/[2fQ\t9A\u000b\u0005\u0002V=6\taK\u0003\u0002X1\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005eS\u0016aB2p]R,\u0007\u0010\u001e\u0006\u00037r\u000bqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002;\u0006\u0019qN]4\n\u0005}3&\u0001\u0002\"fC:\f1\"^:feN+'O^5dKR\u0011!-\u001b\t\u0003G\u001el\u0011\u0001\u001a\u0006\u0003!\u0016T!A\u001a\r\u0002\u0011\u0011,\u0007\u000f\\8zSRL!\u0001\u001b3\u0003\u0017U\u001bXM]*feZL7-\u001a\u0005\u0006U\"\u0001\ra[\u0001\bKZL7\r^3s!\ra\u0017o]\u0007\u0002[*\u0011an\\\u0001\u0005kRLGNC\u0001q\u0003\u0011Q\u0017M^1\n\u0005Il'\u0001C(qi&|g.\u00197\u0011\u00051#\u0018BA;N\u0005A)6/\u001a:DC\u000eDW-\u0012<jGR,'\u000f\u000b\u0002\t)\u0006\u0011\"/\u001a7fCN,'k\u001c7f'\u0016\u0014h/[2f)\u0005I\bC\u0001>|\u001b\u0005y\u0015B\u0001?P\u0005I\u0011V\r\\3bg\u0016\u0014v\u000e\\3TKJ4\u0018nY3)\u0005%!\u0016!\u0006:fY\u0016\f7/\u001a*pY\u0016\u0014V\r]8tSR|'/\u001f\u000b\u0003\u0003\u0003\u00012A_A\u0002\u0013\r\t)a\u0014\u0002\u0016%\u0016dW-Y:f%>dWMU3q_NLGo\u001c:zQ\tQA+\u0001\tvg\u0016\u0014xI]8vaN+'O^5dKR\u0011\u0011Q\u0002\t\u0004u\u0006=\u0011bAA\t\u001f\n\u0001Rk]3s\u000fJ|W\u000f]*feZL7-\u001a\u0015\u0003\u0017Q\u000b1#^:fe\u001e\u0013x.\u001e9SKB|7/\u001b;pef$\"!!\u0007\u0011\u0007i\fY\"C\u0002\u0002\u001e=\u00131#V:fe\u001e\u0013x.\u001e9SKB|7/\u001b;pefD#\u0001\u0004+\u0002!A,'/\\5tg&|g\u000eT5ti\u0016\u0014HCAA\u0013!\ra\u0015qE\u0005\u0004\u0003Si%aE*rYB+'/\\5tg&|g\u000eT5ti\u0016\u0014\bFA\u0007U\u0003A\u0001XM]7jgNLwN\\#eSR|'\u000f\u0006\u0002\u00022A\u00191-a\r\n\u0007\u0005UBM\u0001\tQKJl\u0017n]:j_:,E-\u001b;pe\"\u0012a\u0002V\u0001\u0015q2\u0014\b+\u001a:nSN\u001c\u0018n\u001c8DQ\u0016\u001c7.\u001a:\u0015\t\u0005u\u00121\t\t\u0004G\u0006}\u0012bAA!I\n\t\u0002+\u001a:nSN\u001c\u0018n\u001c8DQ\u0016\u001c7.\u001a:\t\u000f\u0005\u0005r\u00021\u0001\u0002&!\u0012q\u0002V\u0001\u0019e>dW\rU3s[&\u001c8/[8o%\u0016\u0004xn]5u_JLHCAA&!\rQ\u0018QJ\u0005\u0004\u0003\u001fz%a\b*fY\u0016\f7/\u001a*pY\u0016\u0004VM]7jgNLwN\u001c*fa>\u001c\u0018\u000e^8ss\"\u0012\u0001\u0003\u0016\u0015\u0004\u0001\u0005U\u0003cA+\u0002X%\u0019\u0011\u0011\f,\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0001")
public class SqlSecurityConfiguration {
    private boolean cachingEnabled;
    private final SqlConfiguration sqlConfiguration;
    private final XlrConfig xlrConfig;
    private final BroadcastService broadcastService;
    private final XLReleaseEventBus eventBus;
    private volatile boolean bitmap$0;

    private boolean cachingEnabled$lzycompute() {
        SqlSecurityConfiguration sqlSecurityConfiguration = this;
        synchronized (sqlSecurityConfiguration) {
            if (!this.bitmap$0) {
                this.cachingEnabled = this.xlrConfig.isSecurityCacheEnabled();
                this.bitmap$0 = true;
            }
        }
        return this.cachingEnabled;
    }

    public boolean cachingEnabled() {
        if (!this.bitmap$0) {
            return this.cachingEnabled$lzycompute();
        }
        return this.cachingEnabled;
    }

    @Bean
    public SqlRoleService roleService() {
        if (this.cachingEnabled()) {
            return new CachingSqlRoleService(this.sqlConfiguration.xlrRepositoryDatabase(), this.broadcastService);
        }
        return new SqlRoleService(this.sqlConfiguration.xlrRepositoryDatabase());
    }

    @Bean
    public UserService userService(Optional<UserCacheEvicter> evicter) {
        if (this.xlrConfig.isSecurityUserCacheEnabled()) {
            return new CachingSqlUserService(this.sqlConfiguration.xlrRepositoryDatabase(), evicter.get());
        }
        return new SqlUserService(this.sqlConfiguration.xlrRepositoryDatabase());
    }

    @Bean
    public ReleaseRoleService releaseRoleService() {
        return new DefaultReleaseRoleService(this.eventBus, (CiIdService)this.sqlConfiguration.ciIdService(), this.releaseRoleRepository(), this.rolePermissionRepository());
    }

    @Bean
    public ReleaseRoleRepository releaseRoleRepository() {
        return new SqlReleaseRoleRepository(this.sqlConfiguration.xlrDatabaseInformation(), this.sqlConfiguration.xlrRepositoryJdbcTemplate(), this.sqlConfiguration.xlrRepositorySqlDialect(), this.roleService());
    }

    @Bean
    public UserGroupService userGroupService() {
        return new DefaultUserGroupService(this.userGroupRepository());
    }

    @Bean
    public UserGroupRepository userGroupRepository() {
        SqlUserGroupRepository repository = new SqlUserGroupRepository(this.sqlConfiguration.ciIdService(), this.sqlConfiguration.xlrRepositoryJdbcTemplate(), this.sqlConfiguration.xlrRepositorySqlDialect());
        if (this.xlrConfig.isUserGroupCacheEnabled()) {
            return new SqlUserGroupRepositoryCache(repository, this.broadcastService);
        }
        return repository;
    }

    @Bean
    public SqlPermissionLister permissionLister() {
        if (this.cachingEnabled()) {
            return new CachingPermissionLister(this.sqlConfiguration.xlrRepositoryDatabase());
        }
        return new SqlPermissionLister(this.sqlConfiguration.xlrRepositoryDatabase());
    }

    @Bean
    public PermissionEditor permissionEditor() {
        if (this.cachingEnabled()) {
            return new CachingPermissionEditor(this.sqlConfiguration.xlrRepositoryDatabase(), this.broadcastService);
        }
        return new SqlPermissionEditor(this.sqlConfiguration.xlrRepositoryDatabase());
    }

    @Bean
    public PermissionChecker xlrPermissionChecker(SqlPermissionLister permissionLister) {
        return new SqlPermissionChecker(this.sqlConfiguration.xlrRepositoryDatabase(), permissionLister, this.cachingEnabled());
    }

    @Bean
    public ReleaseRolePermissionRepository rolePermissionRepository() {
        return new SqlReleaseRolePermissionRepository(this.sqlConfiguration.xlrRepositoryDatabase());
    }

    public SqlSecurityConfiguration(SqlConfiguration sqlConfiguration, XlrConfig xlrConfig, BroadcastService broadcastService, XLReleaseEventBus eventBus) {
        this.sqlConfiguration = sqlConfiguration;
        this.xlrConfig = xlrConfig;
        this.broadcastService = broadcastService;
        this.eventBus = eventBus;
    }
}

