/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.security.PermissionEnforcer;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.xlrelease.api.internal.EffectiveSecurity;
import com.xebialabs.xlrelease.api.internal.EffectiveSecurityDecorator$;
import com.xebialabs.xlrelease.api.internal.InternalMetadataDecoratorService;
import com.xebialabs.xlrelease.builder.ReleaseBuilder;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.ReleaseBasicInfo;
import com.xebialabs.xlrelease.repository.sql.persistence.data.ReleasePhaseTaskRow;
import com.xebialabs.xlrelease.repository.sql.persistence.data.TaskRow;
import com.xebialabs.xlrelease.service.TaskAccessService;
import com.xebialabs.xlrelease.service.TaskSearchService;
import com.xebialabs.xlrelease.views.TasksFilters;
import com.xebialabs.xlrelease.views.UserView;
import com.xebialabs.xlrelease.views.tasks.TaskListRelease;
import com.xebialabs.xlrelease.views.tasks.TaskListReleaseTask;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import io.micrometer.core.annotation.Timed;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Field;
import java.util.Collection;
import org.slf4j.Marker;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.security.core.Authentication;
import org.springframework.util.StringUtils;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dh\u0001B\b\u0011\u0001eA\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!\f\u0005\tk\u0001\u0011\t\u0011)A\u0005m!A\u0011\b\u0001B\u0001B\u0003%!\b\u0003\u0005C\u0001\t\u0005\t\u0015!\u0003D\u0011!i\u0005A!A!\u0002\u0013q\u0005\"B)\u0001\t\u0003\u0011\u0006\"B-\u0001\t\u0003QVABA\n\u0001\u0001\t)\u0002C\u0004\u0002,\u0001!I!!\f\t\u000f\u0005\u001d\u0004\u0001\"\u0003\u0002j!9\u0011Q\u0011\u0001\u0005\n\u0005\u001d\u0005bBAJ\u0001\u0011%\u0011Q\u0013\u0005\b\u0003\u007f\u0003A\u0011BAa\u0011\u001d\tI\u000e\u0001C\u0001\u00037\u0014AcU9m)\u0006\u001c8nU3be\u000eD7+\u001a:wS\u000e,'BA\t\u0013\u0003\u001d\u0019XM\u001d<jG\u0016T!a\u0005\u000b\u0002\u0013ad'/\u001a7fCN,'BA\u000b\u0017\u0003%AXMY5bY\u0006\u00147OC\u0001\u0018\u0003\r\u0019w.\\\u0002\u0001'\u0011\u0001!\u0004\t\u0013\u0011\u0005mqR\"\u0001\u000f\u000b\u0003u\tQa]2bY\u0006L!a\b\u000f\u0003\r\u0005s\u0017PU3g!\t\t#%D\u0001\u0011\u0013\t\u0019\u0003CA\tUCN\\7+Z1sG\"\u001cVM\u001d<jG\u0016\u0004\"!\n\u0016\u000e\u0003\u0019R!a\n\u0015\u0002\u000bMdg\r\u000e6\u000b\u0003%\n\u0001b\u001a:jujdW\rZ\u0005\u0003W\u0019\u0012q\u0001T8hO&tw-A\u0006s_2,7+\u001a:wS\u000e,\u0007C\u0001\u00184\u001b\u0005y#B\u0001\u00192\u0003!\u0019XmY;sSRL(B\u0001\u001a\u0015\u0003!!W\r\u001d7ps&$\u0018B\u0001\u001b0\u0005-\u0011v\u000e\\3TKJ4\u0018nY3\u0002#Q\f7o[!dG\u0016\u001c8oU3sm&\u001cW\r\u0005\u0002\"o%\u0011\u0001\b\u0005\u0002\u0012)\u0006\u001c8.Q2dKN\u001c8+\u001a:wS\u000e,\u0017\u0001\u00053fG>\u0014\u0018\r^8s'\u0016\u0014h/[2f!\tY\u0004)D\u0001=\u0015\tid(\u0001\u0005j]R,'O\\1m\u0015\ty$#A\u0002ba&L!!\u0011\u001f\u0003A%sG/\u001a:oC2lU\r^1eCR\fG)Z2pe\u0006$xN]*feZL7-Z\u0001\u0010i\u0006\u001c8\u000eU3sg&\u001cH/\u001a8dKB\u0011AiS\u0007\u0002\u000b*\u0011aiR\u0001\fa\u0016\u00148/[:uK:\u001cWM\u0003\u0002I\u0013\u0006\u00191/\u001d7\u000b\u0005)\u0013\u0012A\u0003:fa>\u001c\u0018\u000e^8ss&\u0011A*\u0012\u0002\u0010)\u0006\u001c8\u000eU3sg&\u001cH/\u001a8dK\u0006\u0011\u0002/\u001a:nSN\u001c\u0018n\u001c8F]\u001a|'oY3s!\tqs*\u0003\u0002Q_\t\u0011\u0002+\u001a:nSN\u001c\u0018n\u001c8F]\u001a|'oY3s\u0003\u0019a\u0014N\\5u}Q11\u000bV+W/b\u0003\"!\t\u0001\t\u000b12\u0001\u0019A\u0017\t\u000bU2\u0001\u0019\u0001\u001c\t\u000be2\u0001\u0019\u0001\u001e\t\u000b\t3\u0001\u0019A\"\t\u000b53\u0001\u0019\u0001(\u0002#\u001d,G\u000fV1tWN\u0014\u0015PU3mK\u0006\u001cX\r\u0006\u0003\\_VT\bc\u0001/fO6\tQL\u0003\u0002_?\u00061Am\\7bS:T!\u0001Y1\u0002\t\u0011\fG/\u0019\u0006\u0003E\u000e\fqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002I\u0006\u0019qN]4\n\u0005\u0019l&\u0001\u0002)bO\u0016\u0004\"\u0001[7\u000e\u0003%T!A[6\u0002\u000bQ\f7o[:\u000b\u00051\u0014\u0012!\u0002<jK^\u001c\u0018B\u00018j\u0005=!\u0016m]6MSN$(+\u001a7fCN,\u0007\"\u00029\b\u0001\u0004\t\u0018\u0001\u0004;bg.\u001ch)\u001b7uKJ\u001c\bC\u0001:t\u001b\u0005Y\u0017B\u0001;l\u00051!\u0016m]6t\r&dG/\u001a:t\u0011\u00151x\u00011\u0001x\u0003\u0011\u0001\u0018mZ3\u0011\u0005mA\u0018BA=\u001d\u0005\rIe\u000e\u001e\u0005\u0006w\u001e\u0001\ra^\u0001\r]Vl'-\u001a:CsB\u000bw-\u001a\u0015\u0003\u000fu\u00042A`A\b\u001b\u0005y(\u0002BA\u0001\u0003\u0007\t!\"\u00198o_R\fG/[8o\u0015\u0011\t)!a\u0002\u0002\t\r|'/\u001a\u0006\u0005\u0003\u0013\tY!\u0001\u0006nS\u000e\u0014x.\\3uKJT!!!\u0004\u0002\u0005%|\u0017bAA\t\u007f\n)A+[7fI\nI!+\u001a7fCN,\u0017\n\u001a\t\u0005\u0003/\t)C\u0004\u0003\u0002\u001a\u0005\u0005\u0002cAA\u000e95\u0011\u0011Q\u0004\u0006\u0004\u0003?A\u0012A\u0002\u001fs_>$h(C\u0002\u0002$q\ta\u0001\u0015:fI\u00164\u0017\u0002BA\u0014\u0003S\u0011aa\u0015;sS:<'bAA\u00129\u0005yr-\u001a;FM\u001a,7\r^5wKN+7-\u001e:jif\u0014\u0015PU3mK\u0006\u001cX-\u00133\u0015\t\u0005=\u0012q\b\t\t\u0003/\t\t$!\u000e\u0002:%!\u00111GA\u0015\u0005\ri\u0015\r\u001d\t\u0004\u0003oAQ\"\u0001\u0001\u0011\u0007m\nY$C\u0002\u0002>q\u0012\u0011#\u00124gK\u000e$\u0018N^3TK\u000e,(/\u001b;z\u0011\u001d\t\t%\u0003a\u0001\u0003\u0007\na\u0002^1tWN\u0014\u0015PU3mK\u0006\u001cX\r\u0005\u0005\u0002\u0018\u0005E\u0012QIA(!\u0011\t9%a\u0013\u000e\u0005\u0005%#B\u00011F\u0013\u0011\ti%!\u0013\u0003!I+G.Z1tK\n\u000b7/[2J]\u001a|\u0007CBA)\u00037\n\tG\u0004\u0003\u0002T\u0005]c\u0002BA\u000e\u0003+J\u0011!H\u0005\u0004\u00033b\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003;\nyFA\u0002TKFT1!!\u0017\u001d!\u0011\t9%a\u0019\n\t\u0005\u0015\u0014\u0011\n\u0002\u0014%\u0016dW-Y:f!\"\f7/\u001a+bg.\u0014vn^\u0001\u0019O\u0016$H+Y:l)f\u0004X\r\u0015:pa\u0016\u0014H/\u001f,bYV,GCBA\u000b\u0003W\n\t\tC\u0004\u0002n)\u0001\r!a\u001c\u0002\u0011Q\f7o\u001b+za\u0016\u0004B!!\u001d\u0002~5\u0011\u00111\u000f\u0006\u0005\u0003k\n9(A\u0004sK\u001adWm\u0019;\u000b\u0007}\nIHC\u0002\u0002|E\na\u0001\u001d7vO&t\u0017\u0002BA@\u0003g\u0012A\u0001V=qK\"9\u00111\u0011\u0006A\u0002\u0005U\u0011\u0001\u00049s_B,'\u000f^=OC6,\u0017!\u0003:poR{G+Y:l)\u0011\tI)a$\u0011\u0007!\fY)C\u0002\u0002\u000e&\u00141\u0003V1tW2K7\u000f\u001e*fY\u0016\f7/\u001a+bg.Dq!!%\f\u0001\u0004\t\t'A\u0002s_^\fA\u0001^5nKV!\u0011qSAP)\u0011\tI*a/\u0015\t\u0005m\u0015\u0011\u0017\t\u0005\u0003;\u000by\n\u0004\u0001\u0005\u000f\u0005\u0005FB1\u0001\u0002$\n\t\u0011)\u0005\u0003\u0002&\u0006-\u0006cA\u000e\u0002(&\u0019\u0011\u0011\u0016\u000f\u0003\u000f9{G\u000f[5oOB\u00191$!,\n\u0007\u0005=FDA\u0002B]fD\u0001\"a-\r\t\u0003\u0007\u0011QW\u0001\u0006E2|7m\u001b\t\u00067\u0005]\u00161T\u0005\u0004\u0003sc\"\u0001\u0003\u001fcs:\fW.\u001a \t\u000f\u0005uF\u00021\u0001\u0002\u0016\u0005!A-Z:d\u0003I\u0019xN\u001d;CsJ+G.Z1tKRKG\u000f\\3\u0015\t\u0005\r\u00171\u001b\t\u0006\u0003\u000b\fymZ\u0007\u0003\u0003\u000fTA!!3\u0002L\u0006!Q\u000f^5m\u0015\t\ti-\u0001\u0003kCZ\f\u0017\u0002BAi\u0003\u000f\u0014A\u0001T5ti\"9\u0011Q[\u0007A\u0002\u0005]\u0017!\u0004:fY\u0016\f7/Z:UCN\\7\u000fE\u0003\u0002R\u0005ms-A\u000btK\u0006\u00148\r\u001b*fY\u0016\f7/\u001a+bg.\u0014vn^:\u0015\u0011\u0005u\u0017q\\Aq\u0003K\u0004B\u0001X3\u0002b!)\u0001O\u0004a\u0001c\"1\u00111\u001d\bA\u0002]\fq\u0001]1hK:+X\u000eC\u0003|\u001d\u0001\u0007q\u000f")
public class SqlTaskSearchService
implements TaskSearchService,
Logging {
    private final RoleService roleService;
    private final TaskAccessService taskAccessService;
    private final InternalMetadataDecoratorService decoratorService;
    private final TaskPersistence taskPersistence;
    private final PermissionEnforcer permissionEnforcer;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlTaskSearchService sqlTaskSearchService = this;
        synchronized (sqlTaskSearchService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @Timed
    public Page<TaskListRelease> getTasksByRelease(TasksFilters tasksFilters, int page, int numberByPage) {
        Page releaseTaskRows = (Page)this.time("finding list of ReleasePhaseTaskRow", (Function0 & Serializable)() -> this.searchReleaseTaskRows(tasksFilters, page, numberByPage));
        Pageable pageable = releaseTaskRows.getPageable();
        long total = releaseTaskRows.getTotalElements();
        Map tasksByRelease = CollectionConverters$.MODULE$.ListHasAsScala(releaseTaskRows.getContent()).asScala().toSeq().groupBy((Function1 & Serializable)row -> row.releaseInfo());
        Map<String, EffectiveSecurity> effectiveSecurityByReleaseId = this.getEffectiveSecurityByReleaseId((Map<ReleaseBasicInfo, scala.collection.immutable.Seq<ReleasePhaseTaskRow>>)tasksByRelease);
        scala.collection.immutable.Seq releasesTasks = ((IterableOnceOps)tasksByRelease.collect((PartialFunction)new Serializable(this, effectiveSecurityByReleaseId){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ SqlTaskSearchService $outer;
            private final Map effectiveSecurityByReleaseId$1;

            public final <A1 extends Tuple2<ReleaseBasicInfo, scala.collection.immutable.Seq<ReleasePhaseTaskRow>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    ReleaseBasicInfo releaseInfo = (ReleaseBasicInfo)A1._1();
                    scala.collection.immutable.Seq taskRows = (scala.collection.immutable.Seq)A1._2();
                    java.util.List taskFullViews = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)taskRows.map((Function1 & Serializable)row -> $this.$outer.com$xebialabs$xlrelease$service$SqlTaskSearchService$$rowToTask((ReleasePhaseTaskRow)row))).asJava();
                    TaskListRelease taskListRelease = new TaskListRelease();
                    taskListRelease.id_$eq(releaseInfo.releaseId());
                    taskListRelease.title_$eq(releaseInfo.releaseTitle());
                    taskListRelease.status_$eq(ReleaseStatus.valueOf((String)releaseInfo.releaseStatus().toUpperCase()));
                    taskListRelease.tasks_$eq(taskFullViews);
                    taskListRelease.security_$eq((EffectiveSecurity)this.effectiveSecurityByReleaseId$1.get((Object)releaseInfo.releaseId()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
                    return (B1)taskListRelease;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<ReleaseBasicInfo, scala.collection.immutable.Seq<ReleasePhaseTaskRow>> x1) {
                Tuple2<ReleaseBasicInfo, scala.collection.immutable.Seq<ReleasePhaseTaskRow>> tuple2 = x1;
                return tuple2 != null;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.effectiveSecurityByReleaseId$1 = effectiveSecurityByReleaseId$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(com.xebialabs.xlrelease.service.SqlTaskSearchService$$anonfun$1 com.xebialabs.xlrelease.repository.sql.persistence.data.ReleasePhaseTaskRow )}, serializedLambda);
            }
        })).toSeq();
        java.util.List<TaskListRelease> sortedTasks = this.sortByReleaseTitle((scala.collection.immutable.Seq<TaskListRelease>)releasesTasks);
        PageImpl result = new PageImpl(sortedTasks, pageable, total);
        Field totalField = result.getClass().getDeclaredField("total");
        totalField.setAccessible(true);
        totalField.set(result, BoxesRunTime.boxToLong((long)total));
        return result;
    }

    private Map<String, EffectiveSecurity> getEffectiveSecurityByReleaseId(Map<ReleaseBasicInfo, scala.collection.immutable.Seq<ReleasePhaseTaskRow>> tasksByRelease) {
        this.logger().trace((Function0 & Serializable)() -> "decorateWithEffectiveSecurity called for " + tasksByRelease.size());
        java.util.List cis = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)tasksByRelease.collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Tuple2<ReleaseBasicInfo, scala.collection.immutable.Seq<ReleasePhaseTaskRow>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    ReleaseBasicInfo info = (ReleaseBasicInfo)A1._1();
                    Release r = ReleaseBuilder.newTemplate().withId(info.releaseId()).build();
                    r.set$securedCi(info.releaseSecurityUid());
                    return (B1)r;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<ReleaseBasicInfo, scala.collection.immutable.Seq<ReleasePhaseTaskRow>> x1) {
                Tuple2<ReleaseBasicInfo, scala.collection.immutable.Seq<ReleasePhaseTaskRow>> tuple2 = x1;
                return tuple2 != null;
            }
        })).toList()).asJava();
        this.decoratorService.decorate((Collection)cis, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)EffectiveSecurityDecorator$.MODULE$.EFFECTIVE_SECURITY(), (List)Nil$.MODULE$)).asJava());
        return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(cis).asScala().map((Function1 & Serializable)r -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)r.getId()), (Object)((EffectiveSecurity)r.get$metadata().get(EffectiveSecurityDecorator$.MODULE$.EFFECTIVE_SECURITY()))))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private String getTaskTypePropertyValue(Type taskType, String propertyName) {
        return (String)Option$.MODULE$.apply((Object)taskType.getDescriptor().getPropertyDescriptor(propertyName)).map((Function1 & Serializable)pd -> (String)pd.getDefaultValue()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public TaskListReleaseTask com$xebialabs$xlrelease$service$SqlTaskSearchService$$rowToTask(ReleasePhaseTaskRow row) {
        TaskRow taskRow = row.taskRow();
        TaskStatus taskStatus = TaskStatus.valueOf((String)taskRow.status().toUpperCase());
        Type taskType = Type.valueOf((String)taskRow.taskType());
        String taskColor = this.getTaskTypePropertyValue(taskType, "taskColor");
        String taskIconLocation = this.getTaskTypePropertyValue(taskType, "iconLocation");
        String taskIconClass = this.getTaskTypePropertyValue(taskType, "iconClass");
        TaskStatus taskStatus2 = taskStatus;
        TaskStatus taskStatus3 = TaskStatus.ABORTED;
        boolean taskUpdatable = (taskStatus2 == null ? taskStatus3 != null : !taskStatus2.equals(taskStatus3)) && !taskStatus.isDone() && !taskStatus.isDoneInAdvance();
        TaskListReleaseTask taskListReleaseTask = new TaskListReleaseTask();
        taskListReleaseTask.id_$eq(taskRow.taskId());
        taskListReleaseTask.title_$eq(taskRow.title());
        if (taskStatus.isOneOf(new TaskStatus[]{TaskStatus.PLANNED, TaskStatus.PENDING})) {
            taskListReleaseTask.scheduledStartDate_$eq(taskRow.startDate());
        } else {
            taskListReleaseTask.startDate_$eq(taskRow.startDate());
        }
        if (!taskStatus.isDone() && !taskStatus.isDoneInAdvance()) {
            taskListReleaseTask.dueDate_$eq(taskRow.endDate());
        } else {
            taskListReleaseTask.endDate_$eq(taskRow.endDate());
        }
        taskListReleaseTask.type_$eq(taskRow.taskType());
        taskListReleaseTask.hasBeenStarted_$eq(taskStatus.hasBeenStarted());
        taskListReleaseTask.updatable_$eq(taskUpdatable);
        taskListReleaseTask.active_$eq(taskStatus.isActive());
        taskListReleaseTask.done_$eq(taskStatus.isDone());
        taskListReleaseTask.plannedDuration_$eq((long)taskRow.plannedDuration());
        if (StringUtils.hasText((String)taskRow.owner())) {
            taskListReleaseTask.owner_$eq(new UserView(taskRow.owner()));
        }
        taskListReleaseTask.team_$eq(taskRow.team());
        taskListReleaseTask.status_$eq(taskStatus);
        taskListReleaseTask.locked_$eq(taskRow.locked());
        taskListReleaseTask.color_$eq(taskColor);
        taskListReleaseTask.customIconLocation_$eq(taskIconLocation);
        taskListReleaseTask.customIconClass_$eq(taskIconClass);
        taskListReleaseTask.editable_$eq(taskUpdatable);
        taskListReleaseTask.releaseId_$eq(row.releaseInfo().releaseId());
        taskListReleaseTask.phaseTitle_$eq(row.phaseBasicInfo().phaseTitle());
        return taskListReleaseTask;
    }

    private <A> A time(String desc, Function0<A> block) {
        long startTime = System.currentTimeMillis();
        Object res = block.apply();
        long endTime = System.currentTimeMillis();
        long total = endTime - startTime;
        this.logger().trace((Function0 & Serializable)() -> "TIME: " + desc + " took " + total);
        return (A)res;
    }

    private java.util.List<TaskListRelease> sortByReleaseTitle(scala.collection.immutable.Seq<TaskListRelease> releasesTasks) {
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)releasesTasks.sortBy((Function1 & Serializable)releaseTasks -> (String)Option$.MODULE$.apply((Object)releaseTasks.title()).getOrElse((Function0 & Serializable)() -> ""), (Ordering)Ordering.String$.MODULE$)).asJava();
    }

    public Page<ReleasePhaseTaskRow> searchReleaseTaskRows(TasksFilters tasksFilters, int pageNum, int numberByPage) {
        List allowedTaskTypes = CollectionConverters$.MODULE$.ListHasAsScala(this.taskAccessService.getAllowedTaskTypesForAuthenticatedUser()).asScala().toList();
        List allTaskTypes = CollectionConverters$.MODULE$.ListHasAsScala(this.taskAccessService.getAllTaskTypes()).asScala().toList();
        scala.collection.immutable.Seq principals = CollectionConverters$.MODULE$.CollectionHasAsScala(Permissions.authenticationToPrincipals((Authentication)Permissions.getAuthentication())).asScala().toSeq();
        scala.collection.immutable.Seq roleIds = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(this.roleService.getRolesFor(Permissions.getAuthentication())).asScala().map((Function1 & Serializable)x$1 -> x$1.getId())).toSeq();
        String username = Permissions.getAuthenticatedUserName();
        boolean isAdmin = this.permissionEnforcer.isCurrentUserAdmin();
        TaskPersistence.TaskRowsQueryParams queryParams = new TaskPersistence.TaskRowsQueryParams(tasksFilters, (List<Type>)allowedTaskTypes, (List<Type>)allTaskTypes, (scala.collection.immutable.Seq<String>)principals, (scala.collection.immutable.Seq<String>)roleIds, pageNum, numberByPage, username, isAdmin);
        Page<ReleasePhaseTaskRow> rows = this.taskPersistence.findReleaseTaskRowsByQuery(queryParams);
        return rows;
    }

    public SqlTaskSearchService(RoleService roleService, TaskAccessService taskAccessService, InternalMetadataDecoratorService decoratorService, TaskPersistence taskPersistence, PermissionEnforcer permissionEnforcer) {
        this.roleService = roleService;
        this.taskAccessService = taskAccessService;
        this.decoratorService = decoratorService;
        this.taskPersistence = taskPersistence;
        this.permissionEnforcer = permissionEnforcer;
        Logging.$init$((Logging)this);
    }
}

