package com.xebialabs.xlrelease.repository.sql.persistence

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.db.sql.SqlBuilder.Dialect
import com.xebialabs.xlrelease.db.sql.{Sql, SqlBuilder}
import com.xebialabs.xlrelease.repository.Ids.{getFolderlessId, getName}
import com.xebialabs.xlrelease.repository.sql.persistence.Schema.{FACETS, FOLDERS, RELEASES, TASKS}
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence.hash

object FacetSqlBuilder {
  val alias = "facets"
  val releaseAlias = "releases"
  val taskAlias = "tasks"
  val folderAlias = "folders"

  val STMT_SELECT_FACET: String =
    s"""SELECT
       |  $alias.${FACETS.FACET_ID},
       |  $alias.${FACETS.CI_UID},
       |  $alias.${FACETS.CI_TYPE},
       |  $folderAlias.${FOLDERS.FOLDER_ID},
       |  $folderAlias.${FOLDERS.FOLDER_PATH},
       |   $taskAlias.${TASKS.TASK_ID},
       |  $alias.${FACETS.CONTENT},
       |  $alias.${FACETS.RETRY_ATTEMPT_NUMBER},
       |  $alias.${FACETS.CREATED_VIA_API}
       | FROM ${FACETS.TABLE} $alias
       | INNER JOIN ${TASKS.TABLE} $taskAlias ON $taskAlias.${TASKS.CI_UID} = $alias.${FACETS.APPLIED_TO_TASK_UID}
       | INNER JOIN ${RELEASES.TABLE} $releaseAlias ON $releaseAlias.${RELEASES.CI_UID} = $taskAlias.${TASKS.RELEASE_UID}
       | LEFT OUTER JOIN ${FOLDERS.TABLE} $folderAlias ON $releaseAlias.${RELEASES.FOLDER_CI_UID} = $folderAlias.${FOLDERS.CI_UID}""".stripMargin
}

class FacetSqlBuilder(implicit dialect: Dialect) extends SqlBuilder[FacetSqlBuilder] {

  import FacetSqlBuilder._

  def select: FacetSqlBuilder = {
    super.select(STMT_SELECT_FACET)
  }

  def withParentId(parentId: String): FacetSqlBuilder = {
    if (parentId != null) {
      conditions += Sql(s"$releaseAlias.${RELEASES.RELEASE_ID} = ?", Seq(getName(parentId)))
    }
    this
  }

  def withTargetId(targetId: String, parentId: String = null): FacetSqlBuilder = {
    if (targetId != null) {
      conditions += Sql(s"""$taskAlias.${TASKS.TASK_ID_HASH} = ? AND $taskAlias.${TASKS.TASK_ID} = ?""", Seq(hash(targetId), getFolderlessId(targetId)))
    }
    this
  }

  def withFacetTypes(types: Seq[Type]): FacetSqlBuilder = {
    if (types != null && types.nonEmpty) {
      conditions += Sql(s"$alias.${FACETS.CI_TYPE} IN (${types.map(_ => "?").mkString(",")})", types.map(_.toString))
    }
    this
  }

  override def newInstance: FacetSqlBuilder = new FacetSqlBuilder()
}
