package com.xebialabs.xlrelease.spring.config

import com.xebialabs.xlrelease.config.CacheManagementConstants.CI_REFERENCE_CACHE_MANAGER
import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.support.cache.caffeine.spring.XlrCaffeineCacheManager
import org.springframework.cache.CacheManager
import org.springframework.context.annotation.{Bean, Configuration, Primary}

@Configuration
class SqlCiReferenceCacheConfiguration(xlrConfig: XlrConfig) {

  @Primary
  @Bean(name = Array(CI_REFERENCE_CACHE_MANAGER))
  def ciReferenceCacheManager(): CacheManager = {
    new XlrCaffeineCacheManager(CI_REFERENCE_CACHE_MANAGER, xlrConfig.getCacheSettings())
  }

}

object SqlCiReferenceCacheConfiguration {
  final val CACHE_CI_TASK_TYPES = "task-types"
  final val CACHE_CI_REFERENCE_TYPES = "ci-reference-types"
}
