/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.security;

import com.xebialabs.xlrelease.db.sql.SqlBuilder;
import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.sql.persistence.CompressionSupport;
import com.xebialabs.xlrelease.repository.sql.persistence.PersistenceSupport;
import com.xebialabs.xlrelease.repository.sql.persistence.SecuritySchema;
import com.xebialabs.xlrelease.repository.sql.persistence.Utils;
import com.xebialabs.xlrelease.repository.sql.persistence.Utils$;
import com.xebialabs.xlrelease.security.SqlUserGroupRepository$;
import com.xebialabs.xlrelease.security.UserGroupRepository;
import com.xebialabs.xlrelease.security.sql.Diff;
import com.xebialabs.xlrelease.service.CiIdService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import io.micrometer.core.annotation.Timed;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.UUID;
import org.slf4j.Marker;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Set;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\rma\u0001\u0002\"D\u00011C\u0001\"\u001b\u0001\u0003\u0002\u0003\u0006IA\u001b\u0005\ta\u0002\u0011)\u0019!C\u0001c\"Aa\u0010\u0001B\u0001B\u0003%!\u000fC\u0005\u0000\u0001\t\u0015\r\u0011\"\u0001\u0002\u0002!Q\u0011\u0011\u0007\u0001\u0003\u0002\u0003\u0006I!a\u0001\t\u000f\u0005M\u0002\u0001\"\u0001\u00026!9\u0011q\b\u0001\u0005B\u0005\u0005\u0003bBAB\u0001\u0011\u0005\u0013Q\u0011\u0005\b\u0003\u001b\u0003A\u0011IAH\u0011\u001d\t9\n\u0001C!\u00033Cq!!*\u0001\t\u0003\n9\u000bC\u0004\u00020\u0002!\t%!-\t\u000f\u0005e\u0006\u0001\"\u0011\u0002<\"9\u00111\u0019\u0001\u0005B\u0005\u0015\u0007bBAg\u0001\u0011\u0005\u0013q\u001a\u0005\b\u0003/\u0004A\u0011BAm\u0011\u001d\ty\u000e\u0001C\u0005\u0003CDq!a;\u0001\t\u0013\ti\u000fC\u0004\u0004\u0010\u0001!Ia!\u0005\b\u000f\u0005e8\t#\u0001\u0002|\u001a1!i\u0011E\u0001\u0003{Dq!a\r\u0016\t\u0003\ty\u0010C\u0005\u0003\u0002U\u0011\r\u0011\"\u0003\u0003\u0004!A!QA\u000b!\u0002\u0013\t\u0019\u0006C\u0005\u0003\bU\u0011\r\u0011\"\u0003\u0003\u0004!A!\u0011B\u000b!\u0002\u0013\t\u0019\u0006C\u0005\u0003\fU\u0011\r\u0011\"\u0003\u0003\u0004!A!QB\u000b!\u0002\u0013\t\u0019\u0006C\u0005\u0003\u0010U\u0011\r\u0011\"\u0003\u0003\u0004!A!\u0011C\u000b!\u0002\u0013\t\u0019\u0006C\u0005\u0003\u0014U\u0011\r\u0011\"\u0003\u0003\u0004!A!QC\u000b!\u0002\u0013\t\u0019\u0006C\u0005\u0003\u0018U\u0011\r\u0011\"\u0003\u0003\u0004!A!\u0011D\u000b!\u0002\u0013\t\u0019\u0006C\u0005\u0003\u001cU\u0011\r\u0011\"\u0003\u0003\u0004!A!QD\u000b!\u0002\u0013\t\u0019\u0006C\u0005\u0003 U\u0011\r\u0011\"\u0003\u0003\u0004!A!\u0011E\u000b!\u0002\u0013\t\u0019\u0006C\u0005\u0003$U\u0011\r\u0011\"\u0003\u0003\u0004!A!QE\u000b!\u0002\u0013\t\u0019F\u0002\u0004\u0003(U!%\u0011\u0006\u0005\u000b\u0005\u0007J#Q3A\u0005\u0002\t\r\u0001B\u0003B#S\tE\t\u0015!\u0003\u0002T!Q!qI\u0015\u0003\u0016\u0004%\tAa\u0001\t\u0015\t%\u0013F!E!\u0002\u0013\t\u0019\u0006C\u0004\u00024%\"\tAa\u0013\t\u0013\tU\u0013&!A\u0005\u0002\t]\u0003\"\u0003B/SE\u0005I\u0011\u0001B0\u0011%\u0011\u0019(KI\u0001\n\u0003\u0011y\u0006C\u0005\u0003v%\n\t\u0011\"\u0011\u0003x!I!qQ\u0015\u0002\u0002\u0013\u0005!\u0011\u0012\u0005\n\u0005#K\u0013\u0011!C\u0001\u0005'C\u0011Ba(*\u0003\u0003%\tE!)\t\u0013\t=\u0016&!A\u0005\u0002\tE\u0006\"\u0003B^S\u0005\u0005I\u0011\tB_\u0011%\u0011\t-KA\u0001\n\u0003\u0012\u0019\rC\u0005\u0003F&\n\t\u0011\"\u0011\u0003H\"I!\u0011Z\u0015\u0002\u0002\u0013\u0005#1Z\u0004\n\u0005\u001f,\u0012\u0011!E\u0005\u0005#4\u0011Ba\n\u0016\u0003\u0003EIAa5\t\u000f\u0005MB\b\"\u0001\u0003j\"I!Q\u0019\u001f\u0002\u0002\u0013\u0015#q\u0019\u0005\n\u0005Wd\u0014\u0011!CA\u0005[D\u0011Ba==\u0003\u0003%\tI!>\t\u0013\r\rA(!A\u0005\n\r\u0015!AF*rYV\u001bXM]$s_V\u0004(+\u001a9pg&$xN]=\u000b\u0005\u0011+\u0015\u0001C:fGV\u0014\u0018\u000e^=\u000b\u0005\u0019;\u0015!\u0003=me\u0016dW-Y:f\u0015\tA\u0015*A\u0005yK\nL\u0017\r\\1cg*\t!*A\u0002d_6\u001c\u0001aE\u0003\u0001\u001bN;\u0016\r\u0005\u0002O#6\tqJC\u0001Q\u0003\u0015\u00198-\u00197b\u0013\t\u0011vJ\u0001\u0004B]f\u0014VM\u001a\t\u0003)Vk\u0011aQ\u0005\u0003-\u000e\u00131#V:fe\u001e\u0013x.\u001e9SKB|7/\u001b;pef\u0004\"\u0001W0\u000e\u0003eS!AW.\u0002\u0017A,'o]5ti\u0016t7-\u001a\u0006\u00039v\u000b1a]9m\u0015\tqV)\u0001\u0006sKB|7/\u001b;pefL!\u0001Y-\u0003%A+'o]5ti\u0016t7-Z*vaB|'\u000f\u001e\t\u0003E\u001el\u0011a\u0019\u0006\u0003I\u0016\fQa\u001d7gi)T\u0011AZ\u0001\tOJL'P\u001f7fI&\u0011\u0001n\u0019\u0002\b\u0019><w-\u001b8h\u0003-\u0019\u0017.\u00133TKJ4\u0018nY3\u0011\u0005-tW\"\u00017\u000b\u00055,\u0015aB:feZL7-Z\u0005\u0003_2\u00141bQ5JIN+'O^5dK\u0006a!\u000e\u001a2d)\u0016l\u0007\u000f\\1uKV\t!\u000f\u0005\u0002ty6\tAO\u0003\u0002vm\u0006!1m\u001c:f\u0015\t9\b0\u0001\u0003kI\n\u001c'BA={\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"A>\u0002\u0007=\u0014x-\u0003\u0002~i\na!\n\u001a2d)\u0016l\u0007\u000f\\1uK\u0006i!\u000e\u001a2d)\u0016l\u0007\u000f\\1uK\u0002\nq\u0001Z5bY\u0016\u001cG/\u0006\u0002\u0002\u0004A!\u0011QAA\u0016\u001d\u0011\t9!!\n\u000f\t\u0005%\u0011\u0011\u0005\b\u0005\u0003\u0017\tiB\u0004\u0003\u0002\u000e\u0005ma\u0002BA\b\u00033qA!!\u0005\u0002\u00185\u0011\u00111\u0003\u0006\u0004\u0003+Y\u0015A\u0002\u001fs_>$h(C\u0001K\u0013\tA\u0015*\u0003\u0002G\u000f&\u0019\u0011qD#\u0002\u0005\u0011\u0014\u0017b\u0001/\u0002$)\u0019\u0011qD#\n\t\u0005\u001d\u0012\u0011F\u0001\u000b'Fd')^5mI\u0016\u0014(b\u0001/\u0002$%!\u0011QFA\u0018\u0005\u001d!\u0015.\u00197fGRTA!a\n\u0002*\u0005AA-[1mK\u000e$\b%\u0001\u0004=S:LGO\u0010\u000b\t\u0003o\tI$a\u000f\u0002>A\u0011A\u000b\u0001\u0005\u0006S\u001a\u0001\rA\u001b\u0005\u0006a\u001a\u0001\rA\u001d\u0005\u0007\u007f\u001a\u0001\r!a\u0001\u0002#\u0019Lg\u000eZ$s_V\u00048OR8s+N,'\u000f\u0006\u0003\u0002D\u0005e\u0003CBA#\u0003\u001b\n\u0019F\u0004\u0003\u0002H\u0005%\u0003cAA\t\u001f&\u0019\u00111J(\u0002\rA\u0013X\rZ3g\u0013\u0011\ty%!\u0015\u0003\u0007M+GOC\u0002\u0002L=\u0003B!!\u0012\u0002V%!\u0011qKA)\u0005\u0019\u0019FO]5oO\"9\u00111L\u0004A\u0002\u0005M\u0013\u0001C;tKJt\u0017-\\3)\u0007\u001d\ty\u0006\u0005\u0003\u0002b\u0005ETBAA2\u0015\u0011\t)'a\u001a\u0002\u0015\u0005tgn\u001c;bi&|gNC\u0002v\u0003SRA!a\u001b\u0002n\u0005QQ.[2s_6,G/\u001a:\u000b\u0005\u0005=\u0014AA5p\u0013\u0011\t\u0019(a\u0019\u0003\u000bQKW.\u001a3)\u0007\u001d\t9\b\u0005\u0003\u0002z\u0005}TBAA>\u0015\u0011\ti(!\u000b\u0002\u0017Q\u0014\u0018M\\:bGRLwN\\\u0005\u0005\u0003\u0003\u000bYH\u0001\u0006JgJ+\u0017\rZ(oYf\f1b\u0019:fCR,wI]8vaR!\u00111KAD\u0011\u001d\tI\t\u0003a\u0001\u0003'\n\u0011b\u001a:pkBt\u0015-\\3)\u0007!\ty&\u0001\u0007de\u0016\fG/Z$s_V\u00048\u000f\u0006\u0003\u0002D\u0005E\u0005bBAJ\u0013\u0001\u0007\u00111I\u0001\u000bOJ|W\u000f\u001d(b[\u0016\u001c\bfA\u0005\u0002`\u0005YA-\u001a7fi\u0016<%o\\;q)\u0011\tY*!)\u0011\u00079\u000bi*C\u0002\u0002 >\u0013A!\u00168ji\"9\u0011\u0011\u0012\u0006A\u0002\u0005M\u0003f\u0001\u0006\u0002`\u0005q\u0011\r\u001a3Vg\u0016\u0014Hk\\$s_V\u0004HCBAN\u0003S\u000bY\u000bC\u0004\u0002\\-\u0001\r!a\u0015\t\u000f\u0005%5\u00021\u0001\u0002T!\u001a1\"a\u0018\u0002\u001f\u0005$G-V:feR{wI]8vaN$b!a'\u00024\u0006U\u0006bBA.\u0019\u0001\u0007\u00111\u000b\u0005\b\u0003'c\u0001\u0019AA\"Q\ra\u0011qL\u0001\u0014e\u0016lwN^3Vg\u0016\u0014hI]8n\u000fJ|W\u000f\u001d\u000b\u0007\u00037\u000bi,a0\t\u000f\u0005mS\u00021\u0001\u0002T!9\u0011\u0011R\u0007A\u0002\u0005M\u0003fA\u0007\u0002`\u0005!\"/Z7pm\u0016,6/\u001a:Ge>lwI]8vaN$b!a'\u0002H\u0006%\u0007bBA.\u001d\u0001\u0007\u00111\u000b\u0005\b\u0003's\u0001\u0019AA\"Q\rq\u0011qL\u0001\u001ekB$\u0017\r^3He>,\bo]'f[\n,'o\u001d5ja\u001a{'/V:feR1\u00111TAi\u0003'Dq!a\u0017\u0010\u0001\u0004\t\u0019\u0006C\u0004\u0002\u0014>\u0001\r!a\u0011)\u0007=\ty&A\tuef\fE\rZ+tKJ$vn\u0012:pkB$b!a'\u0002\\\u0006u\u0007bBA.!\u0001\u0007\u00111\u000b\u0005\b\u0003\u0013\u0003\u0002\u0019AA*\u0003-1\u0017N\u001c3He>,\b/\u00133\u0015\t\u0005\r\u0018\u0011\u001e\t\u0006\u001d\u0006\u0015\u00181K\u0005\u0004\u0003O|%AB(qi&|g\u000eC\u0004\u0002\nF\u0001\r!a\u0015\u0002\u0015\u0019Lg\u000eZ$s_V\u00048\u000f\u0006\u0003\u0002p\u000e5\u0001CBA#\u0003\u001b\n\t\u0010E\u0002\u0002t&r1!!>\u0015\u001d\u0011\tY!a>\n\u0005\u0011+\u0015AF*rYV\u001bXM]$s_V\u0004(+\u001a9pg&$xN]=\u0011\u0005Q+2CA\u000bN)\t\tY0A\rT)6#vLR%O\t~;%kT+Q'~3uJU0V'\u0016\u0013VCAA*\u0003i\u0019F+\u0014+`\r&sEiX$S\u001fV\u00036k\u0018$P%~+6+\u0012*!\u0003E\u0019F+\u0014+`\u0013:\u001bVI\u0015+`\u000fJ{U\u000bU\u0001\u0013'RkEkX%O'\u0016\u0013FkX$S\u001fV\u0003\u0006%A\tT)6#v\fR#M\u000bR+ul\u0012*P+B\u000b!c\u0015+N)~#U\tT#U\u000b~;%kT+QA\u0005Q3\u000bV'U?\u0012+E*\u0012+F?V\u001bVIU0H%>+\u0006kX'F\u001b\n+%k\u0015%J!~\u0013\u0015lX$S\u001fV\u0003\u0016aK*U\u001bR{F)\u0012'F)\u0016{VkU#S?\u001e\u0013v*\u0016)`\u001b\u0016k%)\u0012*T\u0011&\u0003vLQ-`\u000fJ{U\u000b\u0015\u0011\u0002CM#V\nV0J\u001dN+%\u000bV0V'\u0016\u0013vl\u0012*P+B{V*R'C\u000bJ\u001b\u0006*\u0013)\u0002EM#V\nV0J\u001dN+%\u000bV0V'\u0016\u0013vl\u0012*P+B{V*R'C\u000bJ\u001b\u0006*\u0013)!\u0003\u0005\u001aF+\u0014+`\t\u0016cU\tV#`+N+%kX$S\u001fV\u0003v,T#N\u0005\u0016\u00136\u000bS%Q\u0003\t\u001aF+\u0014+`\t\u0016cU\tV#`+N+%kX$S\u001fV\u0003v,T#N\u0005\u0016\u00136\u000bS%QA\u0005\u00113\u000bV'U?\u0012+E*\u0012+F?V\u001bVIU0H%>+\u0006kU0N\u000b6\u0013UIU*I\u0013B\u000b1e\u0015+N)~#U\tT#U\u000b~+6+\u0012*`\u000fJ{U\u000bU*`\u001b\u0016k%)\u0012*T\u0011&\u0003\u0006%\u0001\nT)6#vLR%O\t~;%kT+Q?&#\u0015aE*U\u001bR{f)\u0013(E?\u001e\u0013v*\u0016)`\u0013\u0012\u0003\u0013\u0001E*U\u001bR{f)\u0013(E?\u001e\u0013v*\u0016)T\u0003E\u0019F+\u0014+`\r&sEiX$S\u001fV\u00036\u000b\t\u0002\u0006\u000fJ|W\u000f]\n\u0007S5\u0013YC!\r\u0011\u00079\u0013i#C\u0002\u00030=\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0003\u00034\tub\u0002\u0002B\u001b\u0005sqA!!\u0005\u00038%\t\u0001+C\u0002\u0003<=\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0003@\t\u0005#\u0001D*fe&\fG.\u001b>bE2,'b\u0001B\u001e\u001f\u0006\u0011\u0011\u000eZ\u0001\u0004S\u0012\u0004\u0013\u0001\u00028b[\u0016\fQA\\1nK\u0002\"bA!\u0014\u0003R\tM\u0003c\u0001B(S5\tQ\u0003C\u0004\u0003D9\u0002\r!a\u0015\t\u000f\t\u001dc\u00061\u0001\u0002T\u0005!1m\u001c9z)\u0019\u0011iE!\u0017\u0003\\!I!1I\u0018\u0011\u0002\u0003\u0007\u00111\u000b\u0005\n\u0005\u000fz\u0003\u0013!a\u0001\u0003'\nabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003b)\"\u00111\u000bB2W\t\u0011)\u0007\u0005\u0003\u0003h\t=TB\u0001B5\u0015\u0011\u0011YG!\u001c\u0002\u0013Ut7\r[3dW\u0016$'bAA3\u001f&!!\u0011\u000fB5\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011!\u0011\u0010\t\u0005\u0005w\u0012))\u0004\u0002\u0003~)!!q\u0010BA\u0003\u0011a\u0017M\\4\u000b\u0005\t\r\u0015\u0001\u00026bm\u0006LA!a\u0016\u0003~\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011!1\u0012\t\u0004\u001d\n5\u0015b\u0001BH\u001f\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!Q\u0013BN!\rq%qS\u0005\u0004\u00053{%aA!os\"I!Q\u0014\u001b\u0002\u0002\u0003\u0007!1R\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\t\r\u0006C\u0002BS\u0005W\u0013)*\u0004\u0002\u0003(*\u0019!\u0011V(\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003.\n\u001d&\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$BAa-\u0003:B\u0019aJ!.\n\u0007\t]vJA\u0004C_>dW-\u00198\t\u0013\tue'!AA\u0002\tU\u0015A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$BA!\u001f\u0003@\"I!QT\u001c\u0002\u0002\u0003\u0007!1R\u0001\tQ\u0006\u001c\bnQ8eKR\u0011!1R\u0001\ti>\u001cFO]5oOR\u0011!\u0011P\u0001\u0007KF,\u0018\r\\:\u0015\t\tM&Q\u001a\u0005\n\u0005;S\u0014\u0011!a\u0001\u0005+\u000bQa\u0012:pkB\u00042Aa\u0014='\u0015a$Q\u001bBq!)\u00119N!8\u0002T\u0005M#QJ\u0007\u0003\u00053T1Aa7P\u0003\u001d\u0011XO\u001c;j[\u0016LAAa8\u0003Z\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0011\t\t\r(q]\u0007\u0003\u0005KTA!a\u001c\u0003\u0002&!!q\bBs)\t\u0011\t.A\u0003baBd\u0017\u0010\u0006\u0004\u0003N\t=(\u0011\u001f\u0005\b\u0005\u0007z\u0004\u0019AA*\u0011\u001d\u00119e\u0010a\u0001\u0003'\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003x\n}\b#\u0002(\u0002f\ne\bc\u0002(\u0003|\u0006M\u00131K\u0005\u0004\u0005{|%A\u0002+va2,'\u0007C\u0005\u0004\u0002\u0001\u000b\t\u00111\u0001\u0003N\u0005\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\r\u001d\u0001\u0003\u0002B>\u0007\u0013IAaa\u0003\u0003~\t1qJ\u00196fGRDq!a%\u0013\u0001\u0004\t\u0019%A\bhK:,'/\u0019;f\u000fJ|W\u000f]%e)\t\t\u0019\u0006K\u0002\u0001\u0007+\u0001B!!\u001f\u0004\u0018%!1\u0011DA>\u0005=I5\u000f\u0016:b]N\f7\r^5p]\u0006d\u0007")
public class SqlUserGroupRepository
implements UserGroupRepository,
PersistenceSupport,
Logging {
    private final CiIdService ciIdService;
    private final JdbcTemplate jdbcTemplate;
    private final SqlBuilder.Dialect dialect;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private NamedParameterJdbcTemplate namedTemplate;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    @Override
    public MapSqlParameterSource paramMap2MapSqlParameterSource(Map<String, Object> params) {
        return PersistenceSupport.paramMap2MapSqlParameterSource$(this, params);
    }

    @Override
    public Integer sqlInsert(String pkColumn, String sqlStatement, Map<String, Object> params) {
        return PersistenceSupport.sqlInsert$(this, pkColumn, sqlStatement, params);
    }

    @Override
    public <R> R sqlInsert(String pkColumn, String sqlStatement, Map<String, Object> params, Function1<Integer, R> mapper) {
        return (R)PersistenceSupport.sqlInsert$((PersistenceSupport)this, pkColumn, sqlStatement, params, mapper);
    }

    @Override
    public <R> R sqlInsert(String pkColumn, String sqlStatement, MapSqlParameterSource params, Function1<Integer, R> mapper) {
        return (R)PersistenceSupport.sqlInsert$((PersistenceSupport)this, pkColumn, sqlStatement, params, mapper);
    }

    @Override
    public void sqlInsert(String sqlStatement, MapSqlParameterSource params) {
        PersistenceSupport.sqlInsert$(this, sqlStatement, params);
    }

    @Override
    public <R> R sqlExec(String sqlStatement, Map<String, Object> params, PreparedStatementCallback<R> callback) {
        return (R)PersistenceSupport.sqlExec$(this, sqlStatement, params, callback);
    }

    @Override
    public <R> R sqlExecWithContent(String sqlStatement, Map<String, Object> params, Tuple2<String, String> contentParam, Function1<Object, R> mapper) {
        return (R)PersistenceSupport.sqlExecWithContent$(this, sqlStatement, params, contentParam, mapper);
    }

    @Override
    public <R> R sqlInsertWithContent(String pkColumn, String sqlStatement, Map<String, Object> params, Tuple2<String, String> contentParam, Function1<Integer, R> mapper) {
        return (R)PersistenceSupport.sqlInsertWithContent$(this, pkColumn, sqlStatement, params, contentParam, mapper);
    }

    @Override
    public <R> R sqlUpdate(String sqlStatement, MapSqlParameterSource params, Function1<Object, R> mapper) {
        return (R)PersistenceSupport.sqlUpdate$(this, sqlStatement, params, mapper);
    }

    @Override
    public <R> R sqlSet(String sqlStatement, Function1<PreparedStatement, PreparedStatement> setup, Function1<Object, R> callback) {
        return (R)PersistenceSupport.sqlSet$(this, sqlStatement, setup, callback);
    }

    @Override
    public Function1<Object, BoxedUnit> checkCiUpdated(String entityId) {
        return PersistenceSupport.checkCiUpdated$(this, entityId);
    }

    @Override
    public Function1<Object, UUID> checkCiUpdated(Integer uid, Option<UUID> token, UUID freshToken) {
        return PersistenceSupport.checkCiUpdated$(this, uid, token, freshToken);
    }

    @Override
    public Function1<Object, BoxedUnit> checkCiDeleted(Integer uid) {
        return PersistenceSupport.checkCiDeleted$(this, uid);
    }

    @Override
    public <R> Buffer<R> sqlQuery(String sqlStatement, Map<String, Object> params, RowMapper<R> mapper) {
        return PersistenceSupport.sqlQuery$((PersistenceSupport)this, sqlStatement, params, mapper);
    }

    @Override
    public <R> Buffer<R> sqlQuery(String sqlStatement, Map<String, Object> params, Function1<ResultSet, R> mapper) {
        return PersistenceSupport.sqlQuery$((PersistenceSupport)this, sqlStatement, params, mapper);
    }

    @Override
    public <R> R sqlQuery(String sqlStatement, Map<String, Object> params, ResultSetExtractor<R> extractor) {
        return (R)PersistenceSupport.sqlQuery$((PersistenceSupport)this, sqlStatement, params, extractor);
    }

    @Override
    public Seq<Object> sqlBatch(String sqlStatement, scala.collection.immutable.Set<Map<String, Object>> parameters) {
        return PersistenceSupport.sqlBatch$(this, sqlStatement, parameters);
    }

    @Override
    public Seq<Object> sqlBatchWithContent(String sqlStatement, Seq<Tuple2<Map<String, Object>, Tuple2<String, String>>> params) {
        return PersistenceSupport.sqlBatchWithContent$(this, sqlStatement, params);
    }

    @Override
    public String pkName(String pkColumn) {
        return PersistenceSupport.pkName$(this, pkColumn);
    }

    @Override
    public MapSqlParameterSource paramSource(Seq<Tuple2<String, Object>> pairs) {
        return PersistenceSupport.paramSource$(this, pairs);
    }

    @Override
    public byte[] compress(String text) {
        return CompressionSupport.compress$((CompressionSupport)this, text);
    }

    @Override
    public String decompress(InputStream inputStream) {
        return CompressionSupport.decompress$((CompressionSupport)this, inputStream);
    }

    @Override
    public byte[] compress(byte[] byteArray) {
        return CompressionSupport.compress$((CompressionSupport)this, byteArray);
    }

    @Override
    public byte[] decompress(byte[] byteArray) {
        return CompressionSupport.decompress$((CompressionSupport)this, byteArray);
    }

    @Override
    public <A> Option<A> findOptional(Function1<JdbcTemplate, A> body, JdbcTemplate jdbcTemplate) {
        return Utils.findOptional$(this, body, jdbcTemplate);
    }

    @Override
    public <A> Option<A> findOne(Function0<Buffer<A>> body) {
        return Utils.findOne$(this, body);
    }

    @Override
    public <A> Seq<A> findMany(Function0<Buffer<A>> body) {
        return Utils.findMany$(this, body);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SqlUserGroupRepository sqlUserGroupRepository = this;
        synchronized (sqlUserGroupRepository) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    private NamedParameterJdbcTemplate namedTemplate$lzycompute() {
        SqlUserGroupRepository sqlUserGroupRepository = this;
        synchronized (sqlUserGroupRepository) {
            if (!this.bitmap$0) {
                this.namedTemplate = PersistenceSupport.namedTemplate$(this);
                this.bitmap$0 = true;
            }
        }
        return this.namedTemplate;
    }

    @Override
    public NamedParameterJdbcTemplate namedTemplate() {
        if (!this.bitmap$0) {
            return this.namedTemplate$lzycompute();
        }
        return this.namedTemplate;
    }

    @Override
    public JdbcTemplate jdbcTemplate() {
        return this.jdbcTemplate;
    }

    @Override
    public SqlBuilder.Dialect dialect() {
        return this.dialect;
    }

    @Timed
    @IsReadOnly
    public scala.collection.immutable.Set<String> findGroupsForUser(String username) {
        Assert.hasText((String)username, (String)"username cannot be empty");
        this.logger().trace((Function0 & Serializable)() -> "Finding groups for user '" + username + "'");
        return this.findMany((Function0 & Serializable)() -> this.sqlQuery(SqlUserGroupRepository$.MODULE$.com$xebialabs$xlrelease$security$SqlUserGroupRepository$$STMT_FIND_GROUPS_FOR_USER(), Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecuritySchema.GROUP_PRINCIPALS$.MODULE$.PRINCIPAL_NAME()), (Object)username.toLowerCase())})), (Function1 & Serializable)rs -> rs.getString(SecuritySchema.GROUPS$.MODULE$.NAME()))).toSet();
    }

    @Timed
    public String createGroup(String groupName) {
        Assert.hasText((String)groupName, (String)"groupName cannot be empty");
        this.logger().trace((Function0 & Serializable)() -> "Creating new group '" + groupName + "'");
        String groupId = this.generateGroupId();
        this.sqlInsert(SqlUserGroupRepository$.MODULE$.com$xebialabs$xlrelease$security$SqlUserGroupRepository$$STMT_INSERT_GROUP(), this.paramMap2MapSqlParameterSource(Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecuritySchema.GROUPS$.MODULE$.ID()), (Object)groupId), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecuritySchema.GROUPS$.MODULE$.NAME()), (Object)groupName)}))));
        return groupId;
    }

    @Timed
    public scala.collection.immutable.Set<String> createGroups(scala.collection.immutable.Set<String> groupNames) {
        Assert.notEmpty((Collection)CollectionConverters$.MODULE$.SetHasAsJava(groupNames).asJava(), (String)"groupNames cannot be empty");
        scala.collection.immutable.Set nonEmptyGroupNames = (scala.collection.immutable.Set)groupNames.filter((Function1 & Serializable)str -> BoxesRunTime.boxToBoolean((boolean)SqlUserGroupRepository.$anonfun$createGroups$1(str)));
        return nonEmptyGroupNames.grouped(100).flatMap((Function1 & Serializable)chunkedGroupNames -> {
            scala.collection.immutable.Set groups = (scala.collection.immutable.Set)chunkedGroupNames.map((Function1 & Serializable)x$1 -> new Group(this.generateGroupId(), (String)x$1));
            this.sqlBatch(SqlUserGroupRepository$.MODULE$.com$xebialabs$xlrelease$security$SqlUserGroupRepository$$STMT_INSERT_GROUP(), (scala.collection.immutable.Set<Map<String, Object>>)((scala.collection.immutable.Set)groups.map((Function1 & Serializable)group -> Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecuritySchema.GROUPS$.MODULE$.ID()), (Object)group.id()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecuritySchema.GROUPS$.MODULE$.NAME()), (Object)group.name())})))));
            return (scala.collection.immutable.Set)groups.map((Function1 & Serializable)x$2 -> x$2.id());
        }).toSet();
    }

    @Timed
    public void deleteGroup(String groupName) {
        Assert.hasText((String)groupName, (String)"groupName cannot be empty");
        this.logger().trace((Function0 & Serializable)() -> "Deleting group '" + groupName + "'");
        Option<String> option = this.findGroupId(groupName);
        if (option instanceof Some) {
            Some some = (Some)option;
            String groupId = (String)some.value();
            this.sqlExec(SqlUserGroupRepository$.MODULE$.com$xebialabs$xlrelease$security$SqlUserGroupRepository$$STMT_DELETE_USER_GROUP_MEMBERSHIP_BY_GROUP(), Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecuritySchema.GROUP_PRINCIPALS$.MODULE$.GROUP_ID()), (Object)groupId)})), x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.execute()));
            this.sqlExec(SqlUserGroupRepository$.MODULE$.com$xebialabs$xlrelease$security$SqlUserGroupRepository$$STMT_DELETE_GROUP(), Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecuritySchema.GROUPS$.MODULE$.NAME()), (Object)groupName)})), x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.execute()));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            this.logger().trace((Function0 & Serializable)() -> "Group '" + groupName + "' not found");
            return;
        }
        throw new MatchError(option);
    }

    @Timed
    public void addUserToGroup(String username, String groupName) {
        String string;
        Assert.hasText((String)username, (String)"username cannot be empty");
        Assert.hasText((String)groupName, (String)"groupName cannot be empty");
        this.logger().trace((Function0 & Serializable)() -> "Adding user '" + username + "' to group '" + groupName + "'");
        Option<String> option = this.findGroupId(groupName);
        if (option instanceof Some) {
            String id;
            Some some = (Some)option;
            string = id = (String)some.value();
        } else if (None$.MODULE$.equals(option)) {
            string = this.createGroup(groupName);
        } else {
            throw new MatchError(option);
        }
        String groupId = string;
        this.sqlInsert(SqlUserGroupRepository$.MODULE$.com$xebialabs$xlrelease$security$SqlUserGroupRepository$$STMT_INSERT_USER_GROUP_MEMBERSHIP(), this.paramMap2MapSqlParameterSource(Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecuritySchema.GROUP_PRINCIPALS$.MODULE$.GROUP_ID()), (Object)groupId), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecuritySchema.GROUP_PRINCIPALS$.MODULE$.PRINCIPAL_NAME()), (Object)username.toLowerCase())}))));
    }

    @Timed
    public void addUserToGroups(String username, scala.collection.immutable.Set<String> groupNames) {
        scala.collection.immutable.Set set;
        Assert.hasText((String)username, (String)"username cannot be empty");
        Assert.notEmpty((Collection)CollectionConverters$.MODULE$.SetHasAsJava(groupNames).asJava(), (String)"groupNames cannot be empty");
        this.logger().trace((Function0 & Serializable)() -> "Adding user '" + username + "' to groups '" + groupNames + "'");
        scala.collection.immutable.Set<Group> existingGroups = this.findGroups(groupNames);
        scala.collection.immutable.Set newGroups = (scala.collection.immutable.Set)groupNames.filterNot((Function1)existingGroups.map((Function1 & Serializable)x$5 -> x$5.name()));
        if (newGroups.nonEmpty()) {
            scala.collection.immutable.Set<String> newGroupIds = this.createGroups((scala.collection.immutable.Set<String>)newGroups);
            set = (scala.collection.immutable.Set)newGroupIds.$plus$plus((IterableOnce)existingGroups.map((Function1 & Serializable)x$6 -> x$6.id()));
        } else {
            set = (scala.collection.immutable.Set)existingGroups.map((Function1 & Serializable)x$7 -> x$7.id());
        }
        scala.collection.immutable.Set groupIds = set;
        groupIds.grouped(100).foreach((Function1 & Serializable)chunkedGroupIds -> this.sqlBatch(SqlUserGroupRepository$.MODULE$.com$xebialabs$xlrelease$security$SqlUserGroupRepository$$STMT_INSERT_USER_GROUP_MEMBERSHIP(), (scala.collection.immutable.Set<Map<String, Object>>)((scala.collection.immutable.Set)chunkedGroupIds.map((Function1 & Serializable)groupId -> Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecuritySchema.GROUP_PRINCIPALS$.MODULE$.GROUP_ID()), groupId), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecuritySchema.GROUP_PRINCIPALS$.MODULE$.PRINCIPAL_NAME()), (Object)username.toLowerCase())}))))));
    }

    @Timed
    public void removeUserFromGroup(String username, String groupName) {
        Assert.hasText((String)username, (String)"username cannot be empty");
        Assert.hasText((String)groupName, (String)"groupName cannot be empty");
        this.logger().trace((Function0 & Serializable)() -> "Removing user '" + username + "' from group '" + groupName + "'");
        Option<String> option = this.findGroupId(groupName);
        if (option instanceof Some) {
            Some some = (Some)option;
            String groupId = (String)some.value();
            this.sqlExec(SqlUserGroupRepository$.MODULE$.com$xebialabs$xlrelease$security$SqlUserGroupRepository$$STMT_DELETE_USER_GROUP_MEMBERSHIP(), Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecuritySchema.GROUP_PRINCIPALS$.MODULE$.GROUP_ID()), (Object)groupId), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecuritySchema.GROUP_PRINCIPALS$.MODULE$.PRINCIPAL_NAME()), (Object)username.toLowerCase())})), x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.execute()));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            this.logger().trace((Function0 & Serializable)() -> "Group '" + groupName + "' not found");
            return;
        }
        throw new MatchError(option);
    }

    @Timed
    public void removeUserFromGroups(String username, scala.collection.immutable.Set<String> groupNames) {
        Assert.hasText((String)username, (String)"username cannot be empty");
        Assert.notEmpty((Collection)CollectionConverters$.MODULE$.SetHasAsJava(groupNames).asJava(), (String)"groupNames cannot be empty");
        this.logger().trace((Function0 & Serializable)() -> "Removing user '" + username + "' from groups '" + groupNames + "'");
        scala.collection.immutable.Set groupIds = (scala.collection.immutable.Set)this.findGroups(groupNames).map((Function1 & Serializable)x$9 -> x$9.id());
        groupIds.grouped(100).foreach((Function1 & Serializable)chunkedGroupIds -> BoxesRunTime.boxToBoolean((boolean)SqlUserGroupRepository.$anonfun$removeUserFromGroups$3(this, username, chunkedGroupIds)));
    }

    @Timed
    public void updateGroupsMembershipForUser(String username, scala.collection.immutable.Set<String> groupNames) {
        scala.collection.immutable.Set<String> existingGroupsMembership = this.findGroupsForUser(username);
        Diff diff = new Diff(existingGroupsMembership, groupNames);
        diff.newEntries().foreach((Function1 & Serializable)x$11 -> {
            this.tryAddUserToGroup(username, x$11);
            return BoxedUnit.UNIT;
        });
        diff.deletedEntries().foreach((Function1 & Serializable)x$12 -> {
            this.removeUserFromGroup(username, x$12);
            return BoxedUnit.UNIT;
        });
    }

    private void tryAddUserToGroup(String username, String groupName) {
        boolean bl = false;
        Failure failure = null;
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.addUserToGroup(username, groupName));
        if (try_ instanceof Success) {
            this.logger().trace((Function0 & Serializable)() -> "Group " + groupName + " inserted successfully for user " + username);
            return;
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            Throwable e = failure.exception();
            if (e instanceof DuplicateKeyException) {
                DuplicateKeyException duplicateKeyException = (DuplicateKeyException)e;
                this.logger().trace((Function0 & Serializable)() -> "Group " + groupName + " insertion failed for user " + username + ": " + duplicateKeyException.getMessage());
                return;
            }
        }
        if (bl) {
            Throwable e = failure.exception();
            this.logger().warn((Function0 & Serializable)() -> "Unexpected failure accrued during group " + groupName + " insert for user " + username + ": " + e.getMessage());
            throw e;
        }
        throw new MatchError((Object)try_);
    }

    private Option<String> findGroupId(String groupName) {
        return this.findOne((Function0 & Serializable)() -> this.sqlQuery(SqlUserGroupRepository$.MODULE$.com$xebialabs$xlrelease$security$SqlUserGroupRepository$$STMT_FIND_GROUP_ID(), Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecuritySchema.GROUPS$.MODULE$.NAME()), (Object)groupName)})), (Function1 & Serializable)rs -> rs.getString(SecuritySchema.GROUPS$.MODULE$.ID())));
    }

    private scala.collection.immutable.Set<Group> findGroups(scala.collection.immutable.Set<String> groupNames) {
        return ((IterableOps)groupNames.filter((Function1 & Serializable)str -> BoxesRunTime.boxToBoolean((boolean)SqlUserGroupRepository.$anonfun$findGroups$1(str)))).grouped(100).flatMap((Function1 & Serializable)chunkedGroupNames -> this.sqlQuery(SqlUserGroupRepository$.MODULE$.com$xebialabs$xlrelease$security$SqlUserGroupRepository$$STMT_FIND_GROUPS(), Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecuritySchema.GROUPS$.MODULE$.NAME()), (Object)CollectionConverters$.MODULE$.SetHasAsJava((Set)chunkedGroupNames).asJava())})), (Function1 & Serializable)rs -> new Group(rs.getString(SecuritySchema.GROUPS$.MODULE$.ID()), rs.getString(SecuritySchema.GROUPS$.MODULE$.NAME())))).toSet();
    }

    private String generateGroupId() {
        return Ids.getName((String)this.ciIdService.getUniqueId("Group", ""));
    }

    public static final /* synthetic */ boolean $anonfun$createGroups$1(String str) {
        return StringUtils.hasText((String)str);
    }

    public static final /* synthetic */ boolean $anonfun$removeUserFromGroups$3(SqlUserGroupRepository $this, String username$5, scala.collection.immutable.Set chunkedGroupIds) {
        return BoxesRunTime.unboxToBoolean($this.sqlExec(SqlUserGroupRepository$.MODULE$.com$xebialabs$xlrelease$security$SqlUserGroupRepository$$STMT_DELETE_USER_GROUPS_MEMBERSHIP(), Utils$.MODULE$.params((Seq<Tuple2<String, ?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecuritySchema.GROUP_PRINCIPALS$.MODULE$.PRINCIPAL_NAME()), (Object)username$5.toLowerCase()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SecuritySchema.GROUP_PRINCIPALS$.MODULE$.GROUP_ID()), (Object)CollectionConverters$.MODULE$.SetHasAsJava((Set)chunkedGroupIds).asJava())})), x$10 -> BoxesRunTime.boxToBoolean((boolean)x$10.execute())));
    }

    public static final /* synthetic */ boolean $anonfun$findGroups$1(String str) {
        return StringUtils.hasText((String)str);
    }

    public SqlUserGroupRepository(CiIdService ciIdService, JdbcTemplate jdbcTemplate, SqlBuilder.Dialect dialect) {
        this.ciIdService = ciIdService;
        this.jdbcTemplate = jdbcTemplate;
        this.dialect = dialect;
        Utils.$init$(this);
        CompressionSupport.$init$(this);
        PersistenceSupport.$init$(this);
        Logging.$init$((Logging)this);
    }

    private static class Group
    implements Product,
    Serializable {
        private final String id;
        private final String name;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String id() {
            return this.id;
        }

        public String name() {
            return this.name;
        }

        public Group copy(String id, String name) {
            return new Group(id, name);
        }

        public String copy$default$1() {
            return this.id();
        }

        public String copy$default$2() {
            return this.name();
        }

        public String productPrefix() {
            return "Group";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.id();
                }
                case 1: {
                    return this.name();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Group;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "id";
                }
                case 1: {
                    return "name";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Group)) return false;
            boolean bl = true;
            if (!bl) return false;
            Group group = (Group)x$1;
            String string = this.id();
            String string2 = group.id();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.name();
            String string4 = group.name();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            if (!group.canEqual(this)) return false;
            return true;
        }

        public Group(String id, String name) {
            this.id = id;
            this.name = name;
            Product.$init$((Product)this);
        }
    }
}

