/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.license.License;
import com.xebialabs.license.LicenseProperty;
import com.xebialabs.license.LicenseVersion4;
import com.xebialabs.license.service.LicenseService;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseExtension;
import com.xebialabs.xlrelease.domain.ReleaseKind;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.exception.LicenseLimitReachedException;
import com.xebialabs.xlrelease.plugins.dashboard.domain.Dashboard;
import com.xebialabs.xlrelease.repository.FolderRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.PersistenceInterceptor;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.sql.ReleasePersistenceInterceptor$;
import com.xebialabs.xlrelease.repository.sql.WorkflowInterceptorLogic;
import com.xebialabs.xlrelease.repository.sql.WorkflowTaskValidator;
import com.xebialabs.xlrelease.repository.sql.persistence.TaskPersistence;
import java.io.Serializable;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import scala.Function1;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Component
@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\u0005Me\u0001B\u000e\u001d\u0001\u001dB\u0001\"\u0011\u0001\u0003\u0002\u0003\u0006IA\u0011\u0005\t\u000b\u0002\u0011)\u0019!C\u0001\r\"AQ\n\u0001B\u0001B\u0003%q\t\u0003\u0005O\u0001\t\u0005\t\u0015!\u0003P\u0011!\u0011\u0006A!A!\u0002\u0013\u0019\u0006\"B.\u0001\t\u0003a\u0006\"\u00022\u0001\t\u0003\u001a\u0007\"\u00027\u0001\t\u0003j\u0007\"B8\u0001\t\u0013\u0001\b\"B:\u0001\t\u0013!\b\"\u0002<\u0001\t\u00139\b\"B=\u0001\t\u0013Q\b\"\u0002?\u0001\t\u0013i\bBB@\u0001\t\u0013\t\t\u0001C\u0004\u0002\u0006\u0001!I!a\u0002\t\u000f\u0005-\u0001\u0001\"\u0003\u0002\u000e!9\u0011\u0011\u0003\u0001\u0005\n\u0005M\u0001bBA\f\u0001\u0011%\u0011\u0011\u0004\u0005\b\u0003;\u0001A\u0011BA\u0010\u000f\u001d\t\t\u0007\bE\u0001\u0003G2aa\u0007\u000f\t\u0002\u0005\u0015\u0004BB.\u0016\t\u0003\ti\u0007C\u0005\u0002pU\u0011\r\u0011\"\u0003\u0002r!A\u0011\u0011P\u000b!\u0002\u0013\t\u0019\bC\u0005\u0002|U\u0011\r\u0011\"\u0003\u0002~!A\u0011\u0011S\u000b!\u0002\u0013\tyHA\u000fSK2,\u0017m]3QKJ\u001c\u0018n\u001d;f]\u000e,\u0017J\u001c;fe\u000e,\u0007\u000f^8s\u0015\tib$A\u0002tc2T!a\b\u0011\u0002\u0015I,\u0007o\\:ji>\u0014\u0018P\u0003\u0002\"E\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003G\u0011\n\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003\u0015\n1aY8n\u0007\u0001\u0019R\u0001\u0001\u00151uy\u0002\"!\u000b\u0018\u000e\u0003)R!a\u000b\u0017\u0002\t1\fgn\u001a\u0006\u0002[\u0005!!.\u0019<b\u0013\ty#F\u0001\u0004PE*,7\r\u001e\t\u0004cI\"T\"\u0001\u0010\n\u0005Mr\"A\u0006)feNL7\u000f^3oG\u0016Le\u000e^3sG\u0016\u0004Ho\u001c:\u0011\u0005UBT\"\u0001\u001c\u000b\u0005]\u0002\u0013A\u00023p[\u0006Lg.\u0003\u0002:m\t9!+\u001a7fCN,\u0007CA\u001e=\u001b\u0005a\u0012BA\u001f\u001d\u0005U9vN]6gY><H+Y:l-\u0006d\u0017\u000eZ1u_J\u0004\"aO \n\u0005\u0001c\"\u0001G,pe.4Gn\\<J]R,'oY3qi>\u0014Hj\\4jG\u0006\t\"/\u001a7fCN,'+\u001a9pg&$xN]=\u0011\u0005E\u001a\u0015B\u0001#\u001f\u0005E\u0011V\r\\3bg\u0016\u0014V\r]8tSR|'/_\u0001\u0010i\u0006\u001c8\u000eU3sg&\u001cH/\u001a8dKV\tq\t\u0005\u0002I\u00176\t\u0011J\u0003\u0002K9\u0005Y\u0001/\u001a:tSN$XM\\2f\u0013\ta\u0015JA\bUCN\\\u0007+\u001a:tSN$XM\\2f\u0003A!\u0018m]6QKJ\u001c\u0018n\u001d;f]\u000e,\u0007%\u0001\tg_2$WM\u001d*fa>\u001c\u0018\u000e^8ssB\u0011\u0011\u0007U\u0005\u0003#z\u0011\u0001CR8mI\u0016\u0014(+\u001a9pg&$xN]=\u0002\u001d1L7-\u001a8tKN+'O^5dKB\u0011A+W\u0007\u0002+*\u0011akV\u0001\bg\u0016\u0014h/[2f\u0015\tA&%A\u0004mS\u000e,gn]3\n\u0005i+&A\u0004'jG\u0016t7/Z*feZL7-Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000busv\fY1\u0011\u0005m\u0002\u0001\"B!\u0007\u0001\u0004\u0011\u0005\"B#\u0007\u0001\u00049\u0005\"\u0002(\u0007\u0001\u0004y\u0005\"\u0002*\u0007\u0001\u0004\u0019\u0016\u0001C8o\u0007J,\u0017\r^3\u0015\u0005\u0011T\u0007CA3i\u001b\u00051'\"A4\u0002\u000bM\u001c\u0017\r\\1\n\u0005%4'\u0001B+oSRDQa[\u0004A\u0002Q\n!aY5\u0002\u0011=tW\u000b\u001d3bi\u0016$\"\u0001\u001a8\t\u000b-D\u0001\u0019\u0001\u001b\u0002!=t7I]3bi\u0016|%/\u00169eCR,GC\u00013r\u0011\u0015\u0011\u0018\u00021\u00015\u0003\u001d\u0011X\r\\3bg\u0016\f1D^1mS\u0012\fG/\u001a#fM\u0006,H\u000e\u001e+be\u001e,GOR8mI\u0016\u0014HC\u00013v\u0011\u0015\u0011(\u00021\u00015\u0003i1\u0018\r\\5eCR,wk\u001c:lM2|w\u000f\u0015:pa\u0016\u0014H/[3t)\t!\u0007\u0010C\u0003s\u0017\u0001\u0007A'\u0001\rwC2LG-\u0019;f\u001d>$\u0018IU8pi^{'o\u001b4m_^$\"\u0001Z>\t\u000bId\u0001\u0019\u0001\u001b\u0002=Y\fG.\u001b3bi\u0016tu\u000eR1tQ\n|\u0017M\u001d3G_J<vN]6gY><HC\u00013\u007f\u0011\u0015\u0011X\u00021\u00015\u0003\u00112\u0018\r\\5eCR,gj\u001c'pG.$\u0016m]6Qe\u0016\u001cXM\u001c;G_J<vN]6gY><Hc\u00013\u0002\u0004!)!O\u0004a\u0001i\u0005\u0001c/\u00197jI\u0006$XMT8SSN\\\u0007K]8gS2,gi\u001c:X_J\\g\r\\8x)\r!\u0017\u0011\u0002\u0005\u0006e>\u0001\r\u0001N\u0001,m\u0006d\u0017\u000eZ1uK:{WK\\:vaB|'\u000f^3e)\u0006\u001c8\u000e\u0015:fg\u0016tGOR8s/>\u00148N\u001a7poR\u0019A-a\u0004\t\u000bI\u0004\u0002\u0019\u0001\u001b\u0002UY\fG.\u001b3bi\u0016tu.T;mi&dUM^3m\u001d\u0016\u001cH/\u001a3UCN\\7OR8s/>\u00148N\u001a7poR\u0019A-!\u0006\t\u000bI\f\u0002\u0019\u0001\u001b\u0002EY\fG.\u001b3bi\u0016$v\u000e^1m\u001d>|emV8sW\u001adwn\u001e+f[Bd\u0017\r^3t)\r!\u00171\u0004\u0005\u0006eJ\u0001\r\u0001N\u0001\u0012O\u0016$H*[2f]N,W\tZ5uS>tGCAA\u0011!\u0011\t\u0019#!\r\u000f\t\u0005\u0015\u0012Q\u0006\t\u0004\u0003O1WBAA\u0015\u0015\r\tYCJ\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005=b-\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003g\t)D\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003_1\u0007f\u0001\u0001\u0002:A!\u00111HA%\u001b\t\tiD\u0003\u0003\u0002@\u0005\u0005\u0013AC:uKJ,w\u000e^=qK*!\u00111IA#\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'BAA$\u0003\ry'oZ\u0005\u0005\u0003\u0017\niDA\u0005D_6\u0004xN\\3oi\"\u001a\u0001!a\u0014\u0011\t\u0005E\u0013QL\u0007\u0003\u0003'RA!!\u0016\u0002X\u0005YAO]1og\u0006\u001cG/[8o\u0015\ri\u0012\u0011\f\u0006\u0004\u00037\u0002\u0013A\u00013c\u0013\u0011\ty&a\u0015\u0003\u001f%\u001bHK]1og\u0006\u001cG/[8oC2\fQDU3mK\u0006\u001cX\rU3sg&\u001cH/\u001a8dK&sG/\u001a:dKB$xN\u001d\t\u0003wU\u00192!FA4!\r)\u0017\u0011N\u0005\u0004\u0003W2'AB!osJ+g\r\u0006\u0002\u0002d\u0005\tS*\u0011-`\u001d>{vk\u0014*L\r2{uk\u0018+F\u001bBc\u0015\tV#T?\u0006cEjT,F\tV\u0011\u00111\u000f\t\u0004K\u0006U\u0014bAA<M\n\u0019\u0011J\u001c;\u0002E5\u000b\u0005l\u0018(P?^{%k\u0013$M\u001f^{F+R'Q\u0019\u0006#ViU0B\u00192{u+\u0012#!\u0003u)fJU#T)JK5\tV#E?2K5)\u0012(T\u000b~+E)\u0013+J\u001f:\u001bVCAA@!\u0019\t\t)a#\u0002\"9!\u00111QAD\u001d\u0011\t9#!\"\n\u0003\u001dL1!!#g\u0003\u001d\u0001\u0018mY6bO\u0016LA!!$\u0002\u0010\n\u00191+Z9\u000b\u0007\u0005%e-\u0001\u0010V\u001dJ+5\u000b\u0016*J\u0007R+Ei\u0018'J\u0007\u0016s5+R0F\t&#\u0016j\u0014(TA\u0001")
public class ReleasePersistenceInterceptor
implements PersistenceInterceptor<Release>,
WorkflowTaskValidator,
WorkflowInterceptorLogic {
    private final ReleaseRepository releaseRepository;
    private final TaskPersistence taskPersistence;
    private final FolderRepository folderRepository;
    private final LicenseService licenseService;

    @Override
    public void updateWorkflowProperties(Release release) {
        WorkflowInterceptorLogic.updateWorkflowProperties$((WorkflowInterceptorLogic)this, release);
    }

    @Override
    public void updateWorkflowProperties(Task task) {
        WorkflowInterceptorLogic.updateWorkflowProperties$((WorkflowInterceptorLogic)this, task);
    }

    @Override
    public void validateNoLockTaskPresent(Task task) {
        WorkflowTaskValidator.validateNoLockTaskPresent$((WorkflowTaskValidator)this, task);
    }

    @Override
    public void validateNoLockTaskPresent(Seq<Task> tasks) {
        WorkflowTaskValidator.validateNoLockTaskPresent$((WorkflowTaskValidator)this, tasks);
    }

    @Override
    public void validateNoUnsupportedTaskPresent(Task task) {
        WorkflowTaskValidator.validateNoUnsupportedTaskPresent$((WorkflowTaskValidator)this, task);
    }

    @Override
    public void validateNoUnsupportedTaskPresent(Seq<Task> tasks) {
        WorkflowTaskValidator.validateNoUnsupportedTaskPresent$((WorkflowTaskValidator)this, tasks);
    }

    @Override
    public void validateWorkflowTaskCount(Release release) {
        WorkflowTaskValidator.validateWorkflowTaskCount$(this, release);
    }

    @Override
    public void validateNoMultiLevelNestedTasks(Task task) {
        WorkflowTaskValidator.validateNoMultiLevelNestedTasks$((WorkflowTaskValidator)this, task);
    }

    @Override
    public void validateNoMultiLevelNestedTasks(Seq<Task> tasks) {
        WorkflowTaskValidator.validateNoMultiLevelNestedTasks$((WorkflowTaskValidator)this, tasks);
    }

    public void onDelete(String ciId) {
        super.onDelete(ciId);
    }

    public void afterCreate(ConfigurationItem ci) {
        super.afterCreate(ci);
    }

    public void afterUpdate(ConfigurationItem ci) {
        super.afterUpdate(ci);
    }

    public void afterDelete(String ciId) {
        super.afterDelete(ciId);
    }

    @Override
    public TaskPersistence taskPersistence() {
        return this.taskPersistence;
    }

    public void onCreate(Release ci) {
        this.onCreateOrUpdate(ci);
    }

    public void onUpdate(Release ci) {
        this.onCreateOrUpdate(ci);
    }

    private void onCreateOrUpdate(Release release) {
        this.validateTotalNoOfWorkflowTemplates(release);
        this.updateWorkflowProperties(release);
        this.validateDefaultTargetFolder(release);
        this.validateWorkflowProperties(release);
    }

    private void validateDefaultTargetFolder(Release release) {
        boolean defaultTargetFolderIdIsEmpty;
        boolean doesNotAllowTargetFolderOverride = !release.getAllowTargetFolderOverride();
        String defaultTargetFolderId = release.getDefaultTargetFolderId();
        boolean bl = defaultTargetFolderIdIsEmpty = !StringUtils.hasText((String)defaultTargetFolderId);
        if (release.isTemplate() && doesNotAllowTargetFolderOverride && defaultTargetFolderIdIsEmpty) {
            String msg = "Override of the target folder is not allowed, but default target folder is not provided for release with ID [" + release.getId() + "]";
            throw new Checks.IncorrectArgumentException(msg, new Object[0]);
        }
        if (!defaultTargetFolderIdIsEmpty) {
            Option optionalFolder = this.folderRepository.findById(defaultTargetFolderId, 1);
            if (optionalFolder.isEmpty()) {
                throw new Checks.IncorrectArgumentException("Cannot find folder with id [" + defaultTargetFolderId + "]", new Object[0]);
            }
            return;
        }
    }

    private void validateWorkflowProperties(Release release) {
        this.validateNotARootWorkflow(release);
        this.validateNoDashboardForWorkflow(release);
        this.validateNoRiskProfileForWorkflow(release);
        this.validateNoLockTaskPresentForWorkflow(release);
        this.validateNoUnsupportedTaskPresentForWorkflow(release);
        this.validateWorkflowTaskCount(release);
        this.validateNoMultiLevelNestedTasksForWorkflow(release);
    }

    private void validateNotARootWorkflow(Release release) {
        String parentFolder = Ids.getParentId((String)release.getId());
        if (release.isWorkflow()) {
            String string = parentFolder;
            String string2 = Ids.ROOT_FOLDER_ID;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                throw new Checks.IncorrectArgumentException("Workflows can be created only inside a folder", new Object[0]);
            }
        }
    }

    private void validateNoDashboardForWorkflow(Release release) {
        if (release.isWorkflow()) {
            boolean hasDashboards = CollectionConverters$.MODULE$.ListHasAsScala(release.getExtensions()).asScala().exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ReleasePersistenceInterceptor.$anonfun$validateNoDashboardForWorkflow$1(x$1)));
            if (hasDashboards) {
                throw new Checks.IncorrectArgumentException("Dashboards are not supported for workflows", new Object[0]);
            }
            return;
        }
    }

    private void validateNoLockTaskPresentForWorkflow(Release release) {
        if (release.isWorkflow()) {
            this.validateNoLockTaskPresent((Seq<Task>)CollectionConverters$.MODULE$.ListHasAsScala(release.getAllTasks()).asScala().toSeq());
            return;
        }
    }

    private void validateNoRiskProfileForWorkflow(Release release) {
        if (release.isWorkflow() && release.getRiskProfile() != null) {
            throw new Checks.IncorrectArgumentException("Risk profile is not supported for workflows", new Object[0]);
        }
    }

    private void validateNoUnsupportedTaskPresentForWorkflow(Release release) {
        if (release.isWorkflow()) {
            this.validateNoUnsupportedTaskPresent((Seq<Task>)CollectionConverters$.MODULE$.ListHasAsScala(release.getAllTasks()).asScala().toSeq());
            return;
        }
    }

    private void validateNoMultiLevelNestedTasksForWorkflow(Release release) {
        if (release.isWorkflow()) {
            this.validateNoMultiLevelNestedTasks((Seq<Task>)CollectionConverters$.MODULE$.ListHasAsScala(release.getAllTasks()).asScala().toSeq());
            return;
        }
    }

    private void validateTotalNoOfWorkflowTemplates(Release release) {
        if (release.isTemplate() && release.isWorkflow()) {
            String licenseEdition = this.getLicenseEdition();
            if (!ReleasePersistenceInterceptor$.MODULE$.com$xebialabs$xlrelease$repository$sql$ReleasePersistenceInterceptor$$UNRESTRICTED_LICENSE_EDITIONS().contains((Object)licenseEdition)) {
                int totalWorkflowTemplates = this.releaseRepository.countTemplatesByKind(ReleaseKind.WORKFLOW);
                if (totalWorkflowTemplates >= ReleasePersistenceInterceptor$.MODULE$.com$xebialabs$xlrelease$repository$sql$ReleasePersistenceInterceptor$$MAX_NO_WORKFLOW_TEMPLATES_ALLOWED()) {
                    throw new LicenseLimitReachedException("License limit reached. You have exceeded the limit on the number of workflow templates supported with your license.");
                }
                return;
            }
            return;
        }
    }

    private String getLicenseEdition() {
        License license = this.licenseService.getLicense();
        if (license.isDummyLicense()) {
            return LicenseVersion4.Edition4.Unregistered.name();
        }
        return this.licenseService.getLicense().getStringValue(LicenseProperty.EDITION);
    }

    public static final /* synthetic */ boolean $anonfun$validateNoDashboardForWorkflow$1(ReleaseExtension x$1) {
        return x$1 instanceof Dashboard;
    }

    public ReleasePersistenceInterceptor(ReleaseRepository releaseRepository, TaskPersistence taskPersistence, FolderRepository folderRepository, LicenseService licenseService) {
        this.releaseRepository = releaseRepository;
        this.taskPersistence = taskPersistence;
        this.folderRepository = folderRepository;
        this.licenseService = licenseService;
        WorkflowTaskValidator.$init$(this);
        WorkflowInterceptorLogic.$init$(this);
        releaseRepository.registerPersistenceInterceptor((PersistenceInterceptor)this);
    }
}

