/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.xebialabs.xlrelease.db.sql.transaction.IsReadOnly;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.domain.Datacenter;
import com.xebialabs.xlrelease.domain.DatacenterTargetState;
import com.xebialabs.xlrelease.repository.DatacenterRepository;
import com.xebialabs.xlrelease.repository.sql.jpa.JpaDatacenterRepository;
import com.xebialabs.xlrelease.repository.sql.jpa.entities.ClusterDatacenter;
import jakarta.persistence.OptimisticLockException;
import java.io.Serializable;
import java.time.Instant;
import java.util.Optional;
import scala.Function1;
import scala.Option;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0005\u0005-a\u0001\u0002\u0006\f\u0001YA\u0001\"\t\u0001\u0003\u0002\u0003\u0006IA\t\u0005\u0006Q\u0001!\t!\u000b\u0005\u0006[\u0001!\tE\f\u0005\u0006\u001f\u0002!\t\u0005\u0015\u0005\u00067\u0002!\t\u0005\u0018\u0005\u0006C\u0002!\tE\u0019\u0005\u0006O\u0002!\t\u0005\u001b\u0005\u0006c\u0002!\tE\u001d\u0005\u0006o\u0002!I\u0001\u001f\u0002\u0018'FdG)\u0019;bG\u0016tG/\u001a:SKB|7/\u001b;pefT!\u0001D\u0007\u0002\u0007M\fHN\u0003\u0002\u000f\u001f\u0005Q!/\u001a9pg&$xN]=\u000b\u0005A\t\u0012!\u0003=me\u0016dW-Y:f\u0015\t\u00112#A\u0005yK\nL\u0017\r\\1cg*\tA#A\u0002d_6\u001c\u0001aE\u0002\u0001/u\u0001\"\u0001G\u000e\u000e\u0003eQ\u0011AG\u0001\u0006g\u000e\fG.Y\u0005\u00039e\u0011a!\u00118z%\u00164\u0007C\u0001\u0010 \u001b\u0005i\u0011B\u0001\u0011\u000e\u0005Q!\u0015\r^1dK:$XM\u001d*fa>\u001c\u0018\u000e^8ss\u00069\"\u000e]1ECR\f7-\u001a8uKJ\u0014V\r]8tSR|'/\u001f\t\u0003G\u0019j\u0011\u0001\n\u0006\u0003K-\t1A\u001b9b\u0013\t9CEA\fKa\u0006$\u0015\r^1dK:$XM\u001d*fa>\u001c\u0018\u000e^8ss\u00061A(\u001b8jiz\"\"A\u000b\u0017\u0011\u0005-\u0002Q\"A\u0006\t\u000b\u0005\u0012\u0001\u0019\u0001\u0012\u0002\t\u0019Lg\u000e\u001a\u000b\u0003_a\u00022\u0001\u0007\u00193\u0013\t\t\u0014D\u0001\u0004PaRLwN\u001c\t\u0003gYj\u0011\u0001\u000e\u0006\u0003k=\ta\u0001Z8nC&t\u0017BA\u001c5\u0005)!\u0015\r^1dK:$XM\u001d\u0005\u0006s\r\u0001\rAO\u0001\u000bI\u0006$\u0018mY3oi\u0016\u0014\bCA\u001eC\u001d\ta\u0004\t\u0005\u0002>35\taH\u0003\u0002@+\u00051AH]8pizJ!!Q\r\u0002\rA\u0013X\rZ3g\u0013\t\u0019EI\u0001\u0004TiJLgn\u001a\u0006\u0003\u0003fA#a\u0001$\u0011\u0005\u001dkU\"\u0001%\u000b\u0005%S\u0015a\u0003;sC:\u001c\u0018m\u0019;j_:T!\u0001D&\u000b\u00051{\u0011A\u00013c\u0013\tq\u0005J\u0001\u0006JgJ+\u0017\rZ(oYf\fqAZ5oI\u0006cG\u000eF\u0001R!\r\u0011vK\r\b\u0003'Vs!!\u0010+\n\u0003iI!AV\r\u0002\u000fA\f7m[1hK&\u0011\u0001,\u0017\u0002\u0004'\u0016\f(B\u0001,\u001aQ\t!a)A\u0003d_VtG\u000fF\u0001^!\tAb,\u0003\u0002`3\t!Aj\u001c8hQ\t)a)\u0001\u0004eK2,G/\u001a\u000b\u0003G\u001a\u0004\"\u0001\u00073\n\u0005\u0015L\"\u0001B+oSRDQ!\u000f\u0004A\u0002i\naa\u0019:fCR,G\u0003B2jU>DQ!O\u0004A\u0002iBQa[\u0004A\u00021\fQa\u001d;bi\u0016\u0004\"aM7\n\u00059$$!\u0006#bi\u0006\u001cWM\u001c;feR\u000b'oZ3u'R\fG/\u001a\u0005\u0006a\u001e\u0001\rAO\u0001\nGJ,\u0017\r^3e\u0005f\fa!\u001e9eCR,G\u0003B2tiVDQ!\u000f\u0005A\u0002iBQa\u001b\u0005A\u00021DQA\u001e\u0005A\u0002i\n\u0011\"\u001e9eCR,GMQ=\u0002\u000f\u0019\u0014x.\u001c*poR\u0011!'\u001f\u0005\u0006u&\u0001\ra_\u0001\u0004e><\bC\u0001?\u0000\u001b\u0005i(B\u0001@%\u0003!)g\u000e^5uS\u0016\u001c\u0018bAA\u0001{\n\t2\t\\;ti\u0016\u0014H)\u0019;bG\u0016tG/\u001a:)\u0007\u0001\t)\u0001E\u0002H\u0003\u000fI1!!\u0003I\u0005=I5\u000f\u0016:b]N\f7\r^5p]\u0006d\u0007")
public class SqlDatacenterRepository
implements DatacenterRepository {
    private final JpaDatacenterRepository jpaDatacenterRepository;

    @IsReadOnly
    public Option<Datacenter> find(String datacenter) {
        return OptionConverters.RichOptional$.MODULE$.toScala$extension(OptionConverters$.MODULE$.RichOptional(this.jpaDatacenterRepository.findByDatacenterIgnoreCase(datacenter).map(row -> this.fromRow((ClusterDatacenter)row))));
    }

    @IsReadOnly
    public Seq<Datacenter> findAll() {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(this.jpaDatacenterRepository.findAll()).asScala().map((Function1 & Serializable)row -> this.fromRow((ClusterDatacenter)row))).toSeq();
    }

    @IsReadOnly
    public long count() {
        return this.jpaDatacenterRepository.count();
    }

    public void delete(String datacenter) {
        this.jpaDatacenterRepository.deleteByDatacenterIgnoreCase(datacenter);
    }

    public void create(String datacenter, DatacenterTargetState state, String createdBy) {
        ClusterDatacenter newClusterDatacenterRow = new ClusterDatacenter();
        newClusterDatacenterRow.setDatacenter(datacenter);
        newClusterDatacenterRow.setTargetState(state.value());
        newClusterDatacenterRow.setUpdatedBy(createdBy);
        newClusterDatacenterRow.setUpdatedDate(Instant.now());
        this.jpaDatacenterRepository.save(newClusterDatacenterRow);
    }

    public void update(String datacenter, DatacenterTargetState state, String updatedBy) {
        Optional<ClusterDatacenter> maybeClusterDatacenterRow = this.jpaDatacenterRepository.findByDatacenterIgnoreCase(datacenter);
        if (maybeClusterDatacenterRow.isPresent()) {
            ClusterDatacenter existingClusterDatacenterRow = maybeClusterDatacenterRow.get();
            existingClusterDatacenterRow.setTargetState(state.value());
            existingClusterDatacenterRow.setUpdatedBy(updatedBy);
            existingClusterDatacenterRow.setUpdatedDate(Instant.now());
            try {
                this.jpaDatacenterRepository.save(existingClusterDatacenterRow);
            }
            catch (OptimisticLockException e) {
                throw new RuntimeException("Failed to update cluster state for datacenter " + datacenter, e);
            }
            return;
        }
        throw new IllegalArgumentException("Datacenter " + datacenter + " does not exist");
    }

    private Datacenter fromRow(ClusterDatacenter row) {
        return new Datacenter(row.getDatacenter(), DatacenterTargetState.fromString((String)row.getTargetState()), row.getUpdatedBy(), row.getUpdatedDate());
    }

    public SqlDatacenterRepository(JpaDatacenterRepository jpaDatacenterRepository) {
        this.jpaDatacenterRepository = jpaDatacenterRepository;
    }
}

