package com.xebialabs.xlrelease.repository.sql.persistence.data

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.domain.status.TaskStatus
import com.xebialabs.xlrelease.repository.query.TaskBasicData

import java.util.Date

case class TaskRow(
                     ciUid: Int,
                     releaseUid: Int,
                     taskId: String,
                     taskType: String,
                     title: String,
                     status: String,
                     statusLine: String,
                     owner: String,
                     team: String,
                     startDate: Date,
                     endDate: Date,
                     isAutomated: Boolean,
                     locked: Boolean,
                     plannedDuration: Int
                   )

object TaskRow {

  implicit class TaskDataOps(val data: TaskRow) {
    def asTaskData(taskId: String): TaskBasicData = {
      TaskBasicData(
        ciUid = data.ciUid,
        releaseUid = data.releaseUid,
        taskId = taskId, // to use provided full task ID instead of queried folder-less ID
        taskType = Type.valueOf(data.taskType),
        title = data.title,
        status = TaskStatus.valueOf(data.status.toUpperCase),
        statusLine = data.statusLine,
        owner = data.owner,
        team = data.team,
        startDate = data.startDate,
        endDate = data.endDate,
        isAutomated = data.isAutomated,
        locked = data.locked,
      )
    }
  }

}
