/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql.persistence;

import com.xebialabs.xlrelease.domain.events.ReleaseActorStarted;
import com.xebialabs.xlrelease.domain.events.ReleaseActorStopped;
import com.xebialabs.xlrelease.domain.events.ReleaseRiskScoreUpdated;
import com.xebialabs.xlrelease.events.EventListener;
import com.xebialabs.xlrelease.events.Subscribe;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleaseCacheService;
import com.xebialabs.xlrelease.repository.sql.persistence.data.ReleaseRow;
import java.io.Serializable;
import java.util.Date;
import scala.Function1;
import scala.MatchError;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@EventListener
@ScalaSignature(bytes="\u0006\u0005-3AAB\u0004\u0001)!A1\u0004\u0001B\u0001B\u0003%A\u0004C\u0003!\u0001\u0011\u0005\u0011\u0005C\u0003%\u0001\u0011\u0005Q\u0005C\u0003:\u0001\u0011\u0005!\bC\u0003A\u0001\u0011\u0005\u0011I\u0001\rSK2,\u0017m]3DC\u000eDW-\u0012<f]RD\u0015M\u001c3mKJT!\u0001C\u0005\u0002\u0017A,'o]5ti\u0016t7-\u001a\u0006\u0003\u0015-\t1a]9m\u0015\taQ\"\u0001\u0006sKB|7/\u001b;pefT!AD\b\u0002\u0013ad'/\u001a7fCN,'B\u0001\t\u0012\u0003%AXMY5bY\u0006\u00147OC\u0001\u0013\u0003\r\u0019w.\\\u0002\u0001'\t\u0001Q\u0003\u0005\u0002\u001735\tqCC\u0001\u0019\u0003\u0015\u00198-\u00197b\u0013\tQrC\u0001\u0004B]f\u0014VMZ\u0001\u0014e\u0016dW-Y:f\u0007\u0006\u001c\u0007.Z*feZL7-\u001a\t\u0003;yi\u0011aB\u0005\u0003?\u001d\u00111CU3mK\u0006\u001cXmQ1dQ\u0016\u001cVM\u001d<jG\u0016\fa\u0001P5oSRtDC\u0001\u0012$!\ti\u0002\u0001C\u0003\u001c\u0005\u0001\u0007A$\u0001\u0007p]\u0006\u001bGo\u001c:Ti\u0006\u0014H\u000f\u0006\u0002'SA\u0011acJ\u0005\u0003Q]\u0011A!\u00168ji\")!f\u0001a\u0001W\u0005)QM^3oiB\u0011A&M\u0007\u0002[)\u0011afL\u0001\u0007KZ,g\u000e^:\u000b\u0005Aj\u0011A\u00023p[\u0006Lg.\u0003\u00023[\t\u0019\"+\u001a7fCN,\u0017i\u0019;peN#\u0018M\u001d;fI\"\u00121\u0001\u000e\t\u0003k]j\u0011A\u000e\u0006\u0003]5I!\u0001\u000f\u001c\u0003\u0013M+(m]2sS\n,\u0017aC8o\u0003\u000e$xN]*u_B$\"AJ\u001e\t\u000b)\"\u0001\u0019\u0001\u001f\u0011\u00051j\u0014B\u0001 .\u0005M\u0011V\r\\3bg\u0016\f5\r^8s'R|\u0007\u000f]3eQ\t!A'\u0001\u0007p]JK7o[+qI\u0006$X\r\u0006\u0002'\u0005\")!&\u0002a\u0001\u0007B\u0011A\u0006R\u0005\u0003\u000b6\u0012qCU3mK\u0006\u001cXMU5tWN\u001bwN]3Va\u0012\fG/\u001a3)\u0005\u0015!\u0004F\u0001\u0001I!\t)\u0014*\u0003\u0002Km\tiQI^3oi2K7\u000f^3oKJ\u0004")
public class ReleaseCacheEventHandler {
    private final ReleaseCacheService releaseCacheService;

    @Subscribe
    public void onActorStart(ReleaseActorStarted event) {
        this.releaseCacheService.invalidate(event.releaseId());
        this.releaseCacheService.allow(event.releaseId());
    }

    @Subscribe
    public void onActorStop(ReleaseActorStopped event) {
        this.releaseCacheService.disallow(event.releaseId());
        this.releaseCacheService.invalidate(event.releaseId());
    }

    @Subscribe
    public void onRiskUpdate(ReleaseRiskScoreUpdated event) {
        ReleaseRiskScoreUpdated releaseRiskScoreUpdated = event;
        if (releaseRiskScoreUpdated != null) {
            String releaseId = releaseRiskScoreUpdated.releaseId();
            int riskScore = releaseRiskScoreUpdated.riskScore();
            int totalRiskScore = releaseRiskScoreUpdated.totalRiskScore();
            this.releaseCacheService.get(event.releaseId()).foreach((Function1 & Serializable)releaseRow -> {
                ReleaseCacheEventHandler.$anonfun$onRiskUpdate$1(this, riskScore, totalRiskScore, releaseId, releaseRow);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)releaseRiskScoreUpdated);
    }

    public static final /* synthetic */ void $anonfun$onRiskUpdate$1(ReleaseCacheEventHandler $this, int riskScore$1, int totalRiskScore$1, String releaseId$1, ReleaseRow releaseRow) {
        int x$1 = riskScore$1;
        int x$2 = totalRiskScore$1;
        String x$3 = releaseRow.copy$default$1();
        String x$4 = releaseRow.copy$default$2();
        int x$5 = releaseRow.copy$default$3();
        String x$6 = releaseRow.copy$default$4();
        int x$7 = releaseRow.copy$default$5();
        String x$8 = releaseRow.copy$default$6();
        int x$9 = releaseRow.copy$default$7();
        String x$10 = releaseRow.copy$default$8();
        Date x$11 = releaseRow.copy$default$9();
        Date x$12 = releaseRow.copy$default$10();
        int x$13 = releaseRow.copy$default$13();
        Integer x$14 = releaseRow.copy$default$14();
        boolean x$15 = releaseRow.copy$default$15();
        String x$16 = releaseRow.copy$default$16();
        ReleaseRow updatedRow = releaseRow.copy(x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$1, x$2, x$13, x$14, x$15, x$16);
        $this.releaseCacheService.put(releaseId$1, updatedRow);
    }

    public ReleaseCacheEventHandler(ReleaseCacheService releaseCacheService) {
        this.releaseCacheService = releaseCacheService;
    }
}

