package com.xebialabs.xlrelease.upgrade

import com.xebialabs.deployit.server.api.upgrade.RepositoryInitialization
import com.xebialabs.xlrelease.db.XLReleaseDbInitializer
import com.xebialabs.xlrelease.db.sql.SqlBuilder.Dialect
import com.xebialabs.xlrelease.repository.sql.persistence.data.FolderRow.Root
import com.xebialabs.xlrelease.repository.sql.persistence.{Schema, SecurablePersistence}
import com.xebialabs.xlrelease.upgrade.Components.XL_RELEASE_COMPONENT
import com.xebialabs.xlrelease.upgrade.DatabasesInitializer.initializeRows
import com.xebialabs.xlrelease.upgrade.common.ClassNameToString
import com.xebialabs.xlrelease.utils.CloseableUtils.using
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.{Autowired, Qualifier}

import java.sql.Connection
import javax.sql.DataSource

class DatabasesInitializer @Autowired()(@Qualifier("reportingDbInitializer") reportingInit: XLReleaseDbInitializer,
                                        @Qualifier("xlrRepositorySqlDialect") val dialect: Dialect,
                                        securablePersistence: SecurablePersistence)
  extends RepositoryInitialization with ClassNameToString with Logging {

  @Qualifier("xlrRepositoryDbInitializer")
  @Autowired(required = false)
  var releasesInit: XLReleaseDbInitializer = _

  override def doInitialize(): Unit = {
    logger.info("Initializing reporting database...")
    reportingInit.update()
    if (releasesInit != null) {
      logger.info("Initializing repository database...")
      releasesInit.update()
      initializeRows(releasesInit.dataSource, dialect, securablePersistence)
    }
  }

  override def getComponent: String = XL_RELEASE_COMPONENT
}

object DatabasesInitializer {
  def initializeRows(dataSource: DataSource, dialect: Dialect, securablePersistence: SecurablePersistence): Unit = {
    if (securablePersistence != null) {
      using(dataSource.getConnection()) { implicit connection =>
        val isInited = connection.prepareStatement(s"SELECT 1 FROM ${Schema.FOLDERS.TABLE} WHERE ${Schema.FOLDERS.CI_UID} = ${Root.uid}").executeQuery().next()
        if (!isInited) {
          securablePersistence.insert()
          execute(
            s"""INSERT INTO ${Schema.FOLDERS.TABLE}
               | (${Schema.FOLDERS.CI_UID}, ${Schema.FOLDERS.SECURITY_UID}, ${Schema.FOLDERS.FOLDER_ID}, ${Schema.FOLDERS.FOLDER_PATH}, ${Schema.FOLDERS.NAME})
               | VALUES
               | (${Root.uid}, ${Root.uid},'/', '/', '/')""".stripMargin)
          execute(
            s"""INSERT INTO ${Schema.PATHS.TABLE}
               | (${Schema.PATHS.ANCESTOR_UID}, ${Schema.PATHS.DESCENDANT_UID}, ${Schema.PATHS.DEPTH})
               | VALUES
               | (${Root.uid}, ${Root.uid}, 0)""".stripMargin)
        }
      }
    }
  }

  private def execute(statement: String)(implicit connection: Connection): Boolean = {
    connection.prepareStatement(statement).execute()
  }
}
